/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.persistence;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.FlowSerializationException;
import org.apache.nifi.controller.FlowSynchronizationException;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.StandardFlowSerializer;
import org.apache.nifi.controller.StandardFlowSynchronizer;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.StandardReportingInitializationContext;
import org.apache.nifi.controller.service.ControllerServiceLoader;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.persistence.FlowConfigurationDAO;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class StandardXMLFlowConfigurationDAO
implements FlowConfigurationDAO {
    public static final String CONFIGURATION_ARCHIVE_DIR_KEY = "nifi.flow.configuration.archive.dir";
    private final Path flowXmlPath;
    private final Path taskConfigXmlPath;
    private final ControllerServiceLoader servicerLoader;
    private final StringEncryptor encryptor;
    private static final Logger LOG = LoggerFactory.getLogger(StandardXMLFlowConfigurationDAO.class);

    public StandardXMLFlowConfigurationDAO(Path flowXml, Path taskConfigXml, Path serviceConfigXml, StringEncryptor encryptor) throws IOException {
        File flowXmlFile = flowXml.toFile();
        if (!flowXmlFile.exists()) {
            Files.createDirectories(flowXml.getParent(), new FileAttribute[0]);
            Files.createFile(flowXml, new FileAttribute[0]);
        } else if (!flowXmlFile.canRead() || !flowXmlFile.canWrite()) {
            throw new IOException(flowXml + " exists but you have insufficient read/write privileges");
        }
        File taskConfigXmlFile = Objects.requireNonNull(taskConfigXml).toFile();
        if (!taskConfigXmlFile.exists() || !taskConfigXmlFile.canRead()) {
            throw new IOException(taskConfigXml + " does not appear to exist or cannot be read. Cannot load configuration.");
        }
        this.flowXmlPath = flowXml;
        this.taskConfigXmlPath = taskConfigXml;
        this.servicerLoader = new ControllerServiceLoader(serviceConfigXml);
        this.encryptor = encryptor;
    }

    @Override
    public synchronized void load(FlowController controller, DataFlow dataFlow) throws IOException, FlowSerializationException, FlowSynchronizationException, UninheritableFlowException {
        StandardFlowSynchronizer flowSynchronizer = new StandardFlowSynchronizer(this.encryptor);
        controller.synchronize(flowSynchronizer, dataFlow);
        this.save(new ByteArrayInputStream(dataFlow.getFlow()));
    }

    @Override
    public synchronized void load(OutputStream os) throws IOException {
        try (InputStream inStream = Files.newInputStream(this.flowXmlPath, StandardOpenOption.READ);
             GZIPInputStream gzipIn = new GZIPInputStream(inStream);){
            FileUtils.copy((InputStream)gzipIn, (OutputStream)os);
        }
    }

    @Override
    public synchronized void save(InputStream is) throws IOException {
        try (OutputStream outStream = Files.newOutputStream(this.flowXmlPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             GZIPOutputStream gzipOut = new GZIPOutputStream(outStream);){
            FileUtils.copy((InputStream)is, (OutputStream)gzipOut);
        }
    }

    @Override
    public void save(FlowController flow) throws IOException {
        LOG.trace("Saving flow to disk");
        try (OutputStream outStream = Files.newOutputStream(this.flowXmlPath, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             GZIPOutputStream gzipOut = new GZIPOutputStream(outStream);){
            this.save(flow, gzipOut);
        }
        LOG.debug("Finished saving flow to disk");
    }

    @Override
    public synchronized void save(FlowController flow, OutputStream os) throws IOException {
        try {
            StandardFlowSerializer xmlTransformer = new StandardFlowSerializer(this.encryptor);
            flow.serialize(xmlTransformer, os);
        }
        catch (FlowSerializationException fse) {
            throw new IOException(fse);
        }
    }

    @Override
    public synchronized void save(FlowController controller, boolean archive) throws IOException {
        block35: {
            if (null == controller) {
                throw new NullPointerException();
            }
            Path configFile = this.flowXmlPath;
            Path tempFile = configFile.getParent().resolve(configFile.toFile().getName() + ".new.xml.gz");
            try (OutputStream fileOut = Files.newOutputStream(tempFile, new OpenOption[0]);
                 GZIPOutputStream outStream = new GZIPOutputStream(fileOut);){
                StandardFlowSerializer xmlTransformer = new StandardFlowSerializer(this.encryptor);
                controller.serialize(xmlTransformer, outStream);
                Files.deleteIfExists(configFile);
                FileUtils.renameFile((File)tempFile.toFile(), (File)configFile.toFile(), (int)5, (boolean)true);
            }
            catch (FlowSerializationException fse) {
                throw new IOException(fse);
            }
            finally {
                Files.deleteIfExists(tempFile);
            }
            if (archive) {
                try {
                    String archiveDirVal = NiFiProperties.getInstance().getProperty(CONFIGURATION_ARCHIVE_DIR_KEY);
                    Path archiveDir = archiveDirVal == null || archiveDirVal.equals("") ? configFile.getParent().resolve("archive") : new File(archiveDirVal).toPath();
                    Files.createDirectories(archiveDir, new FileAttribute[0]);
                    if (!Files.isDirectory(archiveDir, new LinkOption[0])) {
                        throw new IOException("Archive directory doesn't appear to be a directory " + archiveDir);
                    }
                    Path archiveFile = archiveDir.resolve(System.nanoTime() + "-" + configFile.toFile().getName());
                    Files.copy(configFile, archiveFile, new CopyOption[0]);
                }
                catch (Exception ex) {
                    LOG.warn("Unable to archive flow configuration as requested due to " + ex);
                    if (!LOG.isDebugEnabled()) break block35;
                    LOG.warn("", (Throwable)ex);
                }
            }
        }
    }

    @Override
    public List<ReportingTaskNode> loadReportingTasks(FlowController controller) {
        ArrayList<ReportingTaskNode> tasks;
        block25: {
            tasks = new ArrayList<ReportingTaskNode>();
            if (this.taskConfigXmlPath == null) {
                LOG.info("No reporting tasks to start");
                return tasks;
            }
            try {
                URL schemaUrl = this.getClass().getResource("/ReportingTaskConfiguration.xsd");
                Document document = this.parse(this.taskConfigXmlPath.toFile(), schemaUrl);
                NodeList tasksNodes = document.getElementsByTagName("tasks");
                Element tasksElement = (Element)tasksNodes.item(0);
                for (Element taskElement : DomUtils.getChildElementsByTagName(tasksElement, "task")) {
                    HashMap resolvedProps;
                    ReportingTaskNode reportingTaskNode;
                    HashMap<String, String> properties = new HashMap<String, String>();
                    String taskId = DomUtils.getChild(taskElement, "id").getTextContent().trim();
                    String taskName = DomUtils.getChild(taskElement, "name").getTextContent().trim();
                    List<Element> schedulingStrategyNodeList = DomUtils.getChildElementsByTagName(taskElement, "schedulingStrategy");
                    String schedulingStrategyValue = SchedulingStrategy.TIMER_DRIVEN.name();
                    if (schedulingStrategyNodeList.size() == 1) {
                        String specifiedValue = schedulingStrategyNodeList.get(0).getTextContent();
                        try {
                            schedulingStrategyValue = SchedulingStrategy.valueOf((String)specifiedValue).name();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Cannot start Reporting Task with id " + taskId + " because its Scheduling Strategy does not have a valid value", e);
                        }
                    }
                    SchedulingStrategy schedulingStrategy = SchedulingStrategy.valueOf((String)schedulingStrategyValue);
                    String taskSchedulingPeriod = DomUtils.getChild(taskElement, "schedulingPeriod").getTextContent().trim();
                    String taskClass = DomUtils.getChild(taskElement, "class").getTextContent().trim();
                    for (Element optionalProperty : DomUtils.getChildElementsByTagName(taskElement, "property")) {
                        String name = optionalProperty.getAttribute("name");
                        String value = optionalProperty.getTextContent().trim();
                        properties.put(name, value);
                    }
                    try {
                        reportingTaskNode = controller.createReportingTask(taskClass, taskId);
                    }
                    catch (ReportingTaskInstantiationException e) {
                        LOG.error("Unable to load reporting task {} due to {}", new Object[]{taskId, e});
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.error("", (Throwable)e);
                        continue;
                    }
                    reportingTaskNode.setName(taskName);
                    reportingTaskNode.setScheduldingPeriod(taskSchedulingPeriod);
                    reportingTaskNode.setSchedulingStrategy(schedulingStrategy);
                    ReportingTask reportingTask = reportingTaskNode.getReportingTask();
                    StandardReportingInitializationContext config = new StandardReportingInitializationContext(taskId, taskName, schedulingStrategy, taskSchedulingPeriod, controller);
                    reportingTask.initialize((ReportingInitializationContext)config);
                    try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                        resolvedProps = new HashMap();
                        for (Map.Entry entry : properties.entrySet()) {
                            PropertyDescriptor descriptor = reportingTask.getPropertyDescriptor((String)entry.getKey());
                            resolvedProps.put(descriptor, entry.getValue());
                        }
                    }
                    for (Map.Entry entry : resolvedProps.entrySet()) {
                        reportingTaskNode.setProperty(((PropertyDescriptor)entry.getKey()).getName(), (String)entry.getValue());
                    }
                    tasks.add(reportingTaskNode);
                    controller.startReportingTask(reportingTaskNode);
                }
            }
            catch (IOException | NumberFormatException | ParserConfigurationException | InitializationException | DOMException | SAXException t) {
                LOG.error("Unable to load reporting tasks from {} due to {}", new Object[]{this.taskConfigXmlPath, t});
                if (!LOG.isDebugEnabled()) break block25;
                LOG.error("", t);
            }
        }
        return tasks;
    }

    @Override
    public List<ControllerServiceNode> loadControllerServices(FlowController controller) throws IOException {
        return this.servicerLoader.loadControllerServices(controller);
    }

    private Document parse(File xmlFile, URL schemaUrl) throws SAXException, ParserConfigurationException, IOException {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaUrl);
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setSchema(schema);
        DocumentBuilder builder = docFactory.newDocumentBuilder();
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void fatalError(SAXParseException err) throws SAXException {
                LOG.error("Config file line " + err.getLineNumber() + ", col " + err.getColumnNumber() + ", uri " + err.getSystemId() + " :message: " + err.getMessage());
                if (LOG.isDebugEnabled()) {
                    LOG.error("Error Stack Dump", (Throwable)err);
                }
                throw err;
            }

            @Override
            public void error(SAXParseException err) throws SAXParseException {
                LOG.error("Config file line " + err.getLineNumber() + ", col " + err.getColumnNumber() + ", uri " + err.getSystemId() + " :message: " + err.getMessage());
                if (LOG.isDebugEnabled()) {
                    LOG.error("Error Stack Dump", (Throwable)err);
                }
                throw err;
            }

            @Override
            public void warning(SAXParseException err) throws SAXParseException {
                LOG.warn(" Config file line " + err.getLineNumber() + ", uri " + err.getSystemId() + " : message : " + err.getMessage());
                if (LOG.isDebugEnabled()) {
                    LOG.warn("Warning stack dump", (Throwable)err);
                }
                throw err;
            }
        });
        Document document = builder.parse(xmlFile);
        Validator validator = schema.newValidator();
        validator.validate(new DOMSource(document));
        return document;
    }
}

