/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.ProcessorLog;
import org.apache.nifi.processor.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleProcessLogger
implements ProcessorLog {
    private final Logger logger;
    private final LogRepository logRepository;
    private final Processor processor;

    public SimpleProcessLogger(String processorId, Processor processor) {
        this.logger = LoggerFactory.getLogger(processor.getClass());
        this.logRepository = LogRepositoryFactory.getRepository((String)processorId);
        this.processor = processor;
    }

    private Object[] addProcessor(Object[] originalArgs) {
        return this.prependToArgs(originalArgs, this.processor);
    }

    private Object[] prependToArgs(Object[] originalArgs, Object ... toAdd) {
        Object[] newArgs = new Object[originalArgs.length + toAdd.length];
        System.arraycopy(toAdd, 0, newArgs, 0, toAdd.length);
        System.arraycopy(originalArgs, 0, newArgs, toAdd.length, originalArgs.length);
        return newArgs;
    }

    private Object[] translateException(Object[] os) {
        if (os != null && os.length > 0 && os[os.length - 1] instanceof Throwable) {
            Object[] osCopy = new Object[os.length];
            osCopy[osCopy.length - 1] = os[os.length - 1].toString();
            System.arraycopy(os, 0, osCopy, 0, os.length - 1);
            return osCopy;
        }
        return os;
    }

    private boolean lastArgIsException(Object[] os) {
        return os != null && os.length > 0 && os[os.length - 1] instanceof Throwable;
    }

    public void warn(String msg, Throwable t) {
        this.warn("{} " + msg, new Object[]{this.processor}, t);
    }

    public void warn(String msg, Object[] os) {
        if (this.lastArgIsException(os)) {
            this.warn(msg, this.translateException(os), (Throwable)os[os.length - 1]);
        } else {
            msg = "{} " + msg;
            os = this.addProcessor(os);
            this.logger.warn(msg, os);
            this.logRepository.addLogMessage(LogLevel.WARN, msg, os);
        }
    }

    public void warn(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.warn(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.warn("", t);
        }
        this.logRepository.addLogMessage(LogLevel.WARN, msg, os, t);
    }

    public void warn(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.warn(msg, (Object)this.processor);
        this.logRepository.addLogMessage(LogLevel.WARN, msg, os);
    }

    public void trace(String msg, Throwable t) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.trace(msg, (Object)os, (Object)t);
        this.logRepository.addLogMessage(LogLevel.TRACE, msg, os, t);
    }

    public void trace(String msg, Object[] os) {
        msg = "{} " + msg;
        os = this.addProcessor(os);
        this.logger.trace(msg, os);
        this.logRepository.addLogMessage(LogLevel.TRACE, msg, os);
    }

    public void trace(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.trace(msg, os);
        this.logRepository.addLogMessage(LogLevel.TRACE, msg, os);
    }

    public void trace(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.trace(msg, os);
        this.logger.trace("", t);
        this.logRepository.addLogMessage(LogLevel.TRACE, msg, os, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void info(String msg, Throwable t) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.info(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("", t);
        }
        this.logRepository.addLogMessage(LogLevel.INFO, msg, os, t);
    }

    public void info(String msg, Object[] os) {
        msg = "{} " + msg;
        os = this.addProcessor(os);
        this.logger.info(msg, os);
        this.logRepository.addLogMessage(LogLevel.INFO, msg, os);
    }

    public void info(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.info(msg, os);
        this.logRepository.addLogMessage(LogLevel.INFO, msg, os);
    }

    public void info(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.info(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("", t);
        }
        this.logRepository.addLogMessage(LogLevel.INFO, msg, os, t);
    }

    public String getName() {
        return this.logger.getName();
    }

    public void error(String msg, Throwable t) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.error(msg, (Object)os, (Object)t);
        if (this.logger.isDebugEnabled()) {
            this.logger.error("", t);
        }
        this.logRepository.addLogMessage(LogLevel.ERROR, msg, os, t);
    }

    public void error(String msg, Object[] os) {
        if (this.lastArgIsException(os)) {
            this.error(msg, this.translateException(os), (Throwable)os[os.length - 1]);
        } else {
            os = this.addProcessor(os);
            msg = "{} " + msg;
            this.logger.error(msg, os);
            this.logRepository.addLogMessage(LogLevel.ERROR, msg, os);
        }
    }

    public void error(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.error(msg, os);
        this.logRepository.addLogMessage(LogLevel.ERROR, msg, os);
    }

    private Object[] addProcessorAndThrowable(Object[] os, Throwable t) {
        Object[] modifiedArgs = new Object[os.length + 2];
        modifiedArgs[0] = this.processor.toString();
        for (int i = 0; i < os.length; ++i) {
            modifiedArgs[i + 1] = os[i];
        }
        modifiedArgs[modifiedArgs.length - 1] = t.toString();
        return modifiedArgs;
    }

    public void error(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.error(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.error("", t);
        }
        this.logRepository.addLogMessage(LogLevel.ERROR, msg, os, t);
    }

    public void debug(String msg, Throwable t) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.debug(msg, (Object)os, (Object)t);
        this.logRepository.addLogMessage(LogLevel.DEBUG, msg, os, t);
    }

    public void debug(String msg, Object[] os) {
        os = this.addProcessor(os);
        msg = "{} " + msg;
        this.logger.debug(msg, os);
        this.logRepository.addLogMessage(LogLevel.DEBUG, msg, os);
    }

    public void debug(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + msg + ": {}";
        this.logger.debug(msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("", t);
        }
        this.logRepository.addLogMessage(LogLevel.DEBUG, msg, os, t);
    }

    public void debug(String msg) {
        msg = "{} " + msg;
        Object[] os = new Object[]{this.processor};
        this.logger.debug(msg, os);
        this.logRepository.addLogMessage(LogLevel.DEBUG, msg, os);
    }
}

