/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.StandardPropertyValue;

public class StandardProcessContext
implements ProcessContext,
ControllerServiceLookup {
    private final ProcessorNode procNode;
    private final ControllerServiceProvider controllerServiceProvider;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;
    private final StringEncryptor encryptor;

    public StandardProcessContext(ProcessorNode processorNode, ControllerServiceProvider controllerServiceProvider, StringEncryptor encryptor) {
        this.procNode = processorNode;
        this.controllerServiceProvider = controllerServiceProvider;
        this.encryptor = encryptor;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry entry : this.procNode.getProperties().entrySet()) {
            PropertyDescriptor desc = (PropertyDescriptor)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.getProperty(descriptor.getName());
    }

    public PropertyValue getProperty(String propertyName) {
        Processor processor = this.procNode.getProcessor();
        PropertyDescriptor descriptor = processor.getPropertyDescriptor(propertyName);
        if (descriptor == null) {
            return null;
        }
        String setPropertyValue = this.procNode.getProperty(descriptor);
        String propValue = setPropertyValue == null ? descriptor.getDefaultValue() : setPropertyValue;
        return new StandardPropertyValue(propValue, this, this.preparedQueries.get(descriptor));
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new StandardPropertyValue(rawValue, this, Query.prepare((String)rawValue));
    }

    public void yield() {
        this.procNode.yield();
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerService(serviceIdentifier);
    }

    public int getMaxConcurrentTasks() {
        return this.procNode.getMaxConcurrentTasks();
    }

    public String getAnnotationData() {
        return this.procNode.getAnnotationData();
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.procNode.getProperties();
    }

    public String encrypt(String unencrypted) {
        return this.encryptor.encrypt(unencrypted);
    }

    public String decrypt(String encrypted) {
        return this.encryptor.decrypt(encrypted);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        if (!serviceType.isInterface()) {
            throw new IllegalArgumentException("ControllerServices may be referenced only via their interfaces; " + serviceType + " is not an interface");
        }
        return this.controllerServiceProvider.getControllerServiceIdentifiers(serviceType);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.controllerServiceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public Set<Relationship> getAvailableRelationships() {
        HashSet<Relationship> set = new HashSet<Relationship>();
        for (Relationship relationship : this.procNode.getRelationships()) {
            Set connections = this.procNode.getConnections(relationship);
            if (connections.isEmpty()) {
                set.add(relationship);
                continue;
            }
            boolean available = true;
            for (Connection connection : connections) {
                if (!connection.getFlowFileQueue().isFull()) continue;
                available = false;
            }
            if (!available) continue;
            set.add(relationship);
        }
        return set;
    }
}

