/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.Map;
import java.util.Set;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SchedulingContext;

public class StandardSchedulingContext
implements SchedulingContext {
    private final ProcessContext processContext;
    private final ControllerServiceProvider serviceProvider;
    private final ProcessorNode processorNode;

    public StandardSchedulingContext(ProcessContext processContext, ControllerServiceProvider serviceProvider, ProcessorNode processorNode) {
        this.processContext = processContext;
        this.serviceProvider = serviceProvider;
        this.processorNode = processorNode;
    }

    public void leaseControllerService(String identifier) {
        ControllerServiceNode serviceNode = this.serviceProvider.getControllerServiceNode(identifier);
        if (serviceNode == null) {
            throw new IllegalArgumentException("Cannot lease Controller Service because no Controller Service exists with identifier " + identifier);
        }
        if (serviceNode.isDisabled()) {
            throw new IllegalStateException("Cannot lease Controller Service because Controller Service " + serviceNode.getProxiedControllerService() + " is currently disabled");
        }
        if (!serviceNode.isValid()) {
            throw new IllegalStateException("Cannot lease Controller Service because Controller Service " + serviceNode.getProxiedControllerService() + " is not currently valid");
        }
        serviceNode.addReference((ConfiguredComponent)this.processorNode);
    }

    public PropertyValue getProperty(PropertyDescriptor descriptor) {
        return this.processContext.getProperty(descriptor);
    }

    public PropertyValue getProperty(String propertyName) {
        return this.processContext.getProperty(propertyName);
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return this.processContext.newPropertyValue(rawValue);
    }

    public void yield() {
        this.processContext.yield();
    }

    public int getMaxConcurrentTasks() {
        return this.processContext.getMaxConcurrentTasks();
    }

    public String getAnnotationData() {
        return this.processContext.getAnnotationData();
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.processContext.getProperties();
    }

    public String encrypt(String unencrypted) {
        return this.processContext.encrypt(unencrypted);
    }

    public String decrypt(String encrypted) {
        return this.processContext.decrypt(encrypted);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this.processContext.getControllerServiceLookup();
    }

    public Set<Relationship> getAvailableRelationships() {
        return this.processContext.getAvailableRelationships();
    }
}

