/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtils {
    public static Element getChild(Element element, String tagName) {
        List<Element> children = DomUtils.getChildElementsByTagName(element, tagName);
        if (children.isEmpty()) {
            return null;
        }
        if (children.size() > 1) {
            return null;
        }
        return children.get(0);
    }

    public static List<Element> getChildElementsByTagName(Element element, String tagName) {
        ArrayList<Element> matches = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element child;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(child = (Element)nodeList.item(i)).getNodeName().equals(tagName)) continue;
            matches.add(child);
        }
        return matches;
    }

    public static NodeList getChildNodesByTagName(Element element, String tagName) {
        final List<Element> elements = DomUtils.getChildElementsByTagName(element, tagName);
        return new NodeList(){

            @Override
            public Node item(int index) {
                if (index >= elements.size()) {
                    return null;
                }
                return (Node)elements.get(index);
            }

            @Override
            public int getLength() {
                return elements.size();
            }
        };
    }
}

