/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.NiFiComponentDTO;
import org.apache.nifi.web.api.dto.PositionDTO;

public final class SnippetUtils {
    public static void moveSnippet(FlowSnippetDTO snippet, Double x, Double y) {
        if (x != null && y != null) {
            PositionDTO origin = new PositionDTO(x, y);
            Collection<ConnectionDTO> connections = SnippetUtils.getConnections(snippet);
            Collection<NiFiComponentDTO> components = SnippetUtils.getComponents(snippet);
            if (connections.isEmpty() && components.isEmpty()) {
                return;
            }
            Map<NiFiComponentDTO, PositionDTO> componentPositionLookup = SnippetUtils.getPositionLookup(components);
            Map<ConnectionDTO, List<PositionDTO>> connectionPositionLookup = SnippetUtils.getConnectionPositionLookup(connections);
            PositionDTO currentOrigin = SnippetUtils.getOrigin(componentPositionLookup.values(), connectionPositionLookup.values());
            for (PositionDTO positionDTO : componentPositionLookup.values()) {
                positionDTO.setX(Double.valueOf(origin.getX() + (positionDTO.getX() - currentOrigin.getX())));
                positionDTO.setY(Double.valueOf(origin.getY() + (positionDTO.getY() - currentOrigin.getY())));
            }
            for (List list : connectionPositionLookup.values()) {
                for (PositionDTO bend : list) {
                    bend.setX(Double.valueOf(origin.getX() + (bend.getX() - currentOrigin.getX())));
                    bend.setY(Double.valueOf(origin.getY() + (bend.getY() - currentOrigin.getY())));
                }
            }
            SnippetUtils.applyUpdatedPositions(componentPositionLookup, connectionPositionLookup);
        }
    }

    private static Collection<ConnectionDTO> getConnections(FlowSnippetDTO contents) {
        HashSet<ConnectionDTO> connections = new HashSet<ConnectionDTO>();
        if (contents.getConnections() != null) {
            connections.addAll(contents.getConnections());
        }
        return connections;
    }

    private static Collection<NiFiComponentDTO> getComponents(FlowSnippetDTO contents) {
        HashSet<NiFiComponentDTO> components = new HashSet<NiFiComponentDTO>();
        if (contents.getInputPorts() != null) {
            components.addAll(contents.getInputPorts());
        }
        if (contents.getLabels() != null) {
            components.addAll(contents.getLabels());
        }
        if (contents.getOutputPorts() != null) {
            components.addAll(contents.getOutputPorts());
        }
        if (contents.getProcessGroups() != null) {
            components.addAll(contents.getProcessGroups());
        }
        if (contents.getProcessors() != null) {
            components.addAll(contents.getProcessors());
        }
        if (contents.getFunnels() != null) {
            components.addAll(contents.getFunnels());
        }
        if (contents.getRemoteProcessGroups() != null) {
            components.addAll(contents.getRemoteProcessGroups());
        }
        return components;
    }

    private static Map<NiFiComponentDTO, PositionDTO> getPositionLookup(Collection<NiFiComponentDTO> components) {
        HashMap<NiFiComponentDTO, PositionDTO> positionLookup = new HashMap<NiFiComponentDTO, PositionDTO>();
        for (NiFiComponentDTO component : components) {
            positionLookup.put(component, new PositionDTO(component.getPosition().getX(), component.getPosition().getY()));
        }
        return positionLookup;
    }

    private static Map<ConnectionDTO, List<PositionDTO>> getConnectionPositionLookup(Collection<ConnectionDTO> connections) {
        HashMap<ConnectionDTO, List<PositionDTO>> positionLookup = new HashMap<ConnectionDTO, List<PositionDTO>>();
        for (ConnectionDTO connection : connections) {
            List bendsCopy;
            if (connection.getBends() == null) {
                bendsCopy = Collections.emptyList();
            } else {
                bendsCopy = new ArrayList(connection.getBends().size());
                for (PositionDTO bend : connection.getBends()) {
                    bendsCopy.add(new PositionDTO(bend.getX(), bend.getY()));
                }
            }
            positionLookup.put(connection, bendsCopy);
        }
        return positionLookup;
    }

    private static PositionDTO getOrigin(Collection<PositionDTO> componentPositions, Collection<List<PositionDTO>> connectionPositions) {
        Double x = null;
        Double y = null;
        if (componentPositions.isEmpty() && connectionPositions.isEmpty()) {
            throw new IllegalArgumentException("Unable to compute the origin for an empty snippet.");
        }
        for (PositionDTO positionDTO : componentPositions) {
            if (positionDTO == null) continue;
            if (x == null || positionDTO.getX() < x) {
                x = positionDTO.getX();
            }
            if (y != null && !(positionDTO.getY() < y)) continue;
            y = positionDTO.getY();
        }
        for (List list : connectionPositions) {
            for (PositionDTO point : list) {
                if (x == null || point.getX() < x) {
                    x = point.getX();
                }
                if (y != null && !(point.getY() < y)) continue;
                y = point.getY();
            }
        }
        return new PositionDTO(x, y);
    }

    private static void applyUpdatedPositions(Map<NiFiComponentDTO, PositionDTO> componentPositionLookup, Map<ConnectionDTO, List<PositionDTO>> connectionPositionLookup) {
        for (Map.Entry<NiFiComponentDTO, PositionDTO> entry : componentPositionLookup.entrySet()) {
            NiFiComponentDTO component = entry.getKey();
            PositionDTO position = entry.getValue();
            component.setPosition(position);
        }
        for (Map.Entry<Object, Object> entry : connectionPositionLookup.entrySet()) {
            ConnectionDTO connection = (ConnectionDTO)entry.getKey();
            List bends = (List)entry.getValue();
            connection.setBends(bends);
        }
    }
}

