/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.nifi.controller.Snippet;

@XmlRootElement(name="snippet")
public class StandardSnippet
implements Snippet {
    private String id;
    private String parentGroupId;
    private Boolean linked;
    private final Set<String> processGroups = new HashSet<String>();
    private final Set<String> remoteProcessGroups = new HashSet<String>();
    private final Set<String> processors = new HashSet<String>();
    private final Set<String> inputPorts = new HashSet<String>();
    private final Set<String> outputPorts = new HashSet<String>();
    private final Set<String> connections = new HashSet<String>();
    private final Set<String> labels = new HashSet<String>();
    private final Set<String> funnels = new HashSet<String>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isLinked() {
        if (this.linked == null) {
            return false;
        }
        return this.linked;
    }

    public void setLinked(Boolean linked) {
        this.linked = linked;
    }

    public String getParentGroupId() {
        return this.parentGroupId;
    }

    public void setParentGroupId(String parentGroupId) {
        this.parentGroupId = parentGroupId;
    }

    public Set<String> getConnections() {
        return Collections.unmodifiableSet(this.connections);
    }

    public void addConnections(Collection<String> ids) {
        this.connections.addAll(ids);
    }

    public Set<String> getFunnels() {
        return Collections.unmodifiableSet(this.funnels);
    }

    public void addFunnels(Collection<String> ids) {
        this.funnels.addAll(ids);
    }

    public Set<String> getInputPorts() {
        return Collections.unmodifiableSet(this.inputPorts);
    }

    public void addInputPorts(Collection<String> ids) {
        this.inputPorts.addAll(ids);
    }

    public Set<String> getOutputPorts() {
        return Collections.unmodifiableSet(this.outputPorts);
    }

    public void addOutputPorts(Collection<String> ids) {
        this.outputPorts.addAll(ids);
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    public void addLabels(Collection<String> ids) {
        this.labels.addAll(ids);
    }

    public Set<String> getProcessGroups() {
        return Collections.unmodifiableSet(this.processGroups);
    }

    public void addProcessGroups(Collection<String> ids) {
        this.processGroups.addAll(ids);
    }

    public Set<String> getProcessors() {
        return Collections.unmodifiableSet(this.processors);
    }

    public void addProcessors(Collection<String> ids) {
        this.processors.addAll(ids);
    }

    public Set<String> getRemoteProcessGroups() {
        return Collections.unmodifiableSet(this.remoteProcessGroups);
    }

    public void addRemoteProcessGroups(Collection<String> ids) {
        this.remoteProcessGroups.addAll(ids);
    }

    public boolean isEmpty() {
        return this.processors.isEmpty() && this.processGroups.isEmpty() && this.remoteProcessGroups.isEmpty() && this.labels.isEmpty() && this.inputPorts.isEmpty() && this.outputPorts.isEmpty() && this.connections.isEmpty() && this.funnels.isEmpty();
    }
}

