/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;

public final class StandardFlowFileRecord
implements FlowFile,
FlowFileRecord {
    private final long id;
    private final long entryDate;
    private final long lineageStartDate;
    private final Set<String> lineageIdentifiers;
    private final long size;
    private final long penaltyExpirationMs;
    private final Map<String, String> attributes;
    private final ContentClaim claim;
    private final long claimOffset;
    private final long lastQueueDate;

    private StandardFlowFileRecord(Builder builder) {
        this.id = builder.bId;
        this.attributes = builder.bAttributes;
        this.entryDate = builder.bEntryDate;
        this.lineageStartDate = builder.bLineageStartDate;
        this.lineageIdentifiers = builder.bLineageIdentifiers;
        this.penaltyExpirationMs = builder.bPenaltyExpirationMs;
        this.size = builder.bSize;
        this.claim = builder.bClaim;
        this.claimOffset = builder.bClaimOffset;
        this.lastQueueDate = builder.bLastQueueDate;
    }

    public long getId() {
        return this.id;
    }

    public long getEntryDate() {
        return this.entryDate;
    }

    public Set<String> getLineageIdentifiers() {
        return Collections.unmodifiableSet(this.lineageIdentifiers);
    }

    public long getLineageStartDate() {
        return this.lineageStartDate;
    }

    public Long getLastQueueDate() {
        return this.lastQueueDate;
    }

    public boolean isPenalized() {
        return this.penaltyExpirationMs > 0L ? this.penaltyExpirationMs > System.currentTimeMillis() : false;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public long getSize() {
        return this.size;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public ContentClaim getContentClaim() {
        return this.claim;
    }

    public long getContentClaimOffset() {
        return this.claimOffset;
    }

    public int compareTo(FlowFile other) {
        return new CompareToBuilder().append(this.id, other.getId()).toComparison();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StandardFlowFileRecord)) {
            return false;
        }
        StandardFlowFileRecord otherRecord = (StandardFlowFileRecord)other;
        return new EqualsBuilder().append(this.id, otherRecord.id).isEquals();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("uuid", (Object)this.getAttribute(CoreAttributes.UUID.key()));
        builder.append("claim", (Object)(this.claim == null ? "" : this.claim.getId()));
        builder.append("offset", this.claimOffset);
        builder.append("name", (Object)this.getAttribute(CoreAttributes.FILENAME.key())).append("size", this.size);
        return builder.toString();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 13).append(this.id).toHashCode();
    }

    public long getPenaltyExpirationMillis() {
        return this.penaltyExpirationMs;
    }

    public static final class Builder {
        private long bId;
        private long bEntryDate;
        private long bLineageStartDate;
        private final Set<String> bLineageIdentifiers;
        private long bPenaltyExpirationMs;
        private long bSize;
        private Map<String, String> bAttributes;
        private ContentClaim bClaim;
        private long bClaimOffset;
        private long bLastQueueDate;

        public Builder() {
            this.bLineageStartDate = this.bEntryDate = System.currentTimeMillis();
            this.bLineageIdentifiers = new HashSet<String>();
            this.bPenaltyExpirationMs = -1L;
            this.bSize = 0L;
            this.bAttributes = new HashMap<String, String>();
            this.bClaim = null;
            this.bClaimOffset = 0L;
            this.bLastQueueDate = System.currentTimeMillis();
        }

        public Builder id(long id) {
            this.bId = id;
            return this;
        }

        public Builder lineageIdentifiers(Collection<String> lineageIdentifiers) {
            if (null != lineageIdentifiers) {
                this.bLineageIdentifiers.clear();
                this.bLineageIdentifiers.addAll(lineageIdentifiers);
            }
            return this;
        }

        public Builder entryDate(long epochMs) {
            this.bEntryDate = epochMs;
            return this;
        }

        public Builder lineageStartDate(long lineageStartDate) {
            this.bLineageStartDate = lineageStartDate;
            return this;
        }

        public Builder penaltyExpirationTime(long epochMilliseconds) {
            this.bPenaltyExpirationMs = epochMilliseconds;
            return this;
        }

        public Builder size(long bytes) {
            if (bytes >= 0L) {
                this.bSize = bytes;
            }
            return this;
        }

        public Builder addAttribute(String key, String value) {
            if (key != null && value != null) {
                this.bAttributes.put(FlowFile.KeyValidator.validateKey((String)key), value);
            }
            return this;
        }

        public Builder addAttributes(Map<String, String> attributes) {
            if (null != attributes) {
                for (String string : attributes.keySet()) {
                    FlowFile.KeyValidator.validateKey((String)string);
                }
                for (Map.Entry entry : attributes.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (key == null || value == null) continue;
                    this.bAttributes.put(key, value);
                }
            }
            return this;
        }

        public Builder removeAttributes(String ... keys) {
            if (keys != null) {
                for (String key : keys) {
                    this.bAttributes.remove(key);
                }
            }
            return this;
        }

        public Builder removeAttributes(Set<String> keys) {
            if (keys != null) {
                for (String key : keys) {
                    this.bAttributes.remove(key);
                }
            }
            return this;
        }

        public Builder removeAttributes(Pattern keyPattern) {
            if (keyPattern != null) {
                Iterator<String> iterator = this.bAttributes.keySet().iterator();
                while (iterator.hasNext()) {
                    String key = iterator.next();
                    if (!keyPattern.matcher(key).matches()) continue;
                    iterator.remove();
                }
            }
            return this;
        }

        public Builder contentClaim(ContentClaim claim) {
            this.bClaim = claim;
            return this;
        }

        public Builder contentClaimOffset(long offset) {
            this.bClaimOffset = offset;
            return this;
        }

        public Builder lastQueueDate(long lastQueueDate) {
            this.bLastQueueDate = lastQueueDate;
            return this;
        }

        public Builder fromFlowFile(FlowFileRecord specFlowFile) {
            if (specFlowFile == null) {
                return this;
            }
            this.bId = specFlowFile.getId();
            this.bEntryDate = specFlowFile.getEntryDate();
            this.bLineageStartDate = specFlowFile.getLineageStartDate();
            this.bLineageIdentifiers.clear();
            this.bLineageIdentifiers.addAll(specFlowFile.getLineageIdentifiers());
            this.bPenaltyExpirationMs = specFlowFile.getPenaltyExpirationMillis();
            this.bSize = specFlowFile.getSize();
            this.bAttributes.putAll(specFlowFile.getAttributes());
            this.bClaim = specFlowFile.getContentClaim();
            this.bClaimOffset = specFlowFile.getContentClaimOffset();
            return this;
        }

        public FlowFileRecord build() {
            return new StandardFlowFileRecord(this);
        }
    }
}

