/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.claim;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.controller.repository.claim.ContentClaim;

public final class StandardContentClaim
implements ContentClaim,
Comparable<ContentClaim> {
    private final String id;
    private final String container;
    private final String section;
    private final boolean lossTolerant;
    private final AtomicInteger claimantCount = new AtomicInteger(0);
    private final int hashCode;

    StandardContentClaim(String container, String section, String id, boolean lossTolerant) {
        this.container = container.intern();
        this.section = section.intern();
        this.id = id;
        this.lossTolerant = lossTolerant;
        this.hashCode = 17 + 19 * id.hashCode() + 19 * container.hashCode() + 19 * section.hashCode();
    }

    public boolean isLossTolerant() {
        return this.lossTolerant;
    }

    public String getId() {
        return this.id;
    }

    public String getContainer() {
        return this.container;
    }

    public String getSection() {
        return this.section;
    }

    int getClaimantCount() {
        return this.claimantCount.get();
    }

    int decrementClaimantCount() {
        return this.claimantCount.decrementAndGet();
    }

    int incrementClaimantCount() {
        return this.claimantCount.incrementAndGet();
    }

    @Override
    public int compareTo(ContentClaim other) {
        int idComparison = this.id.compareTo(other.getId());
        if (idComparison != 0) {
            return idComparison;
        }
        int containerComparison = this.container.compareTo(other.getContainer());
        if (containerComparison != 0) {
            return containerComparison;
        }
        return this.section.compareTo(other.getSection());
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.hashCode != other.hashCode()) {
            return false;
        }
        if (!(other instanceof ContentClaim)) {
            return false;
        }
        ContentClaim otherClaim = (ContentClaim)other;
        return this.id.equals(otherClaim.getId()) && this.container.equals(otherClaim.getContainer()) && this.section.equals(otherClaim.getSection());
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "ContentClaim[id=" + this.id + ", container=" + this.container + ", section=" + this.section + "]";
    }
}

