/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.processor.StandardPropertyValue;

public class StandardConfigurationContext
implements ConfigurationContext {
    private final ConfiguredComponent component;
    private final ControllerServiceLookup serviceLookup;
    private final Map<PropertyDescriptor, PreparedQuery> preparedQueries;

    public StandardConfigurationContext(ConfiguredComponent component, ControllerServiceLookup serviceLookup) {
        this.component = component;
        this.serviceLookup = serviceLookup;
        this.preparedQueries = new HashMap<PropertyDescriptor, PreparedQuery>();
        for (Map.Entry entry : component.getProperties().entrySet()) {
            PropertyDescriptor desc = (PropertyDescriptor)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = desc.getDefaultValue();
            }
            PreparedQuery pq = Query.prepare((String)value);
            this.preparedQueries.put(desc, pq);
        }
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.component.getProperty(property);
        return new StandardPropertyValue(configuredValue == null ? property.getDefaultValue() : configuredValue, this.serviceLookup, this.preparedQueries.get(property));
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.component.getProperties();
    }
}

