/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.events.BulletinProcessingStrategy;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinQuery;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.util.RingBuffer;

public class VolatileBulletinRepository
implements BulletinRepository {
    private static final int CONTROLLER_BUFFER_SIZE = 10;
    private static final int COMPONENT_BUFFER_SIZE = 5;
    private static final String CONTROLLER_BULLETIN_STORE_KEY = "CONTROLLER";
    private final ConcurrentMap<String, ConcurrentMap<String, RingBuffer<Bulletin>>> bulletinStoreMap = new ConcurrentHashMap<String, ConcurrentMap<String, RingBuffer<Bulletin>>>();
    private volatile BulletinProcessingStrategy processingStrategy = new DefaultBulletinProcessingStrategy();

    public void addBulletin(Bulletin bulletin) {
        this.processingStrategy.update(bulletin);
    }

    public int getControllerBulletinCapacity() {
        return 10;
    }

    public int getComponentBulletinCapacity() {
        return 5;
    }

    public List<Bulletin> findBulletins(final BulletinQuery bulletinQuery) {
        RingBuffer.Filter<Bulletin> filter = new RingBuffer.Filter<Bulletin>(){

            public boolean select(Bulletin bulletin) {
                long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
                if (bulletin.getTimestamp().getTime() < fiveMinutesAgo) {
                    return false;
                }
                if (bulletinQuery.getAfter() != null && bulletin.getId() <= bulletinQuery.getAfter()) {
                    return false;
                }
                if (!(bulletinQuery.getGroupIdPattern() == null || bulletin.getGroupId() != null && bulletinQuery.getGroupIdPattern().matcher(bulletin.getGroupId()).find())) {
                    return false;
                }
                if (!(bulletinQuery.getMessagePattern() == null || bulletin.getMessage() != null && bulletinQuery.getMessagePattern().matcher(bulletin.getMessage()).find())) {
                    return false;
                }
                if (!(bulletinQuery.getNamePattern() == null || bulletin.getSourceName() != null && bulletinQuery.getNamePattern().matcher(bulletin.getSourceName()).find())) {
                    return false;
                }
                return bulletinQuery.getSourceIdPattern() == null || bulletin.getSourceId() != null && bulletinQuery.getSourceIdPattern().matcher(bulletin.getSourceId()).find();
            }
        };
        ArrayList<Bulletin> selected = new ArrayList<Bulletin>();
        int max = bulletinQuery.getLimit() == null ? Integer.MAX_VALUE : bulletinQuery.getLimit();
        block0: for (ConcurrentMap componentMap : this.bulletinStoreMap.values()) {
            for (RingBuffer ringBuffer : componentMap.values()) {
                List bulletinsForComponent = ringBuffer.getSelectedElements((RingBuffer.Filter)filter, max);
                selected.addAll(bulletinsForComponent);
                if ((max -= bulletinsForComponent.size()) > 0) continue;
                continue block0;
            }
        }
        Collections.sort(selected);
        return selected;
    }

    public List<Bulletin> findBulletinsForGroupBySource(String groupId) {
        return this.findBulletinsForGroupBySource(groupId, 5);
    }

    public List<Bulletin> findBulletinsForGroupBySource(String groupId, int maxPerComponent) {
        final long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
        ConcurrentMap componentMap = (ConcurrentMap)this.bulletinStoreMap.get(groupId);
        if (componentMap == null) {
            return Collections.emptyList();
        }
        ArrayList<Bulletin> allComponentBulletins = new ArrayList<Bulletin>();
        for (RingBuffer ringBuffer : componentMap.values()) {
            allComponentBulletins.addAll(ringBuffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<Bulletin>(){

                public boolean select(Bulletin bulletin) {
                    return bulletin.getTimestamp().getTime() >= fiveMinutesAgo;
                }
            }, maxPerComponent));
        }
        return allComponentBulletins;
    }

    public List<Bulletin> findBulletinsForController() {
        return this.findBulletinsForController(10);
    }

    public List<Bulletin> findBulletinsForController(int max) {
        final long fiveMinutesAgo = System.currentTimeMillis() - TimeUnit.MINUTES.toMillis(5L);
        ConcurrentMap componentMap = (ConcurrentMap)this.bulletinStoreMap.get(CONTROLLER_BULLETIN_STORE_KEY);
        if (componentMap == null) {
            return Collections.emptyList();
        }
        RingBuffer buffer = (RingBuffer)componentMap.get(CONTROLLER_BULLETIN_STORE_KEY);
        return buffer == null ? Collections.emptyList() : buffer.getSelectedElements((RingBuffer.Filter)new RingBuffer.Filter<Bulletin>(){

            public boolean select(Bulletin bulletin) {
                return bulletin.getTimestamp().getTime() >= fiveMinutesAgo;
            }
        }, max);
    }

    public void overrideDefaultBulletinProcessing(BulletinProcessingStrategy strategy) {
        Objects.requireNonNull(strategy);
        this.processingStrategy = strategy;
    }

    public void restoreDefaultBulletinProcessing() {
        this.processingStrategy = new DefaultBulletinProcessingStrategy();
    }

    private RingBuffer<Bulletin> getBulletinBuffer(Bulletin bulletin) {
        int bufferSize;
        RingBuffer existingBuffer;
        boolean controllerBulletin;
        String sourceId;
        RingBuffer bulletinBuffer;
        ConcurrentMap existing;
        String groupId = this.getBulletinStoreKey(bulletin);
        ConcurrentMap<String, RingBuffer> componentMap = (ConcurrentHashMap)this.bulletinStoreMap.get(groupId);
        if (componentMap == null && (existing = (ConcurrentMap)this.bulletinStoreMap.putIfAbsent(groupId, componentMap = new ConcurrentHashMap())) != null) {
            componentMap = existing;
        }
        if ((bulletinBuffer = (RingBuffer)componentMap.get(sourceId = (controllerBulletin = this.isControllerBulletin(bulletin)) ? CONTROLLER_BULLETIN_STORE_KEY : bulletin.getSourceId())) == null && (existingBuffer = componentMap.putIfAbsent(sourceId, bulletinBuffer = new RingBuffer(bufferSize = controllerBulletin ? 10 : 5))) != null) {
            bulletinBuffer = existingBuffer;
        }
        return bulletinBuffer;
    }

    private String getBulletinStoreKey(Bulletin bulletin) {
        return this.isControllerBulletin(bulletin) ? CONTROLLER_BULLETIN_STORE_KEY : bulletin.getGroupId();
    }

    private boolean isControllerBulletin(Bulletin bulletin) {
        return bulletin.getGroupId() == null;
    }

    private class DefaultBulletinProcessingStrategy
    implements BulletinProcessingStrategy {
        private DefaultBulletinProcessingStrategy() {
        }

        public void update(Bulletin bulletin) {
            RingBuffer bulletinBuffer = VolatileBulletinRepository.this.getBulletinBuffer(bulletin);
            bulletinBuffer.add((Object)bulletin);
        }
    }
}

