/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.Counter;

public class StandardCounter
implements Counter {
    private final String identifier;
    private final String context;
    private final String name;
    private final AtomicLong value;

    public StandardCounter(String identifier, String context, String name) {
        this.identifier = identifier;
        this.context = context;
        this.name = name;
        this.value = new AtomicLong(0L);
    }

    public void adjust(long delta) {
        this.value.addAndGet(delta);
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value.get();
    }

    public String getContext() {
        return this.context;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void reset() {
        this.value.set(0L);
    }

    public String toString() {
        return "Counter[identifier=" + this.identifier + ", context=" + this.context + ", name=" + this.name + ", value=" + this.value + ']';
    }

    public static UnmodifiableCounter unmodifiableCounter(Counter counter) {
        return new UnmodifiableCounter(counter);
    }

    static class UnmodifiableCounter
    extends StandardCounter {
        private final Counter counter;

        public UnmodifiableCounter(Counter counter) {
            super(counter.getIdentifier(), counter.getContext(), counter.getName());
            this.counter = counter;
        }

        @Override
        public void adjust(long delta) {
            throw new UnsupportedOperationException("Cannot modify value of UnmodifiableCounter");
        }

        @Override
        public String getName() {
            return this.counter.getName();
        }

        @Override
        public long getValue() {
            return this.counter.getValue();
        }

        @Override
        public String getContext() {
            return this.counter.getContext();
        }

        @Override
        public String getIdentifier() {
            return this.counter.getIdentifier();
        }

        @Override
        public String toString() {
            return this.counter.toString();
        }
    }
}

