/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.nifi.cluster.ConnectionException;
import org.apache.nifi.cluster.protocol.ConnectionRequest;
import org.apache.nifi.cluster.protocol.ConnectionResponse;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.ProtocolException;
import org.apache.nifi.cluster.protocol.ProtocolHandler;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.cluster.protocol.UnknownServiceAddressException;
import org.apache.nifi.cluster.protocol.impl.NodeProtocolSenderListener;
import org.apache.nifi.cluster.protocol.message.ConnectionRequestMessage;
import org.apache.nifi.cluster.protocol.message.ControllerStartupFailureMessage;
import org.apache.nifi.cluster.protocol.message.DisconnectMessage;
import org.apache.nifi.cluster.protocol.message.FlowRequestMessage;
import org.apache.nifi.cluster.protocol.message.FlowResponseMessage;
import org.apache.nifi.cluster.protocol.message.PrimaryRoleAssignmentMessage;
import org.apache.nifi.cluster.protocol.message.ProtocolMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionFailureMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionRequestMessage;
import org.apache.nifi.cluster.protocol.message.ReconnectionResponseMessage;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.FlowSerializationException;
import org.apache.nifi.controller.FlowSynchronizationException;
import org.apache.nifi.controller.SnippetManager;
import org.apache.nifi.controller.StandardFlowSynchronizer;
import org.apache.nifi.controller.StandardSnippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.TemplateManager;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.lifecycle.LifeCycleStartException;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.persistence.FlowConfigurationDAO;
import org.apache.nifi.persistence.StandardXMLFlowConfigurationDAO;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.services.FlowService;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardFlowService
implements FlowService,
ProtocolHandler {
    private static final String EVENT_CATEGORY = "Controller";
    private final FlowController controller;
    private final Path flowXml;
    private final FlowConfigurationDAO dao;
    private final int gracefulShutdownSeconds;
    private final boolean autoResumeState;
    private final int connectionRetryMillis;
    private final StringEncryptor encryptor;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final AtomicReference<ScheduledExecutorService> executor = new AtomicReference<Object>(null);
    private final AtomicReference<SaveHolder> saveHolder = new AtomicReference<Object>(null);
    private final NodeProtocolSenderListener senderListener;
    private final boolean configuredForClustering;
    private NodeIdentifier nodeId;
    private boolean firstControllerInitialization = true;
    private static final String CONNECTION_EXCEPTION_MSG_PREFIX = "Failed to connect node to cluster because ";
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowService.class);

    public static StandardFlowService createStandaloneInstance(FlowController controller, NiFiProperties properties, StringEncryptor encryptor) throws IOException {
        return new StandardFlowService(controller, properties, null, encryptor, false);
    }

    public static StandardFlowService createClusteredInstance(FlowController controller, NiFiProperties properties, NodeProtocolSenderListener senderListener, StringEncryptor encryptor) throws IOException {
        return new StandardFlowService(controller, properties, senderListener, encryptor, true);
    }

    private StandardFlowService(FlowController controller, NiFiProperties properties, NodeProtocolSenderListener senderListener, StringEncryptor encryptor, boolean configuredForClustering) throws IOException {
        this.controller = controller;
        this.encryptor = encryptor;
        this.flowXml = Paths.get(properties.getProperty("nifi.flow.configuration.file"), new String[0]);
        this.gracefulShutdownSeconds = (int)FormatUtils.getTimeDuration((String)properties.getProperty("nifi.flowcontroller.graceful.shutdown.period"), (TimeUnit)TimeUnit.SECONDS);
        this.autoResumeState = properties.getAutoResumeState();
        this.connectionRetryMillis = (int)FormatUtils.getTimeDuration((String)properties.getClusterManagerFlowRetrievalDelay(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.dao = new StandardXMLFlowConfigurationDAO(this.flowXml, encryptor);
        if (configuredForClustering) {
            this.configuredForClustering = configuredForClustering;
            this.senderListener = senderListener;
            senderListener.addHandler((ProtocolHandler)this);
            InetSocketAddress nodeApiAddress = properties.getNodeApiAddress();
            InetSocketAddress nodeSocketAddress = properties.getClusterNodeProtocolAddress();
            this.nodeId = new NodeIdentifier(UUID.randomUUID().toString(), nodeApiAddress.getHostName(), nodeApiAddress.getPort(), nodeSocketAddress.getHostName(), nodeSocketAddress.getPort());
        } else {
            this.configuredForClustering = false;
            this.senderListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFlowChanges() throws IOException {
        this.writeLock.lock();
        try {
            this.dao.save(this.controller);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveFlowChanges(OutputStream outStream) throws IOException {
        this.writeLock.lock();
        try {
            this.dao.save(this.controller, outStream);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overwriteFlow(InputStream is) throws IOException {
        this.writeLock.lock();
        try (OutputStream output = Files.newOutputStream(this.flowXml, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
             GZIPOutputStream gzipOut = new GZIPOutputStream(output);){
            FileUtils.copy((InputStream)is, (OutputStream)gzipOut);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void saveFlowChanges(TimeUnit delayUnit, long delay) {
        this.saveFlowChanges(delayUnit, delay, false);
    }

    @Override
    public void saveFlowChanges(TimeUnit delayUnit, long delay, boolean archive) {
        Calendar saveTime = Calendar.getInstance();
        long delayInMs = TimeUnit.MILLISECONDS.convert(delay, delayUnit);
        int finalDelayMs = 500;
        if (delayInMs <= Integer.MAX_VALUE) {
            finalDelayMs = (int)delayInMs;
        }
        saveTime.add(14, finalDelayMs);
        if (logger.isTraceEnabled()) {
            logger.trace(" A request to save the flow has been made with delay {} for time {}", (Object)finalDelayMs, (Object)saveTime.getTime());
        }
        this.saveHolder.set(new SaveHolder(saveTime, archive));
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public void start() throws LifeCycleStartException {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                return;
            }
            this.running.set(true);
            FlowEngine newExecutor = new FlowEngine(2, "Flow Service Tasks");
            newExecutor.scheduleWithFixedDelay(new SaveReportingTask(), 0L, 500L, TimeUnit.MILLISECONDS);
            this.executor.set(newExecutor);
            if (this.configuredForClustering) {
                this.senderListener.start();
            }
        }
        catch (IOException ioe) {
            try {
                this.stop(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new LifeCycleStartException("Failed to start Flow Service due to: " + ioe, ioe);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean force) {
        block14: {
            this.writeLock.lock();
            try {
                boolean graceful;
                ScheduledExecutorService executorService;
                if (!this.isRunning()) {
                    return;
                }
                this.running.set(false);
                if (!this.controller.isTerminated()) {
                    this.controller.shutdown(force);
                }
                if (this.configuredForClustering && this.senderListener != null) {
                    try {
                        this.senderListener.stop();
                    }
                    catch (IOException ioe) {
                        logger.warn("Protocol sender/listener did not stop gracefully due to: " + ioe);
                    }
                }
                if ((executorService = this.executor.get()) == null) break block14;
                if (force) {
                    executorService.shutdownNow();
                } else {
                    executorService.shutdown();
                }
                try {
                    graceful = executorService.awaitTermination(this.gracefulShutdownSeconds, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    graceful = false;
                }
                if (!graceful) {
                    logger.warn("Scheduling service did not gracefully shutdown within configured " + this.gracefulShutdownSeconds + " second window");
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public boolean canHandle(ProtocolMessage msg) {
        switch (msg.getType()) {
            case RECONNECTION_REQUEST: 
            case DISCONNECTION_REQUEST: 
            case FLOW_REQUEST: 
            case PRIMARY_ROLE: {
                return true;
            }
        }
        return false;
    }

    public ProtocolMessage handle(final ProtocolMessage request) throws ProtocolException {
        long startNanos = System.nanoTime();
        try {
            switch (request.getType()) {
                case FLOW_REQUEST: {
                    FlowResponseMessage flowResponseMessage = this.handleFlowRequest((FlowRequestMessage)request);
                    return flowResponseMessage;
                }
                case RECONNECTION_REQUEST: {
                    this.controller.suspendHeartbeats();
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            StandardFlowService.this.handleReconnectionRequest((ReconnectionRequestMessage)request);
                        }
                    }, "Reconnect to Cluster").start();
                    ReconnectionResponseMessage reconnectionResponseMessage = new ReconnectionResponseMessage();
                    return reconnectionResponseMessage;
                }
                case DISCONNECTION_REQUEST: {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            StandardFlowService.this.handleDisconnectionRequest((DisconnectMessage)request);
                        }
                    }, "Disconnect from Cluster").start();
                    ProtocolMessage protocolMessage = null;
                    return protocolMessage;
                }
                case PRIMARY_ROLE: {
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            StandardFlowService.this.handlePrimaryRoleAssignment((PrimaryRoleAssignmentMessage)request);
                        }
                    }, "Set Primary Role Status").start();
                    ProtocolMessage protocolMessage = null;
                    return protocolMessage;
                }
            }
            throw new ProtocolException("Handler cannot handle message type: " + request.getType());
        }
        finally {
            if (logger.isDebugEnabled()) {
                long procNanos = System.nanoTime() - startNanos;
                long procMillis = TimeUnit.MILLISECONDS.convert(procNanos, TimeUnit.NANOSECONDS);
                logger.debug("Finished Processing Protocol Message of type {} in {} millis", (Object)request.getType(), (Object)procMillis);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(DataFlow proposedFlow) throws IOException, FlowSerializationException, FlowSynchronizationException, UninheritableFlowException {
        block12: {
            this.writeLock.lock();
            try {
                if (this.configuredForClustering) {
                    boolean localFlowEmpty = StandardFlowSynchronizer.isEmpty(proposedFlow, this.encryptor);
                    ConnectionResponse response = this.connect(localFlowEmpty, localFlowEmpty);
                    if (response == null) {
                        logger.info("Flow controller will load local dataflow and suspend connection handshake until a cluster connection response is received.");
                        this.loadFromBytes(proposedFlow, false);
                        this.controller.setNodeId(this.nodeId);
                        this.controller.setClustered(true, null);
                        this.controller.setClusterManagerRemoteSiteInfo(null, null);
                        this.controller.setConnected(false);
                        this.controller.startHeartbeating();
                        try {
                            this.controller.onFlowInitialized(this.autoResumeState);
                        }
                        catch (Exception ex) {
                            logger.warn("Unable to start all processors due to invalid flow configuration.");
                            if (logger.isDebugEnabled()) {
                                logger.warn("", (Throwable)ex);
                            }
                            break block12;
                        }
                    }
                    try {
                        this.loadFromConnectionResponse(response);
                        break block12;
                    }
                    catch (ConnectionException ce) {
                        logger.error("Failed to load flow from cluster due to: " + ce, (Throwable)ce);
                        ControllerStartupFailureMessage msg = new ControllerStartupFailureMessage();
                        msg.setExceptionMessage(ce.getMessage());
                        msg.setNodeId(response.getNodeIdentifier());
                        try {
                            this.senderListener.notifyControllerStartupFailure(msg);
                        }
                        catch (ProtocolException | UnknownServiceAddressException e) {
                            logger.warn("Failed to notify cluster manager of controller startup failure due to: " + e, e);
                        }
                        throw new IOException(ce);
                    }
                }
                this.loadFromBytes(proposedFlow, true);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    private FlowResponseMessage handleFlowRequest(FlowRequestMessage request) throws ProtocolException {
        this.readLock.lock();
        try {
            logger.info("Received flow request message from manager.");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.copyCurrentFlow(baos);
            byte[] flowBytes = baos.toByteArray();
            baos.reset();
            byte[] templateBytes = this.controller.getTemplateManager().export();
            byte[] snippetBytes = this.controller.getSnippetManager().export();
            FlowResponseMessage response = new FlowResponseMessage();
            response.setDataFlow(new StandardDataFlow(flowBytes, templateBytes, snippetBytes));
            FlowResponseMessage flowResponseMessage = response;
            return flowResponseMessage;
        }
        catch (Exception ex) {
            throw new ProtocolException("Failed serializing flow controller state for flow request due to: " + ex, (Throwable)ex);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePrimaryRoleAssignment(PrimaryRoleAssignmentMessage msg) {
        this.writeLock.lock();
        try {
            this.controller.setPrimary(msg.isPrimary());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReconnectionRequest(ReconnectionRequestMessage request) {
        this.writeLock.lock();
        try {
            logger.info("Processing reconnection request from manager.");
            ConnectionResponse connectionResponse = new ConnectionResponse(this.nodeId, request.getDataFlow(), request.isPrimary(), request.getManagerRemoteSiteListeningPort(), request.isManagerRemoteSiteCommsSecure(), request.getInstanceId());
            connectionResponse.setClusterManagerDN(request.getRequestorDN());
            this.loadFromConnectionResponse(connectionResponse);
            this.controller.resumeHeartbeats();
            logger.info("Node reconnected.");
        }
        catch (Exception ex) {
            if (this.controller.isClustered()) {
                this.disconnect();
            }
            logger.error("Handling reconnection request failed due to: " + ex, (Throwable)ex);
            ReconnectionFailureMessage failureMessage = new ReconnectionFailureMessage();
            failureMessage.setNodeId(request.getNodeId());
            failureMessage.setExceptionMessage(ex.toString());
            try {
                this.senderListener.notifyReconnectionFailure(failureMessage);
            }
            catch (ProtocolException | UnknownServiceAddressException e) {
                logger.warn("Failed to notify cluster manager of controller reconnection failure due to: " + e, e);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDisconnectionRequest(DisconnectMessage request) {
        this.writeLock.lock();
        try {
            logger.info("Received disconnection request message from manager with explanation: " + request.getExplanation());
            this.disconnect();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        this.writeLock.lock();
        try {
            logger.info("Disconnecting node.");
            this.controller.setConnected(false);
            this.controller.setPrimary(false);
            this.controller.stopHeartbeating();
            this.controller.setClustered(false, null);
            logger.info("Node disconnected.");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void loadFromBytes(DataFlow proposedFlow, boolean allowEmptyFlow) throws IOException, FlowSerializationException, FlowSynchronizationException, UninheritableFlowException {
        byte[] templateBytes;
        byte[] flowBytes;
        logger.trace("Loading flow from bytes");
        TemplateManager templateManager = this.controller.getTemplateManager();
        templateManager.loadTemplates();
        logger.trace("Finished loading templates");
        if (proposedFlow == null) {
            ByteArrayOutputStream flowOnDisk = new ByteArrayOutputStream();
            this.copyCurrentFlow(flowOnDisk);
            flowBytes = flowOnDisk.toByteArray();
            templateBytes = templateManager.export();
            logger.debug("Loaded Flow from bytes");
        } else {
            flowBytes = proposedFlow.getFlow();
            templateBytes = proposedFlow.getTemplates();
            logger.debug("Loaded flow from proposed flow");
        }
        StandardDataFlow actualProposedFlow = new StandardDataFlow(flowBytes, templateBytes, null);
        if (this.firstControllerInitialization) {
            logger.debug("Loading controller services");
        }
        logger.debug("Loading proposed flow into FlowController");
        this.dao.load(this.controller, (DataFlow)actualProposedFlow);
        ProcessGroup rootGroup = this.controller.getGroup(this.controller.getRootGroupId());
        if (rootGroup.isEmpty() && !allowEmptyFlow) {
            throw new FlowSynchronizationException("Failed to load flow because unable to connect to cluster and local flow is empty");
        }
        if (this.firstControllerInitialization) {
            logger.debug("First controller initialization. Loading reporting tasks and initializing controller.");
            this.controller.initializeFlow();
            this.firstControllerInitialization = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionResponse connect(boolean retryOnCommsFailure, boolean retryIndefinitely) throws ConnectionException {
        this.writeLock.lock();
        try {
            logger.info("Connecting Node: " + this.nodeId);
            ConnectionRequest request = new ConnectionRequest(this.nodeId);
            ConnectionRequestMessage requestMsg = new ConnectionRequestMessage();
            requestMsg.setConnectionRequest(request);
            int maxAttempts = 10;
            ConnectionResponse response = null;
            for (int i = 0; i < 10 || retryIndefinitely; ++i) {
                try {
                    response = this.senderListener.requestConnection(requestMsg).getConnectionResponse();
                    if (response.isBlockedByFirewall()) {
                        logger.warn("Connection request was blocked by cluster manager's firewall.");
                        response = null;
                        break;
                    }
                    if (!response.shouldTryLater()) break;
                    logger.info("Flow controller requested by cluster manager to retry connection in " + response.getTryLaterSeconds() + " seconds.");
                    try {
                        Thread.sleep(response.getTryLaterSeconds() * 1000);
                        continue;
                    }
                    catch (InterruptedException ie) {
                    }
                }
                catch (Exception pe) {
                    logger.warn("Failed to connect to cluster due to: " + pe, (Throwable)pe);
                    if (!retryOnCommsFailure) break;
                    try {
                        Thread.sleep(this.connectionRetryMillis);
                        continue;
                    }
                    catch (InterruptedException ie) {}
                }
                break;
            }
            if (response == null) {
                ConnectionResponse connectionResponse = response;
                return connectionResponse;
            }
            if (response.shouldTryLater()) {
                ConnectionResponse connectionResponse = null;
                return connectionResponse;
            }
            ConnectionResponse connectionResponse = response;
            return connectionResponse;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void loadFromConnectionResponse(ConnectionResponse response) throws ConnectionException {
        this.writeLock.lock();
        try {
            StandardDataFlow dataFlow = response.getDataFlow();
            this.loadFromBytes((DataFlow)dataFlow, true);
            this.nodeId = response.getNodeIdentifier();
            logger.info("Setting Flow Controller's Node ID: " + this.nodeId);
            this.controller.setNodeId(this.nodeId);
            this.controller.setClustered(true, response.getInstanceId(), response.getClusterManagerDN());
            this.controller.setClusterManagerRemoteSiteInfo(response.getManagerRemoteInputPort(), response.isManagerRemoteCommsSecure());
            this.controller.setConnected(true);
            this.controller.setPrimary(response.isPrimary());
            this.controller.onFlowInitialized(dataFlow.isAutoStartProcessors());
            this.loadTemplates(dataFlow.getTemplates());
            this.loadSnippets(dataFlow.getSnippets());
            this.controller.startHeartbeating();
        }
        catch (UninheritableFlowException ufe) {
            throw new ConnectionException("Failed to connect node to cluster because local flow is different than cluster flow.", ufe);
        }
        catch (FlowSerializationException fse) {
            throw new ConnectionException("Failed to connect node to cluster because local or cluster flow is malformed.", fse);
        }
        catch (FlowSynchronizationException fse) {
            throw new ConnectionException("Failed to connect node to cluster because local flow controller partially updated.  Administrator should disconnect node and review flow for corruption.", fse);
        }
        catch (Exception ex) {
            throw new ConnectionException("Failed to connect node to cluster due to: " + ex, ex);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyCurrentFlow(OutputStream os) throws IOException {
        this.readLock.lock();
        try {
            if (!Files.exists(this.flowXml, new LinkOption[0]) || Files.size(this.flowXml) == 0L) {
                return;
            }
            try (InputStream in = Files.newInputStream(this.flowXml, StandardOpenOption.READ);
                 GZIPInputStream gzipIn = new GZIPInputStream(in);){
                FileUtils.copy((InputStream)gzipIn, (OutputStream)os);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void loadTemplates(byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            return;
        }
        this.controller.clearTemplates();
        for (Template template : TemplateManager.parseBytes(bytes)) {
            this.controller.addTemplate(template.getDetails());
        }
    }

    public void loadSnippets(byte[] bytes) throws IOException {
        if (bytes.length == 0) {
            return;
        }
        SnippetManager snippetManager = this.controller.getSnippetManager();
        snippetManager.clear();
        for (StandardSnippet snippet : SnippetManager.parseBytes(bytes)) {
            snippetManager.addSnippet(snippet);
        }
    }

    @Override
    public FlowController getController() {
        return this.controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimary() {
        this.readLock.lock();
        try {
            boolean bl = this.controller.isPrimary();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimary(boolean primary) {
        this.writeLock.lock();
        try {
            this.controller.setPrimary(primary);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private class SaveHolder {
        private final Calendar saveTime;
        private final boolean shouldArchive;

        private SaveHolder(Calendar moment, boolean archive) {
            this.saveTime = moment;
            this.shouldArchive = archive;
        }
    }

    private class SaveReportingTask
    implements Runnable {
        private SaveReportingTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: {
                try {
                    SaveHolder holder = (SaveHolder)StandardFlowService.this.saveHolder.get();
                    if (holder == null) {
                        return;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace("Save request time {} // Current time {}", (Object)holder.saveTime.getTime(), (Object)new Date());
                    }
                    Calendar now = Calendar.getInstance();
                    if (!holder.saveTime.before(now) && !holder.shouldArchive) break block9;
                    if (logger.isTraceEnabled()) {
                        logger.trace("Waiting for write lock and then will save");
                    }
                    StandardFlowService.this.writeLock.lock();
                    try {
                        StandardFlowService.this.dao.save(StandardFlowService.this.controller, holder.shouldArchive);
                        boolean noSavePending = StandardFlowService.this.saveHolder.compareAndSet(holder, null);
                        logger.info("Saved flow controller {} // Another save pending = {}", (Object)StandardFlowService.this.controller, (Object)(!noSavePending ? 1 : 0));
                    }
                    finally {
                        StandardFlowService.this.writeLock.unlock();
                    }
                }
                catch (Throwable t) {
                    logger.error("Unable to save flow controller configuration due to: " + t, t);
                    if (logger.isDebugEnabled()) {
                        logger.error("", t);
                    }
                    Bulletin saveFailureBulletin = BulletinFactory.createBulletin((String)StandardFlowService.EVENT_CATEGORY, (String)LogLevel.ERROR.name(), (String)"Unable to save flow controller configuration.");
                    StandardFlowService.this.controller.getBulletinRepository().addBulletin(saveFailureBulletin);
                }
            }
        }
    }
}

