/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.StandardDataFlow;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.FlowFromDOMFactory;
import org.apache.nifi.controller.FlowSerializationException;
import org.apache.nifi.controller.FlowSynchronizationException;
import org.apache.nifi.controller.FlowSynchronizer;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SnippetManager;
import org.apache.nifi.controller.StandardFlowSerializer;
import org.apache.nifi.controller.StandardSnippet;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.TemplateManager;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.StandardReportingInitializationContext;
import org.apache.nifi.controller.service.ControllerServiceLoader;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.fingerprint.FingerprintException;
import org.apache.nifi.fingerprint.FingerprintFactory;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class StandardFlowSynchronizer
implements FlowSynchronizer {
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowSynchronizer.class);
    public static final URL FLOW_XSD_RESOURCE = StandardFlowSynchronizer.class.getResource("/FlowConfiguration.xsd");
    private final StringEncryptor encryptor;
    private final boolean autoResumeState;

    public StandardFlowSynchronizer(StringEncryptor encryptor) {
        this.encryptor = encryptor;
        this.autoResumeState = NiFiProperties.getInstance().getAutoResumeState();
    }

    public static boolean isEmpty(DataFlow dataFlow, StringEncryptor encryptor) {
        if (dataFlow == null || dataFlow.getFlow() == null || dataFlow.getFlow().length == 0) {
            return true;
        }
        Document document = StandardFlowSynchronizer.parseFlowBytes(dataFlow.getFlow());
        Element rootElement = document.getDocumentElement();
        Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
        ProcessGroupDTO rootGroupDto = FlowFromDOMFactory.getProcessGroup(null, rootGroupElement, encryptor);
        return StandardFlowSynchronizer.isEmpty(rootGroupDto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sync(FlowController controller, DataFlow proposedFlow, StringEncryptor encryptor) throws FlowSerializationException, UninheritableFlowException, FlowSynchronizationException {
        Node controllerServicesElement;
        boolean existingFlowEmpty;
        byte[] existingFlow;
        ProcessGroup rootGroup = controller.getGroup(controller.getRootGroupId());
        if (proposedFlow == null) {
            if (rootGroup.isEmpty()) {
                return;
            }
            throw new UninheritableFlowException("Proposed configuration is empty, but the controller contains a data flow.");
        }
        boolean initialized = controller.isInitialized();
        logger.debug("Synching FlowController with proposed flow: Controller is Initialized = {}", (Object)initialized);
        try {
            if (initialized) {
                existingFlow = this.toBytes(controller);
                existingFlowEmpty = controller.getGroup(controller.getRootGroupId()).isEmpty();
            } else {
                existingFlow = this.readFlowFromDisk();
                if (existingFlow == null || existingFlow.length == 0) {
                    existingFlowEmpty = true;
                } else {
                    Document document = StandardFlowSynchronizer.parseFlowBytes(existingFlow);
                    Element rootElement = document.getDocumentElement();
                    logger.trace("Setting controller thread counts");
                    Integer maxThreadCount = StandardFlowSynchronizer.getInteger(rootElement, "maxThreadCount");
                    if (maxThreadCount == null) {
                        controller.setMaxTimerDrivenThreadCount(StandardFlowSynchronizer.getInt(rootElement, "maxTimerDrivenThreadCount"));
                        controller.setMaxEventDrivenThreadCount(StandardFlowSynchronizer.getInt(rootElement, "maxEventDrivenThreadCount"));
                    } else {
                        controller.setMaxTimerDrivenThreadCount(maxThreadCount * 2 / 3);
                        controller.setMaxEventDrivenThreadCount(maxThreadCount / 3);
                    }
                    Element reportingTasksElement = DomUtils.getChild(rootElement, "reportingTasks");
                    List<Object> taskElements = reportingTasksElement == null ? Collections.emptyList() : DomUtils.getChildElementsByTagName(reportingTasksElement, "reportingTask");
                    controllerServicesElement = DomUtils.getChild(rootElement, "controllerServices");
                    List<Object> controllerServiceElements = controllerServicesElement == null ? Collections.emptyList() : DomUtils.getChildElementsByTagName(controllerServicesElement, "controllerService");
                    logger.trace("Parsing process group from DOM");
                    Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
                    ProcessGroupDTO rootGroupDto = FlowFromDOMFactory.getProcessGroup(null, rootGroupElement, encryptor);
                    existingFlowEmpty = taskElements.isEmpty() && controllerServiceElements.isEmpty() && StandardFlowSynchronizer.isEmpty(rootGroupDto);
                    logger.debug("Existing Flow Empty = {}", (Object)existingFlowEmpty);
                }
            }
        }
        catch (IOException e) {
            throw new FlowSerializationException(e);
        }
        logger.trace("Exporting templates from controller");
        byte[] existingTemplates = controller.getTemplateManager().export();
        logger.trace("Exporting snippets from controller");
        byte[] existingSnippets = controller.getSnippetManager().export();
        StandardDataFlow existingDataFlow = new StandardDataFlow(existingFlow, existingTemplates, existingSnippets);
        boolean existingTemplatesEmpty = existingTemplates == null || existingTemplates.length == 0;
        try {
            String problemInheriting;
            if (!existingFlowEmpty) {
                logger.trace("Checking flow inheritability");
                problemInheriting = this.checkFlowInheritability((DataFlow)existingDataFlow, proposedFlow, controller);
                if (problemInheriting != null) {
                    throw new UninheritableFlowException("Proposed configuration is not inheritable by the flow controller because of flow differences: " + problemInheriting);
                }
            }
            if (!existingTemplatesEmpty) {
                logger.trace("Checking template inheritability");
                problemInheriting = this.checkTemplateInheritability((DataFlow)existingDataFlow, proposedFlow);
                if (problemInheriting != null) {
                    throw new UninheritableFlowException("Proposed configuration is not inheritable by the flow controller because of flow differences: " + problemInheriting);
                }
            }
        }
        catch (FingerprintException fe) {
            throw new FlowSerializationException("Failed to generate flow fingerprints", fe);
        }
        logger.trace("Parsing proposed flow bytes as DOM document");
        Document configuration = StandardFlowSynchronizer.parseFlowBytes(proposedFlow.getFlow());
        try {
            if (configuration != null) {
                controllerServicesElement = configuration;
                synchronized (controllerServicesElement) {
                    Element rootElement = (Element)configuration.getElementsByTagName("flowController").item(0);
                    logger.trace("Updating flow config");
                    Integer maxThreadCount = StandardFlowSynchronizer.getInteger(rootElement, "maxThreadCount");
                    if (maxThreadCount == null) {
                        controller.setMaxTimerDrivenThreadCount(StandardFlowSynchronizer.getInt(rootElement, "maxTimerDrivenThreadCount"));
                        controller.setMaxEventDrivenThreadCount(StandardFlowSynchronizer.getInt(rootElement, "maxEventDrivenThreadCount"));
                    } else {
                        controller.setMaxTimerDrivenThreadCount(maxThreadCount * 2 / 3);
                        controller.setMaxEventDrivenThreadCount(maxThreadCount / 3);
                    }
                    Element rootGroupElement = (Element)rootElement.getElementsByTagName("rootGroup").item(0);
                    Element controllerServicesElement2 = DomUtils.getChild(rootElement, "controllerServices");
                    if (controllerServicesElement2 != null) {
                        List<Element> serviceElements = DomUtils.getChildElementsByTagName(controllerServicesElement2, "controllerService");
                        if (!initialized || existingFlowEmpty) {
                            ControllerServiceLoader.loadControllerServices(serviceElements, controller, encryptor, controller.getBulletinRepository(), this.autoResumeState);
                        } else {
                            for (Element serviceElement : serviceElements) {
                                this.updateControllerService(controller, serviceElement, encryptor);
                            }
                        }
                    }
                    if (!initialized || existingFlowEmpty) {
                        logger.trace("Adding root process group");
                        this.addProcessGroup(controller, null, rootGroupElement, encryptor);
                    } else {
                        logger.trace("Updating root process group");
                        this.updateProcessGroup(controller, null, rootGroupElement, encryptor);
                    }
                    Element reportingTasksElement = DomUtils.getChild(rootElement, "reportingTasks");
                    if (reportingTasksElement != null) {
                        List<Element> taskElements = DomUtils.getChildElementsByTagName(reportingTasksElement, "reportingTask");
                        for (Element taskElement : taskElements) {
                            if (!initialized || existingFlowEmpty) {
                                this.addReportingTask(controller, taskElement, encryptor);
                                continue;
                            }
                            this.updateReportingTask(controller, taskElement, encryptor);
                        }
                    }
                }
            }
            logger.trace("Synching templates");
            if ((existingTemplates == null || existingTemplates.length == 0) && proposedFlow.getTemplates() != null && proposedFlow.getTemplates().length > 0) {
                TemplateManager templateManager = controller.getTemplateManager();
                List<Template> proposedTemplateList = TemplateManager.parseBytes(proposedFlow.getTemplates());
                for (Template template : proposedTemplateList) {
                    templateManager.addTemplate(template.getDetails());
                }
            }
            logger.trace("Clearing existing snippets");
            SnippetManager snippetManager = controller.getSnippetManager();
            snippetManager.clear();
            logger.trace("Loading proposed snippets");
            byte[] proposedSnippets = proposedFlow.getSnippets();
            if (proposedSnippets != null && proposedSnippets.length > 0) {
                for (StandardSnippet snippet : SnippetManager.parseBytes(proposedSnippets)) {
                    snippetManager.addSnippet(snippet);
                }
            }
            logger.debug("Finished synching flows");
        }
        catch (Exception ex) {
            throw new FlowSynchronizationException(ex);
        }
    }

    private static boolean isEmpty(ProcessGroupDTO dto) {
        if (dto == null) {
            return true;
        }
        FlowSnippetDTO contents = dto.getContents();
        if (contents == null) {
            return true;
        }
        return CollectionUtils.isEmpty((Collection)contents.getProcessors()) && CollectionUtils.isEmpty((Collection)contents.getConnections()) && CollectionUtils.isEmpty((Collection)contents.getFunnels()) && CollectionUtils.isEmpty((Collection)contents.getLabels()) && CollectionUtils.isEmpty((Collection)contents.getOutputPorts()) && CollectionUtils.isEmpty((Collection)contents.getProcessGroups()) && CollectionUtils.isEmpty((Collection)contents.getProcessors()) && CollectionUtils.isEmpty((Collection)contents.getRemoteProcessGroups());
    }

    private static Document parseFlowBytes(byte[] flow) throws FlowSerializationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(FLOW_XSD_RESOURCE);
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            docFactory.setSchema(schema);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            return flow == null || flow.length == 0 ? null : docBuilder.parse(new ByteArrayInputStream(flow));
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new FlowSerializationException(ex);
        }
    }

    private byte[] readFlowFromDisk() throws IOException {
        Path flowPath = NiFiProperties.getInstance().getFlowConfigurationFile().toPath();
        if (!Files.exists(flowPath, new LinkOption[0]) || Files.size(flowPath) == 0L) {
            return new byte[0];
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (InputStream in = Files.newInputStream(flowPath, StandardOpenOption.READ);
             GZIPInputStream gzipIn = new GZIPInputStream(in);){
            FileUtils.copy((InputStream)gzipIn, (OutputStream)baos);
        }
        return baos.toByteArray();
    }

    private void updateControllerService(FlowController controller, Element controllerServiceElement, StringEncryptor encryptor) {
        boolean serviceEnabled;
        ControllerServiceDTO dto = FlowFromDOMFactory.getControllerService(controllerServiceElement, encryptor);
        ControllerServiceState dtoState = ControllerServiceState.valueOf((String)dto.getState());
        boolean dtoEnabled = dtoState == ControllerServiceState.ENABLED || dtoState == ControllerServiceState.ENABLING;
        ControllerServiceNode serviceNode = controller.getControllerServiceNode(dto.getId());
        ControllerServiceState serviceState = serviceNode.getState();
        boolean bl = serviceEnabled = serviceState == ControllerServiceState.ENABLED || serviceState == ControllerServiceState.ENABLING;
        if (dtoEnabled && !serviceEnabled) {
            controller.enableControllerService(controller.getControllerServiceNode(dto.getId()));
        } else if (!dtoEnabled && serviceEnabled) {
            controller.disableControllerService(controller.getControllerServiceNode(dto.getId()));
        }
    }

    private void addReportingTask(FlowController controller, Element reportingTaskElement, StringEncryptor encryptor) throws ReportingTaskInstantiationException {
        ReportingTaskDTO dto = FlowFromDOMFactory.getReportingTask(reportingTaskElement, encryptor);
        ReportingTaskNode reportingTask = controller.createReportingTask(dto.getType(), dto.getId(), false);
        reportingTask.setName(dto.getName());
        reportingTask.setComments(dto.getComments());
        reportingTask.setScheduldingPeriod(dto.getSchedulingPeriod());
        reportingTask.setSchedulingStrategy(SchedulingStrategy.valueOf((String)dto.getSchedulingStrategy()));
        reportingTask.setAnnotationData(dto.getAnnotationData());
        for (Map.Entry entry : dto.getProperties().entrySet()) {
            if (entry.getValue() == null) {
                reportingTask.removeProperty((String)entry.getKey());
                continue;
            }
            reportingTask.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        SimpleProcessLogger componentLog = new SimpleProcessLogger(dto.getId(), reportingTask.getReportingTask());
        StandardReportingInitializationContext config = new StandardReportingInitializationContext(dto.getId(), dto.getName(), SchedulingStrategy.valueOf((String)dto.getSchedulingStrategy()), dto.getSchedulingPeriod(), (ComponentLog)componentLog, controller);
        try {
            reportingTask.getReportingTask().initialize((ReportingInitializationContext)config);
        }
        catch (InitializationException ie) {
            throw new ReportingTaskInstantiationException("Failed to initialize reporting task of type " + dto.getType(), (Throwable)ie);
        }
        if (this.autoResumeState) {
            if (ScheduledState.RUNNING.name().equals(dto.getState())) {
                try {
                    controller.startReportingTask(reportingTask);
                }
                catch (Exception e) {
                    logger.error("Failed to start {} due to {}", (Object)reportingTask, (Object)e);
                    if (logger.isDebugEnabled()) {
                        logger.error("", (Throwable)e);
                    }
                    controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Reporting Tasks", (String)Severity.ERROR.name(), (String)("Failed to start " + reportingTask + " due to " + e)));
                }
            } else if (ScheduledState.DISABLED.name().equals(dto.getState())) {
                try {
                    controller.disableReportingTask(reportingTask);
                }
                catch (Exception e) {
                    logger.error("Failed to mark {} as disabled due to {}", (Object)reportingTask, (Object)e);
                    if (logger.isDebugEnabled()) {
                        logger.error("", (Throwable)e);
                    }
                    controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Reporting Tasks", (String)Severity.ERROR.name(), (String)("Failed to mark " + reportingTask + " as disabled due to " + e)));
                }
            }
        }
    }

    private void updateReportingTask(FlowController controller, Element reportingTaskElement, StringEncryptor encryptor) {
        ReportingTaskDTO dto = FlowFromDOMFactory.getReportingTask(reportingTaskElement, encryptor);
        ReportingTaskNode taskNode = controller.getReportingTaskNode(dto.getId());
        if (!taskNode.getScheduledState().name().equals(dto.getState())) {
            try {
                switch (ScheduledState.valueOf((String)dto.getState())) {
                    case DISABLED: {
                        if (taskNode.isRunning()) {
                            controller.stopReportingTask(taskNode);
                        }
                        controller.disableReportingTask(taskNode);
                        break;
                    }
                    case RUNNING: {
                        if (taskNode.getScheduledState() == ScheduledState.DISABLED) {
                            controller.enableReportingTask(taskNode);
                        }
                        controller.startReportingTask(taskNode);
                        break;
                    }
                    case STOPPED: {
                        if (taskNode.getScheduledState() == ScheduledState.DISABLED) {
                            controller.enableReportingTask(taskNode);
                            break;
                        }
                        if (taskNode.getScheduledState() != ScheduledState.RUNNING) break;
                        controller.stopReportingTask(taskNode);
                    }
                }
            }
            catch (IllegalStateException ise) {
                logger.error("Failed to change Scheduled State of {} from {} to {} due to {}", new Object[]{taskNode, taskNode.getScheduledState().name(), dto.getState(), ise.toString()});
                logger.error("", (Throwable)ise);
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + taskNode + " from " + taskNode.getScheduledState().name() + " to " + dto.getState() + " due to " + ise.toString())));
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + taskNode + " from " + taskNode.getScheduledState().name() + " to " + dto.getState() + " due to " + ise.toString())));
            }
        }
    }

    private ProcessGroup updateProcessGroup(FlowController controller, ProcessGroup parentGroup, Element processGroupElement, StringEncryptor encryptor) throws ProcessorInstantiationException {
        String parentId = parentGroup == null ? null : parentGroup.getIdentifier();
        ProcessGroupDTO processGroupDto = FlowFromDOMFactory.getProcessGroup(parentId, processGroupElement, encryptor);
        if (parentId == null) {
            ProcessGroup root = controller.getGroup(controller.getRootGroupId());
            for (Label label : root.findAllLabels()) {
                label.getProcessGroup().removeLabel(label);
            }
        }
        controller.updateProcessGroup(processGroupDto);
        ProcessGroup processGroup = controller.getGroup(processGroupDto.getId());
        List<Element> processorNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processor");
        for (Element processorElement : processorNodeList) {
            ProcessorDTO dto = FlowFromDOMFactory.getProcessor(processorElement, encryptor);
            ProcessorNode procNode = processGroup.getProcessor(dto.getId());
            if (procNode.getScheduledState().name().equals(dto.getState())) continue;
            try {
                switch (ScheduledState.valueOf((String)dto.getState())) {
                    case DISABLED: {
                        procNode.getProcessGroup().stopProcessor(procNode);
                        procNode.getProcessGroup().disableProcessor(procNode);
                        break;
                    }
                    case RUNNING: {
                        procNode.getProcessGroup().enableProcessor(procNode);
                        procNode.getProcessGroup().startProcessor(procNode);
                        break;
                    }
                    case STOPPED: {
                        if (procNode.getScheduledState() == ScheduledState.DISABLED) {
                            procNode.getProcessGroup().enableProcessor(procNode);
                            break;
                        }
                        if (procNode.getScheduledState() != ScheduledState.RUNNING) break;
                        procNode.getProcessGroup().stopProcessor(procNode);
                    }
                }
            }
            catch (IllegalStateException ise) {
                logger.error("Failed to change Scheduled State of {} from {} to {} due to {}", new Object[]{procNode, procNode.getScheduledState().name(), dto.getState(), ise.toString()});
                logger.error("", (Throwable)ise);
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((Connectable)procNode, (String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + procNode + " from " + procNode.getScheduledState().name() + " to " + dto.getState() + " due to " + ise.toString())));
                controller.getBulletinRepository().addBulletin(BulletinFactory.createBulletin((String)"Node Reconnection", (String)Severity.ERROR.name(), (String)("Failed to change Scheduled State of " + procNode + " from " + procNode.getScheduledState().name() + " to " + dto.getState() + " due to " + ise.toString())));
            }
        }
        List<Element> inputPortList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "inputPort");
        for (Element portElement : inputPortList) {
            PortDTO dto = FlowFromDOMFactory.getPort(portElement);
            Port port = processGroup.getInputPort(dto.getId());
            if (port.getScheduledState().name().equals(dto.getState())) continue;
            switch (ScheduledState.valueOf((String)dto.getState())) {
                case DISABLED: {
                    port.getProcessGroup().stopInputPort(port);
                    port.getProcessGroup().disableInputPort(port);
                    break;
                }
                case RUNNING: {
                    port.getProcessGroup().enableInputPort(port);
                    port.getProcessGroup().startInputPort(port);
                    break;
                }
                case STOPPED: {
                    if (port.getScheduledState() == ScheduledState.DISABLED) {
                        port.getProcessGroup().enableInputPort(port);
                        break;
                    }
                    if (port.getScheduledState() != ScheduledState.RUNNING) break;
                    port.getProcessGroup().stopInputPort(port);
                }
            }
        }
        List<Element> outputPortList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "outputPort");
        for (Element portElement : outputPortList) {
            PortDTO dto = FlowFromDOMFactory.getPort(portElement);
            Port port = processGroup.getOutputPort(dto.getId());
            if (port.getScheduledState().name().equals(dto.getState())) continue;
            switch (ScheduledState.valueOf((String)dto.getState())) {
                case DISABLED: {
                    port.getProcessGroup().stopOutputPort(port);
                    port.getProcessGroup().disableOutputPort(port);
                    break;
                }
                case RUNNING: {
                    port.getProcessGroup().enableOutputPort(port);
                    port.getProcessGroup().startOutputPort(port);
                    break;
                }
                case STOPPED: {
                    if (port.getScheduledState() == ScheduledState.DISABLED) {
                        port.getProcessGroup().enableOutputPort(port);
                        break;
                    }
                    if (port.getScheduledState() != ScheduledState.RUNNING) break;
                    port.getProcessGroup().stopOutputPort(port);
                }
            }
        }
        List<Element> labelNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "label");
        for (Element labelElement : labelNodeList) {
            LabelDTO labelDTO = FlowFromDOMFactory.getLabel(labelElement);
            Label label = controller.createLabel(labelDTO.getId(), labelDTO.getLabel());
            label.setStyle(labelDTO.getStyle());
            label.setPosition(new Position(labelDTO.getPosition().getX().doubleValue(), labelDTO.getPosition().getY().doubleValue()));
            if (labelDTO.getWidth() != null && labelDTO.getHeight() != null) {
                label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
            }
            processGroup.addLabel(label);
        }
        List<Element> nestedProcessGroupNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processGroup");
        for (Element nestedProcessGroupElement : nestedProcessGroupNodeList) {
            this.updateProcessGroup(controller, processGroup, nestedProcessGroupElement, encryptor);
        }
        List<Element> connectionNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "connection");
        for (Element connectionElement : connectionNodeList) {
            ConnectionDTO dto = FlowFromDOMFactory.getConnection(connectionElement);
            Connection connection = processGroup.getConnection(dto.getId());
            connection.setName(dto.getName());
            connection.setProcessGroup(processGroup);
            if (dto.getLabelIndex() != null) {
                connection.setLabelIndex(dto.getLabelIndex().intValue());
            }
            if (dto.getzIndex() != null) {
                connection.setZIndex(dto.getzIndex().longValue());
            }
            ArrayList<Position> bendPoints = new ArrayList<Position>();
            for (PositionDTO bend : dto.getBends()) {
                bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
            }
            connection.setBendPoints(bendPoints);
            ArrayList<FlowFilePrioritizer> newPrioritizers = null;
            List prioritizers = dto.getPrioritizers();
            if (prioritizers != null) {
                ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                for (String className : newPrioritizersClasses) {
                    try {
                        newPrioritizers.add(controller.createPrioritizer(className));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                    }
                }
            }
            if (newPrioritizers != null) {
                connection.getFlowFileQueue().setPriorities(newPrioritizers);
            }
            if (dto.getBackPressureObjectThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureObjectThreshold(dto.getBackPressureObjectThreshold().longValue());
            }
            if (dto.getBackPressureDataSizeThreshold() != null && !dto.getBackPressureDataSizeThreshold().trim().isEmpty()) {
                connection.getFlowFileQueue().setBackPressureDataSizeThreshold(dto.getBackPressureDataSizeThreshold());
            }
            if (dto.getFlowFileExpiration() == null) continue;
            connection.getFlowFileQueue().setFlowFileExpiration(dto.getFlowFileExpiration());
        }
        return processGroup;
    }

    private Position toPosition(PositionDTO dto) {
        return new Position(dto.getX().doubleValue(), dto.getY().doubleValue());
    }

    private void updateProcessor(ProcessorNode procNode, ProcessorDTO processorDTO, ProcessGroup processGroup, FlowController controller) throws ProcessorInstantiationException {
        ProcessorConfigDTO config = processorDTO.getConfig();
        procNode.setPosition(this.toPosition(processorDTO.getPosition()));
        procNode.setName(processorDTO.getName());
        procNode.setStyle(processorDTO.getStyle());
        procNode.setProcessGroup(processGroup);
        procNode.setComments(config.getComments());
        procNode.setLossTolerant(config.isLossTolerant().booleanValue());
        procNode.setPenalizationPeriod(config.getPenaltyDuration());
        procNode.setYieldPeriod(config.getYieldDuration());
        procNode.setBulletinLevel(LogLevel.valueOf((String)config.getBulletinLevel()));
        if (config.getSchedulingStrategy() != null) {
            procNode.setSchedulingStrategy(SchedulingStrategy.valueOf((String)config.getSchedulingStrategy()));
        }
        procNode.setMaxConcurrentTasks(config.getConcurrentlySchedulableTaskCount().intValue());
        procNode.setScheduldingPeriod(config.getSchedulingPeriod());
        if (config.getRunDurationMillis() != null) {
            procNode.setRunDuration(config.getRunDurationMillis().longValue(), TimeUnit.MILLISECONDS);
        }
        procNode.setAnnotationData(config.getAnnotationData());
        if (config.getAutoTerminatedRelationships() != null) {
            HashSet<Relationship> relationships = new HashSet<Relationship>();
            for (String rel : config.getAutoTerminatedRelationships()) {
                relationships.add(procNode.getRelationship(rel));
            }
            procNode.setAutoTerminatedRelationships(relationships);
        }
        for (Map.Entry entry : config.getProperties().entrySet()) {
            if (entry.getValue() == null) {
                procNode.removeProperty((String)entry.getKey());
                continue;
            }
            procNode.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
        ScheduledState scheduledState = ScheduledState.valueOf((String)processorDTO.getState());
        if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
            controller.startProcessor(processGroup.getIdentifier(), procNode.getIdentifier());
        } else if (ScheduledState.DISABLED.equals((Object)scheduledState)) {
            processGroup.disableProcessor(procNode);
        }
    }

    private ProcessGroup addProcessGroup(FlowController controller, ProcessGroup parentGroup, Element processGroupElement, StringEncryptor encryptor) throws ProcessorInstantiationException {
        String parentId = parentGroup == null ? null : parentGroup.getIdentifier();
        ProcessGroupDTO processGroupDTO = FlowFromDOMFactory.getProcessGroup(parentId, processGroupElement, encryptor);
        ProcessGroup processGroup = controller.createProcessGroup(processGroupDTO.getId());
        processGroup.setComments(processGroupDTO.getComments());
        processGroup.setPosition(this.toPosition(processGroupDTO.getPosition()));
        processGroup.setName(processGroupDTO.getName());
        processGroup.setParent(parentGroup);
        if (parentGroup == null) {
            controller.setRootGroup(processGroup);
        } else {
            parentGroup.addProcessGroup(processGroup);
        }
        List<Element> processorNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processor");
        for (Element processorElement : processorNodeList) {
            ProcessorDTO processorDTO = FlowFromDOMFactory.getProcessor(processorElement, encryptor);
            ProcessorNode procNode = controller.createProcessor(processorDTO.getType(), processorDTO.getId(), false);
            processGroup.addProcessor(procNode);
            this.updateProcessor(procNode, processorDTO, processGroup, controller);
        }
        List<Element> inputPortNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "inputPort");
        for (Element inputPortElement : inputPortNodeList) {
            ScheduledState scheduledState;
            Set groupControls;
            PortDTO portDTO = FlowFromDOMFactory.getPort(inputPortElement);
            Port port = processGroup.isRootGroup() ? controller.createRemoteInputPort(portDTO.getId(), portDTO.getName()) : controller.createLocalInputPort(portDTO.getId(), portDTO.getName());
            port.setPosition(this.toPosition(portDTO.getPosition()));
            port.setComments(portDTO.getComments());
            port.setProcessGroup(processGroup);
            Set userControls = portDTO.getUserAccessControl();
            if (userControls != null && !userControls.isEmpty()) {
                if (!(port instanceof RootGroupPort)) {
                    throw new IllegalStateException("Attempting to add User Access Controls to " + port + ", but it is not a RootGroupPort");
                }
                ((RootGroupPort)port).setUserAccessControl(userControls);
            }
            if ((groupControls = portDTO.getGroupAccessControl()) != null && !groupControls.isEmpty()) {
                if (!(port instanceof RootGroupPort)) {
                    throw new IllegalStateException("Attempting to add Group Access Controls to " + port + ", but it is not a RootGroupPort");
                }
                ((RootGroupPort)port).setGroupAccessControl(groupControls);
            }
            processGroup.addInputPort(port);
            if (portDTO.getConcurrentlySchedulableTaskCount() != null) {
                port.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (ScheduledState.RUNNING.equals((Object)(scheduledState = ScheduledState.valueOf((String)portDTO.getState())))) {
                controller.startConnectable((Connectable)port);
                continue;
            }
            if (!ScheduledState.DISABLED.equals((Object)scheduledState)) continue;
            processGroup.disableInputPort(port);
        }
        List<Element> outputPortNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "outputPort");
        for (Element outputPortElement : outputPortNodeList) {
            ScheduledState scheduledState;
            Set groupControls;
            PortDTO portDTO = FlowFromDOMFactory.getPort(outputPortElement);
            Port port = processGroup.isRootGroup() ? controller.createRemoteOutputPort(portDTO.getId(), portDTO.getName()) : controller.createLocalOutputPort(portDTO.getId(), portDTO.getName());
            port.setPosition(this.toPosition(portDTO.getPosition()));
            port.setComments(portDTO.getComments());
            port.setProcessGroup(processGroup);
            Set userControls = portDTO.getUserAccessControl();
            if (userControls != null && !userControls.isEmpty()) {
                if (!(port instanceof RootGroupPort)) {
                    throw new IllegalStateException("Attempting to add User Access Controls to " + port + ", but it is not a RootGroupPort");
                }
                ((RootGroupPort)port).setUserAccessControl(userControls);
            }
            if ((groupControls = portDTO.getGroupAccessControl()) != null && !groupControls.isEmpty()) {
                if (!(port instanceof RootGroupPort)) {
                    throw new IllegalStateException("Attempting to add Group Access Controls to " + port + ", but it is not a RootGroupPort");
                }
                ((RootGroupPort)port).setGroupAccessControl(groupControls);
            }
            processGroup.addOutputPort(port);
            if (portDTO.getConcurrentlySchedulableTaskCount() != null) {
                port.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
            }
            if (ScheduledState.RUNNING.equals((Object)(scheduledState = ScheduledState.valueOf((String)portDTO.getState())))) {
                controller.startConnectable((Connectable)port);
                continue;
            }
            if (!ScheduledState.DISABLED.equals((Object)scheduledState)) continue;
            processGroup.disableOutputPort(port);
        }
        List<Element> funnelNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "funnel");
        for (Element funnelElement : funnelNodeList) {
            FunnelDTO funnelDTO = FlowFromDOMFactory.getFunnel(funnelElement);
            Funnel funnel = controller.createFunnel(funnelDTO.getId());
            funnel.setPosition(this.toPosition(funnelDTO.getPosition()));
            processGroup.addFunnel(funnel, false);
            controller.startConnectable((Connectable)funnel);
        }
        List<Element> labelNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "label");
        for (Element labelElement : labelNodeList) {
            LabelDTO labelDTO = FlowFromDOMFactory.getLabel(labelElement);
            Label label = controller.createLabel(labelDTO.getId(), labelDTO.getLabel());
            label.setStyle(labelDTO.getStyle());
            label.setPosition(this.toPosition(labelDTO.getPosition()));
            label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
            processGroup.addLabel(label);
        }
        List<Element> nestedProcessGroupNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "processGroup");
        for (Element nestedProcessGroupElement : nestedProcessGroupNodeList) {
            this.addProcessGroup(controller, processGroup, nestedProcessGroupElement, encryptor);
        }
        List<Element> remoteProcessGroupNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "remoteProcessGroup");
        for (Element remoteProcessGroupElement : remoteProcessGroupNodeList) {
            RemoteGroupPort port;
            RemoteProcessGroupDTO remoteGroupDto = FlowFromDOMFactory.getRemoteProcessGroup(remoteProcessGroupElement);
            RemoteProcessGroup remoteGroup = controller.createRemoteProcessGroup(remoteGroupDto.getId(), remoteGroupDto.getTargetUri());
            remoteGroup.setComments(remoteGroupDto.getComments());
            remoteGroup.setPosition(this.toPosition(remoteGroupDto.getPosition()));
            String name = remoteGroupDto.getName();
            if (name != null && !name.trim().isEmpty()) {
                remoteGroup.setName(name);
            }
            remoteGroup.setProcessGroup(processGroup);
            remoteGroup.setCommunicationsTimeout(remoteGroupDto.getCommunicationsTimeout());
            if (remoteGroupDto.getYieldDuration() != null) {
                remoteGroup.setYieldDuration(remoteGroupDto.getYieldDuration());
            }
            HashSet<RemoteProcessGroupPortDescriptor> inputPorts = new HashSet<RemoteProcessGroupPortDescriptor>();
            for (Element portElement : StandardFlowSynchronizer.getChildrenByTagName(remoteProcessGroupElement, "inputPort")) {
                inputPorts.add(FlowFromDOMFactory.getRemoteProcessGroupPort(portElement));
            }
            remoteGroup.setInputPorts(inputPorts);
            HashSet<RemoteProcessGroupPortDescriptor> outputPorts = new HashSet<RemoteProcessGroupPortDescriptor>();
            for (Element portElement : StandardFlowSynchronizer.getChildrenByTagName(remoteProcessGroupElement, "outputPort")) {
                outputPorts.add(FlowFromDOMFactory.getRemoteProcessGroupPort(portElement));
            }
            remoteGroup.setOutputPorts(outputPorts);
            processGroup.addRemoteProcessGroup(remoteGroup);
            for (RemoteProcessGroupPortDescriptor remoteGroupPortDTO : outputPorts) {
                port = remoteGroup.getOutputPort(remoteGroupPortDTO.getId());
                if (!Boolean.TRUE.equals(remoteGroupPortDTO.isTransmitting())) continue;
                controller.startTransmitting(port);
            }
            for (RemoteProcessGroupPortDescriptor remoteGroupPortDTO : inputPorts) {
                port = remoteGroup.getInputPort(remoteGroupPortDTO.getId());
                if (!Boolean.TRUE.equals(remoteGroupPortDTO.isTransmitting())) continue;
                controller.startTransmitting(port);
            }
        }
        List<Element> connectionNodeList = StandardFlowSynchronizer.getChildrenByTagName(processGroupElement, "connection");
        for (Element connectionElement : connectionNodeList) {
            RemoteGroupPort destination;
            RemoteGroupPort source;
            ConnectionDTO dto = FlowFromDOMFactory.getConnection(connectionElement);
            ConnectableDTO sourceDto = dto.getSource();
            if (ConnectableType.REMOTE_OUTPUT_PORT.name().equals(sourceDto.getType())) {
                RemoteProcessGroup remoteGroup = processGroup.getRemoteProcessGroup(sourceDto.getGroupId());
                source = remoteGroup.getOutputPort(sourceDto.getId());
            } else {
                ProcessGroup sourceGroup = controller.getGroup(sourceDto.getGroupId());
                if (sourceGroup == null) {
                    throw new RuntimeException("Found Invalid ProcessGroup ID for Source: " + dto.getSource().getGroupId());
                }
                source = sourceGroup.getConnectable(sourceDto.getId());
            }
            if (source == null) {
                throw new RuntimeException("Found Invalid Connectable ID for Source: " + dto.getSource().getId());
            }
            ConnectableDTO destinationDto = dto.getDestination();
            if (ConnectableType.REMOTE_INPUT_PORT.name().equals(destinationDto.getType())) {
                RemoteProcessGroup remoteGroup = processGroup.getRemoteProcessGroup(destinationDto.getGroupId());
                destination = remoteGroup.getInputPort(destinationDto.getId());
            } else {
                ProcessGroup destinationGroup = controller.getGroup(destinationDto.getGroupId());
                if (destinationGroup == null) {
                    throw new RuntimeException("Found Invalid ProcessGroup ID for Destination: " + dto.getDestination().getGroupId());
                }
                destination = destinationGroup.getConnectable(destinationDto.getId());
            }
            if (destination == null) {
                throw new RuntimeException("Found Invalid Connectable ID for Destination: " + dto.getDestination().getId());
            }
            Connection connection = controller.createConnection(dto.getId(), dto.getName(), (Connectable)source, (Connectable)destination, dto.getSelectedRelationships());
            connection.setProcessGroup(processGroup);
            ArrayList<Position> bendPoints = new ArrayList<Position>();
            for (PositionDTO bend : dto.getBends()) {
                bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
            }
            connection.setBendPoints(bendPoints);
            Long zIndex = dto.getzIndex();
            if (zIndex != null) {
                connection.setZIndex(zIndex.longValue());
            }
            if (dto.getLabelIndex() != null) {
                connection.setLabelIndex(dto.getLabelIndex().intValue());
            }
            ArrayList<FlowFilePrioritizer> newPrioritizers = null;
            List prioritizers = dto.getPrioritizers();
            if (prioritizers != null) {
                ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                for (String className : newPrioritizersClasses) {
                    try {
                        newPrioritizers.add(controller.createPrioritizer(className));
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                    }
                }
            }
            if (newPrioritizers != null) {
                connection.getFlowFileQueue().setPriorities(newPrioritizers);
            }
            if (dto.getBackPressureObjectThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureObjectThreshold(dto.getBackPressureObjectThreshold().longValue());
            }
            if (dto.getBackPressureDataSizeThreshold() != null) {
                connection.getFlowFileQueue().setBackPressureDataSizeThreshold(dto.getBackPressureDataSizeThreshold());
            }
            if (dto.getFlowFileExpiration() != null) {
                connection.getFlowFileQueue().setFlowFileExpiration(dto.getFlowFileExpiration());
            }
            processGroup.addConnection(connection);
        }
        return processGroup;
    }

    public String checkFlowInheritability(DataFlow existingFlow, DataFlow proposedFlow, FlowController controller) throws FingerprintException {
        if (existingFlow == null) {
            return null;
        }
        return this.checkFlowInheritability(existingFlow.getFlow(), proposedFlow.getFlow(), controller);
    }

    private String checkFlowInheritability(byte[] existingFlow, byte[] proposedFlow, FlowController controller) {
        if (existingFlow == null) {
            return null;
        }
        FingerprintFactory fingerprintFactory = new FingerprintFactory(this.encryptor);
        String existingFlowFingerprintBeforeHash = fingerprintFactory.createFingerprint(existingFlow, controller);
        if (existingFlowFingerprintBeforeHash.trim().isEmpty()) {
            return null;
        }
        if (proposedFlow == null || proposedFlow.length == 0) {
            return "Proposed Flow was empty but Current Flow is not";
        }
        String proposedFlowFingerprintBeforeHash = fingerprintFactory.createFingerprint(proposedFlow, controller);
        if (proposedFlowFingerprintBeforeHash.trim().isEmpty()) {
            return "Proposed Flow was empty but Current Flow is not";
        }
        boolean inheritable = existingFlowFingerprintBeforeHash.equals(proposedFlowFingerprintBeforeHash);
        if (!inheritable) {
            return this.findFirstDiscrepancy(existingFlowFingerprintBeforeHash, proposedFlowFingerprintBeforeHash, "Flows");
        }
        return null;
    }

    public String checkTemplateInheritability(DataFlow existingFlow, DataFlow proposedFlow) throws FingerprintException {
        if (existingFlow == null) {
            return null;
        }
        FingerprintFactory fingerprintFactory = new FingerprintFactory(this.encryptor);
        byte[] existingTemplateBytes = existingFlow.getTemplates();
        if (existingTemplateBytes == null || existingTemplateBytes.length == 0) {
            return null;
        }
        List<Template> existingTemplates = TemplateManager.parseBytes(existingTemplateBytes);
        String existingTemplateFingerprint = fingerprintFactory.createFingerprint(existingTemplates);
        if (existingTemplateFingerprint.trim().isEmpty()) {
            return null;
        }
        byte[] proposedTemplateBytes = proposedFlow.getTemplates();
        if (proposedTemplateBytes == null || proposedTemplateBytes.length == 0) {
            return "Proposed Flow does not contain any Templates but Current Flow does";
        }
        List<Template> proposedTemplates = TemplateManager.parseBytes(proposedTemplateBytes);
        String proposedTemplateFingerprint = fingerprintFactory.createFingerprint(proposedTemplates);
        if (proposedTemplateFingerprint.trim().isEmpty()) {
            return "Proposed Flow does not contain any Templates but Current Flow does";
        }
        try {
            String existingTemplateMd5 = fingerprintFactory.md5Hash(existingTemplateFingerprint);
            String proposedTemplateMd5 = fingerprintFactory.md5Hash(proposedTemplateFingerprint);
            if (!existingTemplateMd5.equals(proposedTemplateMd5)) {
                return this.findFirstDiscrepancy(existingTemplateFingerprint, proposedTemplateFingerprint, "Templates");
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new FingerprintException(e);
        }
        return null;
    }

    private String findFirstDiscrepancy(String existing, String proposed, String comparisonDescription) {
        int shortestFileLength = Math.min(existing.length(), proposed.length());
        for (int i = 0; i < shortestFileLength; ++i) {
            if (existing.charAt(i) == proposed.charAt(i)) continue;
            String formattedExistingDelta = this.formatFlowDiscrepancy(existing, i, 100);
            String formattedProposedDelta = this.formatFlowDiscrepancy(proposed, i, 100);
            return String.format("Found difference in %s:\nLocal Fingerprint:   %s\nCluster Fingerprint: %s", comparisonDescription, formattedExistingDelta, formattedProposedDelta);
        }
        if (existing.length() > proposed.length()) {
            String formattedExistingDelta = existing.substring(proposed.length(), Math.min(existing.length(), proposed.length() + 200));
            return String.format("Found difference in %s:\nLocal Fingerprint contains additional configuration from Cluster Fingerprint: %s", comparisonDescription, formattedExistingDelta);
        }
        if (proposed.length() > existing.length()) {
            String formattedProposedDelta = proposed.substring(existing.length(), Math.min(proposed.length(), existing.length() + 200));
            return String.format("Found difference in %s:\nCluster Fingerprint contains additional configuration from Local Fingerprint: %s", comparisonDescription, formattedProposedDelta);
        }
        return "Unable to find any discrepancies between fingerprints. Please contact the NiFi support team";
    }

    private byte[] toBytes(FlowController flowController) throws FlowSerializationException {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        StandardFlowSerializer flowSerializer = new StandardFlowSerializer(this.encryptor);
        flowController.serialize(flowSerializer, result);
        return result.toByteArray();
    }

    private static String getString(Element element, String childElementName) {
        List<Element> nodeList = StandardFlowSynchronizer.getChildrenByTagName(element, childElementName);
        if (nodeList == null || nodeList.isEmpty()) {
            return "";
        }
        Element childElement = nodeList.get(0);
        return childElement.getTextContent();
    }

    private static int getInt(Element element, String childElementName) {
        return Integer.parseInt(StandardFlowSynchronizer.getString(element, childElementName));
    }

    private static Integer getInteger(Element element, String childElementName) {
        String value = StandardFlowSynchronizer.getString(element, childElementName);
        return value == null || value.trim().equals("") ? null : Integer.valueOf(Integer.parseInt(value));
    }

    private static List<Element> getChildrenByTagName(Element element, String tagName) {
        ArrayList<Element> matches = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element child;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !(child = (Element)nodeList.item(i)).getNodeName().equals(tagName)) continue;
            matches.add(child);
        }
        return matches;
    }

    private String formatFlowDiscrepancy(String flowFingerprint, int deltaIndex, int deltaPad) {
        return flowFingerprint.substring(Math.max(0, deltaIndex - deltaPad), Math.min(flowFingerprint.length(), deltaIndex + deltaPad));
    }
}

