/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.controller.repository.ContentNotFoundException;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ContentClaimManager;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.controller.repository.io.ArrayManagedOutputStream;
import org.apache.nifi.controller.repository.io.MemoryManager;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.stream.io.ByteArrayInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolatileContentRepository
implements ContentRepository {
    private final Logger logger = LoggerFactory.getLogger(VolatileContentRepository.class);
    public static String CONTAINER_NAME = "in-memory";
    public static final int DEFAULT_BLOCK_SIZE_KB = 32;
    public static final String MAX_SIZE_PROPERTY = "nifi.volatile.content.repository.max.size";
    public static final String BLOCK_SIZE_PROPERTY = "nifi.volatile.content.repository.block.size";
    private final ScheduledExecutorService executor = new FlowEngine(3, "VolatileContentRepository Workers", true);
    private final ConcurrentMap<ContentClaim, ContentBlock> claimMap = new ConcurrentHashMap<ContentClaim, ContentBlock>(256);
    private final AtomicLong repoSize = new AtomicLong(0L);
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private final long maxBytes;
    private final MemoryManager memoryManager;
    private final ConcurrentMap<ContentClaim, ContentClaim> backupRepoClaimMap = new ConcurrentHashMap<ContentClaim, ContentClaim>(256);
    private final AtomicReference<ContentRepository> backupRepositoryRef = new AtomicReference<Object>(null);
    private ContentClaimManager claimManager;

    public VolatileContentRepository() {
        this(NiFiProperties.getInstance());
    }

    public VolatileContentRepository(NiFiProperties properties) {
        String maxSize = properties.getProperty(MAX_SIZE_PROPERTY);
        String blockSizeVal = properties.getProperty(BLOCK_SIZE_PROPERTY);
        this.maxBytes = maxSize == null ? (long)DataUnit.B.convert(100.0, DataUnit.MB) : DataUnit.parseDataSize((String)maxSize, (DataUnit)DataUnit.B).longValue();
        int blockSize = blockSizeVal == null ? (int)DataUnit.B.convert(32.0, DataUnit.KB) : DataUnit.parseDataSize((String)blockSizeVal, (DataUnit)DataUnit.B).intValue();
        this.memoryManager = new MemoryManager(this.maxBytes, blockSize);
    }

    public void initialize(ContentClaimManager claimManager) {
        this.claimManager = claimManager;
        for (int i = 0; i < 3; ++i) {
            this.executor.scheduleWithFixedDelay(new CleanupOldClaims(), 1000L, 10L, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() {
        this.executor.shutdown();
    }

    public void setBackupRepository(ContentRepository backup) {
        boolean updated = this.backupRepositoryRef.compareAndSet(null, backup);
        if (!updated) {
            throw new IllegalStateException("Cannot change BackupRepository after it has already been set");
        }
    }

    public ContentRepository getBackupRepository() {
        return this.backupRepositoryRef.get();
    }

    private StandardContentClaim resolveClaim(ContentClaim claim) {
        if (!(claim instanceof StandardContentClaim)) {
            throw new IllegalArgumentException("Cannot increment ClaimantCount of " + claim + " because it does not belong to this ContentRepository");
        }
        return (StandardContentClaim)claim;
    }

    private ContentClaim getBackupClaim(ContentClaim claim) {
        if (claim == null) {
            return null;
        }
        return (ContentClaim)this.backupRepoClaimMap.get(claim);
    }

    public long getContainerCapacity(String containerName) throws IOException {
        return this.maxBytes;
    }

    public Set<String> getContainerNames() {
        return Collections.singleton(CONTAINER_NAME);
    }

    public long getContainerUsableSpace(String containerName) throws IOException {
        return this.maxBytes - this.repoSize.get();
    }

    public ContentClaim create(boolean lossTolerant) throws IOException {
        if (lossTolerant) {
            return this.createLossTolerant();
        }
        ContentRepository backupRepo = this.getBackupRepository();
        if (backupRepo == null) {
            return this.createLossTolerant();
        }
        ContentClaim backupClaim = backupRepo.create(lossTolerant);
        this.backupRepoClaimMap.put(backupClaim, backupClaim);
        return backupClaim;
    }

    private ContentClaim createLossTolerant() {
        long id = this.idGenerator.getAndIncrement();
        ContentClaim claim = this.claimManager.newContentClaim(CONTAINER_NAME, "section", String.valueOf(id), true);
        ContentBlock contentBlock = new ContentBlock(claim, this.repoSize);
        this.claimManager.incrementClaimantCount(claim, true);
        this.claimMap.put(claim, contentBlock);
        this.logger.debug("Created {} and mapped to {}", (Object)claim, (Object)contentBlock);
        return claim;
    }

    public int incrementClaimaintCount(ContentClaim claim) {
        if (claim == null) {
            return 0;
        }
        ContentClaim backupClaim = this.getBackupClaim(claim);
        if (backupClaim == null) {
            return this.claimManager.incrementClaimantCount((ContentClaim)this.resolveClaim(claim));
        }
        return this.getBackupRepository().incrementClaimaintCount(backupClaim);
    }

    public int decrementClaimantCount(ContentClaim claim) {
        if (claim == null) {
            return 0;
        }
        ContentClaim backupClaim = this.getBackupClaim(claim);
        if (backupClaim == null) {
            return this.claimManager.decrementClaimantCount((ContentClaim)this.resolveClaim(claim));
        }
        return this.getBackupRepository().decrementClaimantCount(backupClaim);
    }

    public int getClaimantCount(ContentClaim claim) {
        if (claim == null) {
            return 0;
        }
        ContentClaim backupClaim = this.getBackupClaim(claim);
        if (backupClaim == null) {
            return this.claimManager.getClaimantCount((ContentClaim)this.resolveClaim(claim));
        }
        return this.getBackupRepository().getClaimantCount(backupClaim);
    }

    public boolean remove(ContentClaim claim) {
        if (claim == null) {
            return false;
        }
        ContentClaim backupClaim = this.getBackupClaim(claim);
        if (backupClaim == null) {
            ContentBlock content = (ContentBlock)this.claimMap.remove(claim);
            if (content == null) {
                this.logger.debug("Removed {} from repo but it did not exist", (Object)claim);
            } else {
                this.logger.debug("Removed {} from repo; Content = {}", (Object)claim, (Object)content);
                content.destroy();
            }
        } else {
            this.getBackupRepository().remove(backupClaim);
        }
        return true;
    }

    public ContentClaim clone(ContentClaim original, boolean lossTolerant) throws IOException {
        ContentClaim createdClaim = this.create(lossTolerant);
        try (InputStream dataIn = this.read(original);){
            VolatileContentRepository createdClaimRepo;
            VolatileContentRepository volatileContentRepository = createdClaimRepo = lossTolerant ? this : this.getBackupRepository();
            if (createdClaimRepo == null) {
                throw new IllegalStateException("Cannot create non-loss-tolerant ContentClaim because there is no persistent Content Repository configured");
            }
            try (OutputStream dataOut = createdClaimRepo.write(createdClaim);){
                StreamUtils.copy((InputStream)dataIn, (OutputStream)dataOut);
            }
        }
        return createdClaim;
    }

    public long merge(Collection<ContentClaim> claims, ContentClaim destination, byte[] header, byte[] footer, byte[] demarcator) throws IOException {
        long bytes = 0L;
        try (OutputStream out = this.write(destination);){
            if (header != null) {
                out.write(header);
                bytes += (long)header.length;
            }
            Iterator<ContentClaim> itr = claims.iterator();
            while (itr.hasNext()) {
                ContentClaim readClaim = itr.next();
                try (InputStream in = this.read(readClaim);){
                    bytes += StreamUtils.copy((InputStream)in, (OutputStream)out);
                }
                if (!itr.hasNext() || demarcator == null) continue;
                bytes += (long)demarcator.length;
                out.write(demarcator);
            }
            if (footer != null) {
                bytes += (long)footer.length;
                out.write(footer);
            }
            long l = bytes;
            return l;
        }
    }

    public long importFrom(Path content, ContentClaim claim) throws IOException {
        return this.importFrom(content, claim, false);
    }

    public long importFrom(Path content, ContentClaim claim, boolean append) throws IOException {
        try (FileInputStream in = new FileInputStream(content.toFile());){
            long l = this.importFrom(in, claim, append);
            return l;
        }
    }

    public long importFrom(InputStream content, ContentClaim claim) throws IOException {
        return this.importFrom(content, claim, false);
    }

    public long importFrom(InputStream in, ContentClaim claim, boolean append) throws IOException {
        ContentClaim backupClaim = this.getBackupClaim(claim);
        if (backupClaim == null) {
            ContentBlock content = this.getContent(claim);
            if (!append) {
                content.reset();
            }
            return StreamUtils.copy((InputStream)in, (OutputStream)content.write());
        }
        return this.getBackupRepository().importFrom(in, claim, append);
    }

    public long exportTo(ContentClaim claim, Path destination, boolean append) throws IOException {
        return this.exportTo(claim, destination, append, 0L, this.size(claim));
    }

    /*
     * Exception decompiling
     */
    public long exportTo(ContentClaim claim, Path destination, boolean append, long offset, long length) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public long exportTo(ContentClaim claim, OutputStream destination) throws IOException {
        InputStream in = this.read(claim);
        return StreamUtils.copy((InputStream)in, (OutputStream)destination);
    }

    public long exportTo(ContentClaim claim, OutputStream destination, long offset, long length) throws IOException {
        InputStream in = this.read(claim);
        StreamUtils.skip((InputStream)in, (long)offset);
        StreamUtils.copy((InputStream)in, (OutputStream)destination, (long)length);
        return length;
    }

    private ContentBlock getContent(ContentClaim claim) throws ContentNotFoundException {
        ContentBlock content = (ContentBlock)this.claimMap.get(claim);
        if (content == null) {
            throw new ContentNotFoundException(claim);
        }
        return content;
    }

    public long size(ContentClaim claim) throws IOException {
        if (claim == null) {
            return 0L;
        }
        ContentClaim backupClaim = this.getBackupClaim(claim);
        return backupClaim == null ? this.getContent(claim).getSize() : this.getBackupRepository().size(claim);
    }

    public InputStream read(ContentClaim claim) throws IOException {
        if (claim == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        ContentClaim backupClaim = this.getBackupClaim(claim);
        return backupClaim == null ? this.getContent(claim).read() : this.getBackupRepository().read(backupClaim);
    }

    public OutputStream write(ContentClaim claim) throws IOException {
        ContentClaim backupClaim = this.getBackupClaim(claim);
        return backupClaim == null ? this.getContent(claim).write() : this.getBackupRepository().write(backupClaim);
    }

    public void purge() {
        for (ContentClaim claim : this.claimMap.keySet()) {
            this.claimManager.decrementClaimantCount((ContentClaim)this.resolveClaim(claim));
            ContentClaim backup = this.getBackupClaim(claim);
            if (backup == null) continue;
            this.getBackupRepository().remove(backup);
        }
    }

    public void cleanup() {
    }

    public boolean isAccessible(ContentClaim claim) throws IOException {
        if (claim == null) {
            return false;
        }
        ContentClaim backupClaim = this.getBackupClaim(claim);
        if (backupClaim == null) {
            ContentBlock contentBlock = (ContentBlock)this.claimMap.get(claim);
            return contentBlock != null;
        }
        return this.getBackupRepository().isAccessible(backupClaim);
    }

    private class CleanupOldClaims
    implements Runnable {
        private CleanupOldClaims() {
        }

        @Override
        public void run() {
            ArrayList destructable = new ArrayList(1000);
            block0: while (true) {
                destructable.clear();
                VolatileContentRepository.this.claimManager.drainDestructableClaims(destructable, 1000, 5L, TimeUnit.SECONDS);
                if (destructable.isEmpty()) {
                    return;
                }
                Iterator i$ = destructable.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block0;
                    ContentClaim claim = (ContentClaim)i$.next();
                    VolatileContentRepository.this.remove(claim);
                }
                break;
            }
        }
    }

    class ContentBlock {
        private final ClaimSwitchingOutputStream out;
        private final ContentClaim claim;
        private final AtomicLong repoSizeCounter;

        public ContentBlock(final ContentClaim claim, final AtomicLong repoSizeCounter) {
            this.claim = claim;
            this.repoSizeCounter = repoSizeCounter;
            this.out = new ClaimSwitchingOutputStream(new ArrayManagedOutputStream(VolatileContentRepository.this.memoryManager){

                @Override
                public void write(int b) throws IOException {
                    try {
                        long bufferLengthBefore = this.getBufferLength();
                        super.write(b);
                        long bufferLengthAfter = this.getBufferLength();
                        long bufferSpaceAdded = bufferLengthAfter - bufferLengthBefore;
                        if (bufferSpaceAdded > 0L) {
                            repoSizeCounter.addAndGet(bufferSpaceAdded);
                        }
                    }
                    catch (IOException e) {
                        byte[] buff = new byte[]{(byte)(b & 0xFF)};
                        this.redirect(buff, 0, 1);
                    }
                }

                @Override
                public void write(byte[] b) throws IOException {
                    this.write(b, 0, b.length);
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    try {
                        long bufferLengthBefore = this.getBufferLength();
                        super.write(b, off, len);
                        long bufferLengthAfter = this.getBufferLength();
                        long bufferSpaceAdded = bufferLengthAfter - bufferLengthBefore;
                        if (bufferSpaceAdded > 0L) {
                            repoSizeCounter.addAndGet(bufferSpaceAdded);
                        }
                    }
                    catch (IOException e) {
                        this.redirect(b, off, len);
                    }
                }

                private void redirect(byte[] b, int off, int len) throws IOException {
                    VolatileContentRepository.this.logger.debug("Redirecting {}", (Object)claim);
                    ContentBlock.this.out.redirect();
                    ContentBlock.this.out.write(b, off, len);
                }
            });
        }

        public synchronized long getSize() throws IOException {
            return this.out.getSize();
        }

        public synchronized OutputStream write() {
            return this.out;
        }

        public synchronized InputStream read() throws IOException {
            return this.out.read();
        }

        public synchronized void reset() {
            this.out.reset();
        }

        public synchronized void destroy() {
            this.out.destroy();
        }

        private class ClaimSwitchingOutputStream
        extends FilterOutputStream {
            private ArrayManagedOutputStream amos;
            private OutputStream out;

            public ClaimSwitchingOutputStream(ArrayManagedOutputStream out) {
                super(out);
                this.amos = out;
                this.out = out;
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.out.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.out.write(b, off, len);
            }

            @Override
            public void write(int b) throws IOException {
                this.out.write(b);
            }

            public void destroy() {
                int vcosLength = this.amos.getBufferLength();
                this.amos.destroy();
                this.amos = null;
                ContentBlock.this.repoSizeCounter.addAndGet(-vcosLength);
            }

            @Override
            public void flush() throws IOException {
                this.out.flush();
            }

            @Override
            public void close() throws IOException {
                this.out.close();
            }

            public void reset() {
                this.amos.reset();
            }

            private void redirect() throws IOException {
                ContentRepository backupRepo = VolatileContentRepository.this.getBackupRepository();
                if (backupRepo == null) {
                    throw new IOException("Content Repository is out of space");
                }
                ContentClaim backupClaim = backupRepo.create(true);
                VolatileContentRepository.this.backupRepoClaimMap.put(ContentBlock.this.claim, backupClaim);
                this.out = backupRepo.write(backupClaim);
                this.amos.writeTo(this.out);
                this.amos.destroy();
                this.amos = null;
            }

            public long getSize() throws IOException {
                if (this.amos == null) {
                    ContentClaim backupClaim = VolatileContentRepository.this.getBackupClaim(ContentBlock.this.claim);
                    return VolatileContentRepository.this.getBackupRepository().size(backupClaim);
                }
                return this.amos.size();
            }

            public InputStream read() throws IOException {
                if (this.amos == null) {
                    ContentClaim backupClaim = VolatileContentRepository.this.getBackupClaim(ContentBlock.this.claim);
                    return VolatileContentRepository.this.getBackupRepository().read(backupClaim);
                }
                return this.amos.newInputStream();
            }
        }
    }
}

