/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.List;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.ValueMapper;
import org.apache.nifi.controller.status.history.ValueReducer;

public class StandardMetricDescriptor<T>
implements MetricDescriptor<T> {
    private final String field;
    private final String label;
    private final String description;
    private final MetricDescriptor.Formatter formatter;
    private final ValueMapper<T> valueMapper;
    private final ValueReducer<StatusSnapshot, Long> reducer;

    public StandardMetricDescriptor(String field, String label, String description, MetricDescriptor.Formatter formatter, ValueMapper<T> valueFunction) {
        this(field, label, description, formatter, valueFunction, null);
    }

    public StandardMetricDescriptor(String field, String label, String description, MetricDescriptor.Formatter formatter, ValueMapper<T> valueFunction, ValueReducer<StatusSnapshot, Long> reducer) {
        this.field = field;
        this.label = label;
        this.description = description;
        this.formatter = formatter;
        this.valueMapper = valueFunction;
        this.reducer = reducer == null ? new SumReducer() : reducer;
    }

    public String getField() {
        return this.field;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public MetricDescriptor.Formatter getFormatter() {
        return this.formatter;
    }

    public ValueMapper<T> getValueFunction() {
        return this.valueMapper;
    }

    public ValueReducer<StatusSnapshot, Long> getValueReducer() {
        return this.reducer;
    }

    public String toString() {
        return "StandardMetricDescriptor[" + this.label + "]";
    }

    public int hashCode() {
        return 23987 + this.formatter.name().hashCode() + 4 * this.label.hashCode() + 8 * this.field.hashCode() + 28 * this.description.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MetricDescriptor)) {
            return false;
        }
        MetricDescriptor other = (MetricDescriptor)obj;
        return this.field.equals(other.getField());
    }

    class SumReducer
    implements ValueReducer<StatusSnapshot, Long> {
        SumReducer() {
        }

        public Long reduce(List<StatusSnapshot> values) {
            long sum = 0L;
            for (StatusSnapshot snapshot : values) {
                sum += ((Long)snapshot.getStatusMetrics().get(StandardMetricDescriptor.this)).longValue();
            }
            return sum;
        }
    }
}

