/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;

public class ControllerServiceLogObserver
implements LogObserver {
    private final BulletinRepository bulletinRepository;
    private final ControllerServiceNode serviceNode;

    public ControllerServiceLogObserver(BulletinRepository bulletinRepository, ControllerServiceNode serviceNode) {
        this.bulletinRepository = bulletinRepository;
        this.serviceNode = serviceNode;
    }

    public void onLogMessage(LogMessage message) {
        String bulletinLevel = message.getLevel() == LogLevel.WARN ? Severity.WARNING.name() : message.getLevel().toString();
        Bulletin bulletin = BulletinFactory.createBulletin(null, (String)this.serviceNode.getIdentifier(), (ComponentType)ComponentType.CONTROLLER_SERVICE, (String)this.serviceNode.getName(), (String)"Log Message", (String)bulletinLevel, (String)message.getMessage());
        this.bulletinRepository.addBulletin(bulletin);
    }
}

