/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class StandardLogRepository
implements LogRepository {
    public static final int DEFAULT_MAX_CAPACITY_PER_LEVEL = 10;
    private final Map<LogLevel, Collection<LogObserver>> observers = new HashMap<LogLevel, Collection<LogObserver>>();
    private final Map<String, LogObserver> observerLookup = new HashMap<String, LogObserver>();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Logger logger = LoggerFactory.getLogger(StandardLogRepository.class);

    public void addLogMessage(LogLevel level, String message) {
        this.addLogMessage(level, message, (Throwable)null);
    }

    public void addLogMessage(LogLevel level, String message, Throwable t) {
        LogMessage logMessage = new LogMessage(System.currentTimeMillis(), level, message, t);
        Collection<LogObserver> logObservers = this.observers.get(level);
        if (logObservers != null) {
            for (LogObserver observer : logObservers) {
                try {
                    observer.onLogMessage(logMessage);
                }
                catch (Throwable observerThrowable) {
                    this.logger.error("Failed to pass log message to Observer {} due to {}", (Object)observer, (Object)observerThrowable.toString());
                }
            }
        }
    }

    public void addLogMessage(LogLevel level, String format, Object[] params) {
        String formattedMessage = MessageFormatter.arrayFormat((String)format, (Object[])params).getMessage();
        this.addLogMessage(level, formattedMessage);
    }

    public void addLogMessage(LogLevel level, String format, Object[] params, Throwable t) {
        Object[] paramsWithThrowable = new Object[params.length + 1];
        System.arraycopy(params, 0, paramsWithThrowable, 0, params.length);
        paramsWithThrowable[paramsWithThrowable.length - 1] = t;
        String formattedMessage = MessageFormatter.arrayFormat((String)format, (Object[])paramsWithThrowable).getMessage();
        this.addLogMessage(level, formattedMessage, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservationLevel(String observerIdentifier, LogLevel level) {
        this.writeLock.lock();
        try {
            LogObserver observer = this.removeObserver(observerIdentifier);
            if (observer == null) {
                throw new IllegalArgumentException("The specified observer cannot be found.");
            }
            this.addObserver(observerIdentifier, level, observer);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public LogLevel getObservationLevel(String observerIdentifier) {
        this.readLock.lock();
        try {
            if (!this.observerLookup.containsKey(observerIdentifier)) {
                throw new IllegalStateException("The specified observer identifier does not exist.");
            }
            LogObserver observer = this.observerLookup.get(observerIdentifier);
            for (LogLevel logLevel : LogLevel.values()) {
                Collection<LogObserver> levelObservers = this.observers.get(logLevel);
                if (levelObservers == null || !levelObservers.contains(observer)) continue;
                LogLevel logLevel2 = logLevel;
                return logLevel2;
            }
            throw new IllegalStateException("The specified observer identifier does not exist.");
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(String observerIdentifier, LogLevel minimumLevel, LogObserver observer) {
        this.writeLock.lock();
        try {
            if (this.observerLookup.containsKey(observerIdentifier)) {
                throw new IllegalStateException("The specified observer identifier already exists.");
            }
            LogLevel[] allLevels = LogLevel.values();
            for (int i = minimumLevel.ordinal(); i < allLevels.length; ++i) {
                Collection<LogObserver> collection = this.observers.get(allLevels[i]);
                if (collection == null) {
                    collection = new ArrayList<LogObserver>();
                    this.observers.put(allLevels[i], collection);
                }
                collection.add(observer);
            }
            this.observerLookup.put(observerIdentifier, observer);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogObserver removeObserver(String observerIdentifier) {
        this.writeLock.lock();
        try {
            LogObserver observer = this.observerLookup.get(observerIdentifier);
            for (Collection<LogObserver> collection : this.observers.values()) {
                collection.remove(observer);
            }
            LogObserver logObserver = this.observerLookup.remove(observerIdentifier);
            return logObserver;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllObservers() {
        this.writeLock.lock();
        try {
            this.observers.clear();
            this.observerLookup.clear();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

