/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.QueueProvider;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.claim.ContentClaimManager;

public class VolatileFlowFileRepository
implements FlowFileRepository {
    private final AtomicLong idGenerator = new AtomicLong(0L);
    private ContentClaimManager claimManager;

    public void initialize(ContentClaimManager claimManager) {
        this.claimManager = claimManager;
    }

    public boolean isVolatile() {
        return true;
    }

    public long getStorageCapacity() throws IOException {
        return 1L;
    }

    public long getUsableStorageSpace() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
    }

    public void updateRepository(Collection<RepositoryRecord> records) throws IOException {
        for (RepositoryRecord record : records) {
            if (record.getType() == RepositoryRecordType.DELETE) {
                if (record.getCurrentClaim() != null && this.claimManager.getClaimantCount(record.getCurrentClaim()) <= 0) {
                    this.claimManager.markDestructable(record.getCurrentClaim());
                }
                if (record.getOriginalClaim() == null || record.getOriginalClaim().equals(record.getCurrentClaim()) || this.claimManager.getClaimantCount(record.getOriginalClaim()) > 0) continue;
                this.claimManager.markDestructable(record.getOriginalClaim());
                continue;
            }
            if (record.getType() != RepositoryRecordType.UPDATE || record.getOriginalClaim() == null || record.getCurrentClaim() == record.getOriginalClaim() || this.claimManager.getClaimantCount(record.getOriginalClaim()) > 0) continue;
            this.claimManager.markDestructable(record.getOriginalClaim());
        }
    }

    public long loadFlowFiles(QueueProvider queueProvider, long minimumSequenceNumber) throws IOException {
        this.idGenerator.set(minimumSequenceNumber);
        return 0L;
    }

    public long getNextFlowFileSequence() {
        return this.idGenerator.getAndIncrement();
    }

    public long getMaxFlowFileIdentifier() throws IOException {
        return this.idGenerator.get() - 1L;
    }

    public void swapFlowFilesIn(String swapLocation, List<FlowFileRecord> flowFileRecords, FlowFileQueue queue) throws IOException {
    }

    public void swapFlowFilesOut(List<FlowFileRecord> swappedOut, FlowFileQueue queue, String swapLocation) throws IOException {
    }
}

