/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor;

import java.util.concurrent.TimeUnit;
import org.apache.nifi.attribute.expression.language.PreparedQuery;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.AttributeValueDecorator;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.util.FormatUtils;

public final class StandardPropertyValue
implements PropertyValue {
    private final String rawValue;
    private final ControllerServiceLookup serviceLookup;
    private final PreparedQuery preparedQuery;

    public StandardPropertyValue(String rawValue, ControllerServiceLookup serviceLookup) {
        this(rawValue, serviceLookup, Query.prepare((String)rawValue));
    }

    public StandardPropertyValue(String rawValue, ControllerServiceLookup serviceLookup, PreparedQuery preparedQuery) {
        this.rawValue = rawValue;
        this.serviceLookup = serviceLookup;
        this.preparedQuery = preparedQuery;
    }

    public String getValue() {
        return this.rawValue;
    }

    public Integer asInteger() {
        return this.rawValue == null ? null : Integer.valueOf(Integer.parseInt(this.rawValue.trim()));
    }

    public Long asLong() {
        return this.rawValue == null ? null : Long.valueOf(Long.parseLong(this.rawValue.trim()));
    }

    public Boolean asBoolean() {
        return this.rawValue == null ? null : Boolean.valueOf(Boolean.parseBoolean(this.rawValue.trim()));
    }

    public Float asFloat() {
        return this.rawValue == null ? null : Float.valueOf(Float.parseFloat(this.rawValue.trim()));
    }

    public Double asDouble() {
        return this.rawValue == null ? null : Double.valueOf(Double.parseDouble(this.rawValue.trim()));
    }

    public Long asTimePeriod(TimeUnit timeUnit) {
        return this.rawValue == null ? null : Long.valueOf(FormatUtils.getTimeDuration((String)this.rawValue.trim(), (TimeUnit)timeUnit));
    }

    public Double asDataSize(DataUnit dataUnit) {
        return this.rawValue == null ? null : DataUnit.parseDataSize((String)this.rawValue.trim(), (DataUnit)dataUnit);
    }

    public PropertyValue evaluateAttributeExpressions() throws ProcessException {
        return this.evaluateAttributeExpressions(null, null);
    }

    public PropertyValue evaluateAttributeExpressions(AttributeValueDecorator decorator) throws ProcessException {
        return this.evaluateAttributeExpressions(null, decorator);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile) throws ProcessException {
        return this.evaluateAttributeExpressions(flowFile, null);
    }

    public PropertyValue evaluateAttributeExpressions(FlowFile flowFile, AttributeValueDecorator decorator) throws ProcessException {
        if (this.rawValue == null || this.preparedQuery == null) {
            return this;
        }
        return new StandardPropertyValue(this.preparedQuery.evaluateExpressions(flowFile, decorator), this.serviceLookup, null);
    }

    public String toString() {
        return this.rawValue;
    }

    public ControllerService asControllerService() {
        if (this.rawValue == null || this.rawValue.equals("")) {
            return null;
        }
        return this.serviceLookup.getControllerService(this.rawValue);
    }

    public <T extends ControllerService> T asControllerService(Class<T> serviceType) throws IllegalArgumentException {
        if (!serviceType.isInterface()) {
            throw new IllegalArgumentException("ControllerServices may be referenced only via their interfaces; " + serviceType + " is not an interface");
        }
        if (this.rawValue == null || this.rawValue.equals("")) {
            return null;
        }
        ControllerService service = this.serviceLookup.getControllerService(this.rawValue);
        if (service == null) {
            return null;
        }
        if (serviceType.isAssignableFrom(service.getClass())) {
            return (T)((ControllerService)serviceType.cast(service));
        }
        throw new IllegalArgumentException("Controller Service with identifier " + this.rawValue + " is of type " + service.getClass() + " and cannot be cast to " + serviceType);
    }

    public boolean isSet() {
        return this.rawValue != null;
    }
}

