/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import com.sun.jersey.api.client.ClientHandlerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.admin.service.UserService;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.cluster.BulletinsPayload;
import org.apache.nifi.cluster.HeartbeatPayload;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.Heartbeat;
import org.apache.nifi.cluster.protocol.NodeBulletins;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.UnknownServiceAddressException;
import org.apache.nifi.cluster.protocol.message.HeartbeatMessage;
import org.apache.nifi.cluster.protocol.message.NodeBulletinsMessage;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.connectable.StandardConnection;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ContentAvailability;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.EventDrivenWorkerQueue;
import org.apache.nifi.controller.FlowFileQueue;
import org.apache.nifi.controller.FlowSerializationException;
import org.apache.nifi.controller.FlowSerializer;
import org.apache.nifi.controller.FlowSynchronizationException;
import org.apache.nifi.controller.FlowSynchronizer;
import org.apache.nifi.controller.Heartbeater;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SnippetManager;
import org.apache.nifi.controller.StandardFunnel;
import org.apache.nifi.controller.StandardProcessorNode;
import org.apache.nifi.controller.Template;
import org.apache.nifi.controller.TemplateManager;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.exception.CommunicationsException;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.label.StandardLabel;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.ReportingTaskProvider;
import org.apache.nifi.controller.reporting.StandardReportingInitializationContext;
import org.apache.nifi.controller.reporting.StandardReportingTaskNode;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.QueueProvider;
import org.apache.nifi.controller.repository.RepositoryStatusReport;
import org.apache.nifi.controller.repository.StandardCounterRepository;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.StandardRepositoryRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.controller.repository.claim.StandardResourceClaim;
import org.apache.nifi.controller.repository.claim.StandardResourceClaimManager;
import org.apache.nifi.controller.repository.io.LimitedInputStream;
import org.apache.nifi.controller.scheduling.EventDrivenSchedulingAgent;
import org.apache.nifi.controller.scheduling.ProcessContextFactory;
import org.apache.nifi.controller.scheduling.QuartzSchedulingAgent;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.scheduling.TimerDrivenSchedulingAgent;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceProvider;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.RunStatus;
import org.apache.nifi.controller.status.TransmissionStatus;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.controller.status.history.StatusHistoryUtil;
import org.apache.nifi.controller.tasks.ExpireFlowFiles;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.diagnostics.SystemDiagnosticsFactory;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.events.NodeBulletinProcessingStrategy;
import org.apache.nifi.events.VolatileBulletinRepository;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.framework.security.util.SslContextFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.groups.StandardProcessGroup;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.ControllerServiceLogObserver;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.ProcessorLogObserver;
import org.apache.nifi.logging.ReportingTaskLogObserver;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.QueueSize;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessorInitializationContext;
import org.apache.nifi.processor.StandardValidationContextFactory;
import org.apache.nifi.processor.annotation.OnAdded;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RemoteResourceManager;
import org.apache.nifi.remote.RemoteSiteListener;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.remote.SocketRemoteSiteListener;
import org.apache.nifi.remote.StandardRemoteProcessGroup;
import org.apache.nifi.remote.StandardRemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.StandardRootGroupPort;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.protocol.socket.SocketFlowFileServerProtocol;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupContentsDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowController
implements EventAccess,
ControllerServiceProvider,
ReportingTaskProvider,
Heartbeater,
QueueProvider {
    public static final String DEFAULT_FLOWFILE_REPO_IMPLEMENTATION = "org.apache.nifi.controller.repository.WriteAheadFlowFileRepository";
    public static final String DEFAULT_CONTENT_REPO_IMPLEMENTATION = "org.apache.nifi.controller.repository.FileSystemRepository";
    public static final String DEFAULT_PROVENANCE_REPO_IMPLEMENTATION = "org.apache.nifi.provenance.VolatileProvenanceRepository";
    public static final String DEFAULT_SWAP_MANAGER_IMPLEMENTATION = "org.apache.nifi.controller.FileSystemSwapManager";
    public static final String DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION = "org.apache.nifi.controller.status.history.VolatileComponentStatusRepository";
    public static final String SCHEDULE_MINIMUM_NANOSECONDS = "flowcontroller.minimum.nanoseconds";
    public static final String GRACEFUL_SHUTDOWN_PERIOD = "nifi.flowcontroller.graceful.shutdown.seconds";
    public static final long DEFAULT_GRACEFUL_SHUTDOWN_SECONDS = 10L;
    public static final int METRICS_RESERVOIR_SIZE = 288;
    public static final String ROOT_GROUP_ID_ALIAS = "root";
    public static final String DEFAULT_ROOT_GROUP_NAME = "NiFi Flow";
    private final AtomicInteger maxTimerDrivenThreads;
    private final AtomicInteger maxEventDrivenThreads;
    private final AtomicReference<FlowEngine> timerDrivenEngineRef;
    private final AtomicReference<FlowEngine> eventDrivenEngineRef;
    private final ContentRepository contentRepository;
    private final FlowFileRepository flowFileRepository;
    private final FlowFileEventRepository flowFileEventRepository;
    private final ProvenanceEventRepository provenanceEventRepository;
    private final VolatileBulletinRepository bulletinRepository;
    private final StandardProcessScheduler processScheduler;
    private final TemplateManager templateManager;
    private final SnippetManager snippetManager;
    private final long gracefulShutdownSeconds;
    private final ExtensionManager extensionManager;
    private final NiFiProperties properties;
    private final SSLContext sslContext;
    private final RemoteSiteListener externalSiteListener;
    private final AtomicReference<CounterRepository> counterRepositoryRef;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final ControllerServiceProvider controllerServiceProvider;
    private final UserService userService;
    private final EventDrivenWorkerQueue eventDrivenWorkerQueue;
    private final ComponentStatusRepository componentStatusRepository;
    private final long systemStartTime = System.currentTimeMillis();
    private final ConcurrentMap<String, ReportingTaskNode> reportingTasks = new ConcurrentHashMap<String, ReportingTaskNode>();
    private final AtomicReference<HeartbeatBean> heartbeatBeanRef = new AtomicReference();
    private final AtomicBoolean heartbeatsSuspended = new AtomicBoolean(false);
    private final Integer remoteInputSocketPort;
    private final Boolean isSiteToSiteSecure;
    private Integer clusterManagerRemoteSitePort = null;
    private Boolean clusterManagerRemoteSiteCommsSecure = null;
    private ProcessGroup rootGroup;
    private final List<Connectable> startConnectablesAfterInitialization;
    private final List<RemoteGroupPort> startRemoteGroupPortsAfterInitialization;
    private final boolean configuredForClustering;
    private final int heartbeatDelaySeconds;
    private final StringEncryptor encryptor;
    private final NodeProtocolSender protocolSender;
    private final ScheduledExecutorService clusterTaskExecutor = new FlowEngine(3, "Clustering Tasks");
    private final ResourceClaimManager contentClaimManager = new StandardResourceClaimManager();
    private ScheduledFuture<?> bulletinFuture;
    private ScheduledFuture<?> heartbeatGeneratorFuture;
    private ScheduledFuture<?> heartbeatSenderFuture;
    private final AtomicReference<HeartbeatMessageGeneratorTask> heartbeatMessageGeneratorTaskRef = new AtomicReference<Object>(null);
    private final AtomicReference<NodeBulletinProcessingStrategy> nodeBulletinSubscriber;
    private NodeIdentifier nodeId;
    private boolean clustered;
    private String clusterManagerDN;
    private boolean primary;
    private boolean connected;
    private String instanceId;
    private volatile boolean shutdown = false;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private FlowFileSwapManager flowFileSwapManager;
    private static final Logger LOG = LoggerFactory.getLogger(FlowController.class);
    private static final Logger heartbeatLogger = LoggerFactory.getLogger((String)"org.apache.nifi.cluster.heartbeat");

    public static FlowController createStandaloneInstance(FlowFileEventRepository flowFileEventRepo, NiFiProperties properties, UserService userService, StringEncryptor encryptor) {
        return new FlowController(flowFileEventRepo, properties, userService, encryptor, false, null);
    }

    public static FlowController createClusteredInstance(FlowFileEventRepository flowFileEventRepo, NiFiProperties properties, UserService userService, StringEncryptor encryptor, NodeProtocolSender protocolSender) {
        FlowController flowController = new FlowController(flowFileEventRepo, properties, userService, encryptor, true, protocolSender);
        flowController.setClusterManagerRemoteSiteInfo(properties.getRemoteInputPort(), properties.isSiteToSiteSecure());
        return flowController;
    }

    private FlowController(FlowFileEventRepository flowFileEventRepo, NiFiProperties properties, UserService userService, StringEncryptor encryptor, boolean configuredForClustering, NodeProtocolSender protocolSender) {
        long snapshotMillis;
        long shutdownSecs;
        FlowFileRepository flowFileRepo;
        this.maxTimerDrivenThreads = new AtomicInteger(10);
        this.maxEventDrivenThreads = new AtomicInteger(5);
        this.encryptor = encryptor;
        this.properties = properties;
        this.sslContext = SslContextFactory.createSslContext((NiFiProperties)properties, (boolean)false);
        this.extensionManager = new ExtensionManager();
        this.timerDrivenEngineRef = new AtomicReference<FlowEngine>(new FlowEngine(this.maxTimerDrivenThreads.get(), "Timer-Driven Process"));
        this.eventDrivenEngineRef = new AtomicReference<FlowEngine>(new FlowEngine(this.maxEventDrivenThreads.get(), "Event-Driven Process"));
        this.flowFileRepository = flowFileRepo = FlowController.createFlowFileRepository(properties, this.contentClaimManager);
        this.flowFileEventRepository = flowFileEventRepo;
        this.counterRepositoryRef = new AtomicReference<StandardCounterRepository>(new StandardCounterRepository());
        this.bulletinRepository = new VolatileBulletinRepository();
        this.nodeBulletinSubscriber = new AtomicReference();
        try {
            this.provenanceEventRepository = this.createProvenanceRepository(properties);
            this.provenanceEventRepository.initialize(FlowController.createEventReporter(this.bulletinRepository));
            this.contentRepository = this.createContentRepository(properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Provenance Repository", e);
        }
        this.processScheduler = new StandardProcessScheduler(this, this, encryptor);
        this.eventDrivenWorkerQueue = new EventDrivenWorkerQueue(false, false, this.processScheduler);
        this.controllerServiceProvider = new StandardControllerServiceProvider(this.processScheduler, this.bulletinRepository);
        ProcessContextFactory contextFactory = new ProcessContextFactory(this.contentRepository, this.flowFileRepository, this.flowFileEventRepository, this.counterRepositoryRef.get(), this.provenanceEventRepository);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.EVENT_DRIVEN, new EventDrivenSchedulingAgent(this.eventDrivenEngineRef.get(), this, this.eventDrivenWorkerQueue, contextFactory, this.maxEventDrivenThreads.get(), encryptor));
        QuartzSchedulingAgent quartzSchedulingAgent = new QuartzSchedulingAgent(this, this.timerDrivenEngineRef.get(), contextFactory, encryptor);
        TimerDrivenSchedulingAgent timerDrivenAgent = new TimerDrivenSchedulingAgent(this, this.timerDrivenEngineRef.get(), contextFactory, encryptor);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.TIMER_DRIVEN, timerDrivenAgent);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.PRIMARY_NODE_ONLY, timerDrivenAgent);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.CRON_DRIVEN, quartzSchedulingAgent);
        this.processScheduler.scheduleFrameworkTask(new ExpireFlowFiles(this, contextFactory), "Expire FlowFiles", 30L, 30L, TimeUnit.SECONDS);
        this.startConnectablesAfterInitialization = new ArrayList<Connectable>();
        this.startRemoteGroupPortsAfterInitialization = new ArrayList<RemoteGroupPort>();
        this.userService = userService;
        String gracefulShutdownSecondsVal = properties.getProperty(GRACEFUL_SHUTDOWN_PERIOD);
        try {
            shutdownSecs = Long.parseLong(gracefulShutdownSecondsVal);
            if (shutdownSecs < 1L) {
                shutdownSecs = 10L;
            }
        }
        catch (NumberFormatException nfe) {
            shutdownSecs = 10L;
        }
        this.gracefulShutdownSeconds = shutdownSecs;
        this.remoteInputSocketPort = properties.getRemoteInputPort();
        this.isSiteToSiteSecure = properties.isSiteToSiteSecure();
        if (this.isSiteToSiteSecure.booleanValue() && this.sslContext == null && this.remoteInputSocketPort != null) {
            throw new IllegalStateException("NiFi Configured to allow Secure Site-to-Site communications but the Keystore/Truststore properties are not configured");
        }
        this.configuredForClustering = configuredForClustering;
        this.heartbeatDelaySeconds = (int)FormatUtils.getTimeDuration((String)properties.getNodeHeartbeatInterval(), (TimeUnit)TimeUnit.SECONDS);
        this.protocolSender = protocolSender;
        try {
            this.templateManager = new TemplateManager(properties.getTemplateDirectory());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.snippetManager = new SnippetManager();
        this.rootGroup = new StandardProcessGroup(UUID.randomUUID().toString(), this, this.processScheduler, properties, encryptor);
        this.rootGroup.setName(DEFAULT_ROOT_GROUP_NAME);
        this.instanceId = UUID.randomUUID().toString();
        if (this.remoteInputSocketPort == null) {
            LOG.info("Not enabling Site-to-Site functionality because nifi.remote.input.socket.port is not set");
            this.externalSiteListener = null;
        } else if (this.isSiteToSiteSecure.booleanValue() && this.sslContext == null) {
            LOG.error("Unable to create Secure Site-to-Site Listener because not all required Keystore/Truststore Properties are set. Site-to-Site functionality will be disabled until this problem is has been fixed.");
            this.externalSiteListener = null;
        } else {
            RemoteResourceManager.setServerProtocolImplementation((String)"SocketFlowFileProtocol", SocketFlowFileServerProtocol.class);
            this.externalSiteListener = new SocketRemoteSiteListener(this.remoteInputSocketPort.intValue(), this.isSiteToSiteSecure != false ? this.sslContext : null);
            this.externalSiteListener.setRootGroup(this.rootGroup);
        }
        String snapshotFrequency = properties.getProperty("nifi.components.status.snapshot.frequency", "5 mins");
        try {
            snapshotMillis = FormatUtils.getTimeDuration((String)snapshotFrequency, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            snapshotMillis = FormatUtils.getTimeDuration((String)"5 mins", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        this.componentStatusRepository = this.createComponentStatusRepository();
        this.timerDrivenEngineRef.get().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                FlowController.this.componentStatusRepository.capture(FlowController.this.getControllerStatus());
            }
        }, snapshotMillis, snapshotMillis, TimeUnit.MILLISECONDS);
        this.heartbeatBeanRef.set(new HeartbeatBean(this.rootGroup, false, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FlowFileRepository createFlowFileRepository(NiFiProperties properties, ResourceClaimManager contentClaimManager) {
        String implementationClassName = properties.getProperty("nifi.flowfile.repository.implementation", DEFAULT_FLOWFILE_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create FlowFile Repository because the NiFi Properties is missing the following property: nifi.flowfile.repository.implementation");
        }
        try {
            FlowFileRepository created;
            FlowFileRepository flowFileRepository = created = (FlowFileRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, FlowFileRepository.class);
            synchronized (flowFileRepository) {
                created.initialize(contentClaimManager);
            }
            return created;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static FlowFileSwapManager createSwapManager(NiFiProperties properties) {
        String implementationClassName = properties.getProperty("nifi.swap.manager.implementation", DEFAULT_SWAP_MANAGER_IMPLEMENTATION);
        if (implementationClassName == null) {
            return null;
        }
        try {
            return (FlowFileSwapManager)NarThreadContextClassLoader.createInstance((String)implementationClassName, FlowFileSwapManager.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static EventReporter createEventReporter(final BulletinRepository bulletinRepository) {
        return new EventReporter(){
            private static final long serialVersionUID = 1L;

            public void reportEvent(Severity severity, String category, String message) {
                Bulletin bulletin = BulletinFactory.createBulletin((String)category, (String)severity.name(), (String)message);
                bulletinRepository.addBulletin(bulletin);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFlow() throws IOException {
        this.writeLock.lock();
        try {
            this.flowFileSwapManager = FlowController.createSwapManager(this.properties);
            long maxIdFromSwapFiles = -1L;
            if (this.flowFileSwapManager != null) {
                if (this.flowFileRepository.isVolatile()) {
                    this.flowFileSwapManager.purge();
                } else {
                    maxIdFromSwapFiles = this.flowFileSwapManager.recoverSwappedFlowFiles((QueueProvider)this, this.contentClaimManager);
                }
            }
            this.flowFileRepository.loadFlowFiles((QueueProvider)this, maxIdFromSwapFiles + 1L);
            this.contentRepository.cleanup();
            if (this.flowFileSwapManager != null) {
                this.flowFileSwapManager.start(this.flowFileRepository, (QueueProvider)this, this.contentClaimManager, FlowController.createEventReporter(this.bulletinRepository));
            }
            if (this.externalSiteListener != null) {
                this.externalSiteListener.start();
            }
            this.timerDrivenEngineRef.get().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            FlowController.this.updateRemoteProcessGroups();
                        }
                        catch (Throwable t) {
                            LOG.warn("Unable to update Remote Process Groups due to " + t);
                            if (!LOG.isDebugEnabled()) break block2;
                            LOG.warn("", t);
                        }
                    }
                }
            }, 0L, 30L, TimeUnit.SECONDS);
            this.initialized.set(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFlowInitialized(boolean startDelayedComponents) {
        this.writeLock.lock();
        try {
            if (startDelayedComponents) {
                LOG.info("Starting {} processors/ports/funnels", (Object)(this.startConnectablesAfterInitialization.size() + this.startRemoteGroupPortsAfterInitialization.size()));
                for (Connectable connectable : this.startConnectablesAfterInitialization) {
                    if (connectable.getScheduledState() == ScheduledState.DISABLED) continue;
                    try {
                        if (connectable instanceof ProcessorNode) {
                            connectable.getProcessGroup().startProcessor((ProcessorNode)connectable);
                            continue;
                        }
                        this.startConnectable(connectable);
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start {} due to {}", new Object[]{connectable, t.toString()});
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.error("", t);
                    }
                }
                this.startConnectablesAfterInitialization.clear();
                int startedTransmitting = 0;
                for (RemoteGroupPort remoteGroupPort : this.startRemoteGroupPortsAfterInitialization) {
                    try {
                        remoteGroupPort.getRemoteProcessGroup().startTransmitting(remoteGroupPort);
                        ++startedTransmitting;
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start transmitting with {} due to {}", new Object[]{remoteGroupPort, t});
                    }
                }
                LOG.info("Started {} Remote Group Ports transmitting", (Object)startedTransmitting);
                this.startRemoteGroupPortsAfterInitialization.clear();
            } else {
                for (Connectable connectable : this.startConnectablesAfterInitialization) {
                    try {
                        if (!(connectable instanceof Funnel)) continue;
                        this.startConnectable(connectable);
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start {} due to {}", new Object[]{connectable, t});
                    }
                }
                this.startConnectablesAfterInitialization.clear();
                this.startRemoteGroupPortsAfterInitialization.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentRepository createContentRepository(NiFiProperties properties) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String implementationClassName = properties.getProperty("nifi.content.repository.implementation", DEFAULT_CONTENT_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Provenance Repository because the NiFi Properties is missing the following property: nifi.content.repository.implementation");
        }
        try {
            ContentRepository contentRepo;
            ContentRepository contentRepository = contentRepo = (ContentRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, ContentRepository.class);
            synchronized (contentRepository) {
                contentRepo.initialize(this.contentClaimManager);
            }
            return contentRepo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ProvenanceEventRepository createProvenanceRepository(NiFiProperties properties) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String implementationClassName = properties.getProperty("nifi.provenance.repository.implementation", DEFAULT_PROVENANCE_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Provenance Repository because the NiFi Properties is missing the following property: nifi.provenance.repository.implementation");
        }
        try {
            return (ProvenanceEventRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, ProvenanceEventRepository.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ComponentStatusRepository createComponentStatusRepository() {
        String implementationClassName = this.properties.getProperty("nifi.components.status.repository.implementation", DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Component Status Repository because the NiFi Properties is missing the following property: nifi.components.status.repository.implementation");
        }
        try {
            return (ComponentStatusRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, ComponentStatusRepository.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Connection createConnection(String id, String name, Connectable source, Connectable destination, Collection<String> relationshipNames) {
        StandardConnection.Builder builder = new StandardConnection.Builder(this.processScheduler);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (String relationshipName : Objects.requireNonNull(relationshipNames)) {
            relationships.add(new Relationship.Builder().name(relationshipName).build());
        }
        return builder.id(Objects.requireNonNull(id).intern()).name(name == null ? null : name.intern()).relationships(relationships).source(Objects.requireNonNull(source)).destination(destination).build();
    }

    public Label createLabel(String id, String text) {
        return new StandardLabel(Objects.requireNonNull(id).intern(), text);
    }

    public Funnel createFunnel(String id) {
        return new StandardFunnel(id.intern(), null, (ProcessScheduler)this.processScheduler);
    }

    public Port createLocalInputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new LocalPort(id, name, null, ConnectableType.INPUT_PORT, this.processScheduler);
    }

    public Port createLocalOutputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new LocalPort(id, name, null, ConnectableType.OUTPUT_PORT, this.processScheduler);
    }

    public ProcessGroup createProcessGroup(String id) {
        return new StandardProcessGroup(Objects.requireNonNull(id).intern(), this, this.processScheduler, this.properties, this.encryptor);
    }

    public ProcessorNode createProcessor(String type, String id) throws ProcessorInstantiationException {
        return this.createProcessor(type, id, true);
    }

    public ProcessorNode createProcessor(String type, String id, boolean firstTimeAdded) throws ProcessorInstantiationException {
        id = id.intern();
        Processor processor = this.instantiateProcessor(type, id);
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.controllerServiceProvider);
        StandardProcessorNode procNode = new StandardProcessorNode(processor, id, validationContextFactory, this.processScheduler, this.controllerServiceProvider);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ProcessorLogObserver(this.getBulletinRepository(), procNode));
        if (firstTimeAdded) {
            try (NarCloseable x = NarCloseable.withNarLoader();){
                ReflectionUtils.invokeMethodsWithAnnotations(org.apache.nifi.annotation.lifecycle.OnAdded.class, OnAdded.class, processor, new Object[0]);
            }
            catch (Exception e) {
                logRepository.removeObserver("bulletin-observer");
                throw new ComponentLifeCycleException("Failed to invoke @OnAdded methods of " + procNode.getProcessor(), (Throwable)e);
            }
        }
        return procNode;
    }

    private Processor instantiateProcessor(String type, String identifier) throws ProcessorInstantiationException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader detectedClassLoaderForType = ExtensionManager.getClassLoader((String)type);
            Class<?> rawClass = detectedClassLoaderForType == null ? Class.forName(type) : Class.forName(type, true, ExtensionManager.getClassLoader((String)type));
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<Processor> processorClass = rawClass.asSubclass(Processor.class);
            Processor processor = processorClass.newInstance();
            SimpleProcessLogger processorLogger = new SimpleProcessLogger(identifier, processor);
            StandardProcessorInitializationContext ctx = new StandardProcessorInitializationContext(identifier, processorLogger, this);
            processor.initialize((ProcessorInitializationContext)ctx);
            Processor processor2 = processor;
            return processor2;
        }
        catch (Throwable t) {
            throw new ProcessorInstantiationException(type, t);
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getInstanceId() {
        this.readLock.lock();
        try {
            String string = this.instanceId;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    public SnippetManager getSnippetManager() {
        return this.snippetManager;
    }

    public Port createRemoteInputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new StandardRootGroupPort(id, name, null, TransferDirection.RECEIVE, ConnectableType.INPUT_PORT, this.userService, this.getBulletinRepository(), (ProcessScheduler)this.processScheduler, Boolean.TRUE.equals(this.isSiteToSiteSecure));
    }

    public Port createRemoteOutputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new StandardRootGroupPort(id, name, null, TransferDirection.SEND, ConnectableType.OUTPUT_PORT, this.userService, this.getBulletinRepository(), (ProcessScheduler)this.processScheduler, Boolean.TRUE.equals(this.isSiteToSiteSecure));
    }

    public RemoteProcessGroup createRemoteProcessGroup(String id, String uri) {
        return new StandardRemoteProcessGroup(Objects.requireNonNull(id).intern(), Objects.requireNonNull(uri).intern(), null, this, this.sslContext);
    }

    private void verifyPortIdDoesNotExist(String id) {
        Port port = this.rootGroup.findOutputPort(id);
        if (port != null) {
            throw new IllegalStateException("An Input Port already exists with ID " + id);
        }
        port = this.rootGroup.findInputPort(id);
        if (port != null) {
            throw new IllegalStateException("An Input Port already exists with ID " + id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        this.readLock.lock();
        try {
            String string = this.rootGroup.getName();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        this.readLock.lock();
        try {
            this.rootGroup.setName(name);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComments() {
        this.readLock.lock();
        try {
            String string = this.rootGroup.getComments();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComments(String comments) {
        this.readLock.lock();
        try {
            this.rootGroup.setComments(comments);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTerminated() {
        this.readLock.lock();
        try {
            boolean bl = null == this.timerDrivenEngineRef.get() || this.timerDrivenEngineRef.get().isTerminated();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean kill) {
        this.shutdown = true;
        this.stopAllProcessors();
        this.writeLock.lock();
        try {
            if (this.isTerminated() || this.timerDrivenEngineRef.get().isTerminating()) {
                throw new IllegalStateException("Controller already stopped or still stopping...");
            }
            if (kill) {
                this.timerDrivenEngineRef.get().shutdownNow();
                this.eventDrivenEngineRef.get().shutdownNow();
                LOG.info("Initiated immediate shutdown of flow controller...");
            } else {
                this.timerDrivenEngineRef.get().shutdown();
                this.eventDrivenEngineRef.get().shutdown();
                LOG.info("Initiated graceful shutdown of flow controller...waiting up to " + this.gracefulShutdownSeconds + " seconds");
            }
            this.clusterTaskExecutor.shutdown();
            this.rootGroup.shutdown();
            for (ControllerServiceNode serviceNode : this.getAllControllerServices()) {
                NarCloseable narCloseable = NarCloseable.withNarLoader();
                Throwable throwable = null;
                try {
                    StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)serviceNode, (ControllerServiceLookup)this.controllerServiceProvider, null);
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)serviceNode.getControllerServiceImplementation(), configContext);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (narCloseable == null) continue;
                    if (throwable != null) {
                        try {
                            narCloseable.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    narCloseable.close();
                }
            }
            for (ReportingTaskNode taskNode : this.getAllReportingTasks()) {
                ConfigurationContext configContext = taskNode.getConfigurationContext();
                NarCloseable narCloseable = NarCloseable.withNarLoader();
                Throwable throwable = null;
                try {
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)taskNode.getReportingTask(), configContext);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (narCloseable == null) continue;
                    if (throwable != null) {
                        try {
                            narCloseable.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    narCloseable.close();
                }
            }
            try {
                this.timerDrivenEngineRef.get().awaitTermination(this.gracefulShutdownSeconds / 2L, TimeUnit.SECONDS);
                this.eventDrivenEngineRef.get().awaitTermination(this.gracefulShutdownSeconds / 2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                LOG.info("Interrupted while waiting for controller termination.");
            }
            try {
                this.flowFileRepository.close();
            }
            catch (Throwable t) {
                LOG.warn("Unable to shut down FlowFileRepository due to {}", new Object[]{t});
            }
            if (this.timerDrivenEngineRef.get().isTerminated() && this.eventDrivenEngineRef.get().isTerminated()) {
                LOG.info("Controller has been terminated successfully.");
            } else {
                LOG.warn("Controller hasn't terminated properly.  There exists an uninterruptable thread that will take an indeterminate amount of time to stop.  Might need to kill the program manually.");
            }
            if (this.externalSiteListener != null) {
                this.externalSiteListener.stop();
            }
            if (this.flowFileSwapManager != null) {
                this.flowFileSwapManager.shutdown();
            }
            if (this.processScheduler != null) {
                this.processScheduler.shutdown();
            }
            if (this.contentRepository != null) {
                this.contentRepository.shutdown();
            }
            if (this.provenanceEventRepository != null) {
                try {
                    this.provenanceEventRepository.close();
                }
                catch (IOException ioe) {
                    LOG.warn("There was a problem shutting down the Provenance Repository: " + ioe.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("", (Throwable)ioe);
                    }
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(FlowSerializer serializer, OutputStream os) throws FlowSerializationException {
        this.readLock.lock();
        try {
            serializer.serialize(this, os);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize(FlowSynchronizer synchronizer, DataFlow dataFlow) throws FlowSerializationException, FlowSynchronizationException, UninheritableFlowException {
        this.writeLock.lock();
        try {
            LOG.debug("Synchronizing controller with proposed flow");
            synchronizer.sync(this, dataFlow, this.encryptor);
            LOG.info("Successfully synchronized controller with proposed flow");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getMaxTimerDrivenThreadCount() {
        return this.maxTimerDrivenThreads.get();
    }

    public int getMaxEventDrivenThreadCount() {
        return this.maxEventDrivenThreads.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTimerDrivenThreadCount(int maxThreadCount) {
        this.writeLock.lock();
        try {
            this.setMaxThreadCount(maxThreadCount, this.timerDrivenEngineRef.get(), this.maxTimerDrivenThreads);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxEventDrivenThreadCount(int maxThreadCount) {
        this.writeLock.lock();
        try {
            this.setMaxThreadCount(maxThreadCount, this.eventDrivenEngineRef.get(), this.maxEventDrivenThreads);
            this.processScheduler.setMaxThreadCount(SchedulingStrategy.EVENT_DRIVEN, maxThreadCount);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void setMaxThreadCount(int maxThreadCount, FlowEngine engine, AtomicInteger maxThreads) {
        if (maxThreadCount < 1) {
            throw new IllegalArgumentException();
        }
        maxThreads.getAndSet(maxThreadCount);
        if (null != engine && engine.getCorePoolSize() < maxThreadCount) {
            engine.setCorePoolSize(maxThreads.intValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRootGroupId() {
        this.readLock.lock();
        try {
            String string = this.rootGroup.getIdentifier();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRootGroup(ProcessGroup group) {
        if (Objects.requireNonNull(group).getParent() != null) {
            throw new IllegalArgumentException("A ProcessGroup that has a parent cannot be the Root Group");
        }
        this.writeLock.lock();
        try {
            this.rootGroup = group;
            if (this.externalSiteListener != null) {
                this.externalSiteListener.setRootGroup(group);
            }
            this.heartbeatBeanRef.set(new HeartbeatBean(this.rootGroup, this.primary, this.connected));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public SystemDiagnostics getSystemDiagnostics() {
        SystemDiagnosticsFactory factory = new SystemDiagnosticsFactory();
        return factory.create(this.flowFileRepository, this.contentRepository);
    }

    public void updateProcessGroup(ProcessGroupDTO dto) throws ProcessorInstantiationException {
        ProcessGroup group = this.lookupGroup(Objects.requireNonNull(dto).getId());
        String name = dto.getName();
        PositionDTO position = dto.getPosition();
        String comments = dto.getComments();
        if (name != null) {
            group.setName(name);
        }
        if (position != null) {
            group.setPosition(this.toPosition(position));
        }
        if (comments != null) {
            group.setComments(comments);
        }
    }

    public Template addTemplate(TemplateDTO dto) throws IOException {
        return this.templateManager.addTemplate(dto);
    }

    public void clearTemplates() throws IOException {
        this.templateManager.clear();
    }

    public Template importTemplate(TemplateDTO dto) throws IOException {
        return this.templateManager.importTemplate(dto);
    }

    public Template getTemplate(String id) {
        return this.templateManager.getTemplate(id);
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public Collection<Template> getTemplates() {
        return this.templateManager.getTemplates();
    }

    public void removeTemplate(String id) throws IOException, IllegalStateException {
        this.templateManager.removeTemplate(id);
    }

    private Position toPosition(PositionDTO dto) {
        return new Position(dto.getX().doubleValue(), dto.getY().doubleValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void instantiateSnippet(ProcessGroup group, FlowSnippetDTO dto) throws ProcessorInstantiationException {
        this.writeLock.lock();
        try {
            RemoteProcessGroupContentsDTO contents;
            this.validateSnippetContents(Objects.requireNonNull(group), dto);
            for (ControllerServiceDTO controllerServiceDTO : dto.getControllerServices()) {
                ControllerServiceNode serviceNode = this.createControllerService(controllerServiceDTO.getType(), controllerServiceDTO.getId(), true);
                serviceNode.setAnnotationData(controllerServiceDTO.getAnnotationData());
                serviceNode.setComments(controllerServiceDTO.getComments());
                serviceNode.setName(controllerServiceDTO.getName());
            }
            for (ControllerServiceDTO controllerServiceDTO : dto.getControllerServices()) {
                String serviceId = controllerServiceDTO.getId();
                ControllerServiceNode serviceNode = this.getControllerServiceNode(serviceId);
                for (Map.Entry entry : controllerServiceDTO.getProperties().entrySet()) {
                    if (entry.getValue() == null) continue;
                    serviceNode.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            for (LabelDTO labelDTO : dto.getLabels()) {
                Label label = this.createLabel(labelDTO.getId(), labelDTO.getLabel());
                label.setPosition(this.toPosition(labelDTO.getPosition()));
                if (labelDTO.getWidth() != null && labelDTO.getHeight() != null) {
                    label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
                }
                label.setStyle(labelDTO.getStyle());
                group.addLabel(label);
            }
            for (FunnelDTO funnelDTO : dto.getFunnels()) {
                Funnel funnel = this.createFunnel(funnelDTO.getId());
                funnel.setPosition(this.toPosition(funnelDTO.getPosition()));
                group.addFunnel(funnel);
            }
            for (PortDTO portDTO : dto.getInputPorts()) {
                Port inputPort;
                if (group.isRootGroup()) {
                    inputPort = this.createRemoteInputPort(portDTO.getId(), portDTO.getName());
                    inputPort.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
                    if (portDTO.getGroupAccessControl() != null) {
                        ((RootGroupPort)inputPort).setGroupAccessControl(portDTO.getGroupAccessControl());
                    }
                    if (portDTO.getUserAccessControl() != null) {
                        ((RootGroupPort)inputPort).setUserAccessControl(portDTO.getUserAccessControl());
                    }
                } else {
                    inputPort = this.createLocalInputPort(portDTO.getId(), portDTO.getName());
                }
                inputPort.setPosition(this.toPosition(portDTO.getPosition()));
                inputPort.setProcessGroup(group);
                inputPort.setComments(portDTO.getComments());
                group.addInputPort(inputPort);
            }
            for (PortDTO portDTO : dto.getOutputPorts()) {
                Port outputPort;
                if (group.isRootGroup()) {
                    outputPort = this.createRemoteOutputPort(portDTO.getId(), portDTO.getName());
                    outputPort.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
                    if (portDTO.getGroupAccessControl() != null) {
                        ((RootGroupPort)outputPort).setGroupAccessControl(portDTO.getGroupAccessControl());
                    }
                    if (portDTO.getUserAccessControl() != null) {
                        ((RootGroupPort)outputPort).setUserAccessControl(portDTO.getUserAccessControl());
                    }
                } else {
                    outputPort = this.createLocalOutputPort(portDTO.getId(), portDTO.getName());
                }
                outputPort.setPosition(this.toPosition(portDTO.getPosition()));
                outputPort.setProcessGroup(group);
                outputPort.setComments(portDTO.getComments());
                group.addOutputPort(outputPort);
            }
            for (ProcessorDTO processorDTO : dto.getProcessors()) {
                ProcessorNode procNode = this.createProcessor(processorDTO.getType(), processorDTO.getId());
                procNode.setPosition(this.toPosition(processorDTO.getPosition()));
                procNode.setProcessGroup(group);
                ProcessorConfigDTO config = processorDTO.getConfig();
                procNode.setComments(config.getComments());
                if (config.isLossTolerant() != null) {
                    procNode.setLossTolerant(config.isLossTolerant().booleanValue());
                }
                procNode.setName(processorDTO.getName());
                procNode.setYieldPeriod(config.getYieldDuration());
                procNode.setPenalizationPeriod(config.getPenaltyDuration());
                procNode.setBulletinLevel(LogLevel.valueOf((String)config.getBulletinLevel()));
                procNode.setAnnotationData(config.getAnnotationData());
                procNode.setStyle(processorDTO.getStyle());
                if (config.getRunDurationMillis() != null) {
                    procNode.setRunDuration(config.getRunDurationMillis().longValue(), TimeUnit.MILLISECONDS);
                }
                if (config.getSchedulingStrategy() != null) {
                    procNode.setSchedulingStrategy(SchedulingStrategy.valueOf((String)config.getSchedulingStrategy()));
                }
                procNode.setMaxConcurrentTasks(config.getConcurrentlySchedulableTaskCount().intValue());
                procNode.setScheduldingPeriod(config.getSchedulingPeriod());
                HashSet<Relationship> relationships = new HashSet<Relationship>();
                if (processorDTO.getRelationships() != null) {
                    for (RelationshipDTO relationshipDTO : processorDTO.getRelationships()) {
                        if (!relationshipDTO.isAutoTerminate().booleanValue()) continue;
                        relationships.add(procNode.getRelationship(relationshipDTO.getName()));
                    }
                    procNode.setAutoTerminatedRelationships(relationships);
                }
                if (config.getProperties() != null) {
                    for (Map.Entry entry : config.getProperties().entrySet()) {
                        if (entry.getValue() == null) continue;
                        procNode.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                group.addProcessor(procNode);
            }
            for (RemoteProcessGroupDTO remoteGroupDTO : dto.getRemoteProcessGroups()) {
                RemoteProcessGroup remoteGroup = this.createRemoteProcessGroup(remoteGroupDTO.getId(), remoteGroupDTO.getTargetUri());
                remoteGroup.setComments(remoteGroupDTO.getComments());
                remoteGroup.setPosition(this.toPosition(remoteGroupDTO.getPosition()));
                remoteGroup.setCommunicationsTimeout(remoteGroupDTO.getCommunicationsTimeout());
                remoteGroup.setYieldDuration(remoteGroupDTO.getYieldDuration());
                remoteGroup.setProcessGroup(group);
                if (remoteGroupDTO.getContents() != null) {
                    contents = remoteGroupDTO.getContents();
                    if (contents.getInputPorts() != null) {
                        remoteGroup.setInputPorts(this.convertRemotePort(contents.getInputPorts()));
                    }
                    if (contents.getOutputPorts() != null) {
                        remoteGroup.setOutputPorts(this.convertRemotePort(contents.getOutputPorts()));
                    }
                }
                group.addRemoteProcessGroup(remoteGroup);
            }
            for (ProcessGroupDTO groupDTO : dto.getProcessGroups()) {
                ProcessGroup childGroup = this.createProcessGroup(groupDTO.getId());
                childGroup.setParent(group);
                childGroup.setPosition(this.toPosition(groupDTO.getPosition()));
                childGroup.setComments(groupDTO.getComments());
                childGroup.setName(groupDTO.getName());
                group.addProcessGroup(childGroup);
                contents = groupDTO.getContents();
                FlowSnippetDTO childTemplateDTO = new FlowSnippetDTO();
                childTemplateDTO.setConnections(contents.getConnections());
                childTemplateDTO.setInputPorts(contents.getInputPorts());
                childTemplateDTO.setLabels(contents.getLabels());
                childTemplateDTO.setOutputPorts(contents.getOutputPorts());
                childTemplateDTO.setProcessGroups(contents.getProcessGroups());
                childTemplateDTO.setProcessors(contents.getProcessors());
                childTemplateDTO.setFunnels(contents.getFunnels());
                childTemplateDTO.setRemoteProcessGroups(contents.getRemoteProcessGroups());
                this.instantiateSnippet(childGroup, childTemplateDTO);
            }
            for (ConnectionDTO connectionDTO : dto.getConnections()) {
                RemoteGroupPort destination;
                RemoteGroupPort source;
                ConnectableDTO sourceDTO = connectionDTO.getSource();
                ConnectableDTO destinationDTO = connectionDTO.getDestination();
                if (ConnectableType.REMOTE_OUTPUT_PORT.name().equals(sourceDTO.getType())) {
                    RemoteProcessGroup remoteProcessGroup = group.getRemoteProcessGroup(sourceDTO.getGroupId());
                    source = remoteProcessGroup.getOutputPort(sourceDTO.getId());
                } else {
                    ProcessGroup processGroup = this.getConnectableParent(group, sourceDTO.getGroupId());
                    source = processGroup.getConnectable(sourceDTO.getId());
                }
                if (ConnectableType.REMOTE_INPUT_PORT.name().equals(destinationDTO.getType())) {
                    RemoteProcessGroup remoteProcessGroup = group.getRemoteProcessGroup(destinationDTO.getGroupId());
                    destination = remoteProcessGroup.getInputPort(destinationDTO.getId());
                } else {
                    ProcessGroup processGroup = this.getConnectableParent(group, destinationDTO.getGroupId());
                    destination = processGroup.getConnectable(destinationDTO.getId());
                }
                HashSet<String> hashSet = new HashSet<String>();
                if (connectionDTO.getSelectedRelationships() != null) {
                    hashSet.addAll(connectionDTO.getSelectedRelationships());
                }
                Connection connection = this.createConnection(connectionDTO.getId(), connectionDTO.getName(), (Connectable)source, (Connectable)destination, hashSet);
                if (connectionDTO.getBends() != null) {
                    ArrayList<Position> bendPoints = new ArrayList<Position>();
                    for (PositionDTO bend : connectionDTO.getBends()) {
                        bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
                    }
                    connection.setBendPoints(bendPoints);
                }
                FlowFileQueue queue = connection.getFlowFileQueue();
                queue.setBackPressureDataSizeThreshold(connectionDTO.getBackPressureDataSizeThreshold());
                queue.setBackPressureObjectThreshold(connectionDTO.getBackPressureObjectThreshold().longValue());
                queue.setFlowFileExpiration(connectionDTO.getFlowFileExpiration());
                List prioritizers = connectionDTO.getPrioritizers();
                if (prioritizers != null) {
                    ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                    ArrayList<FlowFilePrioritizer> newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                    for (String className : newPrioritizersClasses) {
                        try {
                            newPrioritizers.add(this.createPrioritizer(className));
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                            throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                        }
                    }
                    queue.setPriorities(newPrioritizers);
                }
                connection.setProcessGroup(group);
                group.addConnection(connection);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<RemoteProcessGroupPortDescriptor> convertRemotePort(Set<RemoteProcessGroupPortDTO> ports) {
        LinkedHashSet<StandardRemoteProcessGroupPortDescriptor> remotePorts = null;
        if (ports != null) {
            remotePorts = new LinkedHashSet<StandardRemoteProcessGroupPortDescriptor>(ports.size());
            for (RemoteProcessGroupPortDTO port : ports) {
                StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
                descriptor.setId(port.getId());
                descriptor.setName(port.getName());
                descriptor.setComments(port.getComments());
                descriptor.setTargetRunning(port.isTargetRunning());
                descriptor.setConnected(port.isConnected());
                descriptor.setConcurrentlySchedulableTaskCount(port.getConcurrentlySchedulableTaskCount());
                descriptor.setTransmitting(port.isTransmitting());
                descriptor.setUseCompression(port.getUseCompression());
                remotePorts.add(descriptor);
            }
        }
        return remotePorts;
    }

    private ProcessGroup getConnectableParent(ProcessGroup group, String parentGroupId) {
        if (this.areGroupsSame(group.getIdentifier(), parentGroupId)) {
            return group;
        }
        return group.getProcessGroup(parentGroupId);
    }

    private void validateSnippetContents(ProcessGroup group, FlowSnippetDTO templateContents) {
        for (PortDTO port : templateContents.getInputPorts()) {
            if (group.getInputPortByName(port.getName()) == null) continue;
            throw new IllegalStateException("ProcessGroup already has an Input Port with name " + port.getName());
        }
        for (PortDTO port : templateContents.getOutputPorts()) {
            if (group.getOutputPortByName(port.getName()) == null) continue;
            throw new IllegalStateException("ProcessGroup already has an Output Port with name " + port.getName());
        }
        HashSet<String> processorClasses = new HashSet<String>();
        for (Class c : ExtensionManager.getExtensions(Processor.class)) {
            processorClasses.add(c.getName());
        }
        HashSet<String> prioritizerClasses = new HashSet<String>();
        for (Class c : ExtensionManager.getExtensions(FlowFilePrioritizer.class)) {
            prioritizerClasses.add(c.getName());
        }
        HashSet<String> controllerServiceClasses = new HashSet<String>();
        for (Class c : ExtensionManager.getExtensions(ControllerService.class)) {
            controllerServiceClasses.add(c.getName());
        }
        HashSet<ProcessorDTO> allProcs = new HashSet<ProcessorDTO>();
        HashSet<ConnectionDTO> allConns = new HashSet<ConnectionDTO>();
        allProcs.addAll(templateContents.getProcessors());
        allConns.addAll(templateContents.getConnections());
        for (ProcessGroupDTO childGroup : templateContents.getProcessGroups()) {
            allProcs.addAll(this.findAllProcessors(childGroup));
            allConns.addAll(this.findAllConnections(childGroup));
        }
        for (ProcessorDTO proc : allProcs) {
            if (processorClasses.contains(proc.getType())) continue;
            throw new IllegalStateException("Invalid Processor Type: " + proc.getType());
        }
        Set controllerServices = templateContents.getControllerServices();
        if (controllerServices != null) {
            for (ControllerServiceDTO service : controllerServices) {
                if (controllerServiceClasses.contains(service.getType())) continue;
                throw new IllegalStateException("Invalid Controller Service Type: " + service.getType());
            }
        }
        for (ConnectionDTO conn : allConns) {
            List prioritizers = conn.getPrioritizers();
            if (prioritizers == null) continue;
            for (String prioritizer : prioritizers) {
                if (prioritizerClasses.contains(prioritizer)) continue;
                throw new IllegalStateException("Invalid FlowFile Prioritizer Type: " + prioritizer);
            }
        }
    }

    private Set<ProcessorDTO> findAllProcessors(ProcessGroupDTO group) {
        HashSet<ProcessorDTO> procs = new HashSet<ProcessorDTO>();
        for (ProcessorDTO dto : group.getContents().getProcessors()) {
            procs.add(dto);
        }
        for (ProcessGroupDTO childGroup : group.getContents().getProcessGroups()) {
            procs.addAll(this.findAllProcessors(childGroup));
        }
        return procs;
    }

    private Set<ConnectionDTO> findAllConnections(ProcessGroupDTO group) {
        HashSet<ConnectionDTO> conns = new HashSet<ConnectionDTO>();
        for (ConnectionDTO dto : group.getContents().getConnections()) {
            conns.add(dto);
        }
        for (ProcessGroupDTO childGroup : group.getContents().getProcessGroups()) {
            conns.addAll(this.findAllConnections(childGroup));
        }
        return conns;
    }

    public boolean areGroupsSame(String id1, String id2) {
        if (id1 == null || id2 == null) {
            return false;
        }
        if (id1.equals(id2)) {
            return true;
        }
        String comparable1 = id1.equals(ROOT_GROUP_ID_ALIAS) ? this.getRootGroupId() : id1;
        String comparable2 = id2.equals(ROOT_GROUP_ID_ALIAS) ? this.getRootGroupId() : id2;
        return comparable1.equals(comparable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowFilePrioritizer createPrioritizer(String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            FlowFilePrioritizer prioritizer;
            ClassLoader detectedClassLoaderForType = ExtensionManager.getClassLoader((String)type);
            Class<?> rawClass = detectedClassLoaderForType == null ? Class.forName(type) : Class.forName(type, true, ExtensionManager.getClassLoader((String)type));
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<FlowFilePrioritizer> prioritizerClass = rawClass.asSubclass(FlowFilePrioritizer.class);
            FlowFilePrioritizer processorObj = prioritizerClass.newInstance();
            FlowFilePrioritizer flowFilePrioritizer = prioritizer = prioritizerClass.cast(processorObj);
            return flowFilePrioritizer;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    public PortDTO updateInputPort(String parentGroupId, PortDTO dto) {
        ProcessGroup parentGroup = this.lookupGroup(parentGroupId);
        Port port = parentGroup.getInputPort(dto.getId());
        if (port == null) {
            throw new IllegalStateException("No Input Port with ID " + dto.getId() + " is known as a child of ProcessGroup with ID " + parentGroupId);
        }
        String name = dto.getName();
        if (dto.getPosition() != null) {
            port.setPosition(this.toPosition(dto.getPosition()));
        }
        if (name != null) {
            port.setName(name);
        }
        return this.createDTO(port);
    }

    private PortDTO createDTO(Port port) {
        if (port == null) {
            return null;
        }
        PortDTO dto = new PortDTO();
        dto.setId(port.getIdentifier());
        dto.setPosition(new PositionDTO(Double.valueOf(port.getPosition().getX()), Double.valueOf(port.getPosition().getY())));
        dto.setName(port.getName());
        dto.setParentGroupId(port.getProcessGroup().getIdentifier());
        return dto;
    }

    public PortDTO updateOutputPort(String parentGroupId, PortDTO dto) {
        ProcessGroup parentGroup = this.lookupGroup(parentGroupId);
        Port port = parentGroup.getOutputPort(dto.getId());
        if (port == null) {
            throw new IllegalStateException("No Output Port with ID " + dto.getId() + " is known as a child of ProcessGroup with ID " + parentGroupId);
        }
        String name = dto.getName();
        if (name != null) {
            port.setName(name);
        }
        if (dto.getPosition() != null) {
            port.setPosition(this.toPosition(dto.getPosition()));
        }
        return this.createDTO(port);
    }

    public Set<Class> getFlowFileProcessorClasses() {
        return ExtensionManager.getExtensions(Processor.class);
    }

    public Set<Class> getFlowFileComparatorClasses() {
        return ExtensionManager.getExtensions(FlowFilePrioritizer.class);
    }

    private ProcessGroup lookupGroup(String id) {
        ProcessGroup group = this.getGroup(id);
        if (group == null) {
            throw new IllegalStateException("No Group with ID " + id + " exists");
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessGroup getGroup(String id) {
        ProcessGroup root;
        Objects.requireNonNull(id);
        this.readLock.lock();
        try {
            root = this.rootGroup;
        }
        finally {
            this.readLock.unlock();
        }
        String searchId = id.equals(ROOT_GROUP_ID_ALIAS) ? this.getRootGroupId() : id;
        return root == null ? null : root.findProcessGroup(searchId);
    }

    public ProcessGroupStatus getControllerStatus() {
        return this.getGroupStatus(this.getRootGroupId());
    }

    public ProcessGroupStatus getGroupStatus(String groupId) {
        return this.getGroupStatus(groupId, this.getProcessorStats());
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport) {
        ProcessGroup group = this.getGroup(groupId);
        return this.getGroupStatus(group, statusReport);
    }

    public ProcessGroupStatus getGroupStatus(ProcessGroup group, RepositoryStatusReport statusReport) {
        if (group == null) {
            return null;
        }
        ProcessGroupStatus status = new ProcessGroupStatus();
        status.setId(group.getIdentifier());
        status.setName(group.getName());
        status.setCreationTimestamp(new Date().getTime());
        int activeGroupThreads = 0;
        long bytesRead = 0L;
        long bytesWritten = 0L;
        int queuedCount = 0;
        long queuedContentSize = 0L;
        int flowFilesIn = 0;
        long bytesIn = 0L;
        int flowFilesOut = 0;
        long bytesOut = 0L;
        int flowFilesReceived = 0;
        long bytesReceived = 0L;
        int flowFilesSent = 0;
        long bytesSent = 0L;
        int flowFilesTransferred = 0;
        long bytesTransferred = 0L;
        ArrayList<ProcessorStatus> processorStatusCollection = new ArrayList<ProcessorStatus>();
        status.setProcessorStatus(processorStatusCollection);
        for (ProcessorNode procNode : group.getProcessors()) {
            ProcessorStatus procStat = this.getProcessorStatus(statusReport, procNode);
            processorStatusCollection.add(procStat);
            activeGroupThreads += procStat.getActiveThreadCount();
            bytesRead += procStat.getBytesRead();
            bytesWritten += procStat.getBytesWritten();
            flowFilesReceived += procStat.getFlowFilesReceived();
            bytesReceived += procStat.getBytesReceived();
            flowFilesSent += procStat.getFlowFilesSent();
            bytesSent += procStat.getBytesSent();
        }
        ArrayList<ProcessGroupStatus> localChildGroupStatusCollection = new ArrayList<ProcessGroupStatus>();
        status.setProcessGroupStatus(localChildGroupStatusCollection);
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            ProcessGroupStatus childGroupStatus = this.getGroupStatus(childGroup, statusReport);
            localChildGroupStatusCollection.add(childGroupStatus);
            activeGroupThreads += childGroupStatus.getActiveThreadCount().intValue();
            bytesRead += childGroupStatus.getBytesRead().longValue();
            bytesWritten += childGroupStatus.getBytesWritten().longValue();
            queuedCount += childGroupStatus.getQueuedCount().intValue();
            queuedContentSize += childGroupStatus.getQueuedContentSize().longValue();
            flowFilesReceived += childGroupStatus.getFlowFilesReceived();
            bytesReceived += childGroupStatus.getBytesReceived();
            flowFilesSent += childGroupStatus.getFlowFilesSent();
            bytesSent += childGroupStatus.getBytesSent();
            flowFilesTransferred += childGroupStatus.getFlowFilesTransferred();
            bytesTransferred += childGroupStatus.getBytesTransferred();
        }
        ArrayList<RemoteProcessGroupStatus> remoteProcessGroupStatusCollection = new ArrayList<RemoteProcessGroupStatus>();
        status.setRemoteProcessGroupStatus(remoteProcessGroupStatusCollection);
        for (RemoteProcessGroup remoteGroup : group.getRemoteProcessGroups()) {
            RemoteProcessGroupStatus remoteStatus = this.createRemoteGroupStatus(remoteGroup, statusReport);
            if (remoteStatus == null) continue;
            remoteProcessGroupStatusCollection.add(remoteStatus);
            flowFilesReceived += remoteStatus.getReceivedCount().intValue();
            bytesReceived += remoteStatus.getReceivedContentSize().longValue();
            flowFilesSent += remoteStatus.getSentCount().intValue();
            bytesSent += remoteStatus.getSentContentSize().longValue();
        }
        ArrayList<ConnectionStatus> connectionStatusCollection = new ArrayList<ConnectionStatus>();
        status.setConnectionStatus(connectionStatusCollection);
        for (Connection conn : group.getConnections()) {
            Connectable destination;
            ConnectionStatus connStatus = new ConnectionStatus();
            connStatus.setId(conn.getIdentifier());
            connStatus.setGroupId(conn.getProcessGroup().getIdentifier());
            connStatus.setSourceId(conn.getSource().getIdentifier());
            connStatus.setSourceName(conn.getSource().getName());
            connStatus.setDestinationId(conn.getDestination().getIdentifier());
            connStatus.setDestinationName(conn.getDestination().getName());
            FlowFileEvent connectionStatusReport = statusReport.getReportEntry(conn.getIdentifier());
            if (connectionStatusReport != null) {
                connStatus.setInputBytes(connectionStatusReport.getContentSizeIn());
                connStatus.setInputCount(connectionStatusReport.getFlowFilesIn());
                connStatus.setOutputBytes(connectionStatusReport.getContentSizeOut());
                connStatus.setOutputCount(connectionStatusReport.getFlowFilesOut());
                flowFilesTransferred += connectionStatusReport.getFlowFilesIn() + connectionStatusReport.getFlowFilesOut();
                bytesTransferred += connectionStatusReport.getContentSizeIn() + connectionStatusReport.getContentSizeOut();
            }
            if (StringUtils.isNotBlank((CharSequence)conn.getName())) {
                connStatus.setName(conn.getName());
            } else if (conn.getRelationships() != null && !conn.getRelationships().isEmpty()) {
                ArrayList<String> relationships = new ArrayList<String>(conn.getRelationships().size());
                for (Relationship relationship : conn.getRelationships()) {
                    relationships.add(relationship.getName());
                }
                connStatus.setName(StringUtils.join(relationships, (String)", "));
            }
            QueueSize queueSize = conn.getFlowFileQueue().size();
            int connectionQueuedCount = queueSize.getObjectCount();
            long connectionQueuedBytes = queueSize.getByteCount();
            if (connectionQueuedCount > 0) {
                connStatus.setQueuedBytes(connectionQueuedBytes);
                connStatus.setQueuedCount(connectionQueuedCount);
            }
            connectionStatusCollection.add(connStatus);
            queuedCount += connectionQueuedCount;
            queuedContentSize += connectionQueuedBytes;
            Connectable source = conn.getSource();
            if (ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)source.getConnectableType())) {
                RemoteGroupPort remoteOutputPort = (RemoteGroupPort)source;
                activeGroupThreads += this.processScheduler.getActiveThreadCount(remoteOutputPort);
            }
            if (!ConnectableType.REMOTE_INPUT_PORT.equals((Object)(destination = conn.getDestination()).getConnectableType())) continue;
            RemoteGroupPort remoteInputPort = (RemoteGroupPort)destination;
            activeGroupThreads += this.processScheduler.getActiveThreadCount(remoteInputPort);
        }
        ArrayList<PortStatus> inputPortStatusCollection = new ArrayList<PortStatus>();
        status.setInputPortStatus(inputPortStatusCollection);
        Set inputPorts = group.getInputPorts();
        for (Port port : inputPorts) {
            FlowFileEvent entry;
            PortStatus portStatus = new PortStatus();
            portStatus.setId(port.getIdentifier());
            portStatus.setGroupId(port.getProcessGroup().getIdentifier());
            portStatus.setName(port.getName());
            portStatus.setActiveThreadCount(Integer.valueOf(this.processScheduler.getActiveThreadCount(port)));
            if (ScheduledState.RUNNING.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Running);
            } else if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Disabled);
            } else if (!port.isValid()) {
                portStatus.setRunStatus(RunStatus.Invalid);
            } else {
                portStatus.setRunStatus(RunStatus.Stopped);
            }
            if (port instanceof RootGroupPort) {
                RootGroupPort rootGroupPort = (RootGroupPort)port;
                portStatus.setTransmitting(Boolean.valueOf(rootGroupPort.isTransmitting()));
            }
            if ((entry = (FlowFileEvent)statusReport.getReportEntries().get(port.getIdentifier())) == null) {
                portStatus.setInputBytes(0L);
                portStatus.setInputCount(0);
                portStatus.setOutputBytes(0L);
                portStatus.setOutputCount(0);
            } else {
                int processedCount = entry.getFlowFilesOut();
                long numProcessedBytes = entry.getContentSizeOut();
                portStatus.setOutputBytes(numProcessedBytes);
                portStatus.setOutputCount(processedCount);
                int inputCount = entry.getFlowFilesIn();
                long inputBytes = entry.getContentSizeIn();
                portStatus.setInputBytes(inputBytes);
                portStatus.setInputCount(inputCount);
                flowFilesIn += inputCount;
                bytesIn += inputBytes;
                bytesWritten += entry.getBytesWritten();
                flowFilesReceived += entry.getFlowFilesReceived();
                bytesReceived += entry.getBytesReceived();
            }
            inputPortStatusCollection.add(portStatus);
            activeGroupThreads += portStatus.getActiveThreadCount().intValue();
        }
        ArrayList<PortStatus> outputPortStatusCollection = new ArrayList<PortStatus>();
        status.setOutputPortStatus(outputPortStatusCollection);
        Set outputPorts = group.getOutputPorts();
        for (Port port : outputPorts) {
            FlowFileEvent entry;
            PortStatus portStatus = new PortStatus();
            portStatus.setId(port.getIdentifier());
            portStatus.setGroupId(port.getProcessGroup().getIdentifier());
            portStatus.setName(port.getName());
            portStatus.setActiveThreadCount(Integer.valueOf(this.processScheduler.getActiveThreadCount(port)));
            if (ScheduledState.RUNNING.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Running);
            } else if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Disabled);
            } else if (!port.isValid()) {
                portStatus.setRunStatus(RunStatus.Invalid);
            } else {
                portStatus.setRunStatus(RunStatus.Stopped);
            }
            if (port instanceof RootGroupPort) {
                RootGroupPort rootGroupPort = (RootGroupPort)port;
                portStatus.setTransmitting(Boolean.valueOf(rootGroupPort.isTransmitting()));
            }
            if ((entry = (FlowFileEvent)statusReport.getReportEntries().get(port.getIdentifier())) == null) {
                portStatus.setInputBytes(0L);
                portStatus.setInputCount(0);
                portStatus.setOutputBytes(0L);
                portStatus.setOutputCount(0);
            } else {
                int processedCount = entry.getFlowFilesOut();
                long numProcessedBytes = entry.getContentSizeOut();
                portStatus.setOutputBytes(numProcessedBytes);
                portStatus.setOutputCount(processedCount);
                int inputCount = entry.getFlowFilesIn();
                long inputBytes = entry.getContentSizeIn();
                portStatus.setInputBytes(inputBytes);
                portStatus.setInputCount(inputCount);
                bytesRead += entry.getBytesRead();
                flowFilesOut += entry.getFlowFilesOut();
                bytesOut += entry.getContentSizeOut();
                flowFilesSent = entry.getFlowFilesSent();
                bytesSent += entry.getBytesSent();
            }
            outputPortStatusCollection.add(portStatus);
            activeGroupThreads += portStatus.getActiveThreadCount().intValue();
        }
        for (Funnel funnel : group.getFunnels()) {
            activeGroupThreads += this.processScheduler.getActiveThreadCount(funnel);
        }
        status.setActiveThreadCount(Integer.valueOf(activeGroupThreads));
        status.setBytesRead(Long.valueOf(bytesRead));
        status.setBytesWritten(Long.valueOf(bytesWritten));
        status.setQueuedCount(Integer.valueOf(queuedCount));
        status.setQueuedContentSize(Long.valueOf(queuedContentSize));
        status.setInputContentSize(Long.valueOf(bytesIn));
        status.setInputCount(Integer.valueOf(flowFilesIn));
        status.setOutputContentSize(Long.valueOf(bytesOut));
        status.setOutputCount(Integer.valueOf(flowFilesOut));
        status.setFlowFilesReceived(flowFilesReceived);
        status.setBytesReceived(bytesReceived);
        status.setFlowFilesSent(flowFilesSent);
        status.setBytesSent(bytesSent);
        status.setFlowFilesTransferred(flowFilesTransferred);
        status.setBytesTransferred(bytesTransferred);
        return status;
    }

    private RemoteProcessGroupStatus createRemoteGroupStatus(RemoteProcessGroup remoteGroup, RepositoryStatusReport statusReport) {
        FlowFileEvent portEvent;
        boolean isConnected;
        int receivedCount = 0;
        long receivedContentSize = 0L;
        int sentCount = 0;
        long sentContentSize = 0L;
        int activeThreadCount = 0;
        int activePortCount = 0;
        int inactivePortCount = 0;
        RemoteProcessGroupStatus status = new RemoteProcessGroupStatus();
        status.setGroupId(remoteGroup.getProcessGroup().getIdentifier());
        status.setName(remoteGroup.getName());
        status.setTargetUri(remoteGroup.getTargetUri().toString());
        long lineageMillis = 0L;
        int flowFilesRemoved = 0;
        int flowFilesTransferred = 0;
        for (Port port : remoteGroup.getInputPorts()) {
            isConnected = port.hasIncomingConnection();
            if (isConnected) {
                if (port.isRunning()) {
                    ++activePortCount;
                } else {
                    ++inactivePortCount;
                }
                activeThreadCount += this.processScheduler.getActiveThreadCount(port);
            }
            if ((portEvent = statusReport.getReportEntry(port.getIdentifier())) == null) continue;
            lineageMillis += portEvent.getAggregateLineageMillis();
            flowFilesRemoved += portEvent.getFlowFilesRemoved();
            flowFilesTransferred += portEvent.getFlowFilesOut();
            sentCount += portEvent.getFlowFilesSent();
            sentContentSize += portEvent.getBytesSent();
        }
        for (Port port : remoteGroup.getOutputPorts()) {
            boolean bl = isConnected = !port.getConnections().isEmpty();
            if (isConnected) {
                if (port.isRunning()) {
                    ++activePortCount;
                } else {
                    ++inactivePortCount;
                }
                activeThreadCount += this.processScheduler.getActiveThreadCount(port);
            }
            if ((portEvent = statusReport.getReportEntry(port.getIdentifier())) == null) continue;
            receivedCount += portEvent.getFlowFilesReceived();
            receivedContentSize += portEvent.getBytesReceived();
        }
        status.setId(remoteGroup.getIdentifier());
        status.setTransmissionStatus(remoteGroup.isTransmitting() ? TransmissionStatus.Transmitting : TransmissionStatus.NotTransmitting);
        status.setActiveThreadCount(Integer.valueOf(activeThreadCount));
        status.setReceivedContentSize(Long.valueOf(receivedContentSize));
        status.setReceivedCount(Integer.valueOf(receivedCount));
        status.setSentContentSize(Long.valueOf(sentContentSize));
        status.setSentCount(Integer.valueOf(sentCount));
        status.setActiveRemotePortCount(Integer.valueOf(activePortCount));
        status.setInactiveRemotePortCount(Integer.valueOf(inactivePortCount));
        int flowFilesOutOrRemoved = flowFilesTransferred + flowFilesRemoved;
        status.setAverageLineageDuration(flowFilesOutOrRemoved == 0 ? 0L : lineageMillis / (long)flowFilesOutOrRemoved, TimeUnit.MILLISECONDS);
        if (remoteGroup.getAuthorizationIssue() != null) {
            status.setAuthorizationIssues(Arrays.asList(remoteGroup.getAuthorizationIssue()));
        }
        return status;
    }

    private ProcessorStatus getProcessorStatus(RepositoryStatusReport report, ProcessorNode procNode) {
        ProcessorStatus status = new ProcessorStatus();
        status.setId(procNode.getIdentifier());
        status.setGroupId(procNode.getProcessGroup().getIdentifier());
        status.setName(procNode.getName());
        status.setType(procNode.getProcessor().getClass().getSimpleName());
        FlowFileEvent entry = (FlowFileEvent)report.getReportEntries().get(procNode.getIdentifier());
        if (entry == null) {
            status.setInputBytes(0L);
            status.setInputCount(0);
            status.setOutputBytes(0L);
            status.setOutputCount(0);
            status.setBytesWritten(0L);
            status.setBytesRead(0L);
            status.setProcessingNanos(0L);
            status.setInvocations(0);
            status.setAverageLineageDuration(0L);
        } else {
            int processedCount = entry.getFlowFilesOut();
            long numProcessedBytes = entry.getContentSizeOut();
            status.setOutputBytes(numProcessedBytes);
            status.setOutputCount(processedCount);
            int inputCount = entry.getFlowFilesIn();
            long inputBytes = entry.getContentSizeIn();
            status.setInputBytes(inputBytes);
            status.setInputCount(inputCount);
            long readBytes = entry.getBytesRead();
            status.setBytesRead(readBytes);
            long writtenBytes = entry.getBytesWritten();
            status.setBytesWritten(writtenBytes);
            status.setProcessingNanos(entry.getProcessingNanoseconds());
            status.setInvocations(entry.getInvocations());
            status.setAverageLineageDuration(entry.getAverageLineageMillis());
            status.setFlowFilesReceived(entry.getFlowFilesReceived());
            status.setBytesReceived(entry.getBytesReceived());
            status.setFlowFilesSent(entry.getFlowFilesSent());
            status.setBytesSent(entry.getBytesSent());
        }
        if (ScheduledState.DISABLED.equals((Object)procNode.getScheduledState())) {
            status.setRunStatus(RunStatus.Disabled);
        } else if (!procNode.isValid()) {
            status.setRunStatus(RunStatus.Invalid);
        } else if (ScheduledState.RUNNING.equals((Object)procNode.getScheduledState())) {
            status.setRunStatus(RunStatus.Running);
        } else {
            status.setRunStatus(RunStatus.Stopped);
        }
        status.setActiveThreadCount(this.processScheduler.getActiveThreadCount(procNode));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessor(String parentGroupId, String processorId) {
        ProcessGroup group = this.lookupGroup(parentGroupId);
        ProcessorNode node = group.getProcessor(processorId);
        if (node == null) {
            throw new IllegalStateException("Cannot find ProcessorNode with ID " + processorId + " within ProcessGroup with ID " + parentGroupId);
        }
        this.writeLock.lock();
        try {
            if (this.initialized.get()) {
                group.startProcessor(node);
            } else {
                this.startConnectablesAfterInitialization.add((Connectable)node);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnectable(Connectable connectable) {
        block9: {
            ProcessGroup group = Objects.requireNonNull(connectable).getProcessGroup();
            this.writeLock.lock();
            try {
                if (this.initialized.get()) {
                    switch (Objects.requireNonNull(connectable).getConnectableType()) {
                        case FUNNEL: {
                            group.startFunnel((Funnel)connectable);
                            break block9;
                        }
                        case INPUT_PORT: 
                        case REMOTE_INPUT_PORT: {
                            group.startInputPort((Port)connectable);
                            break block9;
                        }
                        case OUTPUT_PORT: 
                        case REMOTE_OUTPUT_PORT: {
                            group.startOutputPort((Port)connectable);
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                this.startConnectablesAfterInitialization.add(connectable);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransmitting(RemoteGroupPort remoteGroupPort) {
        this.writeLock.lock();
        try {
            if (this.initialized.get()) {
                remoteGroupPort.getRemoteProcessGroup().startTransmitting(remoteGroupPort);
            } else {
                this.startRemoteGroupPortsAfterInitialization.add(remoteGroupPort);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void stopProcessor(String parentGroupId, String processorId) {
        ProcessGroup group = this.lookupGroup(parentGroupId);
        ProcessorNode node = group.getProcessor(processorId);
        if (node == null) {
            throw new IllegalStateException("Cannot find ProcessorNode with ID " + processorId + " within ProcessGroup with ID " + parentGroupId);
        }
        group.stopProcessor(node);
    }

    public void stopAllProcessors() {
        this.stopProcessGroup(this.getRootGroupId());
    }

    public void startProcessGroup(String groupId) {
        this.lookupGroup(groupId).startProcessing();
    }

    public void stopProcessGroup(String groupId) {
        this.lookupGroup(groupId).stopProcessing();
    }

    public ReportingTaskNode createReportingTask(String type) throws ReportingTaskInstantiationException {
        return this.createReportingTask(type, true);
    }

    public ReportingTaskNode createReportingTask(String type, boolean firstTimeAdded) throws ReportingTaskInstantiationException {
        return this.createReportingTask(type, UUID.randomUUID().toString(), firstTimeAdded);
    }

    public ReportingTaskNode createReportingTask(String type, String id, boolean firstTimeAdded) throws ReportingTaskInstantiationException {
        if (type == null || id == null) {
            throw new NullPointerException();
        }
        ReportingTask task = null;
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader detectedClassLoader = ExtensionManager.getClassLoader((String)type);
            Class<?> rawClass = detectedClassLoader == null ? Class.forName(type) : Class.forName(type, false, detectedClassLoader);
            Thread.currentThread().setContextClassLoader(detectedClassLoader);
            Class<ReportingTask> reportingTaskClass = rawClass.asSubclass(ReportingTask.class);
            ReportingTask reportingTaskObj = reportingTaskClass.newInstance();
            task = reportingTaskClass.cast(reportingTaskObj);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException t) {
            throw new ReportingTaskInstantiationException(type, (Throwable)t);
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.controllerServiceProvider);
        StandardReportingTaskNode taskNode = new StandardReportingTaskNode(task, id, this, (ProcessScheduler)this.processScheduler, (ValidationContextFactory)validationContextFactory);
        taskNode.setName(task.getClass().getSimpleName());
        if (firstTimeAdded) {
            SimpleProcessLogger componentLog = new SimpleProcessLogger(id, taskNode.getReportingTask());
            StandardReportingInitializationContext config = new StandardReportingInitializationContext(id, taskNode.getName(), SchedulingStrategy.TIMER_DRIVEN, "1 min", (ComponentLog)componentLog, this);
            try {
                task.initialize((ReportingInitializationContext)config);
            }
            catch (InitializationException ie) {
                throw new ReportingTaskInstantiationException("Failed to initialize reporting task of type " + type, (Throwable)ie);
            }
            try (NarCloseable x = NarCloseable.withNarLoader();){
                ReflectionUtils.invokeMethodsWithAnnotation(org.apache.nifi.annotation.lifecycle.OnAdded.class, task, new Object[0]);
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + task, (Throwable)e);
            }
        }
        this.reportingTasks.put(id, taskNode);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ReportingTaskLogObserver(this.getBulletinRepository(), taskNode));
        return taskNode;
    }

    public ReportingTaskNode getReportingTaskNode(String taskId) {
        return (ReportingTaskNode)this.reportingTasks.get(taskId);
    }

    public void startReportingTask(ReportingTaskNode reportingTaskNode) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Cannot start reporting task " + reportingTaskNode + " because the controller is terminated");
        }
        reportingTaskNode.verifyCanStart();
        this.processScheduler.schedule(reportingTaskNode);
    }

    public void stopReportingTask(ReportingTaskNode reportingTaskNode) {
        if (this.isTerminated()) {
            return;
        }
        reportingTaskNode.verifyCanStop();
        this.processScheduler.unschedule(reportingTaskNode);
    }

    public void removeReportingTask(ReportingTaskNode reportingTaskNode) {
        ReportingTaskNode existing = (ReportingTaskNode)this.reportingTasks.get(reportingTaskNode.getIdentifier());
        if (existing == null || existing != reportingTaskNode) {
            throw new IllegalStateException("Reporting Task " + reportingTaskNode + " does not exist in this Flow");
        }
        reportingTaskNode.verifyCanDelete();
        try (NarCloseable x = NarCloseable.withNarLoader();){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)reportingTaskNode.getReportingTask(), reportingTaskNode.getConfigurationContext());
        }
        for (Map.Entry entry : reportingTaskNode.getProperties().entrySet()) {
            ControllerServiceNode serviceNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
            serviceNode.removeReference((ConfiguredComponent)reportingTaskNode);
        }
        this.reportingTasks.remove(reportingTaskNode.getIdentifier());
    }

    public Set<ReportingTaskNode> getAllReportingTasks() {
        return new HashSet<ReportingTaskNode>(this.reportingTasks.values());
    }

    public ControllerServiceNode createControllerService(String type, String id, boolean firstTimeAdded) {
        ControllerServiceNode serviceNode = this.controllerServiceProvider.createControllerService(type, id, firstTimeAdded);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ControllerServiceLogObserver(this.getBulletinRepository(), serviceNode));
        return serviceNode;
    }

    public void enableReportingTask(ReportingTaskNode reportingTaskNode) {
        reportingTaskNode.verifyCanEnable();
        this.processScheduler.enableReportingTask(reportingTaskNode);
    }

    public void disableReportingTask(ReportingTaskNode reportingTaskNode) {
        reportingTaskNode.verifyCanDisable();
        this.processScheduler.disableReportingTask(reportingTaskNode);
    }

    public void disableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.disableReferencingServices(serviceNode);
    }

    public void enableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.enableReferencingServices(serviceNode);
    }

    public void scheduleReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.scheduleReferencingComponents(serviceNode);
    }

    public void unscheduleReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.unscheduleReferencingComponents(serviceNode);
    }

    public void enableControllerService(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.enableControllerService(serviceNode);
    }

    public void enableControllerServices(Collection<ControllerServiceNode> serviceNodes) {
        this.controllerServiceProvider.enableControllerServices(serviceNodes);
    }

    public void disableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanDisable();
        this.controllerServiceProvider.disableControllerService(serviceNode);
    }

    public void verifyCanEnableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanEnableReferencingServices(serviceNode);
    }

    public void verifyCanScheduleReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanScheduleReferencingComponents(serviceNode);
    }

    public void verifyCanDisableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanDisableReferencingServices(serviceNode);
    }

    public void verifyCanStopReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanStopReferencingComponents(serviceNode);
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerService(serviceIdentifier);
    }

    public ControllerServiceNode getControllerServiceNode(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerServiceNode(serviceIdentifier);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.controllerServiceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerServiceName(serviceIdentifier);
    }

    public void removeControllerService(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.removeControllerService(serviceNode);
    }

    public Set<ControllerServiceNode> getAllControllerServices() {
        return this.controllerServiceProvider.getAllControllerServices();
    }

    public List<Counter> getCounters() {
        ArrayList<Counter> counters = new ArrayList<Counter>();
        CounterRepository counterRepo = this.counterRepositoryRef.get();
        for (Counter counter : counterRepo.getCounters()) {
            counters.add(counter);
        }
        return counters;
    }

    public Counter resetCounter(String identifier) {
        CounterRepository counterRepo = this.counterRepositoryRef.get();
        Counter resetValue = counterRepo.resetCounter(identifier);
        this.heartbeat();
        return resetValue;
    }

    public QueueSize getTotalFlowFileCount(ProcessGroup group) {
        QueueSize size;
        int count = 0;
        long contentSize = 0L;
        for (Connection connection : group.getConnections()) {
            size = connection.getFlowFileQueue().size();
            count += size.getObjectCount();
            contentSize += size.getByteCount();
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            size = this.getTotalFlowFileCount(childGroup);
            count += size.getObjectCount();
            contentSize += size.getByteCount();
        }
        return new QueueSize(count, contentSize);
    }

    public int getActiveThreadCount() {
        return this.getGroupStatus(this.getRootGroupId()).getActiveThreadCount();
    }

    private RepositoryStatusReport getProcessorStats() {
        return this.getProcessorStats(System.currentTimeMillis() - 300000L);
    }

    private RepositoryStatusReport getProcessorStats(long since) {
        return this.flowFileEventRepository.reportTransferEvents(since);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startHeartbeating() throws IllegalStateException {
        if (!this.configuredForClustering) {
            throw new IllegalStateException("Unable to start heartbeating because heartbeating is not configured.");
        }
        this.writeLock.lock();
        try {
            this.stopHeartbeating();
            this.bulletinFuture = this.clusterTaskExecutor.scheduleWithFixedDelay(new BulletinsTask(this.protocolSender), 250L, 2000L, TimeUnit.MILLISECONDS);
            HeartbeatMessageGeneratorTask heartbeatMessageGeneratorTask = new HeartbeatMessageGeneratorTask();
            this.heartbeatMessageGeneratorTaskRef.set(heartbeatMessageGeneratorTask);
            this.heartbeatGeneratorFuture = this.clusterTaskExecutor.scheduleWithFixedDelay(heartbeatMessageGeneratorTask, 0L, this.heartbeatDelaySeconds, TimeUnit.SECONDS);
            this.heartbeatSenderFuture = this.clusterTaskExecutor.scheduleWithFixedDelay(new HeartbeatSendTask(this.protocolSender), 250L, 250L, TimeUnit.MILLISECONDS);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void suspendHeartbeats() {
        this.heartbeatsSuspended.set(true);
    }

    public void resumeHeartbeats() {
        this.heartbeatsSuspended.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHeartbeating() throws IllegalStateException {
        if (!this.configuredForClustering) {
            throw new IllegalStateException("Unable to stop heartbeating because heartbeating is not configured.");
        }
        this.writeLock.lock();
        try {
            if (!this.isHeartbeating()) {
                return;
            }
            if (this.heartbeatGeneratorFuture != null) {
                this.heartbeatGeneratorFuture.cancel(false);
            }
            if (this.heartbeatSenderFuture != null) {
                this.heartbeatSenderFuture.cancel(false);
            }
            if (this.bulletinFuture != null) {
                this.bulletinFuture.cancel(false);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeartbeating() {
        this.readLock.lock();
        try {
            boolean bl = this.heartbeatGeneratorFuture != null && !this.heartbeatGeneratorFuture.isCancelled() && this.heartbeatSenderFuture != null && !this.heartbeatSenderFuture.isCancelled();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHeartbeatDelaySeconds() {
        this.readLock.lock();
        try {
            int n = this.heartbeatDelaySeconds;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeIdentifier getNodeId() {
        this.readLock.lock();
        try {
            NodeIdentifier nodeIdentifier = this.nodeId;
            return nodeIdentifier;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeId(NodeIdentifier nodeId) {
        this.writeLock.lock();
        try {
            this.nodeId = nodeId;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClustered() {
        this.readLock.lock();
        try {
            boolean bl = this.clustered;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClusterManagerDN() {
        this.readLock.lock();
        try {
            String string = this.clusterManagerDN;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setClustered(boolean clustered, String clusterInstanceId) {
        this.setClustered(clustered, clusterInstanceId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClustered(boolean clustered, String clusterInstanceId, String clusterManagerDn) {
        this.writeLock.lock();
        try {
            boolean isChanging = false;
            if (this.clustered != clustered) {
                isChanging = true;
            }
            this.clustered = clustered;
            if (clusterManagerDn != null) {
                this.clusterManagerDN = clusterManagerDn;
            }
            this.eventDrivenWorkerQueue.setClustered(clustered);
            if (clusterInstanceId != null) {
                this.instanceId = clusterInstanceId;
            }
            if (isChanging) {
                if (clustered) {
                    this.nodeBulletinSubscriber.set(new NodeBulletinProcessingStrategy());
                    this.bulletinRepository.overrideDefaultBulletinProcessing(this.nodeBulletinSubscriber.get());
                } else {
                    this.bulletinRepository.restoreDefaultBulletinProcessing();
                }
                List remoteGroups = this.getGroup(this.getRootGroupId()).findAllRemoteProcessGroups();
                for (RemoteProcessGroup remoteGroup : remoteGroups) {
                    remoteGroup.reinitialize(clustered);
                }
            }
            this.heartbeatBeanRef.set(new HeartbeatBean(this.rootGroup, this.primary, this.connected));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrimary() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.primary;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrimary(boolean primary) {
        this.rwLock.writeLock().lock();
        try {
            if (this.primary == primary) {
                return;
            }
            LOG.info("Setting primary flag from '" + this.primary + "' to '" + primary + "'");
            PrimaryNodeState nodeState = primary ? PrimaryNodeState.ELECTED_PRIMARY_NODE : PrimaryNodeState.PRIMARY_NODE_REVOKED;
            ProcessGroup rootGroup = this.getGroup(this.getRootGroupId());
            for (ProcessorNode procNode : rootGroup.findAllProcessors()) {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)procNode.getProcessor(), nodeState);
            }
            for (ControllerServiceNode serviceNode : this.getAllControllerServices()) {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)serviceNode.getControllerServiceImplementation(), nodeState);
            }
            for (ReportingTaskNode reportingTaskNode : this.getAllReportingTasks()) {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)reportingTaskNode.getReportingTask(), nodeState);
            }
            this.primary = primary;
            this.eventDrivenWorkerQueue.setPrimary(primary);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    static boolean areEqual(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    static boolean areEqual(Long a, Long b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.compareTo(b) == 0;
    }

    public ContentAvailability getContentAvailability(final ProvenanceEventRecord event) {
        final String replayFailure = this.getReplayFailureReason(event);
        return new ContentAvailability(){

            public String getReasonNotReplayable() {
                return replayFailure;
            }

            public boolean isContentSame() {
                return FlowController.areEqual(event.getPreviousContentClaimContainer(), event.getContentClaimContainer()) && FlowController.areEqual(event.getPreviousContentClaimSection(), event.getContentClaimSection()) && FlowController.areEqual(event.getPreviousContentClaimIdentifier(), event.getContentClaimIdentifier()) && FlowController.areEqual(event.getPreviousContentClaimOffset(), event.getContentClaimOffset()) && FlowController.areEqual(event.getPreviousFileSize(), event.getFileSize());
            }

            public boolean isInputAvailable() {
                try {
                    return FlowController.this.contentRepository.isAccessible(this.createClaim(event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier(), event.getPreviousContentClaimOffset()));
                }
                catch (IOException e) {
                    return false;
                }
            }

            public boolean isOutputAvailable() {
                try {
                    return FlowController.this.contentRepository.isAccessible(this.createClaim(event.getContentClaimContainer(), event.getContentClaimSection(), event.getContentClaimIdentifier(), event.getContentClaimOffset()));
                }
                catch (IOException e) {
                    return false;
                }
            }

            private ContentClaim createClaim(String container, String section, String identifier, Long offset) {
                if (container == null || section == null || identifier == null) {
                    return null;
                }
                StandardResourceClaim resourceClaim = new StandardResourceClaim(container, section, identifier, false);
                return new StandardContentClaim(resourceClaim, offset == null ? 0L : offset);
            }

            public boolean isReplayable() {
                return replayFailure == null;
            }
        };
    }

    public InputStream getContent(ProvenanceEventRecord provEvent, ContentDirection direction, String requestor, String requestUri) throws IOException {
        long size;
        long offset;
        StandardContentClaim claim;
        ResourceClaim resourceClaim;
        Objects.requireNonNull(provEvent);
        Objects.requireNonNull(direction);
        Objects.requireNonNull(requestor);
        Objects.requireNonNull(requestUri);
        if (direction == ContentDirection.INPUT) {
            if (provEvent.getPreviousContentClaimContainer() == null || provEvent.getPreviousContentClaimSection() == null || provEvent.getPreviousContentClaimIdentifier() == null) {
                throw new IllegalArgumentException("Input Content Claim not specified");
            }
            resourceClaim = this.contentClaimManager.newResourceClaim(provEvent.getPreviousContentClaimContainer(), provEvent.getPreviousContentClaimSection(), provEvent.getPreviousContentClaimIdentifier(), false);
            claim = new StandardContentClaim(resourceClaim, provEvent.getPreviousContentClaimOffset());
            offset = provEvent.getPreviousContentClaimOffset() == null ? 0L : provEvent.getPreviousContentClaimOffset();
            size = provEvent.getPreviousFileSize();
        } else {
            if (provEvent.getContentClaimContainer() == null || provEvent.getContentClaimSection() == null || provEvent.getContentClaimIdentifier() == null) {
                throw new IllegalArgumentException("Output Content Claim not specified");
            }
            resourceClaim = this.contentClaimManager.newResourceClaim(provEvent.getContentClaimContainer(), provEvent.getContentClaimSection(), provEvent.getContentClaimIdentifier(), false);
            claim = new StandardContentClaim(resourceClaim, provEvent.getContentClaimOffset());
            offset = provEvent.getContentClaimOffset() == null ? 0L : provEvent.getContentClaimOffset();
            size = provEvent.getFileSize();
        }
        InputStream rawStream = this.contentRepository.read((ContentClaim)claim);
        ResourceClaim resourceClaim2 = claim.getResourceClaim();
        StandardProvenanceEventRecord sendEvent = new StandardProvenanceEventRecord.Builder().setEventType(ProvenanceEventType.SEND).setFlowFileUUID(provEvent.getFlowFileUuid()).setAttributes(provEvent.getAttributes(), Collections.emptyMap()).setCurrentContentClaim(resourceClaim2.getContainer(), resourceClaim2.getSection(), resourceClaim2.getId(), Long.valueOf(offset), size).setTransitUri(requestUri).setEventTime(System.currentTimeMillis()).setFlowFileEntryDate(provEvent.getFlowFileEntryDate()).setLineageStartDate(provEvent.getLineageStartDate()).setComponentType(this.getName()).setComponentId(this.getRootGroupId()).setDetails("Download of " + (direction == ContentDirection.INPUT ? "Input" : "Output") + " Content requested by " + requestor + " for Provenance Event " + provEvent.getEventId()).build();
        this.provenanceEventRepository.registerEvent((ProvenanceEventRecord)sendEvent);
        return new LimitedInputStream(rawStream, size);
    }

    private String getReplayFailureReason(ProvenanceEventRecord event) {
        ProvenanceEventType type = event.getEventType();
        if (type == ProvenanceEventType.JOIN) {
            return "Cannot replay events that are created from multiple parents";
        }
        Long contentSize = event.getPreviousFileSize();
        String contentClaimId = event.getPreviousContentClaimIdentifier();
        String contentClaimSection = event.getPreviousContentClaimSection();
        String contentClaimContainer = event.getPreviousContentClaimContainer();
        if (contentSize == null || contentClaimId == null || contentClaimSection == null || contentClaimContainer == null) {
            return "Cannot replay data from Provenance Event because the event does not contain the required Content Claim";
        }
        try {
            ResourceClaim resourceClaim = this.contentClaimManager.newResourceClaim(contentClaimContainer, contentClaimSection, contentClaimId, false);
            StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, event.getPreviousContentClaimOffset());
            if (!this.contentRepository.isAccessible((ContentClaim)contentClaim)) {
                return "Content is no longer available in Content Repository";
            }
        }
        catch (IOException ioe) {
            return "Failed to determine whether or not content was available in Content Repository due to " + ioe.toString();
        }
        if (event.getSourceQueueIdentifier() == null) {
            return "Cannot replay data from Provenance Event because the event does not specify the Source FlowFile Queue";
        }
        List connections = this.getGroup(this.getRootGroupId()).findAllConnections();
        FlowFileQueue queue = null;
        for (Connection connection : connections) {
            if (!event.getSourceQueueIdentifier().equals(connection.getIdentifier())) continue;
            queue = connection.getFlowFileQueue();
            break;
        }
        if (queue == null) {
            return "Cannot replay data from Provenance Event because the Source FlowFile Queue with ID " + event.getSourceQueueIdentifier() + " no longer exists";
        }
        return null;
    }

    public ProvenanceEventRecord replayFlowFile(long provenanceEventRecordId, String requestor) throws IOException {
        ProvenanceEventRecord record = this.provenanceEventRepository.getEvent(provenanceEventRecordId);
        if (record == null) {
            throw new IllegalStateException("Cannot find Provenance Event with ID " + provenanceEventRecordId);
        }
        return this.replayFlowFile(record, requestor);
    }

    public ProvenanceEventRecord replayFlowFile(ProvenanceEventRecord event, String requestor) throws IOException {
        if (event == null) {
            throw new NullPointerException();
        }
        ProvenanceEventType type = event.getEventType();
        if (type == ProvenanceEventType.JOIN) {
            throw new IllegalArgumentException("Cannot replay events that are created from multiple parents");
        }
        Long contentSize = event.getPreviousFileSize();
        String contentClaimId = event.getPreviousContentClaimIdentifier();
        String contentClaimSection = event.getPreviousContentClaimSection();
        String contentClaimContainer = event.getPreviousContentClaimContainer();
        if (contentSize == null || contentClaimId == null || contentClaimSection == null || contentClaimContainer == null) {
            throw new IllegalArgumentException("Cannot replay data from Provenance Event because the event does not contain the required Content Claim");
        }
        if (event.getSourceQueueIdentifier() == null) {
            throw new IllegalArgumentException("Cannot replay data from Provenance Event because the event does not specify the Source FlowFile Queue");
        }
        List connections = this.getGroup(this.getRootGroupId()).findAllConnections();
        FlowFileQueue queue = null;
        for (Connection connection : connections) {
            if (!event.getSourceQueueIdentifier().equals(connection.getIdentifier())) continue;
            queue = connection.getFlowFileQueue();
            break;
        }
        if (queue == null) {
            throw new IllegalStateException("Cannot replay data from Provenance Event because the Source FlowFile Queue with ID " + event.getSourceQueueIdentifier() + " no longer exists");
        }
        ResourceClaim resourceClaim = this.contentClaimManager.newResourceClaim(event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier(), false);
        this.contentClaimManager.incrementClaimantCount(resourceClaim);
        long claimOffset = event.getPreviousContentClaimOffset() == null ? 0L : event.getPreviousContentClaimOffset();
        StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, claimOffset);
        contentClaim.setLength(event.getPreviousFileSize() == null ? -1L : event.getPreviousFileSize());
        if (!this.contentRepository.isAccessible((ContentClaim)contentClaim)) {
            this.contentClaimManager.decrementClaimantCount(resourceClaim);
            throw new IllegalStateException("Cannot replay data from Provenance Event because the data is no longer available in the Content Repository");
        }
        String parentUUID = event.getFlowFileUuid();
        HashSet<String> lineageIdentifiers = new HashSet<String>();
        lineageIdentifiers.addAll(event.getLineageIdentifiers());
        lineageIdentifiers.add(parentUUID);
        String newFlowFileUUID = UUID.randomUUID().toString();
        FlowFileRecord flowFileRecord = new StandardFlowFileRecord.Builder().addAttributes(event.getPreviousAttributes()).contentClaim(contentClaim).contentClaimOffset(0L).entryDate(System.currentTimeMillis()).id(this.flowFileRepository.getNextFlowFileSequence()).lineageIdentifiers(lineageIdentifiers).lineageStartDate(event.getLineageStartDate()).size(contentSize).addAttribute("flowfile.replay", "true").addAttribute("flowfile.replay.timestamp", String.valueOf(new Date())).addAttribute(CoreAttributes.UUID.key(), newFlowFileUUID).removeAttributes(CoreAttributes.DISCARD_REASON.key(), CoreAttributes.ALTERNATE_IDENTIFIER.key()).build();
        StandardProvenanceEventRecord replayEvent = new StandardProvenanceEventRecord.Builder().setEventType(ProvenanceEventType.REPLAY).addChildUuid(newFlowFileUUID).addParentUuid(parentUUID).setFlowFileUUID(parentUUID).setAttributes(Collections.emptyMap(), flowFileRecord.getAttributes()).setCurrentContentClaim(event.getContentClaimSection(), event.getContentClaimContainer(), event.getContentClaimIdentifier(), event.getContentClaimOffset(), event.getFileSize()).setDetails("Replay requested by " + requestor).setEventTime(System.currentTimeMillis()).setFlowFileEntryDate(System.currentTimeMillis()).setLineageStartDate(event.getLineageStartDate()).setComponentType(event.getComponentType()).setComponentId(event.getComponentId()).build();
        this.provenanceEventRepository.registerEvent((ProvenanceEventRecord)replayEvent);
        StandardRepositoryRecord record = new StandardRepositoryRecord(queue, flowFileRecord);
        record.setDestination(queue);
        this.flowFileRepository.updateRepository(Collections.singleton(record));
        queue.put(flowFileRecord);
        return replayEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.connected;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean connected) {
        this.rwLock.writeLock().lock();
        try {
            this.connected = connected;
            this.heartbeatBeanRef.set(new HeartbeatBean(this.rootGroup, this.primary, connected));
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void heartbeat() {
        if (!this.isClustered()) {
            return;
        }
        if (this.shutdown) {
            return;
        }
        HeartbeatMessageGeneratorTask task = this.heartbeatMessageGeneratorTaskRef.get();
        if (task != null) {
            task.run();
        }
    }

    private void updateRemoteProcessGroups() {
        List remoteGroups = this.getGroup(this.getRootGroupId()).findAllRemoteProcessGroups();
        for (RemoteProcessGroup remoteGroup : remoteGroups) {
            try {
                remoteGroup.refreshFlowContents();
            }
            catch (ClientHandlerException | CommunicationsException e) {
                LOG.warn("Unable to communicate with remote instance {} due to {}", (Object)remoteGroup, (Object)e.toString());
                if (!LOG.isDebugEnabled()) continue;
                LOG.warn("", e);
            }
        }
    }

    public List<ProvenanceEventRecord> getProvenanceEvents(long firstEventId, int maxRecords) throws IOException {
        return new ArrayList<ProvenanceEventRecord>(this.provenanceEventRepository.getEvents(firstEventId, maxRecords));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClusterManagerRemoteSiteInfo(Integer managerListeningPort, Boolean commsSecure) {
        this.writeLock.lock();
        try {
            this.clusterManagerRemoteSitePort = managerListeningPort;
            this.clusterManagerRemoteSiteCommsSecure = commsSecure;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getClusterManagerRemoteSiteListeningPort() {
        this.readLock.lock();
        try {
            Integer n = this.clusterManagerRemoteSitePort;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean isClusterManagerRemoteSiteCommsSecure() {
        this.readLock.lock();
        try {
            Boolean bl = this.clusterManagerRemoteSiteCommsSecure;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Integer getRemoteSiteListeningPort() {
        return this.remoteInputSocketPort;
    }

    public Boolean isRemoteSiteCommsSecure() {
        return this.isSiteToSiteSecure;
    }

    public ProcessScheduler getProcessScheduler() {
        return this.processScheduler;
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.controllerServiceProvider.getControllerServiceIdentifiers(serviceType);
    }

    public ProvenanceEventRepository getProvenanceRepository() {
        return this.provenanceEventRepository;
    }

    public StatusHistoryDTO getConnectionStatusHistory(String connectionId) {
        return this.getConnectionStatusHistory(connectionId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getConnectionStatusHistory(String connectionId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getConnectionStatusHistory(connectionId, startTime, endTime, preferredDataPoints));
    }

    public StatusHistoryDTO getProcessorStatusHistory(String processorId) {
        return this.getProcessorStatusHistory(processorId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getProcessorStatusHistory(String processorId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getProcessorStatusHistory(processorId, startTime, endTime, preferredDataPoints));
    }

    public StatusHistoryDTO getProcessGroupStatusHistory(String processGroupId) {
        return this.getProcessGroupStatusHistory(processGroupId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getProcessGroupStatusHistory(String processGroupId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getProcessGroupStatusHistory(processGroupId, startTime, endTime, preferredDataPoints));
    }

    public StatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteGroupId) {
        return this.getRemoteProcessGroupStatusHistory(remoteGroupId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteGroupId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getRemoteProcessGroupStatusHistory(remoteGroupId, startTime, endTime, preferredDataPoints));
    }

    public Collection<FlowFileQueue> getAllQueues() {
        List connections = this.getGroup(this.getRootGroupId()).findAllConnections();
        ArrayList<FlowFileQueue> queues = new ArrayList<FlowFileQueue>(connections.size());
        for (Connection connection : connections) {
            queues.add(connection.getFlowFileQueue());
        }
        return queues;
    }

    private static class HeartbeatBean {
        private final ProcessGroup rootGroup;
        private final boolean primary;
        private final boolean connected;

        public HeartbeatBean(ProcessGroup rootGroup, boolean primary, boolean connected) {
            this.rootGroup = rootGroup;
            this.primary = primary;
            this.connected = connected;
        }

        public ProcessGroup getRootGroup() {
            return this.rootGroup;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public boolean isConnected() {
            return this.connected;
        }
    }

    private class HeartbeatMessageGeneratorTask
    implements Runnable {
        private final AtomicReference<HeartbeatMessage> heartbeatMessageRef = new AtomicReference();

        private HeartbeatMessageGeneratorTask() {
        }

        @Override
        public void run() {
            HeartbeatMessage heartbeatMessage = this.createHeartbeatMessage();
            if (heartbeatMessage != null) {
                this.heartbeatMessageRef.set(heartbeatMessage);
            }
        }

        public HeartbeatMessage getHeartbeatMessage() {
            return this.heartbeatMessageRef.getAndSet(null);
        }

        private HeartbeatMessage createHeartbeatMessage() {
            try {
                HeartbeatBean bean = (HeartbeatBean)FlowController.this.heartbeatBeanRef.get();
                if (bean == null) {
                    return null;
                }
                ProcessGroupStatus procGroupStatus = FlowController.this.getGroupStatus(bean.getRootGroup(), FlowController.this.getProcessorStats());
                HeartbeatPayload hbPayload = new HeartbeatPayload();
                hbPayload.setSystemStartTime(FlowController.this.systemStartTime);
                hbPayload.setActiveThreadCount(procGroupStatus.getActiveThreadCount());
                QueueSize queueSize = FlowController.this.getTotalFlowFileCount(bean.getRootGroup());
                hbPayload.setTotalFlowFileCount(queueSize.getObjectCount());
                hbPayload.setTotalFlowFileBytes(queueSize.getByteCount());
                hbPayload.setCounters(FlowController.this.getCounters());
                hbPayload.setSystemDiagnostics(FlowController.this.getSystemDiagnostics());
                hbPayload.setProcessGroupStatus(procGroupStatus);
                hbPayload.setSiteToSitePort(FlowController.this.remoteInputSocketPort);
                hbPayload.setSiteToSiteSecure(FlowController.this.isSiteToSiteSecure);
                Heartbeat heartbeat = new Heartbeat(FlowController.this.getNodeId(), bean.isPrimary(), bean.isConnected(), hbPayload.marshal());
                HeartbeatMessage message = new HeartbeatMessage();
                message.setHeartbeat(heartbeat);
                heartbeatLogger.debug("Generated heartbeat");
                return message;
            }
            catch (Throwable ex) {
                LOG.warn("Failed to create heartbeat due to: " + ex, ex);
                return null;
            }
        }
    }

    private class HeartbeatSendTask
    implements Runnable {
        private final NodeProtocolSender protocolSender;
        private final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS", Locale.US);

        public HeartbeatSendTask(NodeProtocolSender protocolSender) {
            if (protocolSender == null) {
                throw new IllegalArgumentException("NodeProtocolSender may not be null.");
            }
            this.protocolSender = protocolSender;
        }

        @Override
        public void run() {
            block7: {
                try {
                    if (FlowController.this.heartbeatsSuspended.get()) {
                        return;
                    }
                    HeartbeatMessageGeneratorTask task = (HeartbeatMessageGeneratorTask)FlowController.this.heartbeatMessageGeneratorTaskRef.get();
                    if (task == null) {
                        return;
                    }
                    HeartbeatMessage message = task.getHeartbeatMessage();
                    if (message == null) {
                        heartbeatLogger.debug("No heartbeat to send");
                        return;
                    }
                    long sendStart = System.nanoTime();
                    this.protocolSender.heartbeat(message);
                    long sendNanos = System.nanoTime() - sendStart;
                    long sendMillis = TimeUnit.NANOSECONDS.toMillis(sendNanos);
                    heartbeatLogger.info("Heartbeat created at {} and sent at {}; send took {} millis", new Object[]{this.dateFormatter.format(new Date(message.getHeartbeat().getCreatedTimestamp())), this.dateFormatter.format(new Date()), sendMillis});
                }
                catch (UnknownServiceAddressException usae) {
                    if (heartbeatLogger.isDebugEnabled()) {
                        heartbeatLogger.debug(usae.getMessage());
                    }
                }
                catch (Throwable ex) {
                    heartbeatLogger.warn("Failed to send heartbeat to cluster manager due to: " + ex);
                    if (!heartbeatLogger.isDebugEnabled()) break block7;
                    heartbeatLogger.warn("", ex);
                }
            }
        }
    }

    private class BulletinsTask
    implements Runnable {
        private final NodeProtocolSender protocolSender;
        private final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS", Locale.US);

        public BulletinsTask(NodeProtocolSender protocolSender) {
            if (protocolSender == null) {
                throw new IllegalArgumentException("NodeProtocolSender may not be null.");
            }
            this.protocolSender = protocolSender;
        }

        @Override
        public void run() {
            block6: {
                try {
                    NodeBulletinsMessage message = this.createBulletinsMessage();
                    if (message == null) {
                        return;
                    }
                    this.protocolSender.sendBulletins(message);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(String.format("Sending bulletins to cluster manager at %s", this.dateFormatter.format(new Date())));
                    }
                }
                catch (UnknownServiceAddressException usae) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(usae.getMessage());
                    }
                }
                catch (Exception ex) {
                    if (!LOG.isDebugEnabled()) break block6;
                    LOG.debug("Failed to send bulletins to cluster manager due to: " + ex, (Throwable)ex);
                }
            }
        }

        private boolean isIllegalXmlChar(char c) {
            return c < ' ' && c != '\t' && c != '\n' && c != '\r';
        }

        private boolean containsIllegalXmlChars(Bulletin bulletin) {
            String message = bulletin.getMessage();
            for (int i = 0; i < message.length(); ++i) {
                char c = message.charAt(i);
                if (!this.isIllegalXmlChar(c)) continue;
                return true;
            }
            return false;
        }

        private String stripIllegalXmlChars(String value) {
            StringBuilder sb = new StringBuilder(value.length());
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                sb.append(this.isIllegalXmlChar(c) ? (char)'?' : (char)c);
            }
            return sb.toString();
        }

        private NodeBulletinsMessage createBulletinsMessage() {
            Set<Bulletin> nodeBulletins = ((NodeBulletinProcessingStrategy)FlowController.this.nodeBulletinSubscriber.get()).getBulletins();
            HashSet<Bulletin> escapedNodeBulletins = new HashSet<Bulletin>(nodeBulletins.size());
            if (nodeBulletins.isEmpty()) {
                return null;
            }
            for (Bulletin bulletin : nodeBulletins) {
                Bulletin escapedBulletin;
                if (this.containsIllegalXmlChars(bulletin)) {
                    String escapedBulletinMessage = this.stripIllegalXmlChars(bulletin.getMessage());
                    escapedBulletin = bulletin.getGroupId() == null ? BulletinFactory.createBulletin((String)bulletin.getCategory(), (String)bulletin.getLevel(), (String)escapedBulletinMessage) : BulletinFactory.createBulletin((String)bulletin.getGroupId(), (String)bulletin.getSourceId(), (ComponentType)bulletin.getSourceType(), (String)bulletin.getSourceName(), (String)bulletin.getCategory(), (String)bulletin.getLevel(), (String)escapedBulletinMessage);
                } else {
                    escapedBulletin = bulletin;
                }
                escapedNodeBulletins.add(escapedBulletin);
            }
            BulletinsPayload payload = new BulletinsPayload();
            payload.setBulletins(escapedNodeBulletins);
            NodeBulletins bulletins = new NodeBulletins(FlowController.this.getNodeId(), payload.marshal());
            NodeBulletinsMessage message = new NodeBulletinsMessage();
            message.setBulletins(bulletins);
            return message;
        }
    }
}

