/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.AbstractPort;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.Heartbeater;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.annotation.OnConfigured;
import org.apache.nifi.controller.scheduling.ConnectableProcessContext;
import org.apache.nifi.controller.scheduling.ScheduleState;
import org.apache.nifi.controller.scheduling.SchedulingAgent;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.processor.annotation.OnStopped;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardProcessScheduler
implements ProcessScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(StandardProcessScheduler.class);
    private final ControllerServiceProvider controllerServiceProvider;
    private final Heartbeater heartbeater;
    private final long administrativeYieldMillis;
    private final String administrativeYieldDuration;
    private final ConcurrentMap<Object, ScheduleState> scheduleStates = new ConcurrentHashMap<Object, ScheduleState>();
    private final ScheduledExecutorService frameworkTaskExecutor;
    private final ConcurrentMap<SchedulingStrategy, SchedulingAgent> strategyAgentMap = new ConcurrentHashMap<SchedulingStrategy, SchedulingAgent>();
    private final ExecutorService componentLifeCycleThreadPool = new ThreadPoolExecutor(25, 50, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(5000));
    private final StringEncryptor encryptor;

    public StandardProcessScheduler(Heartbeater heartbeater, ControllerServiceProvider controllerServiceProvider, StringEncryptor encryptor) {
        this.heartbeater = heartbeater;
        this.controllerServiceProvider = controllerServiceProvider;
        this.encryptor = encryptor;
        this.administrativeYieldDuration = NiFiProperties.getInstance().getAdministrativeYieldDuration();
        this.administrativeYieldMillis = FormatUtils.getTimeDuration((String)this.administrativeYieldDuration, (TimeUnit)TimeUnit.MILLISECONDS);
        this.frameworkTaskExecutor = new FlowEngine(4, "Framework Task Thread");
    }

    public void scheduleFrameworkTask(final Runnable command, String taskName, long initialDelay, long delay, TimeUnit timeUnit) {
        this.frameworkTaskExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        command.run();
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to run Framework Task {} due to {}", (Object)command, (Object)t.toString());
                        if (!LOG.isDebugEnabled()) break block2;
                        LOG.error("", t);
                    }
                }
            }
        }, initialDelay, delay, timeUnit);
    }

    public void setMaxThreadCount(SchedulingStrategy schedulingStrategy, int maxThreadCount) {
        SchedulingAgent agent = this.getSchedulingAgent(schedulingStrategy);
        if (agent == null) {
            return;
        }
        agent.setMaxThreadCount(maxThreadCount);
    }

    public void setSchedulingAgent(SchedulingStrategy strategy, SchedulingAgent agent) {
        this.strategyAgentMap.put(strategy, agent);
    }

    public SchedulingAgent getSchedulingAgent(SchedulingStrategy strategy) {
        return (SchedulingAgent)this.strategyAgentMap.get(strategy);
    }

    private SchedulingAgent getSchedulingAgent(Connectable connectable) {
        return this.getSchedulingAgent(connectable.getSchedulingStrategy());
    }

    public void shutdown() {
        for (SchedulingAgent schedulingAgent : this.strategyAgentMap.values()) {
            try {
                schedulingAgent.shutdown();
            }
            catch (Throwable t) {
                LOG.error("Failed to shutdown Scheduling Agent {} due to {}", (Object)schedulingAgent, (Object)t.toString());
                LOG.error("", t);
            }
        }
        this.frameworkTaskExecutor.shutdown();
        this.componentLifeCycleThreadPool.shutdown();
    }

    public void schedule(final ReportingTaskNode taskNode) {
        final ScheduleState scheduleState = this.getScheduleState(Objects.requireNonNull(taskNode));
        if (scheduleState.isScheduled()) {
            return;
        }
        int activeThreadCount = scheduleState.getActiveThreadCount();
        if (activeThreadCount > 0) {
            throw new IllegalStateException("Reporting Task " + taskNode.getName() + " cannot be started because it has " + activeThreadCount + " threads still running");
        }
        if (!taskNode.isValid()) {
            throw new IllegalStateException("Reporting Task " + taskNode.getName() + " is not in a valid state for the following reasons: " + taskNode.getValidationErrors());
        }
        final SchedulingAgent agent = this.getSchedulingAgent(taskNode.getSchedulingStrategy());
        scheduleState.setScheduled(true);
        Runnable startReportingTaskRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long lastStopTime = scheduleState.getLastStopTime();
                ReportingTask reportingTask = taskNode.getReportingTask();
                while (true) {
                    try {
                        ScheduleState scheduleState2 = scheduleState;
                        synchronized (scheduleState2) {
                            if (!scheduleState.isScheduled() || scheduleState.getLastStopTime() != lastStopTime) {
                                return;
                            }
                            try (NarCloseable x = NarCloseable.withNarLoader();){
                                ReflectionUtils.invokeMethodsWithAnnotations(OnScheduled.class, OnConfigured.class, reportingTask, taskNode.getConfigurationContext());
                            }
                            agent.schedule(taskNode, scheduleState);
                            return;
                        }
                    }
                    catch (Exception e) {
                        Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                        SimpleProcessLogger componentLog = new SimpleProcessLogger(reportingTask.getIdentifier(), reportingTask);
                        componentLog.error("Failed to invoke @OnEnabled method due to {}", cause);
                        LOG.error("Failed to invoke the On-Scheduled Lifecycle methods of {} due to {}; administratively yielding this ReportingTask and will attempt to schedule it again after {}", (Object)new Object[]{reportingTask, e.toString(), StandardProcessScheduler.this.administrativeYieldDuration}, (Object)e);
                        try {
                            Thread.sleep(StandardProcessScheduler.this.administrativeYieldMillis);
                        }
                        catch (InterruptedException ie) {
                        }
                        continue;
                    }
                    break;
                }
            }
        };
        this.componentLifeCycleThreadPool.execute(startReportingTaskRunnable);
        taskNode.setScheduledState(ScheduledState.RUNNING);
    }

    public void unschedule(final ReportingTaskNode taskNode) {
        final ScheduleState scheduleState = this.getScheduleState(Objects.requireNonNull(taskNode));
        if (!scheduleState.isScheduled()) {
            return;
        }
        taskNode.verifyCanStop();
        final SchedulingAgent agent = this.getSchedulingAgent(taskNode.getSchedulingStrategy());
        final ReportingTask reportingTask = taskNode.getReportingTask();
        taskNode.setScheduledState(ScheduledState.STOPPED);
        Runnable unscheduleReportingTaskRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ConfigurationContext configurationContext = taskNode.getConfigurationContext();
                ScheduleState scheduleState2 = scheduleState;
                synchronized (scheduleState2) {
                    scheduleState.setScheduled(false);
                    try (NarCloseable x = NarCloseable.withNarLoader();){
                        ReflectionUtils.invokeMethodsWithAnnotations(OnUnscheduled.class, org.apache.nifi.processor.annotation.OnUnscheduled.class, reportingTask, configurationContext);
                    }
                    catch (Exception e) {
                        Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                        SimpleProcessLogger componentLog = new SimpleProcessLogger(reportingTask.getIdentifier(), reportingTask);
                        componentLog.error("Failed to invoke @OnUnscheduled method due to {}", cause);
                        LOG.error("Failed to invoke the @OnUnscheduled methods of {} due to {}; administratively yielding this ReportingTask and will attempt to schedule it again after {}", new Object[]{reportingTask, cause.toString(), StandardProcessScheduler.this.administrativeYieldDuration});
                        LOG.error("", cause);
                        try {
                            Thread.sleep(StandardProcessScheduler.this.administrativeYieldMillis);
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    agent.unschedule(taskNode, scheduleState);
                    if (scheduleState.getActiveThreadCount() == 0 && scheduleState.mustCallOnStoppedMethods()) {
                        ReflectionUtils.quietlyInvokeMethodsWithAnnotations(org.apache.nifi.annotation.lifecycle.OnStopped.class, OnStopped.class, (Object)reportingTask, configurationContext);
                    }
                }
            }
        };
        this.componentLifeCycleThreadPool.execute(unscheduleReportingTaskRunnable);
    }

    public synchronized void startProcessor(final ProcessorNode procNode) {
        if (procNode.getScheduledState() == ScheduledState.DISABLED) {
            throw new IllegalStateException(procNode + " is disabled, so it cannot be started");
        }
        final ScheduleState scheduleState = this.getScheduleState(Objects.requireNonNull(procNode));
        if (scheduleState.isScheduled()) {
            return;
        }
        int activeThreadCount = scheduleState.getActiveThreadCount();
        if (activeThreadCount > 0) {
            throw new IllegalStateException("Processor " + procNode.getName() + " cannot be started because it has " + activeThreadCount + " threads still running");
        }
        if (!procNode.isValid()) {
            throw new IllegalStateException("Processor " + procNode.getName() + " is not in a valid state due to " + procNode.getValidationErrors());
        }
        Runnable startProcRunnable = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        scheduleState.setScheduled(true);
        procNode.setScheduledState(ScheduledState.RUNNING);
        this.componentLifeCycleThreadPool.execute(startProcRunnable);
    }

    public void yield(ProcessorNode procNode) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stopProcessor(final ProcessorNode procNode) {
        ScheduleState state;
        ScheduleState scheduleState = state = this.getScheduleState(Objects.requireNonNull(procNode));
        synchronized (scheduleState) {
            if (!state.isScheduled()) {
                procNode.setScheduledState(ScheduledState.STOPPED);
                return;
            }
            state.setScheduled(false);
            this.getSchedulingAgent((Connectable)procNode).unschedule((Connectable)procNode, state);
            procNode.setScheduledState(ScheduledState.STOPPED);
        }
        Runnable stopProcRunnable = new Runnable(){

            @Override
            public void run() {
                try (NarCloseable x = NarCloseable.withNarLoader();){
                    StandardProcessContext processContext = new StandardProcessContext(procNode, StandardProcessScheduler.this.controllerServiceProvider, StandardProcessScheduler.this.encryptor);
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)procNode.getProcessor(), processContext);
                    if (state.getActiveThreadCount() == 0 && state.mustCallOnStoppedMethods()) {
                        ReflectionUtils.quietlyInvokeMethodsWithAnnotation(org.apache.nifi.annotation.lifecycle.OnStopped.class, (Object)procNode.getProcessor(), processContext);
                        StandardProcessScheduler.this.heartbeater.heartbeat();
                    }
                }
            }
        };
        this.componentLifeCycleThreadPool.execute(stopProcRunnable);
    }

    public void registerEvent(Connectable worker) {
        this.getSchedulingAgent(worker).onEvent(worker);
    }

    public int getActiveThreadCount(Object scheduled) {
        return this.getScheduleState(scheduled).getActiveThreadCount();
    }

    public void startPort(Port port) {
        if (!port.isValid()) {
            throw new IllegalStateException("Port " + port.getName() + " is not in a valid state");
        }
        port.onSchedulingStart();
        this.startConnectable((Connectable)port);
    }

    public void startFunnel(Funnel funnel) {
        this.startConnectable((Connectable)funnel);
        funnel.setScheduledState(ScheduledState.RUNNING);
    }

    public void stopPort(Port port) {
        this.stopConnectable((Connectable)port);
        port.shutdown();
    }

    public void stopFunnel(Funnel funnel) {
        this.stopConnectable((Connectable)funnel);
        funnel.setScheduledState(ScheduledState.STOPPED);
    }

    private synchronized void startConnectable(Connectable connectable) {
        if (connectable.getScheduledState() == ScheduledState.DISABLED) {
            throw new IllegalStateException(connectable + " is disabled, so it cannot be started");
        }
        ScheduleState scheduleState = this.getScheduleState(Objects.requireNonNull(connectable));
        if (scheduleState.isScheduled()) {
            return;
        }
        int activeThreads = scheduleState.getActiveThreadCount();
        if (activeThreads > 0) {
            throw new IllegalStateException("Port cannot be scheduled to run until its last " + activeThreads + " threads finish");
        }
        this.getSchedulingAgent(connectable).schedule(connectable, scheduleState);
        scheduleState.setScheduled(true);
    }

    private synchronized void stopConnectable(Connectable connectable) {
        ScheduleState state = this.getScheduleState(Objects.requireNonNull(connectable));
        if (!state.isScheduled()) {
            return;
        }
        state.setScheduled(false);
        this.getSchedulingAgent(connectable).unschedule(connectable, state);
        if (!state.isScheduled() && state.getActiveThreadCount() == 0 && state.mustCallOnStoppedMethods()) {
            ConnectableProcessContext processContext = new ConnectableProcessContext(connectable, this.encryptor);
            try (NarCloseable x = NarCloseable.withNarLoader();){
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(org.apache.nifi.annotation.lifecycle.OnStopped.class, (Object)connectable, processContext);
                this.heartbeater.heartbeat();
            }
        }
    }

    public synchronized void enableFunnel(Funnel funnel) {
        if (funnel.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException("Funnel cannot be enabled because it is not disabled");
        }
        funnel.setScheduledState(ScheduledState.STOPPED);
    }

    public synchronized void disableFunnel(Funnel funnel) {
        if (funnel.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException("Funnel cannot be disabled because its state its state is set to " + funnel.getScheduledState());
        }
        funnel.setScheduledState(ScheduledState.DISABLED);
    }

    public synchronized void disablePort(Port port) {
        if (port.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException("Port cannot be disabled because its state is set to " + port.getScheduledState());
        }
        if (!(port instanceof AbstractPort)) {
            throw new IllegalArgumentException();
        }
        ((AbstractPort)port).disable();
    }

    public synchronized void enablePort(Port port) {
        if (port.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException("Funnel cannot be enabled because it is not disabled");
        }
        if (!(port instanceof AbstractPort)) {
            throw new IllegalArgumentException();
        }
        ((AbstractPort)port).enable();
    }

    public synchronized void enableProcessor(ProcessorNode procNode) {
        if (procNode.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException("Processor cannot be enabled because it is not disabled");
        }
        procNode.setScheduledState(ScheduledState.STOPPED);
    }

    public synchronized void disableProcessor(ProcessorNode procNode) {
        if (procNode.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException("Processor cannot be disabled because its state is set to " + procNode.getScheduledState());
        }
        procNode.setScheduledState(ScheduledState.DISABLED);
    }

    public synchronized void enableReportingTask(ReportingTaskNode taskNode) {
        if (taskNode.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException("Reporting Task cannot be enabled because it is not disabled");
        }
        taskNode.setScheduledState(ScheduledState.STOPPED);
    }

    public synchronized void disableReportingTask(ReportingTaskNode taskNode) {
        if (taskNode.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException("Reporting Task cannot be disabled because its state is set to " + taskNode.getScheduledState() + " but transition to DISABLED state is allowed only from the STOPPED state");
        }
        taskNode.setScheduledState(ScheduledState.DISABLED);
    }

    public boolean isScheduled(Object scheduled) {
        ScheduleState scheduleState = (ScheduleState)this.scheduleStates.get(scheduled);
        return scheduleState == null ? false : scheduleState.isScheduled();
    }

    private ScheduleState getScheduleState(Object schedulable) {
        ScheduleState previous;
        ScheduleState scheduleState = (ScheduleState)this.scheduleStates.get(schedulable);
        if (scheduleState == null && (previous = this.scheduleStates.putIfAbsent(schedulable, scheduleState = new ScheduleState())) != null) {
            scheduleState = previous;
        }
        return scheduleState;
    }

    public void enableControllerService(final ControllerServiceNode service) {
        service.setState(ControllerServiceState.ENABLING);
        final ScheduleState scheduleState = this.getScheduleState(service);
        Runnable enableRunnable = new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        scheduleState.setScheduled(true);
        this.componentLifeCycleThreadPool.execute(enableRunnable);
    }

    public void disableControllerService(ControllerServiceNode service) {
        this.disableControllerServices(Collections.singletonList(service));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableControllerServices(List<ControllerServiceNode> services) {
        if (Objects.requireNonNull(services).isEmpty()) {
            return;
        }
        ArrayList<ControllerServiceNode> servicesToDisable = new ArrayList<ControllerServiceNode>(services.size());
        for (ControllerServiceNode serviceToDisable : services) {
            if (serviceToDisable.getState() == ControllerServiceState.DISABLED || serviceToDisable.getState() == ControllerServiceState.DISABLING) continue;
            servicesToDisable.add(serviceToDisable);
        }
        if (servicesToDisable.isEmpty()) {
            return;
        }
        for (ControllerServiceNode serviceNode : servicesToDisable) {
            HashSet<ControllerServiceNode> ignoredReferences = new HashSet<ControllerServiceNode>(services);
            ignoredReferences.remove(serviceNode);
            serviceNode.verifyCanDisable(ignoredReferences);
        }
        for (ControllerServiceNode serviceNode : servicesToDisable) {
            ScheduleState scheduleState;
            serviceNode.setState(ControllerServiceState.DISABLING);
            ScheduleState scheduleState2 = scheduleState = this.getScheduleState(serviceNode);
            synchronized (scheduleState2) {
                scheduleState.setScheduled(false);
            }
        }
        final LinkedList nodes = new LinkedList(servicesToDisable);
        Runnable disableRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ControllerServiceNode service;
                while ((service = (ControllerServiceNode)nodes.poll()) != null) {
                    NarCloseable x = NarCloseable.withNarLoader();
                    Throwable throwable = null;
                    try {
                        StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)service, (ControllerServiceLookup)StandardProcessScheduler.this.controllerServiceProvider, null);
                        try {
                            ReflectionUtils.invokeMethodsWithAnnotation(OnDisabled.class, service.getControllerServiceImplementation(), configContext);
                        }
                        catch (Exception e) {
                            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                            SimpleProcessLogger componentLog = new SimpleProcessLogger(service.getIdentifier(), service);
                            componentLog.error("Failed to invoke @OnDisabled method due to {}", cause);
                            LOG.error("Failed to invoke @OnDisabled method of {} due to {}", (Object)service.getControllerServiceImplementation(), (Object)cause.toString());
                            if (LOG.isDebugEnabled()) {
                                LOG.error("", cause);
                            }
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnDisabled.class, (Object)service.getControllerServiceImplementation(), configContext);
                            try {
                                Thread.sleep(StandardProcessScheduler.this.administrativeYieldMillis);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                        }
                        finally {
                            service.setState(ControllerServiceState.DISABLED);
                            StandardProcessScheduler.this.heartbeater.heartbeat();
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (x == null) continue;
                        if (throwable != null) {
                            try {
                                x.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        x.close();
                    }
                }
            }
        };
        this.componentLifeCycleThreadPool.execute(disableRunnable);
    }

    static /* synthetic */ SchedulingAgent access$500(StandardProcessScheduler x0, Connectable x1) {
        return x0.getSchedulingAgent(x1);
    }
}

