/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractConfiguredComponent;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.annotation.OnConfigured;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceReference;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.util.ReflectionUtils;

public class StandardControllerServiceNode
extends AbstractConfiguredComponent
implements ControllerServiceNode {
    private final ControllerService proxedControllerService;
    private final ControllerService implementation;
    private final ControllerServiceProvider serviceProvider;
    private final AtomicReference<ControllerServiceState> stateRef = new AtomicReference<ControllerServiceState>(ControllerServiceState.DISABLED);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<ConfiguredComponent> referencingComponents = new HashSet<ConfiguredComponent>();
    private String comment;

    public StandardControllerServiceNode(ControllerService proxiedControllerService, ControllerService implementation, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider) {
        super((ConfigurableComponent)implementation, id, validationContextFactory, serviceProvider);
        this.proxedControllerService = proxiedControllerService;
        this.implementation = implementation;
        this.serviceProvider = serviceProvider;
    }

    public ControllerService getProxiedControllerService() {
        return this.proxedControllerService;
    }

    public ControllerService getControllerServiceImplementation() {
        return this.implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ControllerServiceReference getReferences() {
        this.readLock.lock();
        try {
            StandardControllerServiceReference standardControllerServiceReference = new StandardControllerServiceReference(this, this.referencingComponents);
            return standardControllerServiceReference;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReference(ConfiguredComponent referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.add(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeReference(ConfiguredComponent referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.remove(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException("Cannot modify Controller Service configuration because it is currently enabled. Please disable the Controller Service first.");
        }
    }

    public void setProperty(String name, String value) {
        super.setProperty(name, value);
        this.onConfigured();
    }

    public boolean removeProperty(String name) {
        boolean removed = super.removeProperty(name);
        if (removed) {
            this.onConfigured();
        }
        return removed;
    }

    private void onConfigured() {
        try (NarCloseable x = NarCloseable.withNarLoader();){
            StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)this, (ControllerServiceLookup)this.serviceProvider, null);
            ReflectionUtils.invokeMethodsWithAnnotation(OnConfigured.class, this.implementation, configContext);
        }
        catch (Exception e) {
            throw new ComponentLifeCycleException("Failed to invoke On-Configured Lifecycle methods of " + this.implementation, (Throwable)e);
        }
    }

    public void verifyCanDelete() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.implementation + " cannot be deleted because it is not disabled");
        }
    }

    public void verifyCanDisable() {
        this.verifyCanDisable(Collections.emptySet());
    }

    public void verifyCanDisable(Set<ControllerServiceNode> ignoreReferences) {
        ControllerServiceState state = this.getState();
        if (state != ControllerServiceState.ENABLED && state != ControllerServiceState.ENABLING) {
            throw new IllegalStateException("Cannot disable " + this.getControllerServiceImplementation() + " because it is not enabled");
        }
        ControllerServiceReference references = this.getReferences();
        HashSet<ConfiguredComponent> activeReferences = new HashSet<ConfiguredComponent>();
        for (ConfiguredComponent activeReference : references.getActiveReferences()) {
            if (ignoreReferences.contains(activeReference)) continue;
            activeReferences.add(activeReference);
        }
        if (!activeReferences.isEmpty()) {
            throw new IllegalStateException(this.implementation + " cannot be disabled because it is referenced by " + activeReferences.size() + " components that are currently running: " + activeReferences);
        }
    }

    public void verifyCanEnable() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not disabled");
        }
        if (!this.isValid()) {
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not valid: " + this.getValidationErrors());
        }
    }

    public void verifyCanEnable(Set<ControllerServiceNode> ignoredReferences) {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not disabled");
        }
        HashSet<String> ids = new HashSet<String>();
        for (ControllerServiceNode node : ignoredReferences) {
            ids.add(node.getIdentifier());
        }
        Collection validationResults = this.getValidationErrors(ids);
        for (ValidationResult result : validationResults) {
            if (result.isValid()) continue;
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not valid: " + result);
        }
    }

    public void verifyCanUpdate() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.implementation + " cannot be updated because it is not disabled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComments() {
        this.readLock.lock();
        try {
            String string = this.comment;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComments(String comment) {
        this.writeLock.lock();
        try {
            this.comment = comment;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ControllerServiceState getState() {
        return this.stateRef.get();
    }

    public void setState(ControllerServiceState state) {
        this.stateRef.set(state);
    }
}

