/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.status.history;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.status.history.MetricDescriptor;
import org.apache.nifi.controller.status.history.StatusSnapshot;
import org.apache.nifi.controller.status.history.ValueReducer;

public class StandardStatusSnapshot
implements StatusSnapshot {
    private final Map<MetricDescriptor<?>, Long> metricValues = new LinkedHashMap();
    private Date timestamp = new Date();

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public Map<MetricDescriptor<?>, Long> getStatusMetrics() {
        return this.metricValues;
    }

    public void addStatusMetric(MetricDescriptor<?> metric, Long value) {
        this.metricValues.put(metric, value);
    }

    public ValueReducer<StatusSnapshot, StatusSnapshot> getValueReducer() {
        return new ValueReducer<StatusSnapshot, StatusSnapshot>(){

            public StatusSnapshot reduce(List<StatusSnapshot> values) {
                Date reducedTimestamp = null;
                LinkedHashSet allDescriptors = new LinkedHashSet(StandardStatusSnapshot.this.metricValues.keySet());
                for (StatusSnapshot statusSnapshot : values) {
                    if (reducedTimestamp == null) {
                        reducedTimestamp = statusSnapshot.getTimestamp();
                    }
                    allDescriptors.addAll(statusSnapshot.getStatusMetrics().keySet());
                }
                StandardStatusSnapshot reduced = new StandardStatusSnapshot();
                if (reducedTimestamp != null) {
                    reduced.setTimestamp(reducedTimestamp);
                }
                for (MetricDescriptor descriptor : allDescriptors) {
                    Long descriptorValue = (Long)descriptor.getValueReducer().reduce(values);
                    reduced.addStatusMetric(descriptor, descriptorValue);
                }
                return reduced;
            }
        };
    }
}

