/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.entity.ControllerEntity;
import org.apache.nifi.web.util.WebUtils;

public class RemoteNiFiUtils {
    public static final String CONTROLLER_URI_PATH = "/controller";
    private static final int CONNECT_TIMEOUT = 10000;
    private static final int READ_TIMEOUT = 10000;
    private final Client client;

    public RemoteNiFiUtils(SSLContext sslContext) {
        this.client = this.getClient(sslContext);
    }

    public ClientResponse get(URI uri, int timeoutMillis) throws ClientHandlerException, UniformInterfaceException {
        return this.get(uri, timeoutMillis, null);
    }

    public ClientResponse get(URI uri, int timeoutMillis, Map<String, String> queryParams) throws ClientHandlerException, UniformInterfaceException {
        WebResource webResource = this.client.resource(uri);
        if (queryParams != null) {
            for (Map.Entry<String, String> queryEntry : queryParams.entrySet()) {
                webResource = webResource.queryParam(queryEntry.getKey(), queryEntry.getValue());
            }
        }
        webResource.setProperty("com.sun.jersey.client.property.readTimeout", (Object)timeoutMillis);
        webResource.setProperty("com.sun.jersey.client.property.connectTimeout", (Object)timeoutMillis);
        return (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
    }

    public ClientResponse head(URI uri, int timeoutMillis) throws ClientHandlerException, UniformInterfaceException {
        WebResource webResource = this.client.resource(uri);
        webResource.setProperty("com.sun.jersey.client.property.readTimeout", (Object)timeoutMillis);
        webResource.setProperty("com.sun.jersey.client.property.connectTimeout", (Object)timeoutMillis);
        return webResource.head();
    }

    private Client getClient(SSLContext sslContext) {
        Client client = sslContext == null ? WebUtils.createClient(null) : WebUtils.createClient(null, (SSLContext)sslContext);
        client.setReadTimeout(Integer.valueOf(10000));
        client.setConnectTimeout(Integer.valueOf(10000));
        return client;
    }

    public Integer getRemoteListeningPort(String uri, int timeoutMillis) throws IOException {
        try {
            URI uriObject = new URI(uri + CONTROLLER_URI_PATH);
            return this.getRemoteListeningPort(uriObject, timeoutMillis);
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to establish connection to remote host because URI is invalid: " + uri);
        }
    }

    public String getRemoteRootGroupId(String uri, int timeoutMillis) throws IOException {
        try {
            URI uriObject = new URI(uri + CONTROLLER_URI_PATH);
            return this.getRemoteRootGroupId(uriObject, timeoutMillis);
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to establish connection to remote host because URI is invalid: " + uri);
        }
    }

    public String getRemoteInstanceId(String uri, int timeoutMillis) throws IOException {
        try {
            URI uriObject = new URI(uri + CONTROLLER_URI_PATH);
            return this.getController(uriObject, timeoutMillis).getInstanceId();
        }
        catch (URISyntaxException e) {
            throw new IOException("Unable to establish connection to remote host because URI is invalid: " + uri);
        }
    }

    private Integer getRemoteListeningPort(URI uri, int timeoutMillis) throws IOException {
        return this.getController(uri, timeoutMillis).getRemoteSiteListeningPort();
    }

    private String getRemoteRootGroupId(URI uri, int timeoutMillis) throws IOException {
        return this.getController(uri, timeoutMillis).getId();
    }

    public ControllerDTO getController(URI uri, int timeoutMillis) throws IOException {
        ClientResponse response = this.get(uri, timeoutMillis);
        if (ClientResponse.Status.OK.getStatusCode() == response.getStatusInfo().getStatusCode()) {
            ControllerEntity entity = (ControllerEntity)response.getEntity(ControllerEntity.class);
            return entity.getController();
        }
        String responseMessage = (String)response.getEntity(String.class);
        throw new IOException("Got HTTP response Code " + response.getStatusInfo().getStatusCode() + ": " + response.getStatusInfo().getReasonPhrase() + " with explanation: " + responseMessage);
    }

    public ClientResponse issueRegistrationRequest(String baseApiUri) {
        URI uri = URI.create(String.format("%s/%s", baseApiUri, "/controller/users"));
        MultivaluedMapImpl entity = new MultivaluedMapImpl();
        entity.add("justification", "A Remote instance of NiFi has attempted to create a reference to this NiFi. This action must be approved first.");
        WebResource webResource = this.client.resource(uri);
        return (ClientResponse)((WebResource.Builder)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/x-www-form-urlencoded")).entity((Object)entity)).post(ClientResponse.class);
    }
}

