/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.TriggerWhenAnyDestinationAvailable;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.SideEffectFree;
import org.apache.nifi.processor.annotation.SupportsBatching;
import org.apache.nifi.processor.annotation.TriggerSerially;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;
import org.quartz.CronExpression;
import org.slf4j.LoggerFactory;

public class StandardProcessorNode
extends ProcessorNode
implements Connectable {
    public static final String BULLETIN_OBSERVER_ID = "bulletin-observer";
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    public static final String DEFAULT_YIELD_PERIOD = "1 sec";
    public static final String DEFAULT_PENALIZATION_PERIOD = "30 sec";
    private final AtomicReference<ProcessGroup> processGroup;
    private final Processor processor;
    private final AtomicReference<String> identifier;
    private final Map<Connection, Connectable> destinations;
    private final Map<Relationship, Set<Connection>> connections;
    private final AtomicReference<Set<Relationship>> undefinedRelationshipsToTerminate;
    private final AtomicReference<List<Connection>> incomingConnectionsRef;
    private final ReentrantReadWriteLock rwLock;
    private final Lock readLock;
    private final Lock writeLock;
    private final AtomicBoolean isolated;
    private final AtomicBoolean lossTolerant;
    private final AtomicReference<ScheduledState> scheduledState;
    private final AtomicReference<String> comments;
    private final AtomicReference<String> name;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> annotationData;
    private final AtomicReference<String> schedulingPeriod;
    private final AtomicReference<String> yieldPeriod;
    private final AtomicReference<String> penalizationPeriod;
    private final AtomicReference<Map<String, String>> style;
    private final AtomicInteger concurrentTaskCount;
    private final AtomicLong yieldExpiration;
    private final AtomicLong schedulingNanos;
    private final boolean triggerWhenEmpty;
    private final boolean sideEffectFree;
    private final boolean triggeredSerially;
    private final boolean triggerWhenAnyDestinationAvailable;
    private final boolean eventDrivenSupported;
    private final boolean batchSupported;
    private final InputRequirement.Requirement inputRequirement;
    private final ValidationContextFactory validationContextFactory;
    private final ProcessScheduler processScheduler;
    private long runNanos = 0L;
    private SchedulingStrategy schedulingStrategy;

    public StandardProcessorNode(Processor processor, String uuid, ValidationContextFactory validationContextFactory, ProcessScheduler scheduler, ControllerServiceProvider controllerServiceProvider) {
        super(processor, uuid, validationContextFactory, controllerServiceProvider);
        this.processor = processor;
        this.identifier = new AtomicReference<String>(uuid);
        this.destinations = new HashMap<Connection, Connectable>();
        this.connections = new HashMap<Relationship, Set<Connection>>();
        this.incomingConnectionsRef = new AtomicReference(new ArrayList());
        this.scheduledState = new AtomicReference<ScheduledState>(ScheduledState.STOPPED);
        this.rwLock = new ReentrantReadWriteLock(false);
        this.readLock = this.rwLock.readLock();
        this.writeLock = this.rwLock.writeLock();
        this.lossTolerant = new AtomicBoolean(false);
        HashSet emptySetOfRelationships = new HashSet();
        this.undefinedRelationshipsToTerminate = new AtomicReference(emptySetOfRelationships);
        this.comments = new AtomicReference<String>("");
        this.name = new AtomicReference<String>(processor.getClass().getSimpleName());
        this.schedulingPeriod = new AtomicReference<String>("0 sec");
        this.schedulingNanos = new AtomicLong(30000L);
        this.yieldPeriod = new AtomicReference<String>(DEFAULT_YIELD_PERIOD);
        this.yieldExpiration = new AtomicLong(0L);
        this.concurrentTaskCount = new AtomicInteger(1);
        this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
        this.style = new AtomicReference(Collections.unmodifiableMap(new HashMap()));
        this.processGroup = new AtomicReference();
        this.processScheduler = scheduler;
        this.annotationData = new AtomicReference();
        this.isolated = new AtomicBoolean(false);
        this.penalizationPeriod = new AtomicReference<String>(DEFAULT_PENALIZATION_PERIOD);
        Class<?> procClass = processor.getClass();
        this.triggerWhenEmpty = procClass.isAnnotationPresent(TriggerWhenEmpty.class) || procClass.isAnnotationPresent(org.apache.nifi.processor.annotation.TriggerWhenEmpty.class);
        this.sideEffectFree = procClass.isAnnotationPresent(org.apache.nifi.annotation.behavior.SideEffectFree.class) || procClass.isAnnotationPresent(SideEffectFree.class);
        this.batchSupported = procClass.isAnnotationPresent(org.apache.nifi.annotation.behavior.SupportsBatching.class) || procClass.isAnnotationPresent(SupportsBatching.class);
        this.triggeredSerially = procClass.isAnnotationPresent(org.apache.nifi.annotation.behavior.TriggerSerially.class) || procClass.isAnnotationPresent(TriggerSerially.class);
        this.triggerWhenAnyDestinationAvailable = procClass.isAnnotationPresent(TriggerWhenAnyDestinationAvailable.class) || procClass.isAnnotationPresent(org.apache.nifi.processor.annotation.TriggerWhenAnyDestinationAvailable.class);
        this.validationContextFactory = validationContextFactory;
        this.eventDrivenSupported = (procClass.isAnnotationPresent(EventDriven.class) || procClass.isAnnotationPresent(org.apache.nifi.processor.annotation.EventDriven.class)) && !this.triggeredSerially && !this.triggerWhenEmpty;
        boolean inputRequirementPresent = procClass.isAnnotationPresent(InputRequirement.class);
        this.inputRequirement = inputRequirementPresent ? procClass.getAnnotation(InputRequirement.class).value() : InputRequirement.Requirement.INPUT_ALLOWED;
        this.schedulingStrategy = SchedulingStrategy.TIMER_DRIVEN;
    }

    public String getComments() {
        return this.comments.get();
    }

    public void setComments(String comments) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            this.comments.set(comments);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ScheduledState getScheduledState() {
        return this.scheduledState.get();
    }

    public Position getPosition() {
        return this.position.get();
    }

    public void setPosition(Position position) {
        this.position.set(position);
    }

    public Map<String, String> getStyle() {
        return this.style.get();
    }

    public void setStyle(Map<String, String> style) {
        if (style != null) {
            this.style.set(Collections.unmodifiableMap(new HashMap<String, String>(style)));
        }
    }

    public String getIdentifier() {
        return this.identifier.get();
    }

    public boolean isLossTolerant() {
        return this.lossTolerant.get();
    }

    public boolean isIsolated() {
        return this.isolated.get();
    }

    public boolean isTriggerWhenEmpty() {
        return this.triggerWhenEmpty;
    }

    public boolean isSideEffectFree() {
        return this.sideEffectFree;
    }

    public boolean isHighThroughputSupported() {
        return this.batchSupported;
    }

    public boolean isTriggerWhenAnyDestinationAvailable() {
        return this.triggerWhenAnyDestinationAvailable;
    }

    public void setLossTolerant(boolean lossTolerant) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            this.lossTolerant.set(lossTolerant);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setIsolated(boolean isolated) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            this.isolated.set(isolated);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isAutoTerminated(Relationship relationship) {
        Set<Relationship> terminatable = this.undefinedRelationshipsToTerminate.get();
        if (terminatable == null) {
            return false;
        }
        return terminatable.contains(relationship);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoTerminatedRelationships(Set<Relationship> terminate) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            for (Relationship rel : terminate) {
                if (this.getConnections(rel).isEmpty()) continue;
                throw new IllegalStateException("Cannot mark relationship '" + rel.getName() + "' as auto-terminated because Connection already exists with this relationship");
            }
            this.undefinedRelationshipsToTerminate.set(new HashSet<Relationship>(terminate));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Relationship> getAutoTerminatedRelationships() {
        Set<Relationship> relationships = this.undefinedRelationshipsToTerminate.get();
        if (relationships == null) {
            relationships = new HashSet<Relationship>();
        }
        return Collections.unmodifiableSet(relationships);
    }

    public String getName() {
        return this.name.get();
    }

    public String getProcessorDescription() {
        org.apache.nifi.annotation.documentation.CapabilityDescription capDesc = this.processor.getClass().getAnnotation(org.apache.nifi.annotation.documentation.CapabilityDescription.class);
        String description = null;
        if (capDesc != null) {
            description = capDesc.value();
        } else {
            CapabilityDescription deprecatedCapDesc = this.processor.getClass().getAnnotation(CapabilityDescription.class);
            if (deprecatedCapDesc != null) {
                description = deprecatedCapDesc.value();
            }
        }
        return description;
    }

    public void setName(String name) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            this.name.set(name);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos.get(), TimeUnit.NANOSECONDS);
    }

    public boolean isEventDrivenSupported() {
        this.readLock.lock();
        try {
            boolean bl = this.eventDrivenSupported;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        this.writeLock.lock();
        try {
            if (schedulingStrategy == SchedulingStrategy.EVENT_DRIVEN && !this.eventDrivenSupported) {
                return;
            }
            this.schedulingStrategy = schedulingStrategy;
            this.setIsolated(schedulingStrategy == SchedulingStrategy.PRIMARY_NODE_ONLY);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public SchedulingStrategy getSchedulingStrategy() {
        this.readLock.lock();
        try {
            SchedulingStrategy schedulingStrategy = this.schedulingStrategy;
            return schedulingStrategy;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScheduldingPeriod(String schedulingPeriod) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            switch (this.schedulingStrategy) {
                case CRON_DRIVEN: {
                    try {
                        new CronExpression(schedulingPeriod);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Scheduling Period is not a valid cron expression: " + schedulingPeriod);
                    }
                }
                case PRIMARY_NODE_ONLY: 
                case TIMER_DRIVEN: {
                    long schedulingNanos = FormatUtils.getTimeDuration((String)Objects.requireNonNull(schedulingPeriod), (TimeUnit)TimeUnit.NANOSECONDS);
                    if (schedulingNanos < 0L) {
                        throw new IllegalArgumentException("Scheduling Period must be positive");
                    }
                    this.schedulingNanos.set(Math.max(30000L, schedulingNanos));
                    break;
                }
                default: {
                    return;
                }
            }
            this.schedulingPeriod.set(schedulingPeriod);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRunDuration(TimeUnit timeUnit) {
        this.readLock.lock();
        try {
            long l = timeUnit.convert(this.runNanos, TimeUnit.NANOSECONDS);
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRunDuration(long duration, TimeUnit timeUnit) {
        this.writeLock.lock();
        try {
            if (duration < 0L) {
                throw new IllegalArgumentException("Run Duration must be non-negative value; cannot set to " + timeUnit.toSeconds(duration) + " seconds");
            }
            this.runNanos = timeUnit.toNanos(duration);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getYieldPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getYieldPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    public String getYieldPeriod() {
        return this.yieldPeriod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYieldPeriod(String yieldPeriod) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            long yieldMillis = FormatUtils.getTimeDuration((String)Objects.requireNonNull(yieldPeriod), (TimeUnit)TimeUnit.MILLISECONDS);
            if (yieldMillis < 0L) {
                throw new IllegalArgumentException("Yield duration must be positive");
            }
            this.yieldPeriod.set(yieldPeriod);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void yield() {
        long yieldMillis = this.getYieldPeriod(TimeUnit.MILLISECONDS);
        this.yield(yieldMillis, TimeUnit.MILLISECONDS);
        String yieldDuration = yieldMillis > 1000L ? yieldMillis / 1000L + " seconds" : yieldMillis + " milliseconds";
        LoggerFactory.getLogger(this.processor.getClass()).debug("{} has chosen to yield its resources; will not be scheduled to run again for {}", (Object)this.processor, (Object)yieldDuration);
    }

    public void yield(long period, TimeUnit timeUnit) {
        long yieldMillis = TimeUnit.MILLISECONDS.convert(period, timeUnit);
        this.yieldExpiration.set(Math.max(this.yieldExpiration.get(), System.currentTimeMillis() + yieldMillis));
        this.processScheduler.yield((ProcessorNode)this);
    }

    public long getYieldExpiration() {
        return this.yieldExpiration.get();
    }

    public long getPenalizationPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getPenalizationPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    public String getPenalizationPeriod() {
        return this.penalizationPeriod.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPenalizationPeriod(String penalizationPeriod) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            long penalizationMillis = FormatUtils.getTimeDuration((String)Objects.requireNonNull(penalizationPeriod), (TimeUnit)TimeUnit.MILLISECONDS);
            if (penalizationMillis < 0L) {
                throw new IllegalArgumentException("Penalization duration must be positive");
            }
            this.penalizationPeriod.set(penalizationPeriod);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setMaxConcurrentTasks(int taskCount) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
            }
            if (taskCount < 1 && this.getSchedulingStrategy() != SchedulingStrategy.EVENT_DRIVEN) {
                throw new IllegalArgumentException();
            }
            if (!this.triggeredSerially) {
                this.concurrentTaskCount.set(taskCount);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isTriggeredSerially() {
        return this.triggeredSerially;
    }

    public int getMaxConcurrentTasks() {
        return this.concurrentTaskCount.get();
    }

    public LogLevel getBulletinLevel() {
        return LogRepositoryFactory.getRepository((String)this.getIdentifier()).getObservationLevel(BULLETIN_OBSERVER_ID);
    }

    public void setBulletinLevel(LogLevel level) {
        LogRepositoryFactory.getRepository((String)this.getIdentifier()).setObservationLevel(BULLETIN_OBSERVER_ID, level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Connection> getConnections() {
        HashSet<Connection> allConnections = new HashSet<Connection>();
        this.readLock.lock();
        try {
            for (Set<Connection> connectionSet : this.connections.values()) {
                allConnections.addAll(connectionSet);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return allConnections;
    }

    public List<Connection> getIncomingConnections() {
        return this.incomingConnectionsRef.get();
    }

    public Set<Connection> getConnections(Relationship relationship) {
        Set<Connection> applicableConnections;
        this.readLock.lock();
        try {
            applicableConnections = this.connections.get(relationship);
        }
        finally {
            this.readLock.unlock();
        }
        return applicableConnections == null ? Collections.emptySet() : Collections.unmodifiableSet(applicableConnections);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        Objects.requireNonNull(connection, "connection cannot be null");
        if (!connection.getSource().equals((Object)this) && !connection.getDestination().equals((Object)this)) {
            throw new IllegalStateException("Cannot a connection to a ProcessorNode for which the ProcessorNode is neither the Source nor the Destination");
        }
        this.writeLock.lock();
        try {
            Object incomingConnections;
            ArrayList<Connection> updatedIncoming = null;
            if (connection.getDestination().equals((Object)this) && !(updatedIncoming = new ArrayList<Connection>((Collection<Connection>)(incomingConnections = this.incomingConnectionsRef.get()))).contains(connection)) {
                updatedIncoming.add(connection);
            }
            if (connection.getSource().equals((Object)this) && !this.destinations.containsKey(connection)) {
                for (Relationship relationship : connection.getRelationships()) {
                    Relationship rel = this.getRelationship(relationship.getName());
                    Set<Connection> set = this.connections.get(rel);
                    if (set == null) {
                        set = new HashSet<Connection>();
                        this.connections.put(rel, set);
                    }
                    set.add(connection);
                    this.destinations.put(connection, connection.getDestination());
                }
                Set<Relationship> autoTerminated = this.undefinedRelationshipsToTerminate.get();
                if (autoTerminated != null) {
                    autoTerminated.removeAll(connection.getRelationships());
                    this.undefinedRelationshipsToTerminate.set(autoTerminated);
                }
            }
            if (updatedIncoming != null) {
                this.incomingConnectionsRef.set(Collections.unmodifiableList(updatedIncoming));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean hasIncomingConnection() {
        return !this.incomingConnectionsRef.get().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnection(Connection connection) throws IllegalStateException {
        if (Objects.requireNonNull(connection).getSource().equals((Object)this)) {
            this.writeLock.lock();
            try {
                ArrayList<Relationship> existingRelationships = new ArrayList<Relationship>();
                for (Map.Entry<Relationship, Set<Connection>> entry : this.connections.entrySet()) {
                    if (!entry.getValue().contains(connection)) continue;
                    existingRelationships.add(entry.getKey());
                }
                for (Relationship relationship : connection.getRelationships()) {
                    Set<Connection> connectionsForRelationship;
                    if (existingRelationships.contains(relationship) || (connectionsForRelationship = this.getConnections(relationship)) == null || connectionsForRelationship.size() != 1 || !this.isRunning() || this.isAutoTerminated(relationship) || !this.getRelationships().contains(relationship)) continue;
                    throw new IllegalStateException("Cannot remove relationship " + relationship.getName() + " from Connection because doing so would invalidate Processor " + (Object)((Object)this) + ", which is currently running");
                }
                for (Set set : this.connections.values()) {
                    set.remove(connection);
                }
                for (Relationship relationship : connection.getRelationships()) {
                    Set<Connection> set = this.connections.get(relationship);
                    if (set == null) {
                        set = new HashSet<Connection>();
                        this.connections.put(relationship, set);
                    }
                    set.add(connection);
                }
                this.destinations.put(connection, connection.getDestination());
                Set<Relationship> autoTerminated = this.undefinedRelationshipsToTerminate.get();
                if (autoTerminated != null) {
                    autoTerminated.removeAll(connection.getRelationships());
                    this.undefinedRelationshipsToTerminate.set(autoTerminated);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (connection.getDestination().equals((Object)this)) {
            this.writeLock.lock();
            try {
                List<Connection> incomingConnections = this.incomingConnectionsRef.get();
                ArrayList<Connection> updatedIncoming = new ArrayList<Connection>(incomingConnections);
                updatedIncoming.remove(connection);
                updatedIncoming.add(connection);
                this.incomingConnectionsRef.set(Collections.unmodifiableList(updatedIncoming));
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connection) {
        boolean connectionRemoved = false;
        if (Objects.requireNonNull(connection).getSource().equals((Object)this)) {
            for (Relationship relationship : connection.getRelationships()) {
                Set<Connection> connectionsForRelationship = this.getConnections(relationship);
                if (connectionsForRelationship != null && connectionsForRelationship.size() > 1 || !this.isRunning()) continue;
                throw new IllegalStateException("This connection cannot be removed because its source is running and removing it will invalidate this processor");
            }
            this.writeLock.lock();
            try {
                for (Set set : this.connections.values()) {
                    set.remove(connection);
                }
                connectionRemoved = this.destinations.remove(connection) != null;
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (connection.getDestination().equals((Object)this)) {
            this.writeLock.lock();
            try {
                List<Connection> incomingConnections = this.incomingConnectionsRef.get();
                if (incomingConnections.contains(connection)) {
                    ArrayList<Connection> arrayList = new ArrayList<Connection>(incomingConnections);
                    arrayList.remove(connection);
                    this.incomingConnectionsRef.set(Collections.unmodifiableList(arrayList));
                    return;
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        if (!connectionRemoved) {
            throw new IllegalArgumentException("Cannot remove a connection from a ProcessorNode for which the ProcessorNode is not the Source");
        }
    }

    public Relationship getRelationship(String relationshipName) {
        Set relationships;
        Relationship specRel;
        Relationship returnRel = specRel = new Relationship.Builder().name(relationshipName).build();
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            relationships = this.processor.getRelationships();
        }
        for (Relationship rel : relationships) {
            if (!rel.equals((Object)specRel)) continue;
            returnRel = rel;
            break;
        }
        return returnRel;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Connectable> getDestinations() {
        HashSet<Connectable> nonSelfDestinations = new HashSet<Connectable>();
        this.readLock.lock();
        try {
            for (Connectable connectable : this.destinations.values()) {
                if (connectable == this) continue;
                nonSelfDestinations.add(connectable);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return nonSelfDestinations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Connectable> getDestinations(Relationship relationship) {
        this.readLock.lock();
        try {
            HashSet<Connectable> destinationSet = new HashSet<Connectable>();
            Set<Connection> relationshipConnections = this.connections.get(relationship);
            if (relationshipConnections != null) {
                for (Connection connection : relationshipConnections) {
                    destinationSet.add(this.destinations.get(connection));
                }
            }
            HashSet<Connectable> hashSet = destinationSet;
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Relationship> getUndefinedRelationships() {
        HashSet<Relationship> undefined = new HashSet<Relationship>();
        this.readLock.lock();
        try {
            Set relationships;
            try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                relationships = this.processor.getRelationships();
            }
            if (relationships == null) {
                HashSet<Relationship> hashSet = undefined;
                return hashSet;
            }
            for (Relationship relation : relationships) {
                Set<Connection> connectionSet = this.connections.get(relation);
                if (connectionSet != null && !connectionSet.isEmpty()) continue;
                undefined.add(relation);
            }
        }
        finally {
            this.readLock.unlock();
        }
        return undefined;
    }

    boolean isRelated(ProcessorNode node) {
        this.readLock.lock();
        try {
            boolean bl = this.destinations.containsValue(node);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isRunning() {
        this.readLock.lock();
        try {
            boolean bl = this.getScheduledState().equals((Object)ScheduledState.RUNNING) || this.processScheduler.getActiveThreadCount((Object)this) > 0;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getActiveThreadCount() {
        this.readLock.lock();
        try {
            int n = this.processScheduler.getActiveThreadCount((Object)this);
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    List<Connection> getIncomingNonLoopConnections() {
        List<Connection> connections = this.getIncomingConnections();
        ArrayList<Connection> nonLoopConnections = new ArrayList<Connection>(connections.size());
        for (Connection connection : connections) {
            if (connection.getSource().equals((Object)this)) continue;
            nonLoopConnections.add(connection);
        }
        return nonLoopConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isValid() {
        this.readLock.lock();
        try {
            Collection validationResults;
            ValidationContext validationContext = this.validationContextFactory.newValidationContext(this.getProperties(), this.getAnnotationData());
            try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                validationResults = this.getProcessor().validate(validationContext);
            }
            for (ValidationResult result : validationResults) {
                if (result.isValid()) continue;
                boolean bl = false;
                return bl;
            }
            for (Relationship undef : this.getUndefinedRelationships()) {
                if (this.isAutoTerminated(undef)) continue;
                boolean bl = false;
                return bl;
            }
            switch (this.getInputRequirement()) {
                case INPUT_ALLOWED: {
                    return true;
                }
                case INPUT_FORBIDDEN: {
                    if (this.getIncomingNonLoopConnections().isEmpty()) return true;
                    boolean bl = false;
                    return bl;
                }
                case INPUT_REQUIRED: {
                    if (!this.getIncomingNonLoopConnections().isEmpty()) return true;
                    boolean bl = false;
                    return bl;
                }
            }
            return true;
        }
        catch (Throwable t) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<ValidationResult> getValidationErrors() {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        this.readLock.lock();
        try {
            Collection validationResults;
            ValidationContext validationContext = this.validationContextFactory.newValidationContext(this.getProperties(), this.getAnnotationData());
            try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                validationResults = this.getProcessor().validate(validationContext);
            }
            for (ValidationResult result : validationResults) {
                if (result.isValid()) continue;
                results.add(result);
            }
            for (Relationship relationship : this.getUndefinedRelationships()) {
                if (this.isAutoTerminated(relationship)) continue;
                ValidationResult error = new ValidationResult.Builder().explanation("Relationship '" + relationship.getName() + "' is not connected to any component and is not auto-terminated").subject("Relationship " + relationship.getName()).valid(false).build();
                results.add(error);
            }
            switch (this.getInputRequirement()) {
                case INPUT_ALLOWED: {
                    return results;
                }
                case INPUT_FORBIDDEN: {
                    int incomingConnCount = this.getIncomingNonLoopConnections().size();
                    if (incomingConnCount == 0) return results;
                    results.add(new ValidationResult.Builder().explanation("Processor does not allow upstream connections but currently has " + incomingConnCount).subject("Upstream Connections").valid(false).build());
                    return results;
                }
                case INPUT_REQUIRED: {
                    if (!this.getIncomingNonLoopConnections().isEmpty()) return results;
                    results.add(new ValidationResult.Builder().explanation("Processor requires an upstream connection but currently has none").subject("Upstream Connections").valid(false).build());
                    return results;
                }
            }
            return results;
        }
        catch (Throwable t) {
            results.add(new ValidationResult.Builder().explanation("Failed to run validation due to " + t.toString()).valid(false).build());
            return results;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public InputRequirement.Requirement getInputRequirement() {
        return this.inputRequirement;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ProcessorNode)) {
            return false;
        }
        ProcessorNode on = (ProcessorNode)other;
        return new EqualsBuilder().append((Object)this.identifier.get(), (Object)on.getIdentifier()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 67).append(this.identifier).toHashCode();
    }

    public Collection<Relationship> getRelationships() {
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            Set set = this.getProcessor().getRelationships();
            return set;
        }
    }

    public String toString() {
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            String string = this.getProcessor().toString();
            return string;
        }
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    public void setProcessGroup(ProcessGroup group) {
        this.writeLock.lock();
        try {
            this.processGroup.set(group);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) {
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            this.processor.onTrigger(context, sessionFactory);
        }
    }

    public ConnectableType getConnectableType() {
        return ConnectableType.PROCESSOR;
    }

    public void setScheduledState(ScheduledState scheduledState) {
        this.scheduledState.set(scheduledState);
        if (!scheduledState.equals((Object)ScheduledState.RUNNING)) {
            this.yieldExpiration.set(0L);
        }
    }

    public void setAnnotationData(String data) {
        this.writeLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException("Cannot set AnnotationData while processor is running");
            }
            this.annotationData.set(data);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String getAnnotationData() {
        return this.annotationData.get();
    }

    public Collection<ValidationResult> validate(ValidationContext validationContext) {
        return this.getValidationErrors();
    }

    public void verifyCanDelete() throws IllegalStateException {
        this.verifyCanDelete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(boolean ignoreConnections) {
        this.readLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException((Object)((Object)this) + " is running");
            }
            if (!ignoreConnections) {
                for (Set<Connection> connectionSet : this.connections.values()) {
                    for (Connection connection : connectionSet) {
                        connection.verifyCanDelete();
                    }
                }
                for (Connection connection : this.incomingConnectionsRef.get()) {
                    if (connection.getSource().equals((Object)this)) {
                        connection.verifyCanDelete();
                        continue;
                    }
                    throw new IllegalStateException((Object)((Object)this) + " is the destination of another component");
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStart() {
        this.readLock.lock();
        try {
            switch (this.getScheduledState()) {
                case DISABLED: {
                    throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is disabled");
                }
                case RUNNING: {
                    throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is already running");
                }
            }
            this.verifyNoActiveThreads();
            if (!this.isValid()) {
                throw new IllegalStateException((Object)((Object)this) + " is not in a valid state");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStart(Set<ControllerServiceNode> ignoredReferences) {
        switch (this.getScheduledState()) {
            case DISABLED: {
                throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is disabled");
            }
            case RUNNING: {
                throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is already running");
            }
        }
        this.verifyNoActiveThreads();
        HashSet<String> ids = new HashSet<String>();
        for (ControllerServiceNode node : ignoredReferences) {
            ids.add(node.getIdentifier());
        }
        Collection validationResults = this.getValidationErrors(ids);
        for (ValidationResult result : validationResults) {
            if (result.isValid()) continue;
            throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is not valid: " + result);
        }
    }

    public void verifyCanStop() {
        if (this.getScheduledState() != ScheduledState.RUNNING) {
            throw new IllegalStateException((Object)((Object)this) + " is not scheduled to run");
        }
    }

    public void verifyCanUpdate() {
        this.readLock.lock();
        try {
            if (this.isRunning()) {
                throw new IllegalStateException((Object)((Object)this) + " is not stopped");
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanEnable() {
        this.readLock.lock();
        try {
            if (this.getScheduledState() != ScheduledState.DISABLED) {
                throw new IllegalStateException((Object)((Object)this) + " is not disabled");
            }
            this.verifyNoActiveThreads();
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanDisable() {
        this.readLock.lock();
        try {
            if (this.getScheduledState() != ScheduledState.STOPPED) {
                throw new IllegalStateException((Object)((Object)this) + " is not stopped");
            }
            this.verifyNoActiveThreads();
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void verifyNoActiveThreads() throws IllegalStateException {
        int threadCount = this.processScheduler.getActiveThreadCount((Object)this);
        if (threadCount > 0) {
            throw new IllegalStateException((Object)((Object)this) + " has " + threadCount + " threads still active");
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
    }
}

