/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;

public class ComponentStatusReport {
    private final Map<String, ProcessGroupStatus> groupMap = new HashMap<String, ProcessGroupStatus>();
    private final Map<String, ProcessorStatus> processorMap = new HashMap<String, ProcessorStatus>();
    private final Map<String, ConnectionStatus> connectionMap = new HashMap<String, ConnectionStatus>();
    private final Map<String, RemoteProcessGroupStatus> remoteGroupMap = new HashMap<String, RemoteProcessGroupStatus>();
    private final Map<String, PortStatus> inputPortMap = new HashMap<String, PortStatus>();
    private final Map<String, PortStatus> outputPortMap = new HashMap<String, PortStatus>();

    private ComponentStatusReport() {
    }

    public static ComponentStatusReport createEmpty() {
        return new ComponentStatusReport();
    }

    public static ComponentStatusReport fromProcessGroupStatus(ProcessGroupStatus status) {
        return ComponentStatusReport.fromProcessGroupStatus(status, ComponentType.values());
    }

    public static ComponentStatusReport fromProcessGroupStatus(ProcessGroupStatus status, ComponentType ... componentTypes) {
        HashSet<ComponentType> componentTypeSet = new HashSet<ComponentType>();
        for (ComponentType type : componentTypes) {
            componentTypeSet.add(type);
        }
        ComponentStatusReport report = new ComponentStatusReport();
        report.populate(status, componentTypeSet);
        return report;
    }

    private void populate(ProcessGroupStatus status, Set<ComponentType> componentTypes) {
        if (componentTypes.contains((Object)ComponentType.PROCESS_GROUP)) {
            this.groupMap.put(status.getId(), status);
        }
        if (componentTypes.contains((Object)ComponentType.PROCESSOR)) {
            for (ProcessorStatus procStatus : status.getProcessorStatus()) {
                this.processorMap.put(procStatus.getId(), procStatus);
            }
        }
        if (componentTypes.contains((Object)ComponentType.CONNECTION)) {
            for (ConnectionStatus connStatus : status.getConnectionStatus()) {
                this.connectionMap.put(connStatus.getId(), connStatus);
            }
        }
        if (componentTypes.contains((Object)ComponentType.REMOTE_PROCESS_GROUP)) {
            for (RemoteProcessGroupStatus rpgStatus : status.getRemoteProcessGroupStatus()) {
                this.remoteGroupMap.put(rpgStatus.getId(), rpgStatus);
            }
        }
        if (componentTypes.contains((Object)ComponentType.INPUT_PORT)) {
            for (PortStatus portStatus : status.getInputPortStatus()) {
                this.inputPortMap.put(portStatus.getId(), portStatus);
            }
        }
        if (componentTypes.contains((Object)ComponentType.OUTPUT_PORT)) {
            for (PortStatus portStatus : status.getOutputPortStatus()) {
                this.outputPortMap.put(portStatus.getId(), portStatus);
            }
        }
        for (ProcessGroupStatus childStatus : status.getProcessGroupStatus()) {
            this.populate(childStatus, componentTypes);
        }
    }

    public ProcessGroupStatus getProcessGroupStatus(String groupId) {
        return this.groupMap.get(groupId);
    }

    public ProcessorStatus getProcessorStatus(String processorId) {
        return this.processorMap.get(processorId);
    }

    public ConnectionStatus getConnectionStatus(String connectionId) {
        return this.connectionMap.get(connectionId);
    }

    public RemoteProcessGroupStatus getRemoteProcessGroupStatus(String remoteGroupId) {
        return this.remoteGroupMap.get(remoteGroupId);
    }

    public PortStatus getInputPortStatus(String portId) {
        return this.inputPortMap.get(portId);
    }

    public PortStatus getOutputPortStatus(String portId) {
        return this.outputPortMap.get(portId);
    }

    public static enum ComponentType {
        PROCESSOR,
        INPUT_PORT,
        OUTPUT_PORT,
        PROCESS_GROUP,
        CONNECTION,
        REMOTE_PROCESS_GROUP;

    }
}

