/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.claim;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardResourceClaim;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardResourceClaimManager
implements ResourceClaimManager {
    private static final ConcurrentMap<ResourceClaim, AtomicInteger> claimantCounts = new ConcurrentHashMap<ResourceClaim, AtomicInteger>();
    private static final Logger logger = LoggerFactory.getLogger(StandardResourceClaimManager.class);
    private static final BlockingQueue<ResourceClaim> destructableClaims = new LinkedBlockingQueue<ResourceClaim>(50000);

    public ResourceClaim newResourceClaim(String container, String section, String id, boolean lossTolerant) {
        return new StandardResourceClaim(container, section, id, lossTolerant);
    }

    private static AtomicInteger getCounter(ResourceClaim claim) {
        if (claim == null) {
            return null;
        }
        AtomicInteger counter = (AtomicInteger)claimantCounts.get(claim);
        if (counter != null) {
            return counter;
        }
        counter = new AtomicInteger(0);
        AtomicInteger existingCounter = claimantCounts.putIfAbsent(claim, counter);
        return existingCounter == null ? counter : existingCounter;
    }

    public int getClaimantCount(ResourceClaim claim) {
        if (claim == null) {
            return 0;
        }
        AtomicInteger counter = (AtomicInteger)claimantCounts.get(claim);
        return counter == null ? 0 : counter.get();
    }

    public int decrementClaimantCount(ResourceClaim claim) {
        if (claim == null) {
            return 0;
        }
        AtomicInteger counter = (AtomicInteger)claimantCounts.get(claim);
        if (counter == null) {
            logger.debug("Decrementing claimant count for {} but claimant count is not known. Returning -1", (Object)claim);
            return -1;
        }
        int newClaimantCount = counter.decrementAndGet();
        logger.debug("Decrementing claimant count for {} to {}", (Object)claim, (Object)newClaimantCount);
        if (newClaimantCount == 0) {
            claimantCounts.remove(claim);
        }
        return newClaimantCount;
    }

    public int incrementClaimantCount(ResourceClaim claim) {
        return this.incrementClaimantCount(claim, false);
    }

    public int incrementClaimantCount(ResourceClaim claim, boolean newClaim) {
        AtomicInteger counter = StandardResourceClaimManager.getCounter(claim);
        int newClaimantCount = counter.incrementAndGet();
        logger.debug("Incrementing claimant count for {} to {}", (Object)claim, (Object)newClaimantCount);
        if (!newClaim && newClaimantCount == 1) {
            destructableClaims.remove(claim);
        }
        return newClaimantCount;
    }

    public void markDestructable(ResourceClaim claim) {
        if (claim == null) {
            return;
        }
        if (this.getClaimantCount(claim) > 0) {
            return;
        }
        logger.debug("Marking claim {} as destructable", (Object)claim);
        try {
            while (!destructableClaims.offer(claim, 30L, TimeUnit.MINUTES)) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void drainDestructableClaims(Collection<ResourceClaim> destination, int maxElements) {
        int drainedCount = destructableClaims.drainTo(destination, maxElements);
        logger.debug("Drained {} destructable claims to {}", (Object)drainedCount, destination);
    }

    public void drainDestructableClaims(Collection<ResourceClaim> destination, int maxElements, long timeout, TimeUnit unit) {
        try {
            ResourceClaim firstClaim = destructableClaims.poll(timeout, unit);
            if (firstClaim != null) {
                destination.add(firstClaim);
                destructableClaims.drainTo(destination, maxElements - 1);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void purge() {
        claimantCounts.clear();
    }
}

