/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.controller.DropFlowFileRequest;
import org.apache.nifi.controller.Heartbeater;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.queue.DropFlowFileState;
import org.apache.nifi.controller.queue.DropFlowFileStatus;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileSummary;
import org.apache.nifi.controller.queue.ListFlowFileRequest;
import org.apache.nifi.controller.queue.ListFlowFileState;
import org.apache.nifi.controller.queue.ListFlowFileStatus;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.swap.StandardSwapSummary;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.provenance.ProvenanceEventBuilder;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.concurrency.TimedLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardFlowFileQueue
implements FlowFileQueue {
    public static final int MAX_EXPIRED_RECORDS_PER_ITERATION = 100000;
    public static final int SWAP_RECORD_POLL_SIZE = 10000;
    private static final Logger logger = LoggerFactory.getLogger(StandardFlowFileQueue.class);
    private PriorityQueue<FlowFileRecord> activeQueue = null;
    private ArrayList<FlowFileRecord> swapQueue = null;
    private final AtomicReference<FlowFileQueueSize> size = new AtomicReference<FlowFileQueueSize>(new FlowFileQueueSize(0, 0L, 0, 0L, 0, 0, 0L));
    private boolean swapMode = false;
    private final AtomicReference<MaxQueueSize> maxQueueSize = new AtomicReference<MaxQueueSize>(new MaxQueueSize("0 MB", 0L, 0L));
    private final AtomicReference<TimePeriod> expirationPeriod = new AtomicReference<TimePeriod>(new TimePeriod("0 mins", 0L));
    private final EventReporter eventReporter;
    private final Connection connection;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);
    private final List<FlowFilePrioritizer> priorities;
    private final int swapThreshold;
    private final FlowFileSwapManager swapManager;
    private final List<String> swapLocations = new ArrayList<String>();
    private final TimedLock readLock;
    private final TimedLock writeLock;
    private final String identifier;
    private final FlowFileRepository flowFileRepository;
    private final ProvenanceEventRepository provRepository;
    private final ResourceClaimManager resourceClaimManager;
    private final Heartbeater heartbeater;
    private final ConcurrentMap<String, DropFlowFileRequest> dropRequestMap = new ConcurrentHashMap<String, DropFlowFileRequest>();
    private final ConcurrentMap<String, ListFlowFileRequest> listRequestMap = new ConcurrentHashMap<String, ListFlowFileRequest>();
    private final ProcessScheduler scheduler;

    public StandardFlowFileQueue(String identifier, Connection connection, FlowFileRepository flowFileRepo, ProvenanceEventRepository provRepo, ResourceClaimManager resourceClaimManager, ProcessScheduler scheduler, FlowFileSwapManager swapManager, EventReporter eventReporter, int swapThreshold, Heartbeater heartbeater) {
        this.activeQueue = new PriorityQueue<FlowFileRecord>(20, new Prioritizer(new ArrayList()));
        this.priorities = new ArrayList<FlowFilePrioritizer>();
        this.swapQueue = new ArrayList();
        this.eventReporter = eventReporter;
        this.swapManager = swapManager;
        this.flowFileRepository = flowFileRepo;
        this.provRepository = provRepo;
        this.resourceClaimManager = resourceClaimManager;
        this.identifier = identifier;
        this.swapThreshold = swapThreshold;
        this.scheduler = scheduler;
        this.connection = connection;
        this.heartbeater = heartbeater;
        this.readLock = new TimedLock((Lock)this.lock.readLock(), identifier + " Read Lock", 100);
        this.writeLock = new TimedLock((Lock)this.lock.writeLock(), identifier + " Write Lock", 100);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public List<FlowFilePrioritizer> getPriorities() {
        return Collections.unmodifiableList(this.priorities);
    }

    public void setPriorities(List<FlowFilePrioritizer> newPriorities) {
        this.writeLock.lock();
        try {
            PriorityQueue<FlowFileRecord> newQueue = new PriorityQueue<FlowFileRecord>(Math.max(20, this.activeQueue.size()), new Prioritizer(newPriorities));
            newQueue.addAll(this.activeQueue);
            this.activeQueue = newQueue;
            this.priorities.clear();
            this.priorities.addAll(newPriorities);
        }
        finally {
            this.writeLock.unlock("setPriorities");
        }
    }

    public void setBackPressureObjectThreshold(long threshold) {
        boolean updated = false;
        while (!updated) {
            MaxQueueSize maxSize = this.maxQueueSize.get();
            MaxQueueSize updatedSize = new MaxQueueSize(maxSize.getMaxSize(), maxSize.getMaxBytes(), threshold);
            updated = this.maxQueueSize.compareAndSet(maxSize, updatedSize);
        }
    }

    public long getBackPressureObjectThreshold() {
        return this.maxQueueSize.get().getMaxCount();
    }

    public void setBackPressureDataSizeThreshold(String maxDataSize) {
        long maxBytes = DataUnit.parseDataSize((String)maxDataSize, (DataUnit)DataUnit.B).longValue();
        boolean updated = false;
        while (!updated) {
            MaxQueueSize maxSize = this.maxQueueSize.get();
            MaxQueueSize updatedSize = new MaxQueueSize(maxDataSize, maxBytes, maxSize.getMaxCount());
            updated = this.maxQueueSize.compareAndSet(maxSize, updatedSize);
        }
    }

    public String getBackPressureDataSizeThreshold() {
        return this.maxQueueSize.get().getMaxSize();
    }

    public QueueSize size() {
        return this.getQueueSize();
    }

    private QueueSize getQueueSize() {
        return this.size.get().toQueueSize();
    }

    public boolean isEmpty() {
        return this.size.get().isEmpty();
    }

    public boolean isActiveQueueEmpty() {
        FlowFileQueueSize queueSize = this.size.get();
        return queueSize.activeQueueCount == 0 && queueSize.swappedCount == 0;
    }

    public QueueSize getActiveQueueSize() {
        return this.size.get().activeQueueSize();
    }

    public void acknowledge(FlowFileRecord flowFile) {
        this.incrementUnacknowledgedQueueSize(-1, -flowFile.getSize());
        if (this.connection.getSource().getSchedulingStrategy() == SchedulingStrategy.EVENT_DRIVEN) {
            this.scheduler.registerEvent(this.connection.getSource());
        }
    }

    public void acknowledge(Collection<FlowFileRecord> flowFiles) {
        long totalSize = 0L;
        for (FlowFileRecord flowFile : flowFiles) {
            totalSize += flowFile.getSize();
        }
        this.incrementUnacknowledgedQueueSize(-flowFiles.size(), -totalSize);
        if (this.connection.getSource().getSchedulingStrategy() == SchedulingStrategy.EVENT_DRIVEN) {
            this.scheduler.registerEvent(this.connection.getSource());
        }
    }

    public boolean isFull() {
        MaxQueueSize maxSize = this.maxQueueSize.get();
        if (maxSize.getMaxBytes() <= 0L && maxSize.getMaxCount() <= 0L) {
            return false;
        }
        QueueSize queueSize = this.getQueueSize();
        if (maxSize.getMaxCount() > 0L && (long)queueSize.getObjectCount() >= maxSize.getMaxCount()) {
            return true;
        }
        return maxSize.getMaxBytes() > 0L && queueSize.getByteCount() >= maxSize.getMaxBytes();
    }

    public void put(FlowFileRecord file) {
        this.writeLock.lock();
        try {
            if (this.swapMode || this.activeQueue.size() >= this.swapThreshold) {
                this.swapQueue.add(file);
                this.incrementSwapQueueSize(1, file.getSize(), 0);
                this.swapMode = true;
                this.writeSwapFilesIfNecessary();
            } else {
                this.incrementActiveQueueSize(1, file.getSize());
                this.activeQueue.add(file);
            }
        }
        finally {
            this.writeLock.unlock("put(FlowFileRecord)");
        }
        if (this.connection.getDestination().getSchedulingStrategy() == SchedulingStrategy.EVENT_DRIVEN) {
            this.scheduler.registerEvent(this.connection.getDestination());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Collection<FlowFileRecord> files) {
        int numFiles = files.size();
        long bytes = 0L;
        for (FlowFile flowFile : files) {
            bytes += flowFile.getSize();
        }
        this.writeLock.lock();
        try {
            if (this.swapMode || this.activeQueue.size() >= this.swapThreshold - numFiles) {
                this.swapQueue.addAll(files);
                this.incrementSwapQueueSize(numFiles, bytes, 0);
                this.swapMode = true;
                this.writeSwapFilesIfNecessary();
            } else {
                this.incrementActiveQueueSize(numFiles, bytes);
                this.activeQueue.addAll(files);
            }
        }
        finally {
            this.writeLock.unlock("putAll");
        }
        if (this.connection.getDestination().getSchedulingStrategy() == SchedulingStrategy.EVENT_DRIVEN) {
            this.scheduler.registerEvent(this.connection.getDestination());
        }
    }

    private boolean isLaterThan(Long maxAge) {
        if (maxAge == null) {
            return false;
        }
        return maxAge < System.currentTimeMillis();
    }

    private Long getExpirationDate(FlowFile flowFile, long expirationMillis) {
        if (flowFile == null) {
            return null;
        }
        if (expirationMillis <= 0L) {
            return null;
        }
        long entryDate = flowFile.getEntryDate();
        long expirationDate = entryDate + expirationMillis;
        return expirationDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowFileRecord poll(Set<FlowFileRecord> expiredRecords) {
        FlowFileRecord flowFile = null;
        long expirationMillis = this.expirationPeriod.get().getMillis();
        this.writeLock.lock();
        try {
            FlowFileRecord flowFileRecord = flowFile = this.doPoll(expiredRecords, expirationMillis);
            return flowFileRecord;
        }
        finally {
            this.writeLock.unlock("poll(Set)");
            if (flowFile != null) {
                this.incrementUnacknowledgedQueueSize(1, flowFile.getSize());
            }
        }
    }

    private FlowFileRecord doPoll(Set<FlowFileRecord> expiredRecords, long expirationMillis) {
        FlowFileRecord flowFile;
        boolean isExpired;
        this.migrateSwapToActive();
        long expiredBytes = 0L;
        do {
            if (isExpired = this.isLaterThan(this.getExpirationDate((FlowFile)(flowFile = this.activeQueue.poll()), expirationMillis))) {
                expiredRecords.add(flowFile);
                expiredBytes += flowFile.getSize();
                flowFile = null;
                if (expiredRecords.size() >= 100000) {
                    break;
                }
            } else if (flowFile != null && flowFile.isPenalized()) {
                this.activeQueue.add(flowFile);
                flowFile = null;
                break;
            }
            if (flowFile == null) continue;
            this.incrementActiveQueueSize(-1, -flowFile.getSize());
        } while (isExpired);
        if (!expiredRecords.isEmpty()) {
            this.incrementActiveQueueSize(-expiredRecords.size(), -expiredBytes);
        }
        return flowFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowFileRecord> poll(int maxResults, Set<FlowFileRecord> expiredRecords) {
        ArrayList<FlowFileRecord> records = new ArrayList<FlowFileRecord>(Math.min(1024, maxResults));
        this.writeLock.lock();
        try {
            this.doPoll(records, maxResults, expiredRecords);
        }
        finally {
            this.writeLock.unlock("poll(int, Set)");
        }
        return records;
    }

    private void doPoll(List<FlowFileRecord> records, int maxResults, Set<FlowFileRecord> expiredRecords) {
        this.migrateSwapToActive();
        long bytesDrained = this.drainQueue(this.activeQueue, records, maxResults, expiredRecords);
        long expiredBytes = 0L;
        for (FlowFileRecord record : expiredRecords) {
            expiredBytes += record.getSize();
        }
        this.incrementActiveQueueSize(-(expiredRecords.size() + records.size()), -bytesDrained);
        this.incrementUnacknowledgedQueueSize(records.size(), bytesDrained - expiredBytes);
    }

    private void migrateSwapToActive() {
        if (this.activeQueue.size() > this.swapThreshold - 10000) {
            return;
        }
        if (!this.swapLocations.isEmpty()) {
            String swapLocation = this.swapLocations.remove(0);
            try {
                List swappedIn = this.swapManager.swapIn(swapLocation, (FlowFileQueue)this);
                long swapSize = 0L;
                for (FlowFileRecord flowFile : swappedIn) {
                    swapSize += flowFile.getSize();
                }
                this.incrementSwapQueueSize(-swappedIn.size(), -swapSize, -1);
                this.incrementActiveQueueSize(swappedIn.size(), swapSize);
                this.activeQueue.addAll(swappedIn);
                return;
            }
            catch (FileNotFoundException fnfe) {
                logger.error("Failed to swap in FlowFiles from Swap File {} because the Swap File can no longer be found", (Object)swapLocation);
                if (this.eventReporter != null) {
                    this.eventReporter.reportEvent(Severity.ERROR, "Swap File", "Failed to swap in FlowFiles from Swap File " + swapLocation + " because the Swap File can no longer be found");
                }
                return;
            }
            catch (IOException ioe) {
                logger.error("Failed to swap in FlowFiles from Swap File {}; Swap File appears to be corrupt!", (Object)swapLocation);
                logger.error("", (Throwable)ioe);
                if (this.eventReporter != null) {
                    this.eventReporter.reportEvent(Severity.ERROR, "Swap File", "Failed to swap in FlowFiles from Swap File " + swapLocation + "; Swap File appears to be corrupt! Some FlowFiles in the queue may not be accessible. See logs for more information.");
                }
                return;
            }
        }
        if (this.size.get().swappedCount == 0 && this.swapQueue.isEmpty()) {
            return;
        }
        if (this.size.get().swappedCount > this.swapQueue.size()) {
            return;
        }
        int recordsMigrated = 0;
        long bytesMigrated = 0L;
        Iterator<FlowFileRecord> swapItr = this.swapQueue.iterator();
        while (this.activeQueue.size() < this.swapThreshold && swapItr.hasNext()) {
            FlowFileRecord toMigrate = swapItr.next();
            this.activeQueue.add(toMigrate);
            bytesMigrated += toMigrate.getSize();
            ++recordsMigrated;
            swapItr.remove();
        }
        if (recordsMigrated > 0) {
            this.incrementActiveQueueSize(recordsMigrated, bytesMigrated);
            this.incrementSwapQueueSize(-recordsMigrated, -bytesMigrated, 0);
        }
        if (this.size.get().swappedCount == 0) {
            this.swapMode = false;
        }
    }

    private void writeSwapFilesIfNecessary() {
        FlowFileRecord toRequeue;
        if (this.swapQueue.size() < 10000) {
            return;
        }
        int numSwapFiles = this.swapQueue.size() / 10000;
        int originalSwapQueueCount = this.swapQueue.size();
        long originalSwapQueueBytes = 0L;
        for (FlowFileRecord flowFile : this.swapQueue) {
            originalSwapQueueBytes += flowFile.getSize();
        }
        PriorityQueue<FlowFileRecord> tempQueue = new PriorityQueue<FlowFileRecord>(this.activeQueue.size() + this.swapQueue.size(), Collections.reverseOrder(new Prioritizer(this.priorities)));
        tempQueue.addAll(this.activeQueue);
        tempQueue.addAll(this.swapQueue);
        long bytesSwappedOut = 0L;
        int flowFilesSwappedOut = 0;
        ArrayList<String> swapLocations = new ArrayList<String>(numSwapFiles);
        for (int i = 0; i < numSwapFiles; ++i) {
            ArrayList<FlowFileRecord> toSwap = new ArrayList<FlowFileRecord>(10000);
            for (int j = 0; j < 10000; ++j) {
                FlowFileRecord flowFile = tempQueue.poll();
                toSwap.add(flowFile);
                bytesSwappedOut += flowFile.getSize();
                ++flowFilesSwappedOut;
            }
            try {
                Collections.reverse(toSwap);
                String swapLocation = this.swapManager.swapOut(toSwap, (FlowFileQueue)this);
                swapLocations.add(swapLocation);
                continue;
            }
            catch (IOException ioe) {
                tempQueue.addAll(toSwap);
                logger.error("FlowFile Queue with identifier {} has {} FlowFiles queued up. Attempted to spill FlowFile information over to disk in order to avoid exhausting the Java heap space but failed to write information to disk due to {}", new Object[]{this.getIdentifier(), this.getQueueSize().getObjectCount(), ioe.toString()});
                logger.error("", (Throwable)ioe);
                if (this.eventReporter == null) break;
                this.eventReporter.reportEvent(Severity.ERROR, "Failed to Overflow to Disk", "Flowfile Queue with identifier " + this.getIdentifier() + " has " + this.getQueueSize().getObjectCount() + " queued up. Attempted to spill FlowFile information over to disk in order to avoid exhausting the Java heap space but failed to write information to disk. " + "See logs for more information.");
                break;
            }
        }
        this.swapQueue.clear();
        long updatedSwapQueueBytes = 0L;
        while (tempQueue.size() > this.swapThreshold) {
            FlowFileRecord record = tempQueue.poll();
            this.swapQueue.add(record);
            updatedSwapQueueBytes += record.getSize();
        }
        Collections.reverse(this.swapQueue);
        this.activeQueue.clear();
        long activeQueueBytes = 0L;
        while ((toRequeue = tempQueue.poll()) != null) {
            this.activeQueue.offer(toRequeue);
            activeQueueBytes += toRequeue.getSize();
        }
        boolean updated = false;
        while (!updated) {
            FlowFileQueueSize originalSize = this.size.get();
            int addedSwapRecords = this.swapQueue.size() - originalSwapQueueCount;
            long addedSwapBytes = updatedSwapQueueBytes - originalSwapQueueBytes;
            FlowFileQueueSize newSize = new FlowFileQueueSize(this.activeQueue.size(), activeQueueBytes, originalSize.swappedCount + addedSwapRecords + flowFilesSwappedOut, originalSize.swappedBytes + addedSwapBytes + bytesSwappedOut, originalSize.swapFiles + numSwapFiles, originalSize.unacknowledgedCount, originalSize.unacknowledgedBytes);
            updated = this.size.compareAndSet(originalSize, newSize);
        }
        this.swapLocations.addAll(swapLocations);
    }

    public long drainQueue(Queue<FlowFileRecord> sourceQueue, List<FlowFileRecord> destination, int maxResults, Set<FlowFileRecord> expiredRecords) {
        long drainedSize = 0L;
        FlowFileRecord pulled = null;
        long expirationMillis = this.expirationPeriod.get().getMillis();
        while (destination.size() < maxResults && (pulled = sourceQueue.poll()) != null) {
            if (this.isLaterThan(this.getExpirationDate((FlowFile)pulled, expirationMillis))) {
                expiredRecords.add(pulled);
                if (expiredRecords.size() >= 100000) {
                    break;
                }
            } else {
                if (pulled.isPenalized()) {
                    sourceQueue.add(pulled);
                    break;
                }
                destination.add(pulled);
            }
            drainedSize += pulled.getSize();
        }
        return drainedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords) {
        long bytesPulled = 0L;
        int flowFilesPulled = 0;
        this.writeLock.lock();
        try {
            FlowFileRecord flowFile;
            this.migrateSwapToActive();
            long expirationMillis = this.expirationPeriod.get().getMillis();
            ArrayList<FlowFileRecord> selectedFlowFiles = new ArrayList<FlowFileRecord>();
            ArrayList<FlowFileRecord> unselected = new ArrayList<FlowFileRecord>();
            while ((flowFile = this.activeQueue.poll()) != null) {
                boolean isExpired = this.isLaterThan(this.getExpirationDate((FlowFile)flowFile, expirationMillis));
                if (isExpired) {
                    expiredRecords.add(flowFile);
                    bytesPulled += flowFile.getSize();
                    ++flowFilesPulled;
                    if (expiredRecords.size() < 100000) continue;
                    break;
                }
                if (flowFile.isPenalized()) {
                    this.activeQueue.add(flowFile);
                    flowFile = null;
                    break;
                }
                FlowFileFilter.FlowFileFilterResult result = filter.filter((FlowFile)flowFile);
                if (result.isAccept()) {
                    bytesPulled += flowFile.getSize();
                    ++flowFilesPulled;
                    this.incrementUnacknowledgedQueueSize(1, flowFile.getSize());
                    selectedFlowFiles.add(flowFile);
                } else {
                    unselected.add(flowFile);
                }
                if (result.isContinue()) continue;
                break;
            }
            this.activeQueue.addAll(unselected);
            this.incrementActiveQueueSize(-flowFilesPulled, -bytesPulled);
            ArrayList<FlowFileRecord> arrayList = selectedFlowFiles;
            return arrayList;
        }
        finally {
            this.writeLock.unlock("poll(Filter, Set)");
        }
    }

    public String getFlowFileExpiration() {
        return this.expirationPeriod.get().getPeriod();
    }

    public int getFlowFileExpiration(TimeUnit timeUnit) {
        return (int)timeUnit.convert(this.expirationPeriod.get().getMillis(), TimeUnit.MILLISECONDS);
    }

    public void setFlowFileExpiration(String flowExpirationPeriod) {
        long millis = FormatUtils.getTimeDuration((String)flowExpirationPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
        if (millis < 0L) {
            throw new IllegalArgumentException("FlowFile Expiration Period must be positive");
        }
        this.expirationPeriod.set(new TimePeriod(flowExpirationPeriod, millis));
    }

    public void purgeSwapFiles() {
        this.swapManager.purge();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SwapSummary recoverSwappedFlowFiles() {
        int swapFlowFileCount = 0;
        long swapByteCount = 0L;
        Long maxId = null;
        ArrayList<ResourceClaim> resourceClaims = new ArrayList<ResourceClaim>();
        this.writeLock.lock();
        try {
            List swapLocations;
            try {
                swapLocations = this.swapManager.recoverSwapLocations((FlowFileQueue)this);
            }
            catch (IOException ioe) {
                logger.error("Failed to determine whether or not any Swap Files exist for FlowFile Queue {}", (Object)this.getIdentifier());
                logger.error("", (Throwable)ioe);
                if (this.eventReporter != null) {
                    this.eventReporter.reportEvent(Severity.ERROR, "FlowFile Swapping", "Failed to determine whether or not any Swap Files exist for FlowFile Queue " + this.getIdentifier() + "; see logs for more detials");
                }
                SwapSummary swapSummary = null;
                this.writeLock.unlock("Recover Swap Files");
                return swapSummary;
            }
            for (String swapLocation : swapLocations) {
                try {
                    SwapSummary summary = this.swapManager.getSwapSummary(swapLocation);
                    QueueSize queueSize = summary.getQueueSize();
                    Long maxSwapRecordId = summary.getMaxFlowFileId();
                    if (maxSwapRecordId != null && (maxId == null || maxSwapRecordId > maxId)) {
                        maxId = maxSwapRecordId;
                    }
                    swapFlowFileCount += queueSize.getObjectCount();
                    swapByteCount += queueSize.getByteCount();
                    resourceClaims.addAll(summary.getResourceClaims());
                }
                catch (IOException ioe) {
                    logger.error("Failed to recover FlowFiles from Swap File {}; the file appears to be corrupt", (Object)swapLocation, (Object)ioe.toString());
                    logger.error("", (Throwable)ioe);
                    if (this.eventReporter == null) continue;
                    this.eventReporter.reportEvent(Severity.ERROR, "FlowFile Swapping", "Failed to recover FlowFiles from Swap File " + swapLocation + "; the file appears to be corrupt. See logs for more details");
                }
            }
            this.incrementSwapQueueSize(swapFlowFileCount, swapByteCount, swapLocations.size());
            this.swapLocations.addAll(swapLocations);
        }
        finally {
            this.writeLock.unlock("Recover Swap Files");
        }
        return new StandardSwapSummary(new QueueSize(swapFlowFileCount, swapByteCount), maxId, resourceClaims);
    }

    public String toString() {
        return "FlowFileQueue[id=" + this.identifier + "]";
    }

    public ListFlowFileStatus listFlowFiles(String requestIdentifier, final int maxResults) {
        if (this.listRequestMap.size() > 10) {
            ArrayList toDrop = new ArrayList();
            for (Map.Entry entry : this.listRequestMap.entrySet()) {
                ListFlowFileRequest request = (ListFlowFileRequest)entry.getValue();
                boolean completed = request.getState() == ListFlowFileState.COMPLETE || request.getState() == ListFlowFileState.FAILURE;
                if (!completed || System.currentTimeMillis() - request.getLastUpdated() <= TimeUnit.MINUTES.toMillis(5L)) continue;
                toDrop.add(entry.getKey());
            }
            for (String requestId : toDrop) {
                this.listRequestMap.remove(requestId);
            }
        }
        final ListFlowFileRequest listRequest = new ListFlowFileRequest(requestIdentifier, maxResults, this.size());
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Prioritizer prioritizer;
                ArrayList allFlowFiles;
                int position = 0;
                int resultCount = 0;
                ArrayList<FlowFileSummary> summaries = new ArrayList<FlowFileSummary>();
                StandardFlowFileQueue.this.readLock.lock();
                try {
                    logger.debug("{} Acquired lock to perform listing of FlowFiles", (Object)StandardFlowFileQueue.this);
                    allFlowFiles = new ArrayList(StandardFlowFileQueue.this.activeQueue);
                    prioritizer = new Prioritizer(StandardFlowFileQueue.this.priorities);
                }
                finally {
                    StandardFlowFileQueue.this.readLock.unlock("List FlowFiles");
                }
                listRequest.setState(ListFlowFileState.CALCULATING_LIST);
                Collections.sort(allFlowFiles, prioritizer);
                for (FlowFileRecord flowFile : allFlowFiles) {
                    summaries.add(StandardFlowFileQueue.this.summarize((FlowFile)flowFile, ++position));
                    if (summaries.size() < maxResults) continue;
                    break;
                }
                logger.debug("{} Finished listing FlowFiles for active queue with a total of {} results", (Object)StandardFlowFileQueue.this, (Object)resultCount);
                listRequest.setFlowFileSummaries(summaries);
                listRequest.setState(ListFlowFileState.COMPLETE);
            }
        }, "List FlowFiles for Connection " + this.getIdentifier());
        t.setDaemon(true);
        t.start();
        this.listRequestMap.put(requestIdentifier, listRequest);
        return listRequest;
    }

    private FlowFileSummary summarize(FlowFile flowFile, final int position) {
        final String uuid = flowFile.getAttribute(CoreAttributes.UUID.key());
        final String filename = flowFile.getAttribute(CoreAttributes.FILENAME.key());
        final long size = flowFile.getSize();
        final Long lastQueuedTime = flowFile.getLastQueueDate();
        final long lineageStart = flowFile.getLineageStartDate();
        final boolean penalized = flowFile.isPenalized();
        return new FlowFileSummary(){

            public String getUuid() {
                return uuid;
            }

            public String getFilename() {
                return filename;
            }

            public int getPosition() {
                return position;
            }

            public long getSize() {
                return size;
            }

            public long getLastQueuedTime() {
                return lastQueuedTime == null ? 0L : lastQueuedTime;
            }

            public long getLineageStartDate() {
                return lineageStart;
            }

            public boolean isPenalized() {
                return penalized;
            }
        };
    }

    public ListFlowFileStatus getListFlowFileStatus(String requestIdentifier) {
        return (ListFlowFileStatus)this.listRequestMap.get(requestIdentifier);
    }

    public ListFlowFileStatus cancelListFlowFileRequest(String requestIdentifier) {
        logger.info("Canceling ListFlowFile Request with ID {}", (Object)requestIdentifier);
        ListFlowFileRequest request = (ListFlowFileRequest)this.listRequestMap.remove(requestIdentifier);
        if (request != null) {
            request.cancel();
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowFileRecord getFlowFile(String flowFileUuid) throws IOException {
        if (flowFileUuid == null) {
            return null;
        }
        this.readLock.lock();
        try {
            for (FlowFileRecord flowFile : this.activeQueue) {
                if (!flowFileUuid.equals(flowFile.getAttribute(CoreAttributes.UUID.key()))) continue;
                FlowFileRecord flowFileRecord = flowFile;
                return flowFileRecord;
            }
        }
        finally {
            this.readLock.unlock("getFlowFile");
        }
        return null;
    }

    public void verifyCanList() throws IllegalStateException {
    }

    public DropFlowFileStatus dropFlowFiles(final String requestIdentifier, final String requestor) {
        logger.info("Initiating drop of FlowFiles from {} on behalf of {} (request identifier={})", new Object[]{this, requestor, requestIdentifier});
        if (this.dropRequestMap.size() > 10) {
            ArrayList toDrop = new ArrayList();
            for (Map.Entry entry : this.dropRequestMap.entrySet()) {
                DropFlowFileRequest request = (DropFlowFileRequest)entry.getValue();
                boolean completed = request.getState() == DropFlowFileState.COMPLETE || request.getState() == DropFlowFileState.FAILURE;
                if (!completed || System.currentTimeMillis() - request.getLastUpdated() <= TimeUnit.MINUTES.toMillis(5L)) continue;
                toDrop.add(entry.getKey());
            }
            for (String requestId : toDrop) {
                this.dropRequestMap.remove(requestId);
            }
        }
        final DropFlowFileRequest dropRequest = new DropFlowFileRequest(requestIdentifier);
        QueueSize originalSize = this.getQueueSize();
        dropRequest.setCurrentSize(originalSize);
        dropRequest.setOriginalSize(originalSize);
        if (originalSize.getObjectCount() == 0) {
            dropRequest.setDroppedSize(originalSize);
            dropRequest.setState(DropFlowFileState.COMPLETE);
            this.dropRequestMap.put(requestIdentifier, dropRequest);
            return dropRequest;
        }
        Thread t = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        }, "Drop FlowFiles for Connection " + this.getIdentifier());
        t.setDaemon(true);
        t.start();
        this.dropRequestMap.put(requestIdentifier, dropRequest);
        return dropRequest;
    }

    private QueueSize drop(List<FlowFileRecord> flowFiles, String requestor) throws IOException {
        ArrayList<ProvenanceEventRecord> provenanceEvents = new ArrayList<ProvenanceEventRecord>(flowFiles.size());
        ArrayList<RepositoryRecord> flowFileRepoRecords = new ArrayList<RepositoryRecord>(flowFiles.size());
        for (FlowFileRecord flowFile : flowFiles) {
            provenanceEvents.add(this.createDropEvent(flowFile, requestor));
            flowFileRepoRecords.add(this.createDeleteRepositoryRecord(flowFile));
        }
        long dropContentSize = 0L;
        for (FlowFileRecord flowFile : flowFiles) {
            ResourceClaim resourceClaim;
            dropContentSize += flowFile.getSize();
            ContentClaim contentClaim = flowFile.getContentClaim();
            if (contentClaim == null || (resourceClaim = contentClaim.getResourceClaim()) == null) continue;
            this.resourceClaimManager.decrementClaimantCount(resourceClaim);
        }
        this.provRepository.registerEvents(provenanceEvents);
        this.flowFileRepository.updateRepository(flowFileRepoRecords);
        return new QueueSize(flowFiles.size(), dropContentSize);
    }

    private ProvenanceEventRecord createDropEvent(FlowFileRecord flowFile, String requestor) {
        ProvenanceEventBuilder builder = this.provRepository.eventBuilder();
        builder.fromFlowFile((FlowFile)flowFile);
        builder.setEventType(ProvenanceEventType.DROP);
        builder.setLineageStartDate(flowFile.getLineageStartDate());
        builder.setComponentId(this.getIdentifier());
        builder.setComponentType("Connection");
        builder.setAttributes(flowFile.getAttributes(), Collections.emptyMap());
        builder.setDetails("FlowFile Queue emptied by " + requestor);
        builder.setSourceQueueIdentifier(this.getIdentifier());
        ContentClaim contentClaim = flowFile.getContentClaim();
        if (contentClaim != null) {
            ResourceClaim resourceClaim = contentClaim.getResourceClaim();
            builder.setPreviousContentClaim(resourceClaim.getContainer(), resourceClaim.getSection(), resourceClaim.getId(), Long.valueOf(contentClaim.getOffset()), flowFile.getSize());
        }
        return builder.build();
    }

    private RepositoryRecord createDeleteRepositoryRecord(final FlowFileRecord flowFile) {
        return new RepositoryRecord(){

            public FlowFileQueue getDestination() {
                return null;
            }

            public FlowFileQueue getOriginalQueue() {
                return StandardFlowFileQueue.this;
            }

            public RepositoryRecordType getType() {
                return RepositoryRecordType.DELETE;
            }

            public ContentClaim getCurrentClaim() {
                return flowFile.getContentClaim();
            }

            public ContentClaim getOriginalClaim() {
                return flowFile.getContentClaim();
            }

            public long getCurrentClaimOffset() {
                return flowFile.getContentClaimOffset();
            }

            public FlowFileRecord getCurrent() {
                return flowFile;
            }

            public boolean isAttributesChanged() {
                return false;
            }

            public boolean isMarkedForAbort() {
                return false;
            }

            public String getSwapLocation() {
                return null;
            }
        };
    }

    public DropFlowFileRequest cancelDropFlowFileRequest(String requestIdentifier) {
        DropFlowFileRequest request = (DropFlowFileRequest)this.dropRequestMap.remove(requestIdentifier);
        if (request == null) {
            return null;
        }
        request.cancel();
        return request;
    }

    public DropFlowFileStatus getDropFlowFileStatus(String requestIdentifier) {
        return (DropFlowFileStatus)this.dropRequestMap.get(requestIdentifier);
    }

    public void lock() {
        this.writeLock.lock();
    }

    public void unlock() {
        this.writeLock.unlock("external unlock");
    }

    public QueueSize getUnacknowledgedQueueSize() {
        return this.size.get().unacknowledgedQueueSize();
    }

    private void incrementActiveQueueSize(int count, long bytes) {
        boolean updated = false;
        while (!updated) {
            FlowFileQueueSize newSize;
            FlowFileQueueSize original = this.size.get();
            updated = this.size.compareAndSet(original, newSize = new FlowFileQueueSize(original.activeQueueCount + count, original.activeQueueBytes + bytes, original.swappedCount, original.swappedBytes, original.swapFiles, original.unacknowledgedCount, original.unacknowledgedBytes));
            if (!updated) continue;
            this.logIfNegative(original, newSize, "active");
        }
    }

    private void incrementSwapQueueSize(int count, long bytes, int fileCount) {
        boolean updated = false;
        while (!updated) {
            FlowFileQueueSize newSize;
            FlowFileQueueSize original = this.size.get();
            updated = this.size.compareAndSet(original, newSize = new FlowFileQueueSize(original.activeQueueCount, original.activeQueueBytes, original.swappedCount + count, original.swappedBytes + bytes, original.swapFiles + fileCount, original.unacknowledgedCount, original.unacknowledgedBytes));
            if (!updated) continue;
            this.logIfNegative(original, newSize, "swap");
        }
    }

    private void incrementUnacknowledgedQueueSize(int count, long bytes) {
        boolean updated = false;
        while (!updated) {
            FlowFileQueueSize newSize;
            FlowFileQueueSize original = this.size.get();
            updated = this.size.compareAndSet(original, newSize = new FlowFileQueueSize(original.activeQueueCount, original.activeQueueBytes, original.swappedCount, original.swappedBytes, original.swapFiles, original.unacknowledgedCount + count, original.unacknowledgedBytes + bytes));
            if (!updated) continue;
            this.logIfNegative(original, newSize, "Unacknowledged");
        }
    }

    private void logIfNegative(FlowFileQueueSize original, FlowFileQueueSize newSize, String counterName) {
        if (newSize.activeQueueBytes < 0L || newSize.activeQueueCount < 0 || newSize.swappedBytes < 0L || newSize.swappedCount < 0 || newSize.unacknowledgedBytes < 0L || newSize.unacknowledgedCount < 0) {
            logger.error("Updated Size of Queue " + counterName + " from " + original + " to " + newSize, (Throwable)new RuntimeException("Cannot create negative queue size"));
        }
    }

    static /* synthetic */ TimedLock access$1200(StandardFlowFileQueue x0) {
        return x0.writeLock;
    }

    static /* synthetic */ QueueSize access$1300(StandardFlowFileQueue x0) {
        return x0.getQueueSize();
    }

    static /* synthetic */ QueueSize access$1400(StandardFlowFileQueue x0, List x1, String x2) throws IOException {
        return x0.drop(x1, x2);
    }

    static /* synthetic */ void access$1500(StandardFlowFileQueue x0, int x1, long x2) {
        x0.incrementActiveQueueSize(x1, x2);
    }

    static /* synthetic */ AtomicReference access$1600(StandardFlowFileQueue x0) {
        return x0.size;
    }

    static /* synthetic */ ArrayList access$1700(StandardFlowFileQueue x0) {
        return x0.swapQueue;
    }

    static /* synthetic */ boolean access$1802(StandardFlowFileQueue x0, boolean x1) {
        x0.swapMode = x1;
        return x0.swapMode;
    }

    static /* synthetic */ void access$1900(StandardFlowFileQueue x0, int x1, long x2, int x3) {
        x0.incrementSwapQueueSize(x1, x2, x3);
    }

    static /* synthetic */ List access$2000(StandardFlowFileQueue x0) {
        return x0.swapLocations;
    }

    static /* synthetic */ FlowFileSwapManager access$2100(StandardFlowFileQueue x0) {
        return x0.swapManager;
    }

    static /* synthetic */ Heartbeater access$2200(StandardFlowFileQueue x0) {
        return x0.heartbeater;
    }

    private static class TimePeriod {
        private final String period;
        private final long millis;

        public TimePeriod(String period, long millis) {
            this.period = period;
            this.millis = millis;
        }

        public String getPeriod() {
            return this.period;
        }

        public long getMillis() {
            return this.millis;
        }

        public String toString() {
            return this.period;
        }
    }

    private static class MaxQueueSize {
        private final String maxSize;
        private final long maxBytes;
        private final long maxCount;

        public MaxQueueSize(String maxSize, long maxBytes, long maxCount) {
            this.maxSize = maxSize;
            this.maxBytes = maxBytes;
            this.maxCount = maxCount;
        }

        public String getMaxSize() {
            return this.maxSize;
        }

        public long getMaxBytes() {
            return this.maxBytes;
        }

        public long getMaxCount() {
            return this.maxCount;
        }

        public String toString() {
            return this.maxCount + " Objects/" + this.maxSize;
        }
    }

    private static class FlowFileQueueSize {
        private final int activeQueueCount;
        private final long activeQueueBytes;
        private final int swappedCount;
        private final long swappedBytes;
        private final int swapFiles;
        private final int unacknowledgedCount;
        private final long unacknowledgedBytes;

        public FlowFileQueueSize(int activeQueueCount, long activeQueueBytes, int swappedCount, long swappedBytes, int swapFileCount, int unacknowledgedCount, long unacknowledgedBytes) {
            this.activeQueueCount = activeQueueCount;
            this.activeQueueBytes = activeQueueBytes;
            this.swappedCount = swappedCount;
            this.swappedBytes = swappedBytes;
            this.swapFiles = swapFileCount;
            this.unacknowledgedCount = unacknowledgedCount;
            this.unacknowledgedBytes = unacknowledgedBytes;
        }

        public boolean isEmpty() {
            return this.activeQueueCount == 0 && this.swappedCount == 0 && this.unacknowledgedCount == 0;
        }

        public QueueSize toQueueSize() {
            return new QueueSize(this.activeQueueCount + this.swappedCount + this.unacknowledgedCount, this.activeQueueBytes + this.swappedBytes + this.unacknowledgedBytes);
        }

        public QueueSize activeQueueSize() {
            return new QueueSize(this.activeQueueCount, this.activeQueueBytes);
        }

        public QueueSize unacknowledgedQueueSize() {
            return new QueueSize(this.unacknowledgedCount, this.unacknowledgedBytes);
        }

        public QueueSize swapQueueSize() {
            return new QueueSize(this.swappedCount, this.swappedBytes);
        }

        public String toString() {
            return "FlowFile Queue Size[ ActiveQueue=[" + this.activeQueueCount + ", " + this.activeQueueBytes + " Bytes], Swap Queue=[" + this.swappedCount + ", " + this.swappedBytes + " Bytes], Swap Files=[" + this.swapFiles + "], Unacknowledged=[" + this.unacknowledgedCount + ", " + this.unacknowledgedBytes + " Bytes] ]";
        }
    }

    private static final class Prioritizer
    implements Comparator<FlowFileRecord>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final transient List<FlowFilePrioritizer> prioritizers = new ArrayList<FlowFilePrioritizer>();

        private Prioritizer(List<FlowFilePrioritizer> priorities) {
            if (null != priorities) {
                this.prioritizers.addAll(priorities);
            }
        }

        @Override
        public int compare(FlowFileRecord f1, FlowFileRecord f2) {
            int returnVal = 0;
            boolean f1Penalized = f1.isPenalized();
            boolean f2Penalized = f2.isPenalized();
            if (f1Penalized && !f2Penalized) {
                return 1;
            }
            if (!f1Penalized && f2Penalized) {
                return -1;
            }
            if (f1Penalized && f2Penalized) {
                if (f1.getPenaltyExpirationMillis() < f2.getPenaltyExpirationMillis()) {
                    return -1;
                }
                if (f1.getPenaltyExpirationMillis() > f2.getPenaltyExpirationMillis()) {
                    return 1;
                }
            }
            if (!this.prioritizers.isEmpty()) {
                for (FlowFilePrioritizer prioritizer : this.prioritizers) {
                    returnVal = prioritizer.compare((Object)f1, (Object)f2);
                    if (returnVal == 0) continue;
                    return returnVal;
                }
            }
            ContentClaim claim1 = f1.getContentClaim();
            ContentClaim claim2 = f2.getContentClaim();
            if (claim1 == null && claim2 != null) {
                return -1;
            }
            if (claim1 != null && claim2 == null) {
                return 1;
            }
            if (claim1 != null && claim2 != null) {
                int claimComparison = claim1.compareTo((Object)claim2);
                if (claimComparison != 0) {
                    return claimComparison;
                }
                int claimOffsetComparison = Long.compare(f1.getContentClaimOffset(), f2.getContentClaimOffset());
                if (claimOffsetComparison != 0) {
                    return claimOffsetComparison;
                }
            }
            return Long.compare(f1.getId(), f2.getId());
        }
    }
}

