/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.FlowSerializationException;
import org.apache.nifi.controller.FlowSerializer;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RootGroupPort;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class StandardFlowSerializer
implements FlowSerializer {
    private final StringEncryptor encryptor;

    public StandardFlowSerializer(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public void serialize(FlowController controller, OutputStream os) throws FlowSerializationException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootNode = doc.createElement("flowController");
            doc.appendChild(rootNode);
            StandardFlowSerializer.addTextElement(rootNode, "maxTimerDrivenThreadCount", controller.getMaxTimerDrivenThreadCount());
            StandardFlowSerializer.addTextElement(rootNode, "maxEventDrivenThreadCount", controller.getMaxEventDrivenThreadCount());
            this.addProcessGroup(rootNode, controller.getGroup(controller.getRootGroupId()), "rootGroup");
            Element controllerServicesNode = doc.createElement("controllerServices");
            rootNode.appendChild(controllerServicesNode);
            for (ControllerServiceNode controllerServiceNode : controller.getAllControllerServices()) {
                StandardFlowSerializer.addControllerService(controllerServicesNode, controllerServiceNode, this.encryptor);
            }
            Element reportingTasksNode = doc.createElement("reportingTasks");
            rootNode.appendChild(reportingTasksNode);
            for (ReportingTaskNode taskNode : controller.getAllReportingTasks()) {
                StandardFlowSerializer.addReportingTask(reportingTasksNode, taskNode, this.encryptor);
            }
            DOMSource dOMSource = new DOMSource(doc);
            StreamResult streamResult = new StreamResult(new BufferedOutputStream(os));
            TransformerFactory transformFactory = TransformerFactory.newInstance();
            Transformer transformer = transformFactory.newTransformer();
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(dOMSource, streamResult);
        }
        catch (IllegalArgumentException | ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | DOMException e) {
            throw new FlowSerializationException(e);
        }
    }

    private void addSize(Element parentElement, Size size) {
        Element element = parentElement.getOwnerDocument().createElement("size");
        element.setAttribute("width", String.valueOf(size.getWidth()));
        element.setAttribute("height", String.valueOf(size.getHeight()));
        parentElement.appendChild(element);
    }

    private void addPosition(Element parentElement, Position position) {
        this.addPosition(parentElement, position, "position");
    }

    private void addPosition(Element parentElement, Position position, String elementName) {
        Element element = parentElement.getOwnerDocument().createElement(elementName);
        element.setAttribute("x", String.valueOf(position.getX()));
        element.setAttribute("y", String.valueOf(position.getY()));
        parentElement.appendChild(element);
    }

    private void addProcessGroup(Element parentElement, ProcessGroup group, String elementName) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", group.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "name", group.getName());
        this.addPosition(element, group.getPosition());
        StandardFlowSerializer.addTextElement(element, "comment", group.getComments());
        for (ProcessorNode processor : group.getProcessors()) {
            this.addProcessor(element, processor);
        }
        if (group.isRootGroup()) {
            for (Port port : group.getInputPorts()) {
                this.addRootGroupPort(element, (RootGroupPort)port, "inputPort");
            }
            for (Port port : group.getOutputPorts()) {
                this.addRootGroupPort(element, (RootGroupPort)port, "outputPort");
            }
        } else {
            for (Port port : group.getInputPorts()) {
                this.addPort(element, port, "inputPort");
            }
            for (Port port : group.getOutputPorts()) {
                this.addPort(element, port, "outputPort");
            }
        }
        for (Label label : group.getLabels()) {
            this.addLabel(element, label);
        }
        for (Funnel funnel : group.getFunnels()) {
            this.addFunnel(element, funnel);
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            this.addProcessGroup(element, childGroup, "processGroup");
        }
        for (RemoteProcessGroup remoteRef : group.getRemoteProcessGroups()) {
            this.addRemoteProcessGroup(element, remoteRef);
        }
        for (Connection connection : group.getConnections()) {
            this.addConnection(element, connection);
        }
    }

    private void addStyle(Element parentElement, Map<String, String> style) {
        Element element = parentElement.getOwnerDocument().createElement("styles");
        for (Map.Entry<String, String> entry : style.entrySet()) {
            Element styleElement = parentElement.getOwnerDocument().createElement("style");
            styleElement.setAttribute("name", entry.getKey());
            styleElement.setTextContent(entry.getValue());
            element.appendChild(styleElement);
        }
        parentElement.appendChild(element);
    }

    private void addLabel(Element parentElement, Label label) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("label");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", label.getIdentifier());
        this.addPosition(element, label.getPosition());
        this.addSize(element, label.getSize());
        this.addStyle(element, label.getStyle());
        StandardFlowSerializer.addTextElement(element, "value", label.getValue());
        parentElement.appendChild(element);
    }

    private void addFunnel(Element parentElement, Funnel funnel) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("funnel");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", funnel.getIdentifier());
        this.addPosition(element, funnel.getPosition());
    }

    private void addRemoteProcessGroup(Element parentElement, RemoteProcessGroup remoteRef) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("remoteProcessGroup");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", remoteRef.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "name", remoteRef.getName());
        this.addPosition(element, remoteRef.getPosition());
        StandardFlowSerializer.addTextElement(element, "comment", remoteRef.getComments());
        StandardFlowSerializer.addTextElement(element, "url", remoteRef.getTargetUri().toString());
        StandardFlowSerializer.addTextElement(element, "timeout", remoteRef.getCommunicationsTimeout());
        StandardFlowSerializer.addTextElement(element, "yieldPeriod", remoteRef.getYieldDuration());
        StandardFlowSerializer.addTextElement(element, "transmitting", String.valueOf(remoteRef.isTransmitting()));
        for (RemoteGroupPort port : remoteRef.getInputPorts()) {
            if (!port.hasIncomingConnection()) continue;
            this.addRemoteGroupPort(element, port, "inputPort");
        }
        for (RemoteGroupPort port : remoteRef.getOutputPorts()) {
            if (port.getConnections().isEmpty()) continue;
            this.addRemoteGroupPort(element, port, "outputPort");
        }
        parentElement.appendChild(element);
    }

    private void addRemoteGroupPort(Element parentElement, RemoteGroupPort port, String elementName) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", port.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        StandardFlowSerializer.addTextElement(element, "comments", port.getComments());
        StandardFlowSerializer.addTextElement(element, "scheduledState", port.getScheduledState().name());
        StandardFlowSerializer.addTextElement(element, "maxConcurrentTasks", port.getMaxConcurrentTasks());
        StandardFlowSerializer.addTextElement(element, "useCompression", String.valueOf(port.isUseCompression()));
        parentElement.appendChild(element);
    }

    private void addPort(Element parentElement, Port port, String elementName) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", port.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        StandardFlowSerializer.addTextElement(element, "comments", port.getComments());
        StandardFlowSerializer.addTextElement(element, "scheduledState", port.getScheduledState().name());
        parentElement.appendChild(element);
    }

    private void addRootGroupPort(Element parentElement, RootGroupPort port, String elementName) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement(elementName);
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", port.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "name", port.getName());
        this.addPosition(element, port.getPosition());
        StandardFlowSerializer.addTextElement(element, "comments", port.getComments());
        StandardFlowSerializer.addTextElement(element, "scheduledState", port.getScheduledState().name());
        StandardFlowSerializer.addTextElement(element, "maxConcurrentTasks", String.valueOf(port.getMaxConcurrentTasks()));
        for (String user : port.getUserAccessControl()) {
            StandardFlowSerializer.addTextElement(element, "userAccessControl", user);
        }
        for (String group : port.getGroupAccessControl()) {
            StandardFlowSerializer.addTextElement(element, "groupAccessControl", group);
        }
        parentElement.appendChild(element);
    }

    private void addProcessor(Element parentElement, ProcessorNode processor) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("processor");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", processor.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "name", processor.getName());
        this.addPosition(element, processor.getPosition());
        this.addStyle(element, processor.getStyle());
        StandardFlowSerializer.addTextElement(element, "comment", processor.getComments());
        StandardFlowSerializer.addTextElement(element, "class", processor.getProcessor().getClass().getCanonicalName());
        StandardFlowSerializer.addTextElement(element, "maxConcurrentTasks", processor.getMaxConcurrentTasks());
        StandardFlowSerializer.addTextElement(element, "schedulingPeriod", processor.getSchedulingPeriod());
        StandardFlowSerializer.addTextElement(element, "penalizationPeriod", processor.getPenalizationPeriod());
        StandardFlowSerializer.addTextElement(element, "yieldPeriod", processor.getYieldPeriod());
        StandardFlowSerializer.addTextElement(element, "bulletinLevel", processor.getBulletinLevel().toString());
        StandardFlowSerializer.addTextElement(element, "lossTolerant", String.valueOf(processor.isLossTolerant()));
        StandardFlowSerializer.addTextElement(element, "scheduledState", processor.getScheduledState().name());
        StandardFlowSerializer.addTextElement(element, "schedulingStrategy", processor.getSchedulingStrategy().name());
        StandardFlowSerializer.addTextElement(element, "runDurationNanos", processor.getRunDuration(TimeUnit.NANOSECONDS));
        StandardFlowSerializer.addConfiguration(element, processor.getProperties(), processor.getAnnotationData(), this.encryptor);
        for (Relationship rel : processor.getAutoTerminatedRelationships()) {
            StandardFlowSerializer.addTextElement(element, "autoTerminatedRelationship", rel.getName());
        }
    }

    private static void addConfiguration(Element element, Map<PropertyDescriptor, String> properties, String annotationData, StringEncryptor encryptor) {
        Document doc = element.getOwnerDocument();
        for (Map.Entry<PropertyDescriptor, String> entry : properties.entrySet()) {
            PropertyDescriptor descriptor = entry.getKey();
            String value = entry.getValue();
            if (value != null && descriptor.isSensitive()) {
                value = "enc{" + encryptor.encrypt(value) + "}";
            }
            if (value == null) {
                value = descriptor.getDefaultValue();
            }
            Element propElement = doc.createElement("property");
            StandardFlowSerializer.addTextElement(propElement, "name", descriptor.getName());
            if (value != null) {
                StandardFlowSerializer.addTextElement(propElement, "value", value);
            }
            element.appendChild(propElement);
        }
        if (annotationData != null) {
            StandardFlowSerializer.addTextElement(element, "annotationData", annotationData);
        }
    }

    private void addConnection(Element parentElement, Connection connection) {
        Document doc = parentElement.getOwnerDocument();
        Element element = doc.createElement("connection");
        parentElement.appendChild(element);
        StandardFlowSerializer.addTextElement(element, "id", connection.getIdentifier());
        StandardFlowSerializer.addTextElement(element, "name", connection.getName());
        Element bendPointsElement = doc.createElement("bendPoints");
        element.appendChild(bendPointsElement);
        for (Position bendPoint : connection.getBendPoints()) {
            this.addPosition(bendPointsElement, bendPoint, "bendPoint");
        }
        StandardFlowSerializer.addTextElement(element, "labelIndex", connection.getLabelIndex());
        StandardFlowSerializer.addTextElement(element, "zIndex", connection.getZIndex());
        String sourceId = connection.getSource().getIdentifier();
        ConnectableType sourceType = connection.getSource().getConnectableType();
        String sourceGroupId = sourceType == ConnectableType.REMOTE_OUTPUT_PORT ? ((RemoteGroupPort)connection.getSource()).getRemoteProcessGroup().getIdentifier() : connection.getSource().getProcessGroup().getIdentifier();
        ConnectableType destinationType = connection.getDestination().getConnectableType();
        String destinationId = connection.getDestination().getIdentifier();
        String destinationGroupId = destinationType == ConnectableType.REMOTE_INPUT_PORT ? ((RemoteGroupPort)connection.getDestination()).getRemoteProcessGroup().getIdentifier() : connection.getDestination().getProcessGroup().getIdentifier();
        StandardFlowSerializer.addTextElement(element, "sourceId", sourceId);
        StandardFlowSerializer.addTextElement(element, "sourceGroupId", sourceGroupId);
        StandardFlowSerializer.addTextElement(element, "sourceType", sourceType.toString());
        StandardFlowSerializer.addTextElement(element, "destinationId", destinationId);
        StandardFlowSerializer.addTextElement(element, "destinationGroupId", destinationGroupId);
        StandardFlowSerializer.addTextElement(element, "destinationType", destinationType.toString());
        for (Relationship relationship : connection.getRelationships()) {
            StandardFlowSerializer.addTextElement(element, "relationship", relationship.getName());
        }
        StandardFlowSerializer.addTextElement(element, "maxWorkQueueSize", connection.getFlowFileQueue().getBackPressureObjectThreshold());
        StandardFlowSerializer.addTextElement(element, "maxWorkQueueDataSize", connection.getFlowFileQueue().getBackPressureDataSizeThreshold());
        StandardFlowSerializer.addTextElement(element, "flowFileExpiration", connection.getFlowFileQueue().getFlowFileExpiration());
        for (FlowFilePrioritizer comparator : connection.getFlowFileQueue().getPriorities()) {
            String className = comparator.getClass().getCanonicalName();
            StandardFlowSerializer.addTextElement(element, "queuePrioritizerClass", className);
        }
        parentElement.appendChild(element);
    }

    public static void addControllerService(Element element, ControllerServiceNode serviceNode, StringEncryptor encryptor) {
        Element serviceElement = element.getOwnerDocument().createElement("controllerService");
        StandardFlowSerializer.addTextElement(serviceElement, "id", serviceNode.getIdentifier());
        StandardFlowSerializer.addTextElement(serviceElement, "name", serviceNode.getName());
        StandardFlowSerializer.addTextElement(serviceElement, "comment", serviceNode.getComments());
        StandardFlowSerializer.addTextElement(serviceElement, "class", serviceNode.getControllerServiceImplementation().getClass().getCanonicalName());
        ControllerServiceState state = serviceNode.getState();
        boolean enabled = state == ControllerServiceState.ENABLED || state == ControllerServiceState.ENABLING;
        StandardFlowSerializer.addTextElement(serviceElement, "enabled", String.valueOf(enabled));
        StandardFlowSerializer.addConfiguration(serviceElement, serviceNode.getProperties(), serviceNode.getAnnotationData(), encryptor);
        element.appendChild(serviceElement);
    }

    public static void addReportingTask(Element element, ReportingTaskNode taskNode, StringEncryptor encryptor) {
        Element taskElement = element.getOwnerDocument().createElement("reportingTask");
        StandardFlowSerializer.addTextElement(taskElement, "id", taskNode.getIdentifier());
        StandardFlowSerializer.addTextElement(taskElement, "name", taskNode.getName());
        StandardFlowSerializer.addTextElement(taskElement, "comment", taskNode.getComments());
        StandardFlowSerializer.addTextElement(taskElement, "class", taskNode.getReportingTask().getClass().getCanonicalName());
        StandardFlowSerializer.addTextElement(taskElement, "schedulingPeriod", taskNode.getSchedulingPeriod());
        StandardFlowSerializer.addTextElement(taskElement, "scheduledState", taskNode.getScheduledState().name());
        StandardFlowSerializer.addTextElement(taskElement, "schedulingStrategy", taskNode.getSchedulingStrategy().name());
        StandardFlowSerializer.addConfiguration(taskElement, taskNode.getProperties(), taskNode.getAnnotationData(), encryptor);
        element.appendChild(taskElement);
    }

    private static void addTextElement(Element element, String name, long value) {
        StandardFlowSerializer.addTextElement(element, name, String.valueOf(value));
    }

    private static void addTextElement(Element element, String name, String value) {
        Document doc = element.getOwnerDocument();
        Element toAdd = doc.createElement(name);
        toAdd.setTextContent(value);
        element.appendChild(toAdd);
    }
}

