/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.nifi.controller.FlowFromDOMFactory;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.util.DomUtils;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ControllerServiceLoader {
    private static final Logger logger = LoggerFactory.getLogger(ControllerServiceLoader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<ControllerServiceNode> loadControllerServices(ControllerServiceProvider provider, InputStream serializedStream, StringEncryptor encryptor, BulletinRepository bulletinRepo, boolean autoResumeState) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try (BufferedInputStream in = new BufferedInputStream(serializedStream);){
            DocumentBuilder builder = documentBuilderFactory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                @Override
                public void fatalError(SAXParseException err) throws SAXException {
                    logger.error("Config file line " + err.getLineNumber() + ", col " + err.getColumnNumber() + ", uri " + err.getSystemId() + " :message: " + err.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.error("Error Stack Dump", (Throwable)err);
                    }
                    throw err;
                }

                @Override
                public void error(SAXParseException err) throws SAXParseException {
                    logger.error("Config file line " + err.getLineNumber() + ", col " + err.getColumnNumber() + ", uri " + err.getSystemId() + " :message: " + err.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.error("Error Stack Dump", (Throwable)err);
                    }
                    throw err;
                }

                @Override
                public void warning(SAXParseException err) throws SAXParseException {
                    logger.warn(" Config file line " + err.getLineNumber() + ", uri " + err.getSystemId() + " : message : " + err.getMessage());
                    if (logger.isDebugEnabled()) {
                        logger.warn("Warning stack dump", (Throwable)err);
                    }
                    throw err;
                }
            });
            Document document = builder.parse(in);
            Element controllerServices = document.getDocumentElement();
            List<Element> serviceElements = DomUtils.getChildElementsByTagName(controllerServices, "controllerService");
            ArrayList<ControllerServiceNode> arrayList = new ArrayList<ControllerServiceNode>(ControllerServiceLoader.loadControllerServices(serviceElements, provider, encryptor, bulletinRepo, autoResumeState));
            return arrayList;
        }
        catch (ParserConfigurationException | SAXException sxe) {
            throw new IOException(sxe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<ControllerServiceNode> loadControllerServices(List<Element> serviceElements, ControllerServiceProvider provider, StringEncryptor encryptor, BulletinRepository bulletinRepo, boolean autoResumeState) {
        HashMap<ControllerServiceNode, Element> nodeMap = new HashMap<ControllerServiceNode, Element>();
        for (Element element : serviceElements) {
            ControllerServiceNode serviceNode = ControllerServiceLoader.createControllerService(provider, element, encryptor);
            nodeMap.put(serviceNode, (Element)element.cloneNode(true));
        }
        for (Map.Entry entry : nodeMap.entrySet()) {
            ControllerServiceLoader.configureControllerService((ControllerServiceNode)entry.getKey(), (Element)entry.getValue(), encryptor);
        }
        if (autoResumeState) {
            HashSet<ControllerServiceNode> nodesToEnable = new HashSet<ControllerServiceNode>();
            for (ControllerServiceNode node : nodeMap.keySet()) {
                ControllerServiceDTO dto;
                Element controllerServiceElement = (Element)nodeMap.get(node);
                Document document = controllerServiceElement.getOwnerDocument();
                synchronized (document) {
                    dto = FlowFromDOMFactory.getControllerService(controllerServiceElement, encryptor);
                }
                ControllerServiceState state = ControllerServiceState.valueOf((String)dto.getState());
                if (state != ControllerServiceState.ENABLED) continue;
                nodesToEnable.add(node);
            }
            provider.enableControllerServices(nodesToEnable);
        }
        return nodeMap.keySet();
    }

    private static ControllerServiceNode createControllerService(ControllerServiceProvider provider, Element controllerServiceElement, StringEncryptor encryptor) {
        ControllerServiceDTO dto = FlowFromDOMFactory.getControllerService(controllerServiceElement, encryptor);
        ControllerServiceNode node = provider.createControllerService(dto.getType(), dto.getId(), false);
        node.setName(dto.getName());
        node.setComments(dto.getComments());
        return node;
    }

    private static void configureControllerService(ControllerServiceNode node, Element controllerServiceElement, StringEncryptor encryptor) {
        ControllerServiceDTO dto = FlowFromDOMFactory.getControllerService(controllerServiceElement, encryptor);
        node.setAnnotationData(dto.getAnnotationData());
        for (Map.Entry entry : dto.getProperties().entrySet()) {
            if (entry.getValue() == null) {
                node.removeProperty((String)entry.getKey());
                continue;
            }
            node.setProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

