/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.spring;

import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.admin.service.UserService;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class FlowControllerFactoryBean
implements FactoryBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private FlowController flowController;
    private NiFiProperties properties;
    private UserService userService;
    private AuditService auditService;
    private StringEncryptor encryptor;

    public Object getObject() throws Exception {
        if (this.properties.isClusterManager()) {
            return null;
        }
        if (this.flowController == null) {
            FlowFileEventRepository flowFileEventRepository = (FlowFileEventRepository)this.applicationContext.getBean("flowFileEventRepository", FlowFileEventRepository.class);
            if (this.properties.isNode()) {
                NodeProtocolSender nodeProtocolSender = (NodeProtocolSender)this.applicationContext.getBean("nodeProtocolSender", NodeProtocolSender.class);
                this.flowController = FlowController.createClusteredInstance(flowFileEventRepository, this.properties, this.userService, this.auditService, this.encryptor, nodeProtocolSender);
            } else {
                this.flowController = FlowController.createStandaloneInstance(flowFileEventRepository, this.properties, this.userService, this.auditService, this.encryptor);
            }
        }
        return this.flowController;
    }

    public Class getObjectType() {
        return FlowController.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setEncryptor(StringEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }
}

