/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.nifi.logging.ProcessorLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);

    public static void invokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ReflectionUtils.invokeMethodsWithAnnotations(annotation, null, instance, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        ArrayList<Class<? extends Annotation>> annotationClasses = new ArrayList<Class<? extends Annotation>>(alternateAnnotation == null ? 1 : 2);
        annotationClasses.add(preferredAnnotation);
        if (alternateAnnotation != null) {
            annotationClasses.add(alternateAnnotation);
        }
        boolean annotationFound = false;
        for (Class clazz : annotationClasses) {
            if (annotationFound) break;
            try {
                for (Method method : instance.getClass().getMethods()) {
                    if (!method.isAnnotationPresent(clazz)) continue;
                    annotationFound = true;
                    boolean isAccessible = method.isAccessible();
                    method.setAccessible(true);
                    try {
                        Class<?>[] argumentTypes = method.getParameterTypes();
                        if (argumentTypes.length > args.length) {
                            throw new IllegalArgumentException(String.format("Unable to invoke method %1$s on %2$s because method expects %3$s parameters but only %4$s were given", method.getName(), instance, argumentTypes.length, args.length));
                        }
                        for (int i = 0; i < argumentTypes.length; ++i) {
                            Class<?> argType = argumentTypes[i];
                            if (argType.isAssignableFrom(args[i].getClass())) continue;
                            throw new IllegalArgumentException(String.format("Unable to invoke method %1$s on %2$s because method parameter %3$s is expected to be of type %4$s but argument passed was of type %5$s", method.getName(), instance, i, argType, args[i].getClass()));
                        }
                        if (argumentTypes.length == args.length) {
                            method.invoke(instance, args);
                            continue;
                        }
                        Object[] argsToPass = new Object[argumentTypes.length];
                        for (int i = 0; i < argsToPass.length; ++i) {
                            argsToPass[i] = args[i];
                        }
                        method.invoke(instance, argsToPass);
                    }
                    finally {
                        if (!isAccessible) {
                            method.setAccessible(false);
                        }
                    }
                }
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ite.getCause();
                }
                throw ite;
            }
        }
    }

    public static boolean quietlyInvokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(annotation, null, instance, null, args);
    }

    public static boolean quietlyInvokeMethodsWithAnnotation(Class<? extends Annotation> annotation, Object instance, ProcessorLog logger, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(annotation, null, instance, logger, args);
    }

    public static boolean quietlyInvokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, Object ... args) {
        return ReflectionUtils.quietlyInvokeMethodsWithAnnotations(preferredAnnotation, alternateAnnotation, instance, null, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean quietlyInvokeMethodsWithAnnotations(Class<? extends Annotation> preferredAnnotation, Class<? extends Annotation> alternateAnnotation, Object instance, ProcessorLog logger, Object ... args) {
        ArrayList<Class<? extends Annotation>> annotationClasses = new ArrayList<Class<? extends Annotation>>(alternateAnnotation == null ? 1 : 2);
        annotationClasses.add(preferredAnnotation);
        if (alternateAnnotation != null) {
            annotationClasses.add(alternateAnnotation);
        }
        boolean annotationFound = false;
        for (Class clazz : annotationClasses) {
            if (annotationFound) break;
            for (Method method : instance.getClass().getMethods()) {
                if (!method.isAnnotationPresent(clazz)) continue;
                annotationFound = true;
                boolean isAccessible = method.isAccessible();
                method.setAccessible(true);
                try {
                    Class<?>[] argumentTypes = method.getParameterTypes();
                    if (argumentTypes.length > args.length) {
                        if (logger == null) {
                            LOG.error("Unable to invoke method {} on {} because method expects {} parameters but only {} were given", new Object[]{method.getName(), instance, argumentTypes.length, args.length});
                        } else {
                            logger.error("Unable to invoke method {} on {} because method expects {} parameters but only {} were given", new Object[]{method.getName(), instance, argumentTypes.length, args.length});
                        }
                        boolean bl = false;
                        return bl;
                    }
                    for (int i = 0; i < argumentTypes.length; ++i) {
                        Class<?> argType = argumentTypes[i];
                        if (argType.isAssignableFrom(args[i].getClass())) continue;
                        if (logger == null) {
                            LOG.error("Unable to invoke method {} on {} because method parameter {} is expected to be of type {} but argument passed was of type {}", new Object[]{method.getName(), instance, i, argType, args[i].getClass()});
                        } else {
                            logger.error("Unable to invoke method {} on {} because method parameter {} is expected to be of type {} but argument passed was of type {}", new Object[]{method.getName(), instance, i, argType, args[i].getClass()});
                        }
                        boolean bl = false;
                        return bl;
                    }
                    try {
                        if (argumentTypes.length == args.length) {
                            method.invoke(instance, args);
                            continue;
                        }
                        Object[] argsToPass = new Object[argumentTypes.length];
                        for (int i = 0; i < argsToPass.length; ++i) {
                            argsToPass[i] = args[i];
                        }
                        method.invoke(instance, argsToPass);
                    }
                    catch (InvocationTargetException ite) {
                        if (logger == null) {
                            LOG.error("Unable to invoke method {} on {} due to {}", new Object[]{method.getName(), instance, ite.getCause()});
                            LOG.error("", ite.getCause());
                            continue;
                        }
                        logger.error("Unable to invoke method {} on {} due to {}", new Object[]{method.getName(), instance, ite.getCause()});
                    }
                    catch (IllegalAccessException | IllegalArgumentException t) {
                        if (logger == null) {
                            LOG.error("Unable to invoke method {} on {} due to {}", new Object[]{method.getName(), instance, t});
                            LOG.error("", (Throwable)t);
                        } else {
                            logger.error("Unable to invoke method {} on {} due to {}", new Object[]{method.getName(), instance, t});
                        }
                        boolean bl = false;
                        if (!isAccessible) {
                            method.setAccessible(false);
                        }
                        return bl;
                    }
                }
                finally {
                    if (!isAccessible) {
                        method.setAccessible(false);
                    }
                }
            }
        }
        return true;
    }
}

