/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.events;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.nifi.events.BulletinProcessingStrategy;
import org.apache.nifi.reporting.Bulletin;

public class NodeBulletinProcessingStrategy
implements BulletinProcessingStrategy {
    private final Lock lock = new ReentrantLock();
    private final Set<Bulletin> bulletins = new LinkedHashSet<Bulletin>();

    public void update(Bulletin bulletin) {
        this.lock.lock();
        try {
            this.bulletins.add(bulletin);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Set<Bulletin> getBulletins() {
        HashSet<Bulletin> response = new HashSet<Bulletin>();
        this.lock.lock();
        try {
            response.addAll(this.bulletins);
            this.bulletins.clear();
        }
        finally {
            this.lock.unlock();
        }
        return response;
    }
}

