/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state.server;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.nifi.util.NiFiProperties;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeer;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperStateServer
extends ZooKeeperServerMain {
    private static final Logger logger = LoggerFactory.getLogger(ZooKeeperStateServer.class);
    private final QuorumPeerConfig quorumPeerConfig = new QuorumPeerConfig();
    private volatile boolean started = false;
    private ServerCnxnFactory connectionFactory;
    private FileTxnSnapLog transactionLog;
    private ZooKeeperServer embeddedZkServer;
    private QuorumPeer quorumPeer;

    private ZooKeeperStateServer(Properties zkProperties) throws IOException, QuorumPeerConfig.ConfigException {
        this.quorumPeerConfig.parseProperties(zkProperties);
    }

    public synchronized void start() throws IOException {
        if (this.quorumPeerConfig.isDistributed()) {
            this.startDistributed();
        } else {
            this.startStandalone();
        }
    }

    private void startStandalone() throws IOException {
        logger.info("Starting Embedded ZooKeeper Server");
        ServerConfig config = new ServerConfig();
        config.readFrom(this.quorumPeerConfig);
        try {
            this.started = true;
            this.transactionLog = new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir()));
            this.embeddedZkServer = new ZooKeeperServer();
            this.embeddedZkServer.setTxnLogFactory(this.transactionLog);
            this.embeddedZkServer.setTickTime(config.getTickTime());
            this.embeddedZkServer.setMinSessionTimeout(config.getMinSessionTimeout());
            this.embeddedZkServer.setMaxSessionTimeout(config.getMaxSessionTimeout());
            this.connectionFactory = ServerCnxnFactory.createFactory();
            this.connectionFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
            this.connectionFactory.startup(this.embeddedZkServer);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("Embedded ZooKeeper Server interrupted", (Throwable)e);
        }
        catch (IOException ioe) {
            throw new IOException("Failed to start embedded ZooKeeper Server", ioe);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start embedded ZooKeeper Server", e);
        }
    }

    private void startDistributed() throws IOException {
        logger.info("Starting Embedded ZooKeeper Peer");
        try {
            this.started = true;
            this.transactionLog = new FileTxnSnapLog(new File(this.quorumPeerConfig.getDataLogDir()), new File(this.quorumPeerConfig.getDataDir()));
            this.connectionFactory = ServerCnxnFactory.createFactory();
            this.connectionFactory.configure(this.quorumPeerConfig.getClientPortAddress(), this.quorumPeerConfig.getMaxClientCnxns());
            this.quorumPeer = new QuorumPeer();
            this.quorumPeer.setClientPortAddress(this.quorumPeerConfig.getClientPortAddress());
            this.quorumPeer.setTxnFactory(new FileTxnSnapLog(new File(this.quorumPeerConfig.getDataLogDir()), new File(this.quorumPeerConfig.getDataDir())));
            this.quorumPeer.setQuorumPeers(this.quorumPeerConfig.getServers());
            this.quorumPeer.setElectionType(this.quorumPeerConfig.getElectionAlg());
            this.quorumPeer.setMyid(this.quorumPeerConfig.getServerId());
            this.quorumPeer.setTickTime(this.quorumPeerConfig.getTickTime());
            this.quorumPeer.setMinSessionTimeout(this.quorumPeerConfig.getMinSessionTimeout());
            this.quorumPeer.setMaxSessionTimeout(this.quorumPeerConfig.getMaxSessionTimeout());
            this.quorumPeer.setInitLimit(this.quorumPeerConfig.getInitLimit());
            this.quorumPeer.setSyncLimit(this.quorumPeerConfig.getSyncLimit());
            this.quorumPeer.setQuorumVerifier(this.quorumPeerConfig.getQuorumVerifier());
            this.quorumPeer.setCnxnFactory(this.connectionFactory);
            this.quorumPeer.setZKDatabase(new ZKDatabase(this.quorumPeer.getTxnFactory()));
            this.quorumPeer.setLearnerType(this.quorumPeerConfig.getPeerType());
            this.quorumPeer.setSyncEnabled(this.quorumPeerConfig.getSyncEnabled());
            this.quorumPeer.setQuorumListenOnAllIPs(this.quorumPeerConfig.getQuorumListenOnAllIPs().booleanValue());
            this.quorumPeer.start();
        }
        catch (IOException ioe) {
            throw new IOException("Failed to start embedded ZooKeeper Peer", ioe);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start embedded ZooKeeper Peer", e);
        }
    }

    public synchronized void shutdown() {
        if (this.started) {
            this.started = false;
            if (this.transactionLog != null) {
                try {
                    this.transactionLog.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close Transaction Log", (Throwable)ioe);
                }
            }
            if (this.connectionFactory != null) {
                this.connectionFactory.shutdown();
            }
            if (this.quorumPeer != null && this.quorumPeer.isRunning()) {
                this.quorumPeer.shutdown();
            }
            if (this.embeddedZkServer != null && this.embeddedZkServer.isRunning()) {
                this.embeddedZkServer.shutdown();
            }
        }
    }

    public static ZooKeeperStateServer create(NiFiProperties properties) throws IOException, QuorumPeerConfig.ConfigException {
        File propsFile = properties.getEmbeddedZooKeeperPropertiesFile();
        if (propsFile == null) {
            return null;
        }
        if (!propsFile.exists() || !propsFile.canRead()) {
            throw new IOException("Cannot create Embedded ZooKeeper Server because the Properties File " + propsFile.getAbsolutePath() + " referenced in nifi.properties does not exist or cannot be read");
        }
        Properties zkProperties = new Properties();
        try (FileInputStream fis = new FileInputStream(propsFile);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            zkProperties.load(bis);
        }
        return new ZooKeeperStateServer(zkProperties);
    }
}

