/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.RepositoryStatusReport;

public class StandardRepositoryStatusReport
implements RepositoryStatusReport {
    private final Map<String, FlowFileEvent> entries = new HashMap<String, FlowFileEvent>();

    public Map<String, FlowFileEvent> getReportEntries() {
        return Collections.unmodifiableMap(this.entries);
    }

    public FlowFileEvent getReportEntry(String componentId) {
        return this.entries.get(componentId);
    }

    public void addReportEntry(FlowFileEvent entry) {
        if (entry == null) {
            throw new NullPointerException("report entry may not be null");
        }
        this.entries.put(entry.getComponentIdentifier(), entry);
    }

    public String toString() {
        StringBuilder strb = new StringBuilder();
        for (String key : this.entries.keySet()) {
            FlowFileEvent entry = this.entries.get(key);
            strb.append("[").append(entry.getComponentIdentifier()).append(", ").append(entry.getFlowFilesIn()).append(", ").append(entry.getContentSizeIn()).append(", ").append(entry.getFlowFilesOut()).append(", ").append(entry.getContentSizeOut()).append(", ").append(entry.getBytesRead()).append(", ").append(entry.getBytesWritten()).append("]\n");
        }
        return strb.toString();
    }
}

