/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.scheduling;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ScheduleState {
    private final AtomicInteger activeThreadCount = new AtomicInteger(0);
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    private final Set<ScheduledFuture<?>> futures = new HashSet();
    private final AtomicBoolean mustCallOnStoppedMethods = new AtomicBoolean(false);
    private volatile long lastStopTime = -1L;

    public int incrementActiveThreadCount() {
        return this.activeThreadCount.incrementAndGet();
    }

    public int decrementActiveThreadCount() {
        return this.activeThreadCount.decrementAndGet();
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount.get();
    }

    public boolean isScheduled() {
        return this.scheduled.get();
    }

    void setScheduled(boolean scheduled) {
        this.scheduled.set(scheduled);
        this.mustCallOnStoppedMethods.set(true);
        if (!scheduled) {
            this.lastStopTime = System.currentTimeMillis();
        }
    }

    public long getLastStopTime() {
        return this.lastStopTime;
    }

    public String toString() {
        return "activeThreads:" + this.activeThreadCount.get() + "; " + "scheduled:" + this.scheduled.get() + "; ";
    }

    public boolean mustCallOnStoppedMethods() {
        return this.mustCallOnStoppedMethods.getAndSet(false);
    }

    public synchronized void setFutures(Collection<ScheduledFuture<?>> newFutures) {
        this.futures.clear();
        this.futures.addAll(newFutures);
    }

    public synchronized void replaceFuture(ScheduledFuture<?> oldFuture, ScheduledFuture<?> newFuture) {
        this.futures.remove(oldFuture);
        this.futures.add(newFuture);
    }

    public synchronized Set<ScheduledFuture<?>> getFutures() {
        return Collections.unmodifiableSet(this.futures);
    }
}

