/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.ProcessGroupCounts;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.StandardProcessContext;
import org.apache.nifi.processor.annotation.OnRemoved;
import org.apache.nifi.processor.annotation.OnShutdown;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardProcessGroup
implements ProcessGroup {
    private final String id;
    private final AtomicReference<ProcessGroup> parent;
    private final AtomicReference<String> name;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> comments;
    private final StandardProcessScheduler scheduler;
    private final ControllerServiceProvider controllerServiceProvider;
    private final FlowController flowController;
    private final Map<String, Port> inputPorts = new HashMap<String, Port>();
    private final Map<String, Port> outputPorts = new HashMap<String, Port>();
    private final Map<String, Connection> connections = new HashMap<String, Connection>();
    private final Map<String, ProcessGroup> processGroups = new HashMap<String, ProcessGroup>();
    private final Map<String, Label> labels = new HashMap<String, Label>();
    private final Map<String, RemoteProcessGroup> remoteGroups = new HashMap<String, RemoteProcessGroup>();
    private final Map<String, ProcessorNode> processors = new HashMap<String, ProcessorNode>();
    private final Map<String, Funnel> funnels = new HashMap<String, Funnel>();
    private final StringEncryptor encryptor;
    private final VariableRegistry variableRegistry;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private static final Logger LOG = LoggerFactory.getLogger(StandardProcessGroup.class);

    public StandardProcessGroup(String id, ControllerServiceProvider serviceProvider, StandardProcessScheduler scheduler, NiFiProperties nifiProps, StringEncryptor encryptor, FlowController flowController, VariableRegistry variableRegistry) {
        this.id = id;
        this.controllerServiceProvider = serviceProvider;
        this.parent = new AtomicReference();
        this.scheduler = scheduler;
        this.comments = new AtomicReference<String>("");
        this.encryptor = encryptor;
        this.flowController = flowController;
        this.variableRegistry = variableRegistry;
        this.name = new AtomicReference();
        this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
    }

    public ProcessGroup getParent() {
        return this.parent.get();
    }

    public void setParent(ProcessGroup newParent) {
        this.parent.set(newParent);
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("The name cannot be blank.");
        }
        this.name.set(name);
    }

    public void setPosition(Position position) {
        this.position.set(position);
    }

    public Position getPosition() {
        return this.position.get();
    }

    public String getComments() {
        return this.comments.get();
    }

    public void setComments(String comments) {
        this.comments.set(comments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessGroupCounts getCounts() {
        int inputPortCount = 0;
        int outputPortCount = 0;
        int running = 0;
        int stopped = 0;
        int invalid = 0;
        int disabled = 0;
        int activeRemotePorts = 0;
        int inactiveRemotePorts = 0;
        this.readLock.lock();
        try {
            for (ProcessorNode procNode : this.processors.values()) {
                if (ScheduledState.DISABLED.equals((Object)procNode.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (procNode.isRunning()) {
                    ++running;
                    continue;
                }
                if (!procNode.isValid()) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            inputPortCount = this.inputPorts.size();
            for (Port port : this.inputPorts.values()) {
                if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (port.isRunning()) {
                    ++running;
                    continue;
                }
                if (!port.isValid()) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            outputPortCount = this.outputPorts.size();
            for (Port port : this.outputPorts.values()) {
                if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                    ++disabled;
                    continue;
                }
                if (port.isRunning()) {
                    ++running;
                    continue;
                }
                if (!port.isValid()) {
                    ++invalid;
                    continue;
                }
                ++stopped;
            }
            for (ProcessGroup childGroup : this.processGroups.values()) {
                ProcessGroupCounts childCounts = childGroup.getCounts();
                running += childCounts.getRunningCount();
                stopped += childCounts.getStoppedCount();
                invalid += childCounts.getInvalidCount();
                disabled += childCounts.getDisabledCount();
            }
            for (RemoteProcessGroup remoteGroup : this.findAllRemoteProcessGroups()) {
                for (Port port : remoteGroup.getInputPorts()) {
                    if (!port.hasIncomingConnection()) continue;
                    if (port.isRunning()) {
                        ++activeRemotePorts;
                        continue;
                    }
                    ++inactiveRemotePorts;
                }
                for (Port port : remoteGroup.getOutputPorts()) {
                    if (port.getConnections().isEmpty()) continue;
                    if (port.isRunning()) {
                        ++activeRemotePorts;
                        continue;
                    }
                    ++inactiveRemotePorts;
                }
                String authIssue = remoteGroup.getAuthorizationIssue();
                if (authIssue == null) continue;
                ++invalid;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return new ProcessGroupCounts(inputPortCount, outputPortCount, running, stopped, invalid, disabled, activeRemotePorts, inactiveRemotePorts);
    }

    public boolean isRootGroup() {
        return this.parent.get() == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessing() {
        this.readLock.lock();
        try {
            for (ProcessorNode node : this.processors.values()) {
                try {
                    if (node.isRunning() || node.getScheduledState() == ScheduledState.DISABLED) continue;
                    this.startProcessor(node);
                }
                catch (Throwable t) {
                    LOG.error("Unable to start {} due to {}", new Object[]{node, t});
                }
            }
            for (Port inputPort : this.getInputPorts()) {
                if (inputPort.getScheduledState() == ScheduledState.DISABLED) continue;
                this.startInputPort(inputPort);
            }
            for (Port outputPort : this.getOutputPorts()) {
                if (outputPort.getScheduledState() == ScheduledState.DISABLED) continue;
                this.startOutputPort(outputPort);
            }
            for (Funnel funnel : this.getFunnels()) {
                if (funnel.getScheduledState() == ScheduledState.DISABLED) continue;
                this.startFunnel(funnel);
            }
            for (ProcessGroup group : this.processGroups.values()) {
                group.startProcessing();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopProcessing() {
        this.readLock.lock();
        try {
            for (ProcessorNode node : this.processors.values()) {
                try {
                    if (!node.isRunning()) continue;
                    this.stopProcessor(node);
                }
                catch (Throwable t) {
                    LOG.error("Unable to stop {} due to {}", new Object[]{node, t});
                }
            }
            for (Port inputPort : this.getInputPorts()) {
                if (inputPort.getScheduledState() != ScheduledState.RUNNING) continue;
                this.stopInputPort(inputPort);
            }
            for (Port outputPort : this.getOutputPorts()) {
                if (outputPort.getScheduledState() != ScheduledState.RUNNING) continue;
                this.stopOutputPort(outputPort);
            }
            for (ProcessGroup group : this.processGroups.values()) {
                group.stopProcessing();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private StateManager getStateManager(String componentId) {
        return this.flowController.getStateManagerProvider().getStateManager(componentId);
    }

    private void shutdown(ProcessGroup procGroup) {
        for (ProcessorNode node : procGroup.getProcessors()) {
            NarCloseable x = NarCloseable.withNarLoader();
            Throwable throwable = null;
            try {
                StandardProcessContext processContext = new StandardProcessContext(node, this.controllerServiceProvider, this.encryptor, this.getStateManager(node.getIdentifier()), this.variableRegistry);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotations(org.apache.nifi.annotation.lifecycle.OnShutdown.class, OnShutdown.class, (Object)node.getProcessor(), processContext);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (x == null) continue;
                if (throwable != null) {
                    try {
                        x.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                x.close();
            }
        }
        for (RemoteProcessGroup rpg : procGroup.getRemoteProcessGroups()) {
            rpg.shutdown();
        }
        for (ProcessGroup group : procGroup.getProcessGroups()) {
            this.shutdown(group);
        }
    }

    public void shutdown() {
        this.readLock.lock();
        try {
            this.shutdown(this);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addInputPort(Port port) {
        if (this.isRootGroup()) {
            if (!(port instanceof RootGroupPort)) {
                throw new IllegalArgumentException("Cannot add Input Port of type " + port.getClass().getName() + " to the Root Group");
            }
        } else if (!(port instanceof LocalPort)) {
            throw new IllegalArgumentException("Cannot add Input Port of type " + port.getClass().getName() + " to a non-root group");
        }
        this.writeLock.lock();
        try {
            if (this.inputPorts.containsKey(Objects.requireNonNull(port).getIdentifier())) {
                throw new IllegalStateException("Input Port with ID " + port.getIdentifier() + " already exists");
            }
            if (this.getInputPortByName(port.getName()) != null) {
                throw new IllegalStateException("Input Port with name " + port.getName() + " already exists");
            }
            port.setProcessGroup((ProcessGroup)this);
            this.inputPorts.put(Objects.requireNonNull(port).getIdentifier(), port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInputPort(Port port) {
        this.writeLock.lock();
        try {
            Port toRemove = this.inputPorts.get(Objects.requireNonNull(port).getIdentifier());
            if (toRemove == null) {
                throw new IllegalStateException(port + " is not an Input Port of this Process Group");
            }
            port.verifyCanDelete();
            for (Object conn : port.getConnections()) {
                conn.verifyCanDelete();
            }
            if (port.isRunning()) {
                this.stopInputPort(port);
            }
            HashSet copy = new HashSet(port.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            Port removed = this.inputPorts.remove(port.getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(port + " is not an Input Port of this Process Group");
            }
            LOG.info("Input Port {} removed from flow", (Object)port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Port getInputPort(String id) {
        this.readLock.lock();
        try {
            Port port = this.inputPorts.get(Objects.requireNonNull(id));
            return port;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Port> getInputPorts() {
        this.readLock.lock();
        try {
            HashSet<Port> hashSet = new HashSet<Port>(this.inputPorts.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addOutputPort(Port port) {
        if (this.isRootGroup()) {
            if (!(port instanceof RootGroupPort)) {
                throw new IllegalArgumentException("Cannot add Output Port of type " + port.getClass().getName() + " to the Root Group");
            }
        } else if (!(port instanceof LocalPort)) {
            throw new IllegalArgumentException("Cannot add Output Port of type " + port.getClass().getName() + " to a non-root group");
        }
        this.writeLock.lock();
        try {
            if (this.outputPorts.containsKey(Objects.requireNonNull(port).getIdentifier())) {
                throw new IllegalStateException("Output Port with ID " + port.getIdentifier() + " already exists");
            }
            if (this.getOutputPortByName(port.getName()) != null) {
                throw new IllegalStateException("Output Port with Name " + port.getName() + " already exists");
            }
            port.setProcessGroup((ProcessGroup)this);
            this.outputPorts.put(port.getIdentifier(), port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOutputPort(Port port) {
        this.writeLock.lock();
        try {
            Port toRemove = this.outputPorts.get(Objects.requireNonNull(port).getIdentifier());
            toRemove.verifyCanDelete();
            if (port.isRunning()) {
                this.stopOutputPort(port);
            }
            if (!toRemove.getConnections().isEmpty()) {
                throw new IllegalStateException(port + " cannot be removed until its connections are removed");
            }
            Port removed = this.outputPorts.remove(port.getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(port + " is not an Output Port of this Process Group");
            }
            LOG.info("Output Port {} removed from flow", (Object)port);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Port getOutputPort(String id) {
        this.readLock.lock();
        try {
            Port port = this.outputPorts.get(Objects.requireNonNull(id));
            return port;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<Port> getOutputPorts() {
        this.readLock.lock();
        try {
            HashSet<Port> hashSet = new HashSet<Port>(this.outputPorts.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addProcessGroup(ProcessGroup group) {
        if (StringUtils.isEmpty((CharSequence)group.getName())) {
            throw new IllegalArgumentException("Process Group's name must be specified");
        }
        this.writeLock.lock();
        try {
            group.setParent((ProcessGroup)this);
            this.processGroups.put(Objects.requireNonNull(group).getIdentifier(), group);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ProcessGroup getProcessGroup(String id) {
        this.readLock.lock();
        try {
            ProcessGroup processGroup = this.processGroups.get(id);
            return processGroup;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Set<ProcessGroup> getProcessGroups() {
        this.readLock.lock();
        try {
            HashSet<ProcessGroup> hashSet = new HashSet<ProcessGroup>(this.processGroups.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void removeProcessGroup(ProcessGroup group) {
        Objects.requireNonNull(group).verifyCanDelete();
        this.writeLock.lock();
        try {
            ProcessGroup toRemove = this.processGroups.get(group.getIdentifier());
            if (toRemove == null) {
                throw new IllegalStateException(group + " is not a member of this Process Group");
            }
            toRemove.verifyCanDelete();
            this.removeComponents(group);
            this.processGroups.remove(group.getIdentifier());
            LOG.info("{} removed from flow", (Object)group);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void removeComponents(ProcessGroup group) {
        for (Connection connection : new ArrayList(group.getConnections())) {
            group.removeConnection(connection);
        }
        for (Port port : new ArrayList(group.getInputPorts())) {
            group.removeInputPort(port);
        }
        for (Port port : new ArrayList(group.getOutputPorts())) {
            group.removeOutputPort(port);
        }
        for (Funnel funnel : new ArrayList(group.getFunnels())) {
            group.removeFunnel(funnel);
        }
        for (ProcessorNode processor : new ArrayList(group.getProcessors())) {
            group.removeProcessor(processor);
        }
        for (RemoteProcessGroup rpg : new ArrayList(group.getRemoteProcessGroups())) {
            group.removeRemoteProcessGroup(rpg);
        }
        for (Label label : new ArrayList(group.getLabels())) {
            group.removeLabel(label);
        }
        for (ProcessGroup childGroup : new ArrayList(group.getProcessGroups())) {
            group.removeProcessGroup(childGroup);
        }
    }

    public void addRemoteProcessGroup(RemoteProcessGroup remoteGroup) {
        this.writeLock.lock();
        try {
            if (this.remoteGroups.containsKey(Objects.requireNonNull(remoteGroup).getIdentifier())) {
                throw new IllegalStateException("RemoteProcessGroup already exists with ID " + remoteGroup.getIdentifier());
            }
            remoteGroup.setProcessGroup((ProcessGroup)this);
            this.remoteGroups.put(Objects.requireNonNull(remoteGroup).getIdentifier(), remoteGroup);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<RemoteProcessGroup> getRemoteProcessGroups() {
        this.readLock.lock();
        try {
            HashSet<RemoteProcessGroup> hashSet = new HashSet<RemoteProcessGroup>(this.remoteGroups.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemoteProcessGroup(RemoteProcessGroup remoteProcessGroup) {
        String remoteGroupId = Objects.requireNonNull(remoteProcessGroup).getIdentifier();
        this.writeLock.lock();
        try {
            RemoteProcessGroup remoteGroup = this.remoteGroups.get(remoteGroupId);
            if (remoteGroup == null) {
                throw new IllegalStateException(remoteProcessGroup + " is not a member of this Process Group");
            }
            remoteGroup.verifyCanDelete();
            for (RemoteGroupPort port : remoteGroup.getOutputPorts()) {
                for (Connection connection : port.getConnections()) {
                    connection.verifyCanDelete();
                }
            }
            for (RemoteGroupPort port : remoteGroup.getOutputPorts()) {
                HashSet copy = new HashSet(port.getConnections());
                for (Connection connection : copy) {
                    this.removeConnection(connection);
                }
            }
            try {
                remoteGroup.onRemove();
            }
            catch (Exception e) {
                LOG.warn("Failed to clean up resources for {} due to {}", (Object)remoteGroup, (Object)e);
            }
            this.remoteGroups.remove(remoteGroupId);
            LOG.info("{} removed from flow", (Object)remoteProcessGroup);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessor(ProcessorNode processor) {
        this.writeLock.lock();
        try {
            String processorId = Objects.requireNonNull(processor).getIdentifier();
            ProcessorNode existingProcessor = this.processors.get(processorId);
            if (existingProcessor != null) {
                throw new IllegalStateException("A processor is already registered to this ProcessGroup with ID " + processorId);
            }
            processor.setProcessGroup((ProcessGroup)this);
            this.processors.put(processorId, processor);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessor(final ProcessorNode processor) {
        String id = Objects.requireNonNull(processor).getIdentifier();
        this.writeLock.lock();
        try {
            if (!this.processors.containsKey(id)) {
                throw new IllegalStateException(processor + " is not a member of this Process Group");
            }
            processor.verifyCanDelete();
            for (Object conn : processor.getConnections()) {
                conn.verifyCanDelete();
            }
            try {
                Object conn;
                NarCloseable x = NarCloseable.withNarLoader();
                conn = null;
                try {
                    StandardProcessContext processContext = new StandardProcessContext(processor, this.controllerServiceProvider, this.encryptor, this.getStateManager(processor.getIdentifier()), this.variableRegistry);
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotations(org.apache.nifi.annotation.lifecycle.OnRemoved.class, OnRemoved.class, (Object)processor.getProcessor(), processContext);
                }
                catch (Throwable processContext) {
                    conn = processContext;
                    throw processContext;
                }
                finally {
                    if (x != null) {
                        if (conn != null) {
                            try {
                                x.close();
                            }
                            catch (Throwable processContext) {
                                ((Throwable)conn).addSuppressed(processContext);
                            }
                        } else {
                            x.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke 'OnRemoved' methods of " + processor, (Throwable)e);
            }
            for (Map.Entry entry : processor.getProperties().entrySet()) {
                ControllerServiceNode serviceNode;
                String value;
                PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
                if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
                serviceNode.removeReference((ConfiguredComponent)processor);
            }
            this.processors.remove(id);
            LogRepositoryFactory.getRepository((String)processor.getIdentifier()).removeAllObservers();
            final StateManagerProvider stateManagerProvider = this.flowController.getStateManagerProvider();
            this.scheduler.submitFrameworkTask(new Runnable(){

                @Override
                public void run() {
                    stateManagerProvider.onComponentRemoved(processor.getIdentifier());
                }
            });
            HashSet copy = new HashSet(processor.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            LOG.info("{} removed from flow", (Object)processor);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<ProcessorNode> getProcessors() {
        this.readLock.lock();
        try {
            LinkedHashSet<ProcessorNode> linkedHashSet = new LinkedHashSet<ProcessorNode>(this.processors.values());
            return linkedHashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public ProcessorNode getProcessor(String id) {
        this.readLock.lock();
        try {
            ProcessorNode processorNode = this.processors.get(Objects.requireNonNull(id));
            return processorNode;
        }
        finally {
            this.readLock.unlock();
        }
    }

    private boolean isInputPort(Connectable connectable) {
        if (connectable.getConnectableType() != ConnectableType.INPUT_PORT) {
            return false;
        }
        return this.findInputPort(connectable.getIdentifier()) != null;
    }

    private boolean isOutputPort(Connectable connectable) {
        if (connectable.getConnectableType() != ConnectableType.OUTPUT_PORT) {
            return false;
        }
        return this.findOutputPort(connectable.getIdentifier()) != null;
    }

    public void inheritConnection(Connection connection) {
        this.writeLock.lock();
        try {
            this.connections.put(connection.getIdentifier(), connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection connection) {
        this.writeLock.lock();
        try {
            String id = Objects.requireNonNull(connection).getIdentifier();
            Connection existingConnection = this.connections.get(id);
            if (existingConnection != null) {
                throw new IllegalStateException("Connection already exists with ID " + id);
            }
            Connectable source = connection.getSource();
            Connectable destination = connection.getDestination();
            ProcessGroup sourceGroup = source.getProcessGroup();
            ProcessGroup destinationGroup = destination.getProcessGroup();
            if (this.isInputPort(source)) {
                if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection to Process Group because destination is an Input Port that does not belong to a child Process Group");
                    }
                } else if (sourceGroup != this || destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection to Process Group because source and destination are not both in this Process Group");
                }
            } else if (this.isOutputPort(source)) {
                if (!this.processGroups.containsKey(sourceGroup.getIdentifier())) {
                    throw new IllegalStateException("Cannot add Connection to Process Group because source is an Output Port that does not belong to a child Process Group");
                }
                if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection to Process Group because its destination is an Input Port that does not belong to a child Process Group");
                    }
                } else if (destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection to Process Group because its destination does not belong to this Process Group");
                }
            } else {
                if (sourceGroup != this) {
                    throw new IllegalStateException("Cannot add Connection to Process Group because the source does not belong to this Process Group");
                }
                if (this.isOutputPort(destination)) {
                    if (destinationGroup != this) {
                        throw new IllegalStateException("Cannot add Connection to Process Group because its destination is an Output Port but does not belong to this Process Group");
                    }
                } else if (this.isInputPort(destination)) {
                    if (!this.processGroups.containsKey(destinationGroup.getIdentifier())) {
                        throw new IllegalStateException("Cannot add Connection to Process Group because its destination is an Input Port but the Input Port does not belong to a child Process Group");
                    }
                } else if (destinationGroup != this) {
                    throw new IllegalStateException("Cannot add Connection between " + source + " and " + destination + " because they are in different Process Groups and neither is an Input Port or Output Port");
                }
            }
            connection.setProcessGroup((ProcessGroup)this);
            source.addConnection(connection);
            if (source != destination) {
                destination.addConnection(connection);
            }
            this.connections.put(connection.getIdentifier(), connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connectable getConnectable(String id) {
        this.readLock.lock();
        try {
            ProcessorNode node = this.processors.get(id);
            if (node != null) {
                ProcessorNode processorNode = node;
                return processorNode;
            }
            Port inputPort = this.inputPorts.get(id);
            if (inputPort != null) {
                Port port = inputPort;
                return port;
            }
            Port outputPort = this.outputPorts.get(id);
            if (outputPort != null) {
                Port port = outputPort;
                return port;
            }
            Funnel funnel = this.funnels.get(id);
            if (funnel != null) {
                Funnel funnel2 = funnel;
                return funnel2;
            }
            Connectable connectable = null;
            return connectable;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(Connection connectionToRemove) {
        this.writeLock.lock();
        try {
            Connection connection = this.connections.get(Objects.requireNonNull(connectionToRemove).getIdentifier());
            if (connection == null) {
                throw new IllegalStateException(connectionToRemove + " is not a member of this Process Group");
            }
            connectionToRemove.verifyCanDelete();
            Connectable source = connectionToRemove.getSource();
            Connectable dest = connectionToRemove.getDestination();
            source.removeConnection(connection);
            if (source != dest) {
                dest.removeConnection(connection);
            }
            this.connections.remove(connection.getIdentifier());
            LOG.info("{} removed from flow", (Object)connection);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Connection> getConnections() {
        this.readLock.lock();
        try {
            HashSet<Connection> hashSet = new HashSet<Connection>(this.connections.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Connection getConnection(String id) {
        this.readLock.lock();
        try {
            Connection connection = this.connections.get(Objects.requireNonNull(id));
            return connection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<Connection> findAllConnections() {
        return this.findAllConnections(this);
    }

    private List<Connection> findAllConnections(ProcessGroup group) {
        ArrayList<Connection> connections = new ArrayList<Connection>(group.getConnections());
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            connections.addAll(this.findAllConnections(childGroup));
        }
        return connections;
    }

    public void addLabel(Label label) {
        this.writeLock.lock();
        try {
            Label existing = this.labels.get(Objects.requireNonNull(label).getIdentifier());
            if (existing != null) {
                throw new IllegalStateException("A label already exists in this ProcessGroup with ID " + label.getIdentifier());
            }
            label.setProcessGroup((ProcessGroup)this);
            this.labels.put(label.getIdentifier(), label);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void removeLabel(Label label) {
        this.writeLock.lock();
        try {
            Label removed = this.labels.remove(Objects.requireNonNull(label).getIdentifier());
            if (removed == null) {
                throw new IllegalStateException(label + " is not a member of this Process Group.");
            }
            LOG.info("Label with ID {} removed from flow", (Object)label.getIdentifier());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Label> getLabels() {
        this.readLock.lock();
        try {
            HashSet<Label> hashSet = new HashSet<Label>(this.labels.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Label getLabel(String id) {
        this.readLock.lock();
        try {
            Label label = this.labels.get(id);
            return label;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isEmpty() {
        this.readLock.lock();
        try {
            boolean bl = this.inputPorts.isEmpty() && this.outputPorts.isEmpty() && this.connections.isEmpty() && this.processGroups.isEmpty() && this.labels.isEmpty() && this.processors.isEmpty() && this.remoteGroups.isEmpty();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public RemoteProcessGroup getRemoteProcessGroup(String id) {
        this.readLock.lock();
        try {
            RemoteProcessGroup remoteProcessGroup = this.remoteGroups.get(Objects.requireNonNull(id));
            return remoteProcessGroup;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (this.getProcessor(processor.getIdentifier()) == null) {
                throw new IllegalStateException("Processor is not a member of this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("Processor is disabled");
            }
            if (state == ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startInputPort(Port port) {
        this.readLock.lock();
        try {
            if (this.getInputPort(port.getIdentifier()) == null) {
                throw new IllegalStateException(port + " is not a member of this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("InputPort " + port + " is disabled");
            }
            if (state == ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (this.getOutputPort(port.getIdentifier()) == null) {
                throw new IllegalStateException("Port is not a member of this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("OutputPort is disabled");
            }
            if (state == ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void startFunnel(Funnel funnel) {
        this.readLock.lock();
        try {
            if (this.getFunnel(funnel.getIdentifier()) == null) {
                throw new IllegalStateException("Funnel is not a member of this Process Group");
            }
            ScheduledState state = funnel.getScheduledState();
            if (state == ScheduledState.RUNNING) {
                return;
            }
            this.scheduler.startFunnel(funnel);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void stopProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("Processor is disabled");
            }
            if (state == ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void stopInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Input Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("InputPort is disabled");
            }
            if (state == ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void stopOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Output Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("OutputPort is disabled");
            }
            if (state == ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopPort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    private void stopFunnel(Funnel funnel) {
        this.readLock.lock();
        try {
            if (!this.funnels.containsKey(funnel.getIdentifier())) {
                throw new IllegalStateException("No Funnel with ID " + funnel.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = funnel.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                throw new IllegalStateException("Funnel is disabled");
            }
            if (state == ScheduledState.STOPPED) {
                return;
            }
            this.scheduler.stopFunnel(funnel);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Input Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.STOPPED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("InputPort is currently running");
            }
            this.scheduler.enablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No Output Port with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.STOPPED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("OutputPort is currently running");
            }
            this.scheduler.enablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void enableProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No Processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.STOPPED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("Processor is currently running");
            }
            this.scheduler.enableProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableInputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.inputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No InputPort with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("InputPort is currently running");
            }
            this.scheduler.disablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableOutputPort(Port port) {
        this.readLock.lock();
        try {
            if (!this.outputPorts.containsKey(port.getIdentifier())) {
                throw new IllegalStateException("No OutputPort with ID " + port.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = port.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("OutputPort is currently running");
            }
            this.scheduler.disablePort(port);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableProcessor(ProcessorNode processor) {
        this.readLock.lock();
        try {
            if (!this.processors.containsKey(processor.getIdentifier())) {
                throw new IllegalStateException("No Processor with ID " + processor.getIdentifier() + " belongs to this Process Group");
            }
            ScheduledState state = processor.getScheduledState();
            if (state == ScheduledState.DISABLED) {
                return;
            }
            if (state == ScheduledState.RUNNING) {
                throw new IllegalStateException("Processor is currently running");
            }
            this.scheduler.disableProcessor(processor);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StandardProcessGroup) {
            StandardProcessGroup other = (StandardProcessGroup)obj;
            return this.getIdentifier().equals(other.getIdentifier());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getIdentifier()).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", this.name).toString();
    }

    public ProcessGroup findProcessGroup(String id) {
        return this.findProcessGroup(Objects.requireNonNull(id), this);
    }

    private ProcessGroup findProcessGroup(String id, ProcessGroup start) {
        if (id.equals(start.getIdentifier())) {
            return start;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            ProcessGroup matching = this.findProcessGroup(id, group);
            if (matching == null) continue;
            return matching;
        }
        return null;
    }

    public List<RemoteProcessGroup> findAllRemoteProcessGroups() {
        return this.findAllRemoteProcessGroups(this);
    }

    private List<RemoteProcessGroup> findAllRemoteProcessGroups(ProcessGroup start) {
        ArrayList<RemoteProcessGroup> remoteGroups = new ArrayList<RemoteProcessGroup>(start.getRemoteProcessGroups());
        for (ProcessGroup childGroup : start.getProcessGroups()) {
            remoteGroups.addAll(this.findAllRemoteProcessGroups(childGroup));
        }
        return remoteGroups;
    }

    public RemoteProcessGroup findRemoteProcessGroup(String id) {
        return this.findRemoteProcessGroup(Objects.requireNonNull(id), this);
    }

    private RemoteProcessGroup findRemoteProcessGroup(String id, ProcessGroup start) {
        RemoteProcessGroup remoteGroup = start.getRemoteProcessGroup(id);
        if (remoteGroup != null) {
            return remoteGroup;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            remoteGroup = this.findRemoteProcessGroup(id, group);
            if (remoteGroup == null) continue;
            return remoteGroup;
        }
        return null;
    }

    public ProcessorNode findProcessor(String id) {
        return this.findProcessor(id, this);
    }

    private ProcessorNode findProcessor(String id, ProcessGroup start) {
        ProcessorNode node = start.getProcessor(id);
        if (node != null) {
            return node;
        }
        for (ProcessGroup group : start.getProcessGroups()) {
            node = this.findProcessor(id, group);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public List<ProcessorNode> findAllProcessors() {
        return this.findAllProcessors(this);
    }

    private List<ProcessorNode> findAllProcessors(ProcessGroup start) {
        ArrayList<ProcessorNode> allNodes = new ArrayList<ProcessorNode>(start.getProcessors());
        for (ProcessGroup group : start.getProcessGroups()) {
            allNodes.addAll(this.findAllProcessors(group));
        }
        return allNodes;
    }

    public Connectable findConnectable(String identifier) {
        return StandardProcessGroup.findConnectable(identifier, this);
    }

    private static Connectable findConnectable(String identifier, ProcessGroup group) {
        ProcessorNode procNode = group.getProcessor(identifier);
        if (procNode != null) {
            return procNode;
        }
        Port inPort = group.getInputPort(identifier);
        if (inPort != null) {
            return inPort;
        }
        Port outPort = group.getOutputPort(identifier);
        if (outPort != null) {
            return outPort;
        }
        Funnel funnel = group.getFunnel(identifier);
        if (funnel != null) {
            return funnel;
        }
        for (RemoteProcessGroup remoteGroup : group.getRemoteProcessGroups()) {
            RemoteGroupPort remoteInPort = remoteGroup.getInputPort(identifier);
            if (remoteInPort != null) {
                return remoteInPort;
            }
            RemoteGroupPort remoteOutPort = remoteGroup.getOutputPort(identifier);
            if (remoteOutPort == null) continue;
            return remoteOutPort;
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            Connectable childGroupConnectable = StandardProcessGroup.findConnectable(identifier, childGroup);
            if (childGroupConnectable == null) continue;
            return childGroupConnectable;
        }
        return null;
    }

    public List<Label> findAllLabels() {
        return this.findAllLabels(this);
    }

    private List<Label> findAllLabels(ProcessGroup start) {
        ArrayList<Label> allLabels = new ArrayList<Label>(start.getLabels());
        for (ProcessGroup group : start.getProcessGroups()) {
            allLabels.addAll(this.findAllLabels(group));
        }
        return allLabels;
    }

    public Port findInputPort(String id) {
        return this.findPort(id, this, new InputPortRetriever());
    }

    public Port findOutputPort(String id) {
        return this.findPort(id, this, new OutputPortRetriever());
    }

    public Port getInputPortByName(String name) {
        return this.getPortByName(name, this, new InputPortRetriever());
    }

    public Port getOutputPortByName(String name) {
        return this.getPortByName(name, this, new OutputPortRetriever());
    }

    private Port findPort(String id, ProcessGroup group, PortRetriever retriever) {
        Port port = retriever.getPort(group, id);
        if (port != null) {
            return port;
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            port = this.findPort(id, childGroup, retriever);
            if (port == null) continue;
            return port;
        }
        return null;
    }

    private Port getPortByName(String name, ProcessGroup group, PortRetriever retriever) {
        for (Port port : retriever.getPorts(group)) {
            if (!port.getName().equals(name)) continue;
            return port;
        }
        return null;
    }

    public void addFunnel(Funnel funnel) {
        this.addFunnel(funnel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFunnel(Funnel funnel, boolean autoStart) {
        this.writeLock.lock();
        try {
            Funnel existing = this.funnels.get(Objects.requireNonNull(funnel).getIdentifier());
            if (existing != null) {
                throw new IllegalStateException("A funnel already exists in this ProcessGroup with ID " + funnel.getIdentifier());
            }
            funnel.setProcessGroup((ProcessGroup)this);
            this.funnels.put(funnel.getIdentifier(), funnel);
            if (autoStart) {
                this.startFunnel(funnel);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Funnel getFunnel(String id) {
        this.readLock.lock();
        try {
            Funnel funnel = this.funnels.get(id);
            return funnel;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFunnel(Funnel funnel) {
        this.writeLock.lock();
        try {
            Funnel existing = this.funnels.get(Objects.requireNonNull(funnel).getIdentifier());
            if (existing == null) {
                throw new IllegalStateException(funnel + " is not a member of this ProcessGroup");
            }
            funnel.verifyCanDelete();
            for (Connection conn : funnel.getConnections()) {
                conn.verifyCanDelete();
            }
            this.stopFunnel(funnel);
            HashSet copy = new HashSet(funnel.getConnections());
            for (Connection conn : copy) {
                this.removeConnection(conn);
            }
            this.funnels.remove(funnel.getIdentifier());
            LOG.info("{} removed from flow", (Object)funnel);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Set<Funnel> getFunnels() {
        this.readLock.lock();
        try {
            HashSet<Funnel> hashSet = new HashSet<Funnel>(this.funnels.values());
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Snippet snippet) {
        this.writeLock.lock();
        try {
            this.verifyContents(snippet);
            Set<Connectable> connectables = this.getAllConnectables(snippet);
            HashSet<String> connectionIdsToRemove = new HashSet<String>(this.replaceNullWithEmptySet(snippet.getConnections()));
            for (Connectable connectable : connectables) {
                for (Connection conn : connectable.getConnections()) {
                    if (!this.connections.containsKey(conn.getIdentifier())) {
                        throw new IllegalStateException(connectable + " cannot be removed because it has incoming connections from the parent Process Group");
                    }
                    connectionIdsToRemove.add(conn.getIdentifier());
                }
            }
            for (String id : connectionIdsToRemove) {
                this.connections.get(id).verifyCanDelete();
            }
            for (String procId : snippet.getProcessors()) {
                ProcessorNode procNode = this.getProcessor(procId);
                if (procNode.isRunning()) {
                    throw new IllegalStateException(procNode + " cannot be removed because it is running");
                }
                int activeThreadCount = this.scheduler.getActiveThreadCount(procNode);
                if (activeThreadCount == 0) continue;
                throw new IllegalStateException(procNode + " cannot be removed because it still has " + activeThreadCount + " active threads");
            }
            Set connectionIds = snippet.getConnections();
            for (Connectable connectable : connectables) {
                for (Connection conn : connectable.getIncomingConnections()) {
                    if (connectionIds.contains(conn.getIdentifier()) || connectables.contains(conn.getSource())) continue;
                    throw new IllegalStateException(connectable + " cannot be removed because it has incoming connections " + "that are not selected to be deleted");
                }
            }
            for (String groupId : snippet.getProcessGroups()) {
                ProcessGroup toRemove = this.getProcessGroup(groupId);
                toRemove.verifyCanDelete(true);
            }
            for (String id : connectionIdsToRemove) {
                this.removeConnection(this.connections.get(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getInputPorts())) {
                this.removeInputPort(this.inputPorts.get(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getOutputPorts())) {
                this.removeOutputPort(this.outputPorts.get(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getFunnels())) {
                this.removeFunnel(this.funnels.get(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getLabels())) {
                this.removeLabel(this.labels.get(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getProcessors())) {
                this.removeProcessor(this.processors.get(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getRemoteProcessGroups())) {
                this.removeRemoteProcessGroup(this.remoteGroups.get(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getProcessGroups())) {
                this.removeProcessGroup(this.processGroups.get(id));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<String> replaceNullWithEmptySet(Set<String> toReplace) {
        return toReplace == null ? new HashSet() : toReplace;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(Snippet snippet, ProcessGroup destination) {
        this.writeLock.lock();
        try {
            this.verifyContents(snippet);
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            if (!(!this.isRootGroup() || snippet.getInputPorts().isEmpty() && snippet.getOutputPorts().isEmpty())) {
                throw new IllegalStateException("Cannot move Ports out of the root group");
            }
            if (!(!destination.isRootGroup() || snippet.getInputPorts().isEmpty() && snippet.getOutputPorts().isEmpty())) {
                throw new IllegalStateException("Cannot move Ports into the root group");
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getInputPorts())) {
                destination.addInputPort(this.inputPorts.remove(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getOutputPorts())) {
                destination.addOutputPort(this.outputPorts.remove(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getFunnels())) {
                destination.addFunnel(this.funnels.remove(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getLabels())) {
                destination.addLabel(this.labels.remove(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getProcessGroups())) {
                destination.addProcessGroup(this.processGroups.remove(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getProcessors())) {
                destination.addProcessor(this.processors.remove(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getRemoteProcessGroups())) {
                destination.addRemoteProcessGroup(this.remoteGroups.remove(id));
            }
            for (String id : this.replaceNullWithEmptySet(snippet.getConnections())) {
                destination.inheritConnection(this.connections.remove(id));
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<Connectable> getAllConnectables(Snippet snippet) {
        HashSet<Connectable> connectables = new HashSet<Connectable>();
        for (String id : this.replaceNullWithEmptySet(snippet.getInputPorts())) {
            connectables.add((Connectable)this.getInputPort(id));
        }
        for (String id : this.replaceNullWithEmptySet(snippet.getOutputPorts())) {
            connectables.add((Connectable)this.getOutputPort(id));
        }
        for (String id : this.replaceNullWithEmptySet(snippet.getFunnels())) {
            connectables.add((Connectable)this.getFunnel(id));
        }
        for (String id : this.replaceNullWithEmptySet(snippet.getProcessors())) {
            connectables.add((Connectable)this.getProcessor(id));
        }
        return connectables;
    }

    private boolean isDisconnected(Snippet snippet) {
        Set<Connectable> connectables = this.getAllConnectables(snippet);
        for (String string : this.replaceNullWithEmptySet(snippet.getRemoteProcessGroups())) {
            RemoteProcessGroup remoteGroup = this.getRemoteProcessGroup(string);
            connectables.addAll(remoteGroup.getInputPorts());
            connectables.addAll(remoteGroup.getOutputPorts());
        }
        Set connectionIds = snippet.getConnections();
        for (Connectable connectable : connectables) {
            for (Connection conn : connectable.getIncomingConnections()) {
                if (connectionIds.contains(conn.getIdentifier())) continue;
                return false;
            }
            for (Connection conn : connectable.getConnections()) {
                if (connectionIds.contains(conn.getIdentifier())) continue;
                return false;
            }
        }
        HashSet<Connectable> hashSet = new HashSet<Connectable>(connectables);
        for (String id : snippet.getProcessGroups()) {
            ProcessGroup childGroup = this.getProcessGroup(id);
            hashSet.addAll(this.findAllConnectables(childGroup, true));
        }
        for (String id : connectionIds) {
            Connection connection = this.getConnection(id);
            if (hashSet.contains(connection.getSource()) && hashSet.contains(connection.getDestination())) continue;
            return false;
        }
        return true;
    }

    private Set<Connectable> findAllConnectables(ProcessGroup group, boolean includeRemotePorts) {
        HashSet<Connectable> set = new HashSet<Connectable>();
        set.addAll(group.getInputPorts());
        set.addAll(group.getOutputPorts());
        set.addAll(group.getFunnels());
        set.addAll(group.getProcessors());
        if (includeRemotePorts) {
            for (RemoteProcessGroup remoteGroup : group.getRemoteProcessGroups()) {
                set.addAll(remoteGroup.getInputPorts());
                set.addAll(remoteGroup.getOutputPorts());
            }
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            set.addAll(this.findAllConnectables(childGroup, includeRemotePorts));
        }
        return set;
    }

    private void verifyContents(Snippet snippet) throws NullPointerException, IllegalStateException {
        Objects.requireNonNull(snippet);
        this.verifyAllKeysExist(snippet.getInputPorts(), this.inputPorts, "Input Port");
        this.verifyAllKeysExist(snippet.getOutputPorts(), this.outputPorts, "Output Port");
        this.verifyAllKeysExist(snippet.getFunnels(), this.funnels, "Funnel");
        this.verifyAllKeysExist(snippet.getLabels(), this.labels, "Label");
        this.verifyAllKeysExist(snippet.getProcessGroups(), this.processGroups, "Process Group");
        this.verifyAllKeysExist(snippet.getProcessors(), this.processors, "Processor");
        this.verifyAllKeysExist(snippet.getRemoteProcessGroups(), this.remoteGroups, "Remote Process Group");
        this.verifyAllKeysExist(snippet.getConnections(), this.connections, "Connection");
    }

    private void verifyAllKeysExist(Set<String> ids, Map<String, ?> map, String componentType) {
        if (ids != null) {
            for (String id : ids) {
                if (map.containsKey(id)) continue;
                throw new IllegalStateException("ID " + id + " does not refer to a(n) " + componentType + " in this ProcessGroup");
            }
        }
    }

    public void verifyCanDelete() {
        this.verifyCanDelete(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(boolean ignoreConnections) {
        this.readLock.lock();
        try {
            for (Port port : this.inputPorts.values()) {
                port.verifyCanDelete(true);
            }
            for (Port port : this.outputPorts.values()) {
                port.verifyCanDelete(true);
            }
            for (ProcessorNode procNode : this.processors.values()) {
                procNode.verifyCanDelete(true);
            }
            for (Connection connection : this.connections.values()) {
                connection.verifyCanDelete();
            }
            for (ProcessGroup childGroup : this.processGroups.values()) {
                childGroup.verifyCanDelete(true);
            }
            if (!ignoreConnections) {
                for (Port port : this.inputPorts.values()) {
                    for (Connection connection : port.getIncomingConnections()) {
                        if (connection.getSource().equals(port)) {
                            connection.verifyCanDelete();
                            continue;
                        }
                        throw new IllegalStateException("Cannot delete Process Group because Input Port " + port + " has at least one incoming connection from a component outside of the Process Group. Delete this connection first.");
                    }
                }
                for (Port port : this.outputPorts.values()) {
                    for (Connection connection : port.getConnections()) {
                        if (connection.getDestination().equals(port)) {
                            connection.verifyCanDelete();
                            continue;
                        }
                        throw new IllegalStateException("Cannot delete Process Group because Output Port " + port + " has at least one outgoing connection to a component outside of the Process Group. Delete this connection first.");
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void verifyCanStop() {
    }

    public void verifyCanStart() {
        this.readLock.lock();
        try {
            for (Connectable connectable : this.findAllConnectables(this, false)) {
                if (connectable.getScheduledState() != ScheduledState.STOPPED) continue;
                if (this.scheduler.getActiveThreadCount(connectable) > 0) {
                    throw new IllegalStateException("Cannot start " + connectable + " because it is currently stopping");
                }
                connectable.verifyCanStart();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanDelete(Snippet snippet) throws IllegalStateException {
        this.readLock.lock();
        try {
            ProcessGroup group;
            Port port;
            if (!this.id.equals(snippet.getParentGroupId())) {
                throw new IllegalStateException("Snippet belongs to ProcessGroup with ID " + snippet.getParentGroupId() + " but this ProcessGroup has id " + this.id);
            }
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            for (String id : snippet.getConnections()) {
                Connection connection = this.getConnection(id);
                if (connection == null) {
                    throw new IllegalStateException("Snippet references Connection with ID " + id + ", which does not exist in this ProcessGroup");
                }
                connection.verifyCanDelete();
            }
            for (String id : snippet.getFunnels()) {
                Funnel funnel = this.getFunnel(id);
                if (funnel == null) {
                    throw new IllegalStateException("Snippet references Funnel with ID " + id + ", which does not exist in this ProcessGroup");
                }
                funnel.verifyCanDelete(true);
            }
            for (String id : snippet.getInputPorts()) {
                port = this.getInputPort(id);
                if (port == null) {
                    throw new IllegalStateException("Snippet references Input Port with ID " + id + ", which does not exist in this ProcessGroup");
                }
                port.verifyCanDelete(true);
            }
            for (String id : snippet.getLabels()) {
                Label label = this.getLabel(id);
                if (label != null) continue;
                throw new IllegalStateException("Snippet references Label with ID " + id + ", which does not exist in this ProcessGroup");
            }
            for (String id : snippet.getOutputPorts()) {
                port = this.getOutputPort(id);
                if (port == null) {
                    throw new IllegalStateException("Snippet references Output Port with ID " + id + ", which does not exist in this ProcessGroup");
                }
                port.verifyCanDelete(true);
            }
            for (String id : snippet.getProcessGroups()) {
                group = this.getProcessGroup(id);
                if (group == null) {
                    throw new IllegalStateException("Snippet references Process Group with ID " + id + ", which does not exist in this ProcessGroup");
                }
                group.verifyCanDelete(true);
            }
            for (String id : snippet.getProcessors()) {
                ProcessorNode processor = this.getProcessor(id);
                if (processor == null) {
                    throw new IllegalStateException("Snippet references Processor with ID " + id + ", which does not exist in this ProcessGroup");
                }
                processor.verifyCanDelete(true);
            }
            for (String id : snippet.getRemoteProcessGroups()) {
                group = this.getRemoteProcessGroup(id);
                if (group == null) {
                    throw new IllegalStateException("Snippet references Remote Process Group with ID " + id + ", which does not exist in this ProcessGroup");
                }
                group.verifyCanDelete(true);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyCanMove(Snippet snippet, ProcessGroup newProcessGroup) throws IllegalStateException {
        this.readLock.lock();
        try {
            String portName;
            Port port;
            if (!this.id.equals(snippet.getParentGroupId())) {
                throw new IllegalStateException("Snippet belongs to ProcessGroup with ID " + snippet.getParentGroupId() + " but this ProcessGroup has id " + this.id);
            }
            this.verifyContents(snippet);
            if (!this.isDisconnected(snippet)) {
                throw new IllegalStateException("One or more components within the snippet is connected to a component outside of the snippet. Only a disconnected snippet may be moved.");
            }
            if (!(!this.isRootGroup() || snippet.getInputPorts().isEmpty() && snippet.getOutputPorts().isEmpty())) {
                throw new IllegalStateException("Cannot move Ports from the Root Group to a Non-Root Group");
            }
            for (String id : snippet.getInputPorts()) {
                port = this.getInputPort(id);
                portName = port.getName();
                if (newProcessGroup.getInputPortByName(portName) == null) continue;
                throw new IllegalStateException("Cannot perform Move Operation because the destination Process Group already has an Input Port with the name " + portName);
            }
            for (String id : snippet.getOutputPorts()) {
                port = this.getOutputPort(id);
                portName = port.getName();
                if (newProcessGroup.getOutputPortByName(portName) == null) continue;
                throw new IllegalStateException("Cannot perform Move Operation because the destination Process Group already has an Output Port with the name " + portName);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    private static class OutputPortRetriever
    implements PortRetriever {
        private OutputPortRetriever() {
        }

        @Override
        public Set<Port> getPorts(ProcessGroup group) {
            return group.getOutputPorts();
        }

        @Override
        public Port getPort(ProcessGroup group, String id) {
            return group.getOutputPort(id);
        }
    }

    private static class InputPortRetriever
    implements PortRetriever {
        private InputPortRetriever() {
        }

        @Override
        public Set<Port> getPorts(ProcessGroup group) {
            return group.getInputPorts();
        }

        @Override
        public Port getPort(ProcessGroup group, String id) {
            return group.getInputPort(id);
        }
    }

    private static interface PortRetriever {
        public Port getPort(ProcessGroup var1, String var2);

        public Set<Port> getPorts(ProcessGroup var1);
    }
}

