/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.QueueProvider;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.StandardRepositoryRecord;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wali.MinimalLockingWriteAheadLog;
import org.wali.SerDe;
import org.wali.SyncListener;
import org.wali.UpdateType;
import org.wali.WriteAheadRepository;

public class WriteAheadFlowFileRepository
implements FlowFileRepository,
SyncListener {
    private final AtomicLong flowFileSequenceGenerator = new AtomicLong(0L);
    private final boolean alwaysSync;
    private static final Logger logger = LoggerFactory.getLogger(WriteAheadFlowFileRepository.class);
    private volatile ScheduledFuture<?> checkpointFuture;
    private final long checkpointDelayMillis;
    private final Path flowFileRepositoryPath;
    private final int numPartitions;
    private final ScheduledExecutorService checkpointExecutor;
    private WriteAheadRepository<RepositoryRecord> wal;
    private WriteAheadRecordSerde serde;
    private ResourceClaimManager claimManager;
    private final ConcurrentMap<Integer, BlockingQueue<ResourceClaim>> claimsAwaitingDestruction = new ConcurrentHashMap<Integer, BlockingQueue<ResourceClaim>>();

    public WriteAheadFlowFileRepository() {
        NiFiProperties properties = NiFiProperties.getInstance();
        this.alwaysSync = Boolean.parseBoolean(properties.getProperty("nifi.flowfile.repository.always.sync", "false"));
        this.flowFileRepositoryPath = properties.getFlowFileRepositoryPath();
        this.numPartitions = properties.getFlowFileRepositoryPartitions();
        this.checkpointDelayMillis = FormatUtils.getTimeDuration((String)properties.getFlowFileRepositoryCheckpointInterval(), (TimeUnit)TimeUnit.MILLISECONDS);
        this.checkpointExecutor = Executors.newSingleThreadScheduledExecutor();
    }

    public void initialize(ResourceClaimManager claimManager) throws IOException {
        this.claimManager = claimManager;
        Files.createDirectories(this.flowFileRepositoryPath, new FileAttribute[0]);
        this.serde = new WriteAheadRecordSerde(claimManager);
        this.wal = new MinimalLockingWriteAheadLog(this.flowFileRepositoryPath, this.numPartitions, (SerDe)this.serde, (SyncListener)this);
    }

    public void close() throws IOException {
        if (this.checkpointFuture != null) {
            this.checkpointFuture.cancel(false);
        }
        this.checkpointExecutor.shutdown();
        this.wal.shutdown();
    }

    public boolean isVolatile() {
        return false;
    }

    public long getStorageCapacity() throws IOException {
        return Files.getFileStore(this.flowFileRepositoryPath).getTotalSpace();
    }

    public long getUsableStorageSpace() throws IOException {
        return Files.getFileStore(this.flowFileRepositoryPath).getUsableSpace();
    }

    public void updateRepository(Collection<RepositoryRecord> records) throws IOException {
        this.updateRepository(records, this.alwaysSync);
    }

    private void markDestructable(ResourceClaim resourceClaim) {
        if (resourceClaim == null) {
            return;
        }
        this.claimManager.markDestructable(resourceClaim);
    }

    private boolean isDestructable(ContentClaim claim) {
        if (claim == null) {
            return false;
        }
        ResourceClaim resourceClaim = claim.getResourceClaim();
        if (resourceClaim == null) {
            return false;
        }
        return !resourceClaim.isInUse();
    }

    private void updateRepository(Collection<RepositoryRecord> records, boolean sync) throws IOException {
        for (RepositoryRecord record : records) {
            if (record.getType() == RepositoryRecordType.DELETE || record.getType() == RepositoryRecordType.CONTENTMISSING || record.getDestination() != null) continue;
            throw new IllegalArgumentException("Record " + record + " has no destination and Type is " + record.getType());
        }
        int partitionIndex = this.wal.update(records, sync);
        HashSet<ResourceClaim> claimsToAdd = new HashSet<ResourceClaim>();
        for (RepositoryRecord record : records) {
            List transientClaims;
            if (record.getType() == RepositoryRecordType.DELETE) {
                if (record.getCurrentClaim() != null && this.isDestructable(record.getCurrentClaim())) {
                    claimsToAdd.add(record.getCurrentClaim().getResourceClaim());
                }
                if (record.getOriginalClaim() != null && !record.getOriginalClaim().equals(record.getCurrentClaim()) && this.isDestructable(record.getOriginalClaim())) {
                    claimsToAdd.add(record.getOriginalClaim().getResourceClaim());
                }
            } else if (record.getType() == RepositoryRecordType.UPDATE && record.getOriginalClaim() != null && record.getCurrentClaim() != record.getOriginalClaim() && this.isDestructable(record.getOriginalClaim())) {
                claimsToAdd.add(record.getOriginalClaim().getResourceClaim());
            }
            if ((transientClaims = record.getTransientClaims()) == null) continue;
            for (ContentClaim transientClaim : transientClaims) {
                if (!this.isDestructable(transientClaim)) continue;
                claimsToAdd.add(transientClaim.getResourceClaim());
            }
        }
        if (!claimsToAdd.isEmpty()) {
            BlockingQueue existingClaimQueue;
            Integer partitionKey = partitionIndex;
            BlockingQueue claimQueue = (LinkedBlockingQueue)this.claimsAwaitingDestruction.get(partitionKey);
            if (claimQueue == null && (existingClaimQueue = (BlockingQueue)this.claimsAwaitingDestruction.putIfAbsent(partitionKey, claimQueue = new LinkedBlockingQueue())) != null) {
                claimQueue = existingClaimQueue;
            }
            claimQueue.addAll(claimsToAdd);
        }
    }

    public void onSync(int partitionIndex) {
        BlockingQueue claimQueue = (BlockingQueue)this.claimsAwaitingDestruction.get(partitionIndex);
        if (claimQueue == null) {
            return;
        }
        HashSet claimsToDestroy = new HashSet();
        claimQueue.drainTo(claimsToDestroy);
        for (ResourceClaim claim : claimsToDestroy) {
            this.markDestructable(claim);
        }
    }

    public void onGlobalSync() {
        for (BlockingQueue claimQueue : this.claimsAwaitingDestruction.values()) {
            HashSet claimsToDestroy = new HashSet();
            claimQueue.drainTo(claimsToDestroy);
            for (ResourceClaim claim : claimsToDestroy) {
                this.markDestructable(claim);
            }
        }
    }

    public void swapFlowFilesOut(List<FlowFileRecord> swappedOut, FlowFileQueue queue, String swapLocation) throws IOException {
        ArrayList<StandardRepositoryRecord> repoRecords = new ArrayList<StandardRepositoryRecord>();
        if (swappedOut == null || swappedOut.isEmpty()) {
            return;
        }
        for (FlowFileRecord swapRecord : swappedOut) {
            StandardRepositoryRecord repoRecord = new StandardRepositoryRecord(queue, swapRecord, swapLocation);
            repoRecords.add(repoRecord);
        }
        this.wal.update(repoRecords, true);
        logger.info("Successfully swapped out {} FlowFiles from {} to Swap File {}", new Object[]{swappedOut.size(), queue, swapLocation});
    }

    public void swapFlowFilesIn(String swapLocation, List<FlowFileRecord> swapRecords, FlowFileQueue queue) throws IOException {
        ArrayList<RepositoryRecord> repoRecords = new ArrayList<RepositoryRecord>();
        for (FlowFileRecord swapRecord : swapRecords) {
            StandardRepositoryRecord repoRecord = new StandardRepositoryRecord(queue, swapRecord);
            repoRecord.setSwapLocation(swapLocation);
            repoRecord.setDestination(queue);
            repoRecords.add(repoRecord);
        }
        this.updateRepository(repoRecords, true);
        logger.info("Repository updated to reflect that {} FlowFiles were swapped in to {}", new Object[]{swapRecords.size(), queue});
    }

    public long loadFlowFiles(QueueProvider queueProvider, long minimumSequenceNumber) throws IOException {
        HashMap<String, FlowFileQueue> queueMap = new HashMap<String, FlowFileQueue>();
        for (FlowFileQueue queue : queueProvider.getAllQueues()) {
            queueMap.put(queue.getIdentifier(), queue);
        }
        this.serde.setQueueMap(queueMap);
        Collection recordList = this.wal.recoverRecords();
        this.serde.setQueueMap(null);
        for (RepositoryRecord record : recordList) {
            ContentClaim claim = record.getCurrentClaim();
            if (claim == null) continue;
            this.claimManager.incrementClaimantCount(claim.getResourceClaim());
        }
        long maxId = minimumSequenceNumber;
        for (RepositoryRecord record : recordList) {
            long recordId = this.serde.getRecordIdentifier(record);
            if (recordId > maxId) {
                maxId = recordId;
            }
            FlowFileRecord flowFile = record.getCurrent();
            FlowFileQueue queue = record.getOriginalQueue();
            if (queue == null) continue;
            queue.put(flowFile);
        }
        this.flowFileSequenceGenerator.set(maxId + 1L);
        logger.info("Successfully restored {} FlowFiles", (Object)recordList.size());
        Runnable checkpointRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    logger.info("Initiating checkpoint of FlowFile Repository");
                    long start = System.nanoTime();
                    int numRecordsCheckpointed = WriteAheadFlowFileRepository.this.checkpoint();
                    long end = System.nanoTime();
                    long millis = TimeUnit.MILLISECONDS.convert(end - start, TimeUnit.NANOSECONDS);
                    logger.info("Successfully checkpointed FlowFile Repository with {} records in {} milliseconds", new Object[]{numRecordsCheckpointed, millis});
                }
                catch (IOException e) {
                    logger.error("Unable to checkpoint FlowFile Repository due to " + e.toString(), (Throwable)e);
                }
            }
        };
        this.checkpointFuture = this.checkpointExecutor.scheduleWithFixedDelay(checkpointRunnable, this.checkpointDelayMillis, this.checkpointDelayMillis, TimeUnit.MILLISECONDS);
        return maxId;
    }

    public long getNextFlowFileSequence() {
        return this.flowFileSequenceGenerator.getAndIncrement();
    }

    public long getMaxFlowFileIdentifier() throws IOException {
        return this.flowFileSequenceGenerator.get() - 1L;
    }

    public int checkpoint() throws IOException {
        return this.wal.checkpoint();
    }

    private static class WriteAheadRecordSerde
    implements SerDe<RepositoryRecord> {
        public static final byte ACTION_CREATE = 0;
        public static final byte ACTION_UPDATE = 1;
        public static final byte ACTION_DELETE = 2;
        public static final byte ACTION_SWAPPED_OUT = 3;
        public static final byte ACTION_SWAPPED_IN = 4;
        private Map<String, FlowFileQueue> flowFileQueueMap = null;
        private long recordsRestored = 0L;
        private final ResourceClaimManager claimManager;

        public WriteAheadRecordSerde(ResourceClaimManager claimManager) {
            this.claimManager = claimManager;
        }

        private void setQueueMap(Map<String, FlowFileQueue> queueMap) {
            this.flowFileQueueMap = queueMap;
        }

        public void serializeEdit(RepositoryRecord previousRecordState, RepositoryRecord record, DataOutputStream out) throws IOException {
            this.serializeEdit(previousRecordState, record, out, false);
        }

        public void serializeEdit(RepositoryRecord previousRecordState, RepositoryRecord record, DataOutputStream out, boolean forceAttributesWritten) throws IOException {
            if (record.isMarkedForAbort()) {
                logger.warn("Repository Record {} is marked to be aborted; it will be persisted in the FlowFileRepository as a DELETE record", (Object)record);
                out.write(2);
                out.writeLong(this.getRecordIdentifier(record));
                this.serializeContentClaim(record.getCurrentClaim(), record.getCurrentClaimOffset(), out);
                return;
            }
            UpdateType updateType = this.getUpdateType(record);
            if (updateType.equals((Object)UpdateType.DELETE)) {
                out.write(2);
                out.writeLong(this.getRecordIdentifier(record));
                this.serializeContentClaim(record.getCurrentClaim(), record.getCurrentClaimOffset(), out);
                return;
            }
            FlowFileQueue associatedQueue = record.getDestination();
            if (associatedQueue == null) {
                associatedQueue = record.getOriginalQueue();
            }
            if (updateType.equals((Object)UpdateType.SWAP_OUT)) {
                out.write(3);
                out.writeLong(this.getRecordIdentifier(record));
                out.writeUTF(associatedQueue.getIdentifier());
                out.writeUTF(this.getLocation(record));
                return;
            }
            FlowFileRecord flowFile = record.getCurrent();
            ContentClaim claim = record.getCurrentClaim();
            switch (updateType) {
                case UPDATE: {
                    out.write(1);
                    break;
                }
                case CREATE: {
                    out.write(0);
                    break;
                }
                case SWAP_IN: {
                    out.write(4);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            out.writeLong(this.getRecordIdentifier(record));
            out.writeLong(flowFile.getEntryDate());
            Set lineageIdentifiers = flowFile.getLineageIdentifiers();
            out.writeInt(lineageIdentifiers.size());
            for (String lineageId : lineageIdentifiers) {
                out.writeUTF(lineageId);
            }
            out.writeLong(flowFile.getLineageStartDate());
            Long queueDate = flowFile.getLastQueueDate();
            out.writeLong(queueDate == null ? System.currentTimeMillis() : queueDate);
            out.writeLong(flowFile.getSize());
            if (associatedQueue == null) {
                logger.warn("{} Repository Record {} has no Connection associated with it; it will be destroyed on restart", new Object[]{this, record});
                this.writeString("", out);
            } else {
                this.writeString(associatedQueue.getIdentifier(), out);
            }
            this.serializeContentClaim(claim, record.getCurrentClaimOffset(), out);
            if (forceAttributesWritten || record.isAttributesChanged() || updateType == UpdateType.CREATE || updateType == UpdateType.SWAP_IN) {
                out.write(1);
                Map attributes = flowFile.getAttributes();
                out.writeInt(attributes.size());
                for (Map.Entry entry : attributes.entrySet()) {
                    this.writeString((String)entry.getKey(), out);
                    this.writeString((String)entry.getValue(), out);
                }
            } else {
                out.write(0);
            }
            if (updateType == UpdateType.SWAP_IN) {
                out.writeUTF(record.getSwapLocation());
            }
        }

        public RepositoryRecord deserializeEdit(DataInputStream in, Map<Object, RepositoryRecord> currentRecordStates, int version) throws IOException {
            StandardRepositoryRecord standardRepoRecord;
            int action = in.read();
            long recordId = in.readLong();
            if (action == 2) {
                StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder().id(recordId);
                if (version > 4) {
                    this.deserializeClaim(in, version, ffBuilder);
                }
                FlowFileRecord flowFileRecord = ffBuilder.build();
                StandardRepositoryRecord record = new StandardRepositoryRecord(null, flowFileRecord);
                record.markForDelete();
                return record;
            }
            if (action == 3) {
                String queueId = in.readUTF();
                String location = in.readUTF();
                FlowFileQueue queue = this.flowFileQueueMap.get(queueId);
                FlowFileRecord flowFileRecord = new StandardFlowFileRecord.Builder().id(recordId).build();
                return new StandardRepositoryRecord(queue, flowFileRecord, location);
            }
            StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder();
            RepositoryRecord record = currentRecordStates.get(recordId);
            ffBuilder.id(recordId);
            if (record != null) {
                ffBuilder.fromFlowFile(record.getCurrent());
            }
            ffBuilder.entryDate(in.readLong());
            if (version > 1) {
                int numLineageIds = in.readInt();
                HashSet<String> lineageIdentifiers = new HashSet<String>(numLineageIds);
                for (int i = 0; i < numLineageIds; ++i) {
                    lineageIdentifiers.add(in.readUTF());
                }
                ffBuilder.lineageIdentifiers(lineageIdentifiers);
                ffBuilder.lineageStartDate(in.readLong());
                if (version > 5) {
                    ffBuilder.lastQueueDate(in.readLong());
                }
            }
            ffBuilder.size(in.readLong());
            String connectionId = this.readString(in);
            logger.debug("{} -> {}", new Object[]{recordId, connectionId});
            this.deserializeClaim(in, version, ffBuilder);
            int attributesChanged = in.read();
            if (attributesChanged == -1) {
                throw new EOFException();
            }
            if (attributesChanged == 1) {
                int numAttributes = in.readInt();
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (int i = 0; i < numAttributes; ++i) {
                    String key = this.readString(in);
                    String value = this.readString(in);
                    attributes.put(key, value);
                }
                ffBuilder.addAttributes(attributes);
            } else if (attributesChanged != 0) {
                throw new IOException("Attribute Change Qualifier not found in stream; found value: " + attributesChanged + " after successfully restoring " + this.recordsRestored + " records. The FlowFile Repository appears to be corrupt!");
            }
            FlowFileRecord flowFile = ffBuilder.build();
            String swapLocation = null;
            if (action == 4) {
                swapLocation = in.readUTF();
            }
            if (this.flowFileQueueMap == null) {
                standardRepoRecord = new StandardRepositoryRecord(null, flowFile);
            } else {
                FlowFileQueue queue = this.flowFileQueueMap.get(connectionId);
                standardRepoRecord = new StandardRepositoryRecord(queue, flowFile);
                if (swapLocation != null) {
                    standardRepoRecord.setSwapLocation(swapLocation);
                }
                if (connectionId.isEmpty()) {
                    logger.warn("{} does not have a Queue associated with it; this record will be discarded", (Object)flowFile);
                    standardRepoRecord.markForAbort();
                } else if (queue == null) {
                    logger.warn("{} maps to unknown Queue {}; this record will be discarded", (Object)flowFile, (Object)connectionId);
                    standardRepoRecord.markForAbort();
                }
            }
            ++this.recordsRestored;
            return standardRepoRecord;
        }

        public StandardRepositoryRecord deserializeRecord(DataInputStream in, int version) throws IOException {
            StandardRepositoryRecord record;
            int action = in.read();
            if (action == -1) {
                return null;
            }
            long recordId = in.readLong();
            if (action == 2) {
                StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder().id(recordId);
                if (version > 4) {
                    this.deserializeClaim(in, version, ffBuilder);
                }
                FlowFileRecord flowFileRecord = ffBuilder.build();
                StandardRepositoryRecord record2 = new StandardRepositoryRecord(null, flowFileRecord);
                record2.markForDelete();
                return record2;
            }
            StandardFlowFileRecord.Builder ffBuilder = new StandardFlowFileRecord.Builder();
            long entryDate = in.readLong();
            if (version > 1) {
                int numLineageIds = in.readInt();
                HashSet<String> lineageIdentifiers = new HashSet<String>(numLineageIds);
                for (int i = 0; i < numLineageIds; ++i) {
                    lineageIdentifiers.add(in.readUTF());
                }
                ffBuilder.lineageIdentifiers(lineageIdentifiers);
                ffBuilder.lineageStartDate(in.readLong());
                if (version > 5) {
                    ffBuilder.lastQueueDate(in.readLong());
                }
            }
            long size = in.readLong();
            String connectionId = this.readString(in);
            logger.debug("{} -> {}", new Object[]{recordId, connectionId});
            ffBuilder.id(recordId);
            ffBuilder.entryDate(entryDate);
            ffBuilder.size(size);
            this.deserializeClaim(in, version, ffBuilder);
            int attributesChanged = in.read();
            if (attributesChanged == 1) {
                int numAttributes = in.readInt();
                HashMap<String, String> attributes = new HashMap<String, String>();
                for (int i = 0; i < numAttributes; ++i) {
                    String key = this.readString(in);
                    String value = this.readString(in);
                    attributes.put(key, value);
                }
                ffBuilder.addAttributes(attributes);
            } else {
                if (attributesChanged == -1) {
                    throw new EOFException();
                }
                if (attributesChanged != 0) {
                    throw new IOException("Attribute Change Qualifier not found in stream; found value: " + attributesChanged + " after successfully restoring " + this.recordsRestored + " records");
                }
            }
            FlowFileRecord flowFile = ffBuilder.build();
            String swapLocation = null;
            if (action == 4) {
                swapLocation = in.readUTF();
            }
            if (this.flowFileQueueMap == null) {
                record = new StandardRepositoryRecord(null, flowFile);
            } else {
                FlowFileQueue queue = this.flowFileQueueMap.get(connectionId);
                record = new StandardRepositoryRecord(queue, flowFile);
                if (swapLocation != null) {
                    record.setSwapLocation(swapLocation);
                }
                if (connectionId.isEmpty()) {
                    logger.warn("{} does not have a FlowFile Queue associated with it; this record will be discarded", (Object)flowFile);
                    record.markForAbort();
                } else if (queue == null) {
                    logger.warn("{} maps to unknown FlowFile Queue {}; this record will be discarded", (Object)flowFile, (Object)connectionId);
                    record.markForAbort();
                }
            }
            ++this.recordsRestored;
            return record;
        }

        public void serializeRecord(RepositoryRecord record, DataOutputStream out) throws IOException {
            this.serializeEdit(null, record, out, true);
        }

        private void serializeContentClaim(ContentClaim claim, long offset, DataOutputStream out) throws IOException {
            if (claim == null) {
                out.write(0);
            } else {
                out.write(1);
                ResourceClaim resourceClaim = claim.getResourceClaim();
                this.writeString(resourceClaim.getId(), out);
                this.writeString(resourceClaim.getContainer(), out);
                this.writeString(resourceClaim.getSection(), out);
                out.writeLong(claim.getOffset());
                out.writeLong(claim.getLength());
                out.writeLong(offset);
                out.writeBoolean(resourceClaim.isLossTolerant());
            }
        }

        private void deserializeClaim(DataInputStream in, int serializationVersion, StandardFlowFileRecord.Builder ffBuilder) throws IOException {
            int claimExists = in.read();
            if (claimExists == 1) {
                long resourceLength;
                long resourceOffset;
                String claimId = serializationVersion < 4 ? String.valueOf(in.readLong()) : this.readString(in);
                String container = this.readString(in);
                String section = this.readString(in);
                if (serializationVersion < 7) {
                    resourceOffset = 0L;
                    resourceLength = -1L;
                } else {
                    resourceOffset = in.readLong();
                    resourceLength = in.readLong();
                }
                long claimOffset = in.readLong();
                boolean lossTolerant = serializationVersion >= 3 ? in.readBoolean() : false;
                ResourceClaim resourceClaim = this.claimManager.newResourceClaim(container, section, claimId, lossTolerant);
                StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, resourceOffset);
                contentClaim.setLength(resourceLength);
                ffBuilder.contentClaim(contentClaim);
                ffBuilder.contentClaimOffset(claimOffset);
            } else {
                if (claimExists == -1) {
                    throw new EOFException();
                }
                if (claimExists != 0) {
                    throw new IOException("Claim Existence Qualifier not found in stream; found value: " + claimExists + " after successfully restoring " + this.recordsRestored + " records");
                }
            }
        }

        private void writeString(String toWrite, OutputStream out) throws IOException {
            byte[] bytes = toWrite.getBytes("UTF-8");
            int utflen = bytes.length;
            if (utflen < 65535) {
                out.write(utflen >>> 8);
                out.write(utflen);
                out.write(bytes);
            } else {
                out.write(255);
                out.write(255);
                out.write(utflen >>> 24);
                out.write(utflen >>> 16);
                out.write(utflen >>> 8);
                out.write(utflen);
                out.write(bytes);
            }
        }

        private String readString(InputStream in) throws IOException {
            Integer numBytes = this.readFieldLength(in);
            if (numBytes == null) {
                throw new EOFException();
            }
            byte[] bytes = new byte[numBytes.intValue()];
            this.fillBuffer(in, bytes, numBytes);
            return new String(bytes, "UTF-8");
        }

        private Integer readFieldLength(InputStream in) throws IOException {
            int firstValue = in.read();
            int secondValue = in.read();
            if (firstValue < 0) {
                return null;
            }
            if (secondValue < 0) {
                throw new EOFException();
            }
            if (firstValue == 255 && secondValue == 255) {
                int ch4;
                int ch3;
                int ch2;
                int ch1 = in.read();
                if ((ch1 | (ch2 = in.read()) | (ch3 = in.read()) | (ch4 = in.read())) < 0) {
                    throw new EOFException();
                }
                return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + ch4;
            }
            return (firstValue << 8) + secondValue;
        }

        private void fillBuffer(InputStream in, byte[] buffer, int length) throws IOException {
            int bytesRead;
            int totalBytesRead = 0;
            while ((bytesRead = in.read(buffer, totalBytesRead, length - totalBytesRead)) > 0) {
                totalBytesRead += bytesRead;
            }
            if (totalBytesRead != length) {
                throw new EOFException();
            }
        }

        public Long getRecordIdentifier(RepositoryRecord record) {
            return record.getCurrent().getId();
        }

        public UpdateType getUpdateType(RepositoryRecord record) {
            switch (record.getType()) {
                case CONTENTMISSING: 
                case DELETE: {
                    return UpdateType.DELETE;
                }
                case CREATE: {
                    return UpdateType.CREATE;
                }
                case UPDATE: {
                    return UpdateType.UPDATE;
                }
                case SWAP_OUT: {
                    return UpdateType.SWAP_OUT;
                }
                case SWAP_IN: {
                    return UpdateType.SWAP_IN;
                }
            }
            return null;
        }

        public int getVersion() {
            return 7;
        }

        public String getLocation(RepositoryRecord record) {
            return record.getSwapLocation();
        }
    }
}

