/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceInitializationContext;
import org.apache.nifi.controller.service.StandardControllerServiceNode;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardValidationContextFactory;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.util.ObjectHolder;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceProvider
implements ControllerServiceProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardControllerServiceProvider.class);
    private final ProcessScheduler processScheduler;
    private final ConcurrentMap<String, ControllerServiceNode> controllerServices = new ConcurrentHashMap<String, ControllerServiceNode>();
    private static final Set<Method> validDisabledMethods;
    private final BulletinRepository bulletinRepo;
    private final StateManagerProvider stateManagerProvider;
    private final VariableRegistry variableRegistry;

    public StandardControllerServiceProvider(ProcessScheduler scheduler, BulletinRepository bulletinRepo, StateManagerProvider stateManagerProvider, VariableRegistry variableRegistry) {
        this.processScheduler = scheduler;
        this.bulletinRepo = bulletinRepo;
        this.stateManagerProvider = stateManagerProvider;
        this.variableRegistry = variableRegistry;
    }

    private Class<?>[] getInterfaces(Class<?> cls) {
        ArrayList allIfcs = new ArrayList();
        this.populateInterfaces(cls, allIfcs);
        return allIfcs.toArray(new Class[allIfcs.size()]);
    }

    private void populateInterfaces(Class<?> cls, List<Class<?>> interfacesDefinedThusFar) {
        Class<?> superClass;
        Class<?>[] ifc = cls.getInterfaces();
        if (ifc != null && ifc.length > 0) {
            for (Class<?> i : ifc) {
                interfacesDefinedThusFar.add(i);
            }
        }
        if ((superClass = cls.getSuperclass()) != null) {
            this.populateInterfaces(superClass, interfacesDefinedThusFar);
        }
    }

    private StateManager getStateManager(String componentId) {
        return this.stateManagerProvider.getStateManager(componentId);
    }

    public ControllerServiceNode createControllerService(String type, final String id, boolean firstTimeAdded) {
        if (type == null || id == null) {
            throw new NullPointerException();
        }
        ClassLoader currentContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> rawClass;
            ClassLoader cl = ExtensionManager.getClassLoader((String)type);
            if (cl == null) {
                rawClass = Class.forName(type);
            } else {
                Thread.currentThread().setContextClassLoader(cl);
                rawClass = Class.forName(type, false, cl);
            }
            Class<ControllerService> controllerServiceClass = rawClass.asSubclass(ControllerService.class);
            final ControllerService originalService = controllerServiceClass.newInstance();
            final ObjectHolder serviceNodeHolder = new ObjectHolder(null);
            InvocationHandler invocationHandler = new InvocationHandler(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    boolean disabled;
                    String methodName = method.getName();
                    if ("initialize".equals(methodName)) throw new UnsupportedOperationException(method + " may only be invoked by the NiFi framework");
                    if ("onPropertyModified".equals(methodName)) {
                        throw new UnsupportedOperationException(method + " may only be invoked by the NiFi framework");
                    }
                    ControllerServiceNode node = (ControllerServiceNode)serviceNodeHolder.get();
                    ControllerServiceState state = node.getState();
                    boolean bl = disabled = state != ControllerServiceState.ENABLED;
                    if (disabled && !validDisabledMethods.contains(method)) {
                        try {
                            NarCloseable narCloseable = NarCloseable.withNarLoader();
                            Throwable throwable = null;
                            try {
                                try {
                                    throw new IllegalStateException("Cannot invoke method " + method + " on Controller Service " + originalService + " because the Controller Service is disabled");
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                            }
                            catch (Throwable throwable3) {
                                if (narCloseable == null) throw throwable3;
                                if (throwable == null) {
                                    narCloseable.close();
                                    throw throwable3;
                                }
                                try {
                                    narCloseable.close();
                                    throw throwable3;
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                    throw throwable3;
                                }
                            }
                        }
                        catch (Throwable e) {
                            throw new IllegalStateException("Cannot invoke method " + method + " on Controller Service with identifier " + id + " because the Controller Service is disabled");
                        }
                    }
                    try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                        Object object = method.invoke((Object)originalService, args);
                        return object;
                    }
                    catch (InvocationTargetException e) {
                        throw e.getCause();
                    }
                }
            };
            ControllerService proxiedService = cl == null ? (ControllerService)Proxy.newProxyInstance(this.getClass().getClassLoader(), this.getInterfaces(controllerServiceClass), invocationHandler) : (ControllerService)Proxy.newProxyInstance(cl, this.getInterfaces(controllerServiceClass), invocationHandler);
            logger.info("Created Controller Service of type {} with identifier {}", (Object)type, (Object)id);
            SimpleProcessLogger serviceLogger = new SimpleProcessLogger(id, originalService);
            originalService.initialize((ControllerServiceInitializationContext)new StandardControllerServiceInitializationContext(id, (ComponentLog)serviceLogger, this, this.getStateManager(id)));
            StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this, this.variableRegistry);
            StandardControllerServiceNode serviceNode = new StandardControllerServiceNode(proxiedService, originalService, id, validationContextFactory, this, this.variableRegistry);
            serviceNodeHolder.set((Object)serviceNode);
            serviceNode.setName(rawClass.getSimpleName());
            if (firstTimeAdded) {
                try (NarCloseable x = NarCloseable.withNarLoader();){
                    ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, originalService, new Object[0]);
                }
                catch (Exception e) {
                    throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + originalService, (Throwable)e);
                }
            }
            this.controllerServices.put(id, serviceNode);
            StandardControllerServiceNode standardControllerServiceNode = serviceNode;
            return standardControllerServiceNode;
        }
        catch (Throwable t) {
            throw new ControllerServiceInstantiationException(t);
        }
        finally {
            if (currentContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentContextClassLoader);
            }
        }
    }

    public void disableReferencingServices(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> toDisable = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        HashSet<ControllerServiceNode> serviceSet = new HashSet<ControllerServiceNode>(toDisable);
        for (ControllerServiceNode nodeToDisable : toDisable) {
            if (!nodeToDisable.isActive()) continue;
            nodeToDisable.verifyCanDisable(serviceSet);
        }
        Collections.reverse(toDisable);
        this.processScheduler.disableControllerServices(toDisable);
    }

    public void scheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List<ProcessorNode> processors = this.findRecursiveReferences(serviceNode, ProcessorNode.class);
        List<ReportingTaskNode> reportingTasks = this.findRecursiveReferences(serviceNode, ReportingTaskNode.class);
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getScheduledState() == ScheduledState.DISABLED) continue;
            processorNode.verifyCanStart();
        }
        for (ReportingTaskNode reportingTaskNode : reportingTasks) {
            if (reportingTaskNode.getScheduledState() == ScheduledState.DISABLED) continue;
            reportingTaskNode.verifyCanStart();
        }
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getScheduledState() == ScheduledState.DISABLED) continue;
            processorNode.getProcessGroup().startProcessor(processorNode);
        }
        for (ReportingTaskNode reportingTaskNode : reportingTasks) {
            if (reportingTaskNode.getScheduledState() == ScheduledState.DISABLED) continue;
            this.processScheduler.schedule(reportingTaskNode);
        }
    }

    public void unscheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List<ProcessorNode> processors = this.findRecursiveReferences(serviceNode, ProcessorNode.class);
        List<ReportingTaskNode> reportingTasks = this.findRecursiveReferences(serviceNode, ReportingTaskNode.class);
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getScheduledState() != ScheduledState.RUNNING) continue;
            processorNode.verifyCanStop();
        }
        for (ReportingTaskNode reportingTaskNode : reportingTasks) {
            if (reportingTaskNode.getScheduledState() != ScheduledState.RUNNING) continue;
            reportingTaskNode.verifyCanStop();
        }
        for (ProcessorNode processorNode : processors) {
            if (processorNode.getScheduledState() != ScheduledState.RUNNING) continue;
            processorNode.getProcessGroup().stopProcessor(processorNode);
        }
        for (ReportingTaskNode reportingTaskNode : reportingTasks) {
            if (reportingTaskNode.getScheduledState() != ScheduledState.RUNNING) continue;
            this.processScheduler.unschedule(reportingTaskNode);
        }
    }

    public void enableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanEnable();
        this.processScheduler.enableControllerService(serviceNode);
    }

    public void enableControllerServices(Collection<ControllerServiceNode> serviceNodes) {
        boolean shouldStart = true;
        Iterator<ControllerServiceNode> serviceIter = serviceNodes.iterator();
        while (serviceIter.hasNext() && shouldStart) {
            ControllerServiceNode controllerServiceNode = serviceIter.next();
            List<ControllerServiceNode> requiredServices = ((StandardControllerServiceNode)controllerServiceNode).getRequiredControllerServices();
            for (ControllerServiceNode requiredService : requiredServices) {
                if (requiredService.isActive() || serviceNodes.contains(requiredService)) continue;
                shouldStart = false;
            }
        }
        if (shouldStart) {
            for (ControllerServiceNode controllerServiceNode : serviceNodes) {
                try {
                    if (controllerServiceNode.isActive()) continue;
                    this.enableControllerServiceDependenciesFirst(controllerServiceNode);
                }
                catch (Exception e) {
                    logger.error("Failed to enable " + controllerServiceNode + " due to " + e);
                    if (this.bulletinRepo == null) continue;
                    this.bulletinRepo.addBulletin(BulletinFactory.createBulletin((String)"Controller Service", (String)Severity.ERROR.name(), (String)("Could not start " + controllerServiceNode + " due to " + e)));
                }
            }
        }
    }

    private void enableControllerServiceDependenciesFirst(ControllerServiceNode serviceNode) {
        for (ControllerServiceNode depNode : serviceNode.getRequiredControllerServices()) {
            if (depNode.isActive()) continue;
            this.enableControllerServiceDependenciesFirst(depNode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Enabling " + serviceNode);
        }
        this.enableControllerService(serviceNode);
    }

    static List<List<ControllerServiceNode>> determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap) {
        ArrayList<List<ControllerServiceNode>> orderedNodeLists = new ArrayList<List<ControllerServiceNode>>();
        for (ControllerServiceNode node : serviceNodeMap.values()) {
            ArrayList<ControllerServiceNode> branch = new ArrayList<ControllerServiceNode>();
            StandardControllerServiceProvider.determineEnablingOrder(serviceNodeMap, node, branch, new HashSet<ControllerServiceNode>());
            orderedNodeLists.add(branch);
        }
        return orderedNodeLists;
    }

    private static void determineEnablingOrder(Map<String, ControllerServiceNode> serviceNodeMap, ControllerServiceNode contextNode, List<ControllerServiceNode> orderedNodes, Set<ControllerServiceNode> visited) {
        if (visited.contains(contextNode)) {
            return;
        }
        for (Map.Entry entry : contextNode.getProperties().entrySet()) {
            ControllerServiceNode referencedNode;
            String referencedServiceId;
            if (((PropertyDescriptor)entry.getKey()).getControllerServiceDefinition() == null || (referencedServiceId = (String)entry.getValue()) == null || orderedNodes.contains(referencedNode = serviceNodeMap.get(referencedServiceId))) continue;
            visited.add(contextNode);
            StandardControllerServiceProvider.determineEnablingOrder(serviceNodeMap, referencedNode, orderedNodes, visited);
        }
        if (!orderedNodes.contains(contextNode)) {
            orderedNodes.add(contextNode);
        }
    }

    public void disableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanDisable();
        this.processScheduler.disableControllerService(serviceNode);
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        ControllerServiceNode node = (ControllerServiceNode)this.controllerServices.get(serviceIdentifier);
        return node == null ? null : node.getProxiedControllerService();
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.isControllerServiceEnabled(service.getIdentifier());
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        ControllerServiceNode node = (ControllerServiceNode)this.controllerServices.get(serviceIdentifier);
        return node == null ? false : ControllerServiceState.ENABLED == node.getState();
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        ControllerServiceNode node = (ControllerServiceNode)this.controllerServices.get(serviceIdentifier);
        return node == null ? false : ControllerServiceState.ENABLING == node.getState();
    }

    public ControllerServiceNode getControllerServiceNode(String serviceIdentifier) {
        return (ControllerServiceNode)this.controllerServices.get(serviceIdentifier);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        HashSet<String> identifiers = new HashSet<String>();
        for (Map.Entry entry : this.controllerServices.entrySet()) {
            if (!Objects.requireNonNull(serviceType).isAssignableFrom(((ControllerServiceNode)entry.getValue()).getProxiedControllerService().getClass())) continue;
            identifiers.add((String)entry.getKey());
        }
        return identifiers;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        ControllerServiceNode node = this.getControllerServiceNode(serviceIdentifier);
        return node == null ? null : node.getName();
    }

    public void removeControllerService(ControllerServiceNode serviceNode) {
        ControllerServiceNode existing = (ControllerServiceNode)this.controllerServices.get(serviceNode.getIdentifier());
        if (existing == null || existing != serviceNode) {
            throw new IllegalStateException("Controller Service " + serviceNode + " does not exist in this Flow");
        }
        serviceNode.verifyCanDelete();
        try (NarCloseable x = NarCloseable.withNarLoader();){
            StandardConfigurationContext configurationContext = new StandardConfigurationContext((ConfiguredComponent)serviceNode, (ControllerServiceLookup)this, null, this.variableRegistry);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)serviceNode.getControllerServiceImplementation(), configurationContext);
        }
        for (Map.Entry entry : serviceNode.getProperties().entrySet()) {
            ControllerServiceNode referencedNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (referencedNode = this.getControllerServiceNode(value)) == null) continue;
            referencedNode.removeReference((ConfiguredComponent)serviceNode);
        }
        this.controllerServices.remove(serviceNode.getIdentifier());
        this.stateManagerProvider.onComponentRemoved(serviceNode.getIdentifier());
    }

    public Set<ControllerServiceNode> getAllControllerServices() {
        return new HashSet<ControllerServiceNode>(this.controllerServices.values());
    }

    private <T> List<T> findRecursiveReferences(ControllerServiceNode referencedNode, Class<T> componentType) {
        ArrayList<T> references = new ArrayList<T>();
        for (ConfiguredComponent referencingComponent : referencedNode.getReferences().getReferencingComponents()) {
            if (componentType.isAssignableFrom(referencingComponent.getClass())) {
                references.add(componentType.cast(referencingComponent));
            }
            if (!(referencingComponent instanceof ControllerServiceNode)) continue;
            ControllerServiceNode referencingNode = (ControllerServiceNode)referencingComponent;
            List<T> recursive = this.findRecursiveReferences(referencingNode, componentType);
            references.removeAll(recursive);
            references.addAll(recursive);
        }
        return references;
    }

    public void enableReferencingServices(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> recursiveReferences = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        this.enableReferencingServices(serviceNode, recursiveReferences);
    }

    private void enableReferencingServices(ControllerServiceNode serviceNode, List<ControllerServiceNode> recursiveReferences) {
        if (!serviceNode.isActive()) {
            serviceNode.verifyCanEnable(new HashSet<ControllerServiceNode>(recursiveReferences));
        }
        HashSet<ControllerServiceNode> ifEnabled = new HashSet<ControllerServiceNode>();
        for (ControllerServiceNode nodeToEnable : recursiveReferences) {
            if (nodeToEnable.isActive()) continue;
            nodeToEnable.verifyCanEnable(ifEnabled);
            ifEnabled.add(nodeToEnable);
        }
        for (ControllerServiceNode nodeToEnable : recursiveReferences) {
            if (nodeToEnable.isActive()) continue;
            this.enableControllerService(nodeToEnable);
        }
    }

    public void verifyCanEnableReferencingServices(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> referencingServices = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        HashSet<ControllerServiceNode> referencingServiceSet = new HashSet<ControllerServiceNode>(referencingServices);
        for (ControllerServiceNode referencingService : referencingServices) {
            referencingService.verifyCanEnable(referencingServiceSet);
        }
    }

    public void verifyCanScheduleReferencingComponents(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> referencingServices = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        List<ReportingTaskNode> referencingReportingTasks = this.findRecursiveReferences(serviceNode, ReportingTaskNode.class);
        List<ProcessorNode> referencingProcessors = this.findRecursiveReferences(serviceNode, ProcessorNode.class);
        HashSet<ControllerServiceNode> referencingServiceSet = new HashSet<ControllerServiceNode>(referencingServices);
        for (ReportingTaskNode taskNode : referencingReportingTasks) {
            if (taskNode.getScheduledState() == ScheduledState.DISABLED) continue;
            taskNode.verifyCanStart(referencingServiceSet);
        }
        for (ProcessorNode procNode : referencingProcessors) {
            if (procNode.getScheduledState() == ScheduledState.DISABLED) continue;
            procNode.verifyCanStart(referencingServiceSet);
        }
    }

    public void verifyCanDisableReferencingServices(ControllerServiceNode serviceNode) {
        List<ControllerServiceNode> toDisable = this.findRecursiveReferences(serviceNode, ControllerServiceNode.class);
        HashSet<ControllerServiceNode> serviceSet = new HashSet<ControllerServiceNode>(toDisable);
        for (ControllerServiceNode nodeToDisable : toDisable) {
            if (!nodeToDisable.isActive()) continue;
            nodeToDisable.verifyCanDisable(serviceSet);
        }
    }

    public void verifyCanStopReferencingComponents(ControllerServiceNode serviceNode) {
    }

    static {
        HashSet<Method> validMethods = new HashSet<Method>();
        for (Method method : ControllerService.class.getMethods()) {
            validMethods.add(method);
        }
        for (Method method : Object.class.getMethods()) {
            validMethods.add(method);
        }
        validDisabledMethods = Collections.unmodifiableSet(validMethods);
    }
}

