/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.logging;

import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogMessage;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.ComponentType;
import org.apache.nifi.reporting.Severity;

public class ReportingTaskLogObserver
implements LogObserver {
    private final BulletinRepository bulletinRepository;
    private final ReportingTaskNode taskNode;

    public ReportingTaskLogObserver(BulletinRepository bulletinRepository, ReportingTaskNode taskNode) {
        this.bulletinRepository = bulletinRepository;
        this.taskNode = taskNode;
    }

    public void onLogMessage(LogMessage message) {
        String bulletinLevel = message.getLevel() == LogLevel.WARN ? Severity.WARNING.name() : message.getLevel().toString();
        Bulletin bulletin = BulletinFactory.createBulletin(null, (String)this.taskNode.getIdentifier(), (ComponentType)ComponentType.REPORTING_TASK, (String)this.taskNode.getName(), (String)"Log Message", (String)bulletinLevel, (String)message.getMessage());
        this.bulletinRepository.addBulletin(bulletin);
    }
}

