/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.RepositoryRecord;
import org.apache.nifi.controller.repository.RepositoryRecordType;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.processor.Relationship;

public class StandardRepositoryRecord
implements RepositoryRecord {
    private RepositoryRecordType type = null;
    private FlowFileRecord workingFlowFileRecord = null;
    private Relationship transferRelationship = null;
    private FlowFileQueue destination = null;
    private final FlowFileRecord originalFlowFileRecord;
    private final FlowFileQueue originalQueue;
    private String swapLocation;
    private final Map<String, String> updatedAttributes = new HashMap<String, String>();
    private final Map<String, String> originalAttributes;
    private List<ContentClaim> transientClaims;

    public StandardRepositoryRecord(FlowFileQueue originalQueue) {
        this(originalQueue, null);
        this.type = RepositoryRecordType.CREATE;
    }

    public StandardRepositoryRecord(FlowFileQueue originalQueue, FlowFileRecord originalFlowFileRecord) {
        this(originalQueue, originalFlowFileRecord, null);
        this.type = RepositoryRecordType.UPDATE;
    }

    public StandardRepositoryRecord(FlowFileQueue originalQueue, FlowFileRecord originalFlowFileRecord, String swapLocation) {
        this.originalQueue = originalQueue;
        this.originalFlowFileRecord = originalFlowFileRecord;
        this.type = RepositoryRecordType.SWAP_OUT;
        this.swapLocation = swapLocation;
        this.originalAttributes = originalFlowFileRecord == null ? Collections.emptyMap() : originalFlowFileRecord.getAttributes();
    }

    public FlowFileQueue getDestination() {
        return this.destination;
    }

    public void setDestination(FlowFileQueue destination) {
        this.destination = destination;
    }

    public RepositoryRecordType getType() {
        return this.type;
    }

    FlowFileRecord getOriginal() {
        return this.originalFlowFileRecord;
    }

    public String getSwapLocation() {
        return this.swapLocation;
    }

    public void setSwapLocation(String swapLocation) {
        this.swapLocation = swapLocation;
        if (this.type != RepositoryRecordType.SWAP_OUT) {
            this.type = RepositoryRecordType.SWAP_IN;
        }
    }

    public ContentClaim getOriginalClaim() {
        return this.originalFlowFileRecord == null ? null : this.originalFlowFileRecord.getContentClaim();
    }

    public FlowFileQueue getOriginalQueue() {
        return this.originalQueue;
    }

    public void setWorking(FlowFileRecord flowFile) {
        this.workingFlowFileRecord = flowFile;
    }

    public void setWorking(FlowFileRecord flowFile, String attributeKey, String attributeValue) {
        this.workingFlowFileRecord = flowFile;
        String currentValue = this.originalAttributes.get(attributeKey);
        if (currentValue == null || !currentValue.equals(attributeValue)) {
            this.updatedAttributes.put(attributeKey, attributeValue);
        }
    }

    public void setWorking(FlowFileRecord flowFile, Map<String, String> updatedAttribs) {
        this.workingFlowFileRecord = flowFile;
        for (Map.Entry<String, String> entry : updatedAttribs.entrySet()) {
            String currentValue = this.originalAttributes.get(entry.getKey());
            if (currentValue != null && currentValue.equals(entry.getValue())) continue;
            this.updatedAttributes.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean isAttributesChanged() {
        return !this.updatedAttributes.isEmpty();
    }

    public void markForAbort() {
        this.type = RepositoryRecordType.CONTENTMISSING;
    }

    public boolean isMarkedForAbort() {
        return RepositoryRecordType.CONTENTMISSING.equals((Object)this.type);
    }

    public void markForDelete() {
        this.type = RepositoryRecordType.DELETE;
    }

    public boolean isMarkedForDelete() {
        return RepositoryRecordType.DELETE.equals((Object)this.type);
    }

    public void setTransferRelationship(Relationship relationship) {
        this.transferRelationship = relationship;
    }

    public Relationship getTransferRelationship() {
        return this.transferRelationship;
    }

    FlowFileRecord getWorking() {
        return this.workingFlowFileRecord;
    }

    ContentClaim getWorkingClaim() {
        return this.workingFlowFileRecord == null ? null : this.workingFlowFileRecord.getContentClaim();
    }

    public FlowFileRecord getCurrent() {
        return this.workingFlowFileRecord == null ? this.originalFlowFileRecord : this.workingFlowFileRecord;
    }

    public ContentClaim getCurrentClaim() {
        return this.getCurrent() == null ? null : this.getCurrent().getContentClaim();
    }

    public long getCurrentClaimOffset() {
        return this.getCurrent() == null ? 0L : this.getCurrent().getContentClaimOffset();
    }

    boolean isWorking() {
        return this.workingFlowFileRecord != null;
    }

    Map<String, String> getOriginalAttributes() {
        return this.originalAttributes;
    }

    Map<String, String> getUpdatedAttributes() {
        return this.updatedAttributes;
    }

    public String toString() {
        return "StandardRepositoryRecord[UpdateType=" + this.getType() + ",Record=" + this.getCurrent() + "]";
    }

    public List<ContentClaim> getTransientClaims() {
        return this.transientClaims == null ? Collections.emptyList() : Collections.unmodifiableList(this.transientClaims);
    }

    void addTransientClaim(ContentClaim claim) {
        if (claim == null) {
            return;
        }
        if (this.transientClaims == null) {
            this.transientClaims = new ArrayList<ContentClaim>();
        }
        this.transientClaims.add(claim);
    }
}

