/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.TriggerWhenAnyDestinationAvailable;
import org.apache.nifi.annotation.behavior.TriggerWhenEmpty;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SchedulingAgentCallback;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.annotation.CapabilityDescription;
import org.apache.nifi.processor.annotation.OnScheduled;
import org.apache.nifi.processor.annotation.SideEffectFree;
import org.apache.nifi.processor.annotation.SupportsBatching;
import org.apache.nifi.processor.annotation.TriggerSerially;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.quartz.CronExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class StandardProcessorNode
extends ProcessorNode
implements Connectable {
    private static final Logger LOG = LoggerFactory.getLogger(StandardProcessorNode.class);
    public static final String BULLETIN_OBSERVER_ID = "bulletin-observer";
    public static final TimeUnit DEFAULT_TIME_UNIT = TimeUnit.MILLISECONDS;
    public static final String DEFAULT_YIELD_PERIOD = "1 sec";
    public static final String DEFAULT_PENALIZATION_PERIOD = "30 sec";
    private final AtomicReference<ProcessGroup> processGroup;
    private final Processor processor;
    private final AtomicReference<String> identifier;
    private final Map<Connection, Connectable> destinations;
    private final Map<Relationship, Set<Connection>> connections;
    private final AtomicReference<Set<Relationship>> undefinedRelationshipsToTerminate;
    private final AtomicReference<List<Connection>> incomingConnectionsRef;
    private final AtomicBoolean isolated;
    private final AtomicBoolean lossTolerant;
    private final AtomicReference<String> comments;
    private final AtomicReference<Position> position;
    private final AtomicReference<String> schedulingPeriod;
    private final AtomicReference<String> yieldPeriod;
    private final AtomicReference<String> penalizationPeriod;
    private final AtomicReference<Map<String, String>> style;
    private final AtomicInteger concurrentTaskCount;
    private final AtomicLong yieldExpiration;
    private final AtomicLong schedulingNanos;
    private final boolean triggerWhenEmpty;
    private final boolean sideEffectFree;
    private final boolean triggeredSerially;
    private final boolean triggerWhenAnyDestinationAvailable;
    private final boolean eventDrivenSupported;
    private final boolean batchSupported;
    private final InputRequirement.Requirement inputRequirement;
    private final ProcessScheduler processScheduler;
    private long runNanos = 0L;
    private SchedulingStrategy schedulingStrategy;

    public StandardProcessorNode(Processor processor, String uuid, ValidationContextFactory validationContextFactory, ProcessScheduler scheduler, ControllerServiceProvider controllerServiceProvider) {
        super(processor, uuid, validationContextFactory, controllerServiceProvider);
        this.processor = processor;
        this.identifier = new AtomicReference<String>(uuid);
        this.destinations = new HashMap<Connection, Connectable>();
        this.connections = new HashMap<Relationship, Set<Connection>>();
        this.incomingConnectionsRef = new AtomicReference(new ArrayList());
        this.lossTolerant = new AtomicBoolean(false);
        HashSet emptySetOfRelationships = new HashSet();
        this.undefinedRelationshipsToTerminate = new AtomicReference(emptySetOfRelationships);
        this.comments = new AtomicReference<String>("");
        this.schedulingPeriod = new AtomicReference<String>("0 sec");
        this.schedulingNanos = new AtomicLong(30000L);
        this.yieldPeriod = new AtomicReference<String>(DEFAULT_YIELD_PERIOD);
        this.yieldExpiration = new AtomicLong(0L);
        this.concurrentTaskCount = new AtomicInteger(1);
        this.position = new AtomicReference<Position>(new Position(0.0, 0.0));
        this.style = new AtomicReference(Collections.unmodifiableMap(new HashMap()));
        this.processGroup = new AtomicReference();
        this.processScheduler = scheduler;
        this.isolated = new AtomicBoolean(false);
        this.penalizationPeriod = new AtomicReference<String>(DEFAULT_PENALIZATION_PERIOD);
        Class<?> procClass = processor.getClass();
        this.triggerWhenEmpty = procClass.isAnnotationPresent(TriggerWhenEmpty.class) || procClass.isAnnotationPresent(org.apache.nifi.processor.annotation.TriggerWhenEmpty.class);
        this.sideEffectFree = procClass.isAnnotationPresent(org.apache.nifi.annotation.behavior.SideEffectFree.class) || procClass.isAnnotationPresent(SideEffectFree.class);
        this.batchSupported = procClass.isAnnotationPresent(org.apache.nifi.annotation.behavior.SupportsBatching.class) || procClass.isAnnotationPresent(SupportsBatching.class);
        this.triggeredSerially = procClass.isAnnotationPresent(org.apache.nifi.annotation.behavior.TriggerSerially.class) || procClass.isAnnotationPresent(TriggerSerially.class);
        this.triggerWhenAnyDestinationAvailable = procClass.isAnnotationPresent(TriggerWhenAnyDestinationAvailable.class) || procClass.isAnnotationPresent(org.apache.nifi.processor.annotation.TriggerWhenAnyDestinationAvailable.class);
        this.eventDrivenSupported = (procClass.isAnnotationPresent(EventDriven.class) || procClass.isAnnotationPresent(org.apache.nifi.processor.annotation.EventDriven.class)) && !this.triggeredSerially && !this.triggerWhenEmpty;
        boolean inputRequirementPresent = procClass.isAnnotationPresent(InputRequirement.class);
        this.inputRequirement = inputRequirementPresent ? procClass.getAnnotation(InputRequirement.class).value() : InputRequirement.Requirement.INPUT_ALLOWED;
        this.schedulingStrategy = SchedulingStrategy.TIMER_DRIVEN;
    }

    public String getComments() {
        return this.comments.get();
    }

    public void setComments(String comments) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        this.comments.set(comments);
    }

    public Position getPosition() {
        return this.position.get();
    }

    public void setPosition(Position position) {
        this.position.set(position);
    }

    public Map<String, String> getStyle() {
        return this.style.get();
    }

    public void setStyle(Map<String, String> style) {
        if (style != null) {
            this.style.set(Collections.unmodifiableMap(new HashMap<String, String>(style)));
        }
    }

    public String getIdentifier() {
        return this.identifier.get();
    }

    public boolean isLossTolerant() {
        return this.lossTolerant.get();
    }

    public boolean isIsolated() {
        return this.isolated.get();
    }

    public boolean isTriggerWhenEmpty() {
        return this.triggerWhenEmpty;
    }

    public boolean isSideEffectFree() {
        return this.sideEffectFree;
    }

    public boolean isHighThroughputSupported() {
        return this.batchSupported;
    }

    public boolean isTriggerWhenAnyDestinationAvailable() {
        return this.triggerWhenAnyDestinationAvailable;
    }

    public void setLossTolerant(boolean lossTolerant) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        this.lossTolerant.set(lossTolerant);
    }

    public void setIsolated(boolean isolated) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        this.isolated.set(isolated);
    }

    public boolean isAutoTerminated(Relationship relationship) {
        if (relationship.isAutoTerminated() && this.getConnections(relationship).isEmpty()) {
            return true;
        }
        Set<Relationship> terminatable = this.undefinedRelationshipsToTerminate.get();
        return terminatable == null ? false : terminatable.contains(relationship);
    }

    public void setAutoTerminatedRelationships(Set<Relationship> terminate) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        for (Relationship rel : terminate) {
            if (this.getConnections(rel).isEmpty()) continue;
            throw new IllegalStateException("Cannot mark relationship '" + rel.getName() + "' as auto-terminated because Connection already exists with this relationship");
        }
        this.undefinedRelationshipsToTerminate.set(new HashSet<Relationship>(terminate));
    }

    public Set<Relationship> getAutoTerminatedRelationships() {
        Set<Relationship> relationships = this.undefinedRelationshipsToTerminate.get();
        if (relationships == null) {
            relationships = new HashSet<Relationship>();
        }
        return Collections.unmodifiableSet(relationships);
    }

    public String getProcessorDescription() {
        org.apache.nifi.annotation.documentation.CapabilityDescription capDesc = this.processor.getClass().getAnnotation(org.apache.nifi.annotation.documentation.CapabilityDescription.class);
        String description = null;
        if (capDesc != null) {
            description = capDesc.value();
        } else {
            CapabilityDescription deprecatedCapDesc = this.processor.getClass().getAnnotation(CapabilityDescription.class);
            if (deprecatedCapDesc != null) {
                description = deprecatedCapDesc.value();
            }
        }
        return description;
    }

    public void setName(String name) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        super.setName(name);
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return timeUnit.convert(this.schedulingNanos.get(), TimeUnit.NANOSECONDS);
    }

    public boolean isEventDrivenSupported() {
        return this.eventDrivenSupported;
    }

    public void setSchedulingStrategy(SchedulingStrategy schedulingStrategy) {
        if (schedulingStrategy == SchedulingStrategy.EVENT_DRIVEN && !this.eventDrivenSupported) {
            return;
        }
        this.schedulingStrategy = schedulingStrategy;
        this.setIsolated(schedulingStrategy == SchedulingStrategy.PRIMARY_NODE_ONLY);
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod.get();
    }

    public void setScheduldingPeriod(String schedulingPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        switch (this.schedulingStrategy) {
            case CRON_DRIVEN: {
                try {
                    new CronExpression(schedulingPeriod);
                    break;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Scheduling Period is not a valid cron expression: " + schedulingPeriod);
                }
            }
            case PRIMARY_NODE_ONLY: 
            case TIMER_DRIVEN: {
                long schedulingNanos = FormatUtils.getTimeDuration((String)Objects.requireNonNull(schedulingPeriod), (TimeUnit)TimeUnit.NANOSECONDS);
                if (schedulingNanos < 0L) {
                    throw new IllegalArgumentException("Scheduling Period must be positive");
                }
                this.schedulingNanos.set(Math.max(30000L, schedulingNanos));
                break;
            }
            default: {
                return;
            }
        }
        this.schedulingPeriod.set(schedulingPeriod);
    }

    public long getRunDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.runNanos, TimeUnit.NANOSECONDS);
    }

    public void setRunDuration(long duration, TimeUnit timeUnit) {
        if (duration < 0L) {
            throw new IllegalArgumentException("Run Duration must be non-negative value; cannot set to " + timeUnit.toSeconds(duration) + " seconds");
        }
        this.runNanos = timeUnit.toNanos(duration);
    }

    public long getYieldPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getYieldPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    public String getYieldPeriod() {
        return this.yieldPeriod.get();
    }

    public void setYieldPeriod(String yieldPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        long yieldMillis = FormatUtils.getTimeDuration((String)Objects.requireNonNull(yieldPeriod), (TimeUnit)TimeUnit.MILLISECONDS);
        if (yieldMillis < 0L) {
            throw new IllegalArgumentException("Yield duration must be positive");
        }
        this.yieldPeriod.set(yieldPeriod);
    }

    public void yield() {
        long yieldMillis = this.getYieldPeriod(TimeUnit.MILLISECONDS);
        this.yield(yieldMillis, TimeUnit.MILLISECONDS);
        String yieldDuration = yieldMillis > 1000L ? yieldMillis / 1000L + " seconds" : yieldMillis + " milliseconds";
        LoggerFactory.getLogger(this.processor.getClass()).debug("{} has chosen to yield its resources; will not be scheduled to run again for {}", (Object)this.processor, (Object)yieldDuration);
    }

    public void yield(long period, TimeUnit timeUnit) {
        long yieldMillis = TimeUnit.MILLISECONDS.convert(period, timeUnit);
        this.yieldExpiration.set(Math.max(this.yieldExpiration.get(), System.currentTimeMillis() + yieldMillis));
        this.processScheduler.yield((ProcessorNode)this);
    }

    public long getYieldExpiration() {
        return this.yieldExpiration.get();
    }

    public long getPenalizationPeriod(TimeUnit timeUnit) {
        return FormatUtils.getTimeDuration((String)this.getPenalizationPeriod(), (TimeUnit)(timeUnit == null ? DEFAULT_TIME_UNIT : timeUnit));
    }

    public String getPenalizationPeriod() {
        return this.penalizationPeriod.get();
    }

    public void setPenalizationPeriod(String penalizationPeriod) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        long penalizationMillis = FormatUtils.getTimeDuration((String)Objects.requireNonNull(penalizationPeriod), (TimeUnit)TimeUnit.MILLISECONDS);
        if (penalizationMillis < 0L) {
            throw new IllegalArgumentException("Penalization duration must be positive");
        }
        this.penalizationPeriod.set(penalizationPeriod);
    }

    public void setMaxConcurrentTasks(int taskCount) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
        if (taskCount < 1 && this.getSchedulingStrategy() != SchedulingStrategy.EVENT_DRIVEN) {
            throw new IllegalArgumentException();
        }
        if (!this.triggeredSerially) {
            this.concurrentTaskCount.set(taskCount);
        }
    }

    public boolean isTriggeredSerially() {
        return this.triggeredSerially;
    }

    public int getMaxConcurrentTasks() {
        return this.concurrentTaskCount.get();
    }

    public LogLevel getBulletinLevel() {
        return LogRepositoryFactory.getRepository((String)this.getIdentifier()).getObservationLevel(BULLETIN_OBSERVER_ID);
    }

    public void setBulletinLevel(LogLevel level) {
        LogRepositoryFactory.getRepository((String)this.getIdentifier()).setObservationLevel(BULLETIN_OBSERVER_ID, level);
    }

    public Set<Connection> getConnections() {
        HashSet<Connection> allConnections = new HashSet<Connection>();
        for (Set<Connection> connectionSet : this.connections.values()) {
            allConnections.addAll(connectionSet);
        }
        return allConnections;
    }

    public List<Connection> getIncomingConnections() {
        return this.incomingConnectionsRef.get();
    }

    public Set<Connection> getConnections(Relationship relationship) {
        Set<Connection> applicableConnections = this.connections.get(relationship);
        return applicableConnections == null ? Collections.emptySet() : Collections.unmodifiableSet(applicableConnections);
    }

    public void addConnection(Connection connection) {
        Object incomingConnections;
        Objects.requireNonNull(connection, "connection cannot be null");
        if (!connection.getSource().equals((Object)this) && !connection.getDestination().equals((Object)this)) {
            throw new IllegalStateException("Cannot a connection to a ProcessorNode for which the ProcessorNode is neither the Source nor the Destination");
        }
        ArrayList<Connection> updatedIncoming = null;
        if (connection.getDestination().equals((Object)this) && !(updatedIncoming = new ArrayList<Connection>((Collection<Connection>)(incomingConnections = this.incomingConnectionsRef.get()))).contains(connection)) {
            updatedIncoming.add(connection);
        }
        if (connection.getSource().equals((Object)this) && !this.destinations.containsKey(connection)) {
            for (Relationship relationship : connection.getRelationships()) {
                Relationship rel = this.getRelationship(relationship.getName());
                Set<Connection> set = this.connections.get(rel);
                if (set == null) {
                    set = new HashSet<Connection>();
                    this.connections.put(rel, set);
                }
                set.add(connection);
                this.destinations.put(connection, connection.getDestination());
            }
            Set<Relationship> autoTerminated = this.undefinedRelationshipsToTerminate.get();
            if (autoTerminated != null) {
                autoTerminated.removeAll(connection.getRelationships());
                this.undefinedRelationshipsToTerminate.set(autoTerminated);
            }
        }
        if (updatedIncoming != null) {
            this.incomingConnectionsRef.set(Collections.unmodifiableList(updatedIncoming));
        }
    }

    public boolean hasIncomingConnection() {
        return !this.incomingConnectionsRef.get().isEmpty();
    }

    public void updateConnection(Connection connection) throws IllegalStateException {
        if (Objects.requireNonNull(connection).getSource().equals((Object)this)) {
            ArrayList<Relationship> existingRelationships = new ArrayList<Relationship>();
            for (Map.Entry<Relationship, Set<Connection>> entry : this.connections.entrySet()) {
                if (!entry.getValue().contains(connection)) continue;
                existingRelationships.add(entry.getKey());
            }
            for (Relationship relationship : connection.getRelationships()) {
                Set<Connection> connectionsForRelationship;
                if (existingRelationships.contains(relationship) || (connectionsForRelationship = this.getConnections(relationship)) == null || connectionsForRelationship.size() != 1 || !this.isRunning() || this.isAutoTerminated(relationship) || !this.getRelationships().contains(relationship)) continue;
                throw new IllegalStateException("Cannot remove relationship " + relationship.getName() + " from Connection because doing so would invalidate Processor " + (Object)((Object)this) + ", which is currently running");
            }
            for (Set set : this.connections.values()) {
                set.remove(connection);
            }
            for (Relationship relationship : connection.getRelationships()) {
                Set<Connection> set = this.connections.get(relationship);
                if (set == null) {
                    set = new HashSet<Connection>();
                    this.connections.put(relationship, set);
                }
                set.add(connection);
            }
            this.destinations.put(connection, connection.getDestination());
            Set<Relationship> autoTerminated = this.undefinedRelationshipsToTerminate.get();
            if (autoTerminated != null) {
                autoTerminated.removeAll(connection.getRelationships());
                this.undefinedRelationshipsToTerminate.set(autoTerminated);
            }
        }
        if (connection.getDestination().equals((Object)this)) {
            List<Connection> incomingConnections = this.incomingConnectionsRef.get();
            ArrayList<Connection> updatedIncoming = new ArrayList<Connection>(incomingConnections);
            updatedIncoming.remove(connection);
            updatedIncoming.add(connection);
            this.incomingConnectionsRef.set(Collections.unmodifiableList(updatedIncoming));
        }
    }

    public void removeConnection(Connection connection) {
        List<Connection> incomingConnections;
        boolean connectionRemoved = false;
        if (Objects.requireNonNull(connection).getSource().equals((Object)this)) {
            for (Relationship relationship : connection.getRelationships()) {
                Set<Connection> connectionsForRelationship = this.getConnections(relationship);
                if (connectionsForRelationship != null && connectionsForRelationship.size() > 1 || !this.isRunning()) continue;
                throw new IllegalStateException("This connection cannot be removed because its source is running and removing it will invalidate this processor");
            }
            for (Set set : this.connections.values()) {
                set.remove(connection);
            }
            boolean bl = connectionRemoved = this.destinations.remove(connection) != null;
        }
        if (connection.getDestination().equals((Object)this) && (incomingConnections = this.incomingConnectionsRef.get()).contains(connection)) {
            ArrayList<Connection> arrayList = new ArrayList<Connection>(incomingConnections);
            arrayList.remove(connection);
            this.incomingConnectionsRef.set(Collections.unmodifiableList(arrayList));
            return;
        }
        if (!connectionRemoved) {
            throw new IllegalArgumentException("Cannot remove a connection from a ProcessorNode for which the ProcessorNode is not the Source");
        }
    }

    public Relationship getRelationship(String relationshipName) {
        Set relationships;
        Relationship specRel;
        Relationship returnRel = specRel = new Relationship.Builder().name(relationshipName).build();
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            relationships = this.processor.getRelationships();
        }
        for (Relationship rel : relationships) {
            if (!rel.equals((Object)specRel)) continue;
            returnRel = rel;
            break;
        }
        return returnRel;
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public Set<Connectable> getDestinations() {
        HashSet<Connectable> nonSelfDestinations = new HashSet<Connectable>();
        for (Connectable connectable : this.destinations.values()) {
            if (connectable == this) continue;
            nonSelfDestinations.add(connectable);
        }
        return nonSelfDestinations;
    }

    public Set<Connectable> getDestinations(Relationship relationship) {
        HashSet<Connectable> destinationSet = new HashSet<Connectable>();
        Set<Connection> relationshipConnections = this.connections.get(relationship);
        if (relationshipConnections != null) {
            for (Connection connection : relationshipConnections) {
                destinationSet.add(this.destinations.get(connection));
            }
        }
        return destinationSet;
    }

    public Set<Relationship> getUndefinedRelationships() {
        Set relationships;
        HashSet<Relationship> undefined = new HashSet<Relationship>();
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            relationships = this.processor.getRelationships();
        }
        if (relationships == null) {
            return undefined;
        }
        for (Relationship relation : relationships) {
            Set<Connection> connectionSet = this.connections.get(relation);
            if (connectionSet != null && !connectionSet.isEmpty()) continue;
            undefined.add(relation);
        }
        return undefined;
    }

    boolean isRelated(ProcessorNode node) {
        return this.destinations.containsValue(node);
    }

    public boolean isRunning() {
        return this.getScheduledState().equals((Object)ScheduledState.RUNNING) || this.processScheduler.getActiveThreadCount((Object)this) > 0;
    }

    public int getActiveThreadCount() {
        return this.processScheduler.getActiveThreadCount((Object)this);
    }

    List<Connection> getIncomingNonLoopConnections() {
        List<Connection> connections = this.getIncomingConnections();
        ArrayList<Connection> nonLoopConnections = new ArrayList<Connection>(connections.size());
        for (Connection connection : connections) {
            if (connection.getSource().equals((Object)this)) continue;
            nonLoopConnections.add(connection);
        }
        return nonLoopConnections;
    }

    public boolean isValid() {
        try {
            Collection validationResults;
            ValidationContext validationContext = this.getValidationContextFactory().newValidationContext(this.getProperties(), this.getAnnotationData());
            try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                validationResults = this.getProcessor().validate(validationContext);
            }
            for (ValidationResult result : validationResults) {
                if (result.isValid()) continue;
                return false;
            }
            for (Relationship undef : this.getUndefinedRelationships()) {
                if (this.isAutoTerminated(undef)) continue;
                return false;
            }
            switch (this.getInputRequirement()) {
                case INPUT_ALLOWED: {
                    break;
                }
                case INPUT_FORBIDDEN: {
                    if (this.getIncomingNonLoopConnections().isEmpty()) break;
                    return false;
                }
                case INPUT_REQUIRED: {
                    if (!this.getIncomingNonLoopConnections().isEmpty()) break;
                    return false;
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("Failed during validation", t);
            return false;
        }
        return true;
    }

    public Collection<ValidationResult> getValidationErrors() {
        ArrayList<ValidationResult> results;
        block21: {
            results = new ArrayList<ValidationResult>();
            try {
                Collection validationResults;
                if (this.getScheduledState() != ScheduledState.STOPPED) break block21;
                ValidationContext validationContext = this.getValidationContextFactory().newValidationContext(this.getProperties(), this.getAnnotationData());
                try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
                    validationResults = this.getProcessor().validate(validationContext);
                }
                for (ValidationResult result : validationResults) {
                    if (result.isValid()) continue;
                    results.add(result);
                }
                for (Relationship relationship : this.getUndefinedRelationships()) {
                    if (this.isAutoTerminated(relationship)) continue;
                    ValidationResult error = new ValidationResult.Builder().explanation("Relationship '" + relationship.getName() + "' is not connected to any component and is not auto-terminated").subject("Relationship " + relationship.getName()).valid(false).build();
                    results.add(error);
                }
                switch (this.getInputRequirement()) {
                    case INPUT_ALLOWED: {
                        break;
                    }
                    case INPUT_FORBIDDEN: {
                        int incomingConnCount = this.getIncomingNonLoopConnections().size();
                        if (incomingConnCount == 0) break;
                        results.add(new ValidationResult.Builder().explanation("Processor does not allow upstream connections but currently has " + incomingConnCount).subject("Upstream Connections").valid(false).build());
                        break;
                    }
                    case INPUT_REQUIRED: {
                        if (!this.getIncomingNonLoopConnections().isEmpty()) break;
                        results.add(new ValidationResult.Builder().explanation("Processor requires an upstream connection but currently has none").subject("Upstream Connections").valid(false).build());
                    }
                }
            }
            catch (Throwable t) {
                results.add(new ValidationResult.Builder().explanation("Failed to run validation due to " + t.toString()).valid(false).build());
            }
        }
        return results;
    }

    public InputRequirement.Requirement getInputRequirement() {
        return this.inputRequirement;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ProcessorNode)) {
            return false;
        }
        ProcessorNode on = (ProcessorNode)other;
        return new EqualsBuilder().append((Object)this.identifier.get(), (Object)on.getIdentifier()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 67).append(this.identifier).toHashCode();
    }

    public Collection<Relationship> getRelationships() {
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            Set set = this.getProcessor().getRelationships();
            return set;
        }
    }

    public String toString() {
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            String string = this.getProcessor().toString();
            return string;
        }
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    public void setProcessGroup(ProcessGroup group) {
        this.processGroup.set(group);
    }

    public void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory) {
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            this.processor.onTrigger(context, sessionFactory);
        }
    }

    public ConnectableType getConnectableType() {
        return ConnectableType.PROCESSOR;
    }

    public void setAnnotationData(String data) {
        Assert.state((!this.isRunning() ? 1 : 0) != 0, (String)"Cannot set AnnotationData while processor is running");
        super.setAnnotationData(data);
    }

    public Collection<ValidationResult> validate(ValidationContext validationContext) {
        return this.getValidationErrors();
    }

    public void verifyCanDelete() throws IllegalStateException {
        this.verifyCanDelete(false);
    }

    public void verifyCanDelete(boolean ignoreConnections) {
        if (this.isRunning()) {
            throw new IllegalStateException((Object)((Object)this) + " is running");
        }
        if (!ignoreConnections) {
            for (Set<Connection> connectionSet : this.connections.values()) {
                for (Connection connection : connectionSet) {
                    connection.verifyCanDelete();
                }
            }
            for (Connection connection : this.incomingConnectionsRef.get()) {
                if (connection.getSource().equals((Object)this)) {
                    connection.verifyCanDelete();
                    continue;
                }
                throw new IllegalStateException((Object)((Object)this) + " is the destination of another component");
            }
        }
    }

    public void verifyCanStart() {
        this.verifyCanStart(null);
    }

    public void verifyCanStart(Set<ControllerServiceNode> ignoredReferences) {
        ScheduledState currentState = this.getPhysicalScheduledState();
        if (currentState != ScheduledState.STOPPED && currentState != ScheduledState.DISABLED) {
            throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is not stopped. Current state is " + currentState.name());
        }
        this.verifyNoActiveThreads();
        if (ignoredReferences != null) {
            HashSet<String> ids = new HashSet<String>();
            for (ControllerServiceNode node : ignoredReferences) {
                ids.add(node.getIdentifier());
            }
            Collection validationResults = this.getValidationErrors(ids);
            for (ValidationResult result : validationResults) {
                if (result.isValid()) continue;
                throw new IllegalStateException((Object)((Object)this) + " cannot be started because it is not valid: " + result);
            }
        } else if (!this.isValid()) {
            throw new IllegalStateException((Object)((Object)this) + " is not in a valid state");
        }
    }

    public void verifyCanStop() {
        if (this.getScheduledState() != ScheduledState.RUNNING) {
            throw new IllegalStateException((Object)((Object)this) + " is not scheduled to run");
        }
    }

    public void verifyCanUpdate() {
        if (this.isRunning()) {
            throw new IllegalStateException((Object)((Object)this) + " is not stopped");
        }
    }

    public void verifyCanEnable() {
        if (this.getScheduledState() != ScheduledState.DISABLED) {
            throw new IllegalStateException((Object)((Object)this) + " is not disabled");
        }
        this.verifyNoActiveThreads();
    }

    public void verifyCanDisable() {
        if (this.getScheduledState() != ScheduledState.STOPPED) {
            throw new IllegalStateException((Object)((Object)this) + " is not stopped");
        }
        this.verifyNoActiveThreads();
    }

    public void verifyCanClearState() throws IllegalStateException {
        this.verifyCanUpdate();
    }

    private void verifyNoActiveThreads() throws IllegalStateException {
        int threadCount = this.processScheduler.getActiveThreadCount((Object)this);
        if (threadCount > 0) {
            throw new IllegalStateException((Object)((Object)this) + " has " + threadCount + " threads still active");
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot modify Processor configuration while the Processor is running");
        }
    }

    public <T extends ProcessContext & ControllerServiceLookup> void start(final ScheduledExecutorService taskScheduler, final long administrativeYieldMillis, final T processContext, final SchedulingAgentCallback schedulingAgentCallback) {
        if (!this.isValid()) {
            throw new IllegalStateException("Processor " + this.getName() + " is not in a valid state due to " + this.getValidationErrors());
        }
        final SimpleProcessLogger procLog = new SimpleProcessLogger(this.getIdentifier(), this.processor);
        if (this.scheduledState.compareAndSet(ScheduledState.STOPPED, ScheduledState.STARTING)) {
            Runnable startProcRunnable = new Runnable(){

                @Override
                public void run() {
                    block16: {
                        try {
                            StandardProcessorNode.this.invokeTaskAsCancelableFuture(schedulingAgentCallback, new Callable<Void>(){

                                @Override
                                public Void call() throws Exception {
                                    try (NarCloseable nc = NarCloseable.withNarLoader();){
                                        ReflectionUtils.invokeMethodsWithAnnotations(org.apache.nifi.annotation.lifecycle.OnScheduled.class, OnScheduled.class, (Object)StandardProcessorNode.this.processor, processContext);
                                        Void void_ = null;
                                        return void_;
                                    }
                                }
                            });
                            if (StandardProcessorNode.this.scheduledState.compareAndSet(ScheduledState.STARTING, ScheduledState.RUNNING)) {
                                schedulingAgentCallback.trigger();
                                break block16;
                            }
                            try (NarCloseable nc = NarCloseable.withNarLoader();){
                                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)StandardProcessorNode.this.processor, processContext);
                            }
                            StandardProcessorNode.this.scheduledState.set(ScheduledState.STOPPED);
                        }
                        catch (Exception e) {
                            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                            procLog.error("{} failed to invoke @OnScheduled method due to {}; processor will not be scheduled to run for {}", new Object[]{StandardProcessorNode.this.getProcessor(), cause, administrativeYieldMillis + " milliseconds"}, cause);
                            LOG.error("Failed to invoke @OnScheduled method due to {}", (Object)cause.toString(), (Object)cause);
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)StandardProcessorNode.this.processor, processContext);
                            if (StandardProcessorNode.this.scheduledState.get() != ScheduledState.STOPPING) {
                                taskScheduler.schedule(this, administrativeYieldMillis, TimeUnit.MILLISECONDS);
                            }
                            StandardProcessorNode.this.scheduledState.set(ScheduledState.STOPPED);
                        }
                    }
                }
            };
            taskScheduler.execute(startProcRunnable);
        } else {
            String procName = this.processor.getClass().getSimpleName();
            LOG.warn("Can not start '" + procName + "' since it's already in the process of being started or it is DISABLED - " + this.scheduledState.get());
            procLog.warn("Can not start '" + procName + "' since it's already in the process of being started or it is DISABLED - " + this.scheduledState.get());
        }
    }

    public <T extends ProcessContext & ControllerServiceLookup> void stop(final ScheduledExecutorService scheduler, final T processContext, final Callable<Boolean> activeThreadMonitorCallback) {
        LOG.info("Stopping processor: " + this.processor.getClass());
        if (this.scheduledState.compareAndSet(ScheduledState.RUNNING, ScheduledState.STOPPING)) {
            scheduler.execute(new Runnable(){
                boolean unscheduled = false;

                @Override
                public void run() {
                    block17: {
                        if (!this.unscheduled) {
                            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnUnscheduled.class, (Object)StandardProcessorNode.this.processor, processContext);
                            this.unscheduled = true;
                        }
                        try {
                            if (((Boolean)activeThreadMonitorCallback.call()).booleanValue()) {
                                try (NarCloseable nc = NarCloseable.withNarLoader();){
                                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnStopped.class, (Object)StandardProcessorNode.this.processor, processContext);
                                }
                                StandardProcessorNode.this.scheduledState.set(ScheduledState.STOPPED);
                                break block17;
                            }
                            scheduler.schedule(this, 100L, TimeUnit.MILLISECONDS);
                        }
                        catch (Exception e) {
                            LOG.warn("Failed while shutting down processor " + StandardProcessorNode.this.processor, (Throwable)e);
                        }
                    }
                }
            });
        } else {
            this.scheduledState.compareAndSet(ScheduledState.STARTING, ScheduledState.STOPPING);
        }
    }

    private <T> void invokeTaskAsCancelableFuture(SchedulingAgentCallback callback, Callable<T> task) {
        String timeoutString = NiFiProperties.getInstance().getProperty("nifi.processor.scheduling.timeout");
        long onScheduleTimeout = timeoutString == null ? 60000L : FormatUtils.getTimeDuration((String)timeoutString.trim(), (TimeUnit)TimeUnit.MILLISECONDS);
        Future taskFuture = callback.invokeMonitoringTask(task);
        try {
            taskFuture.get(onScheduleTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Thread was interrupted while waiting for processor '" + this.processor.getClass().getSimpleName() + "' lifecycle OnScheduled operation to finish.");
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted while executing one of processor's OnScheduled tasks.", e);
        }
        catch (TimeoutException e) {
            taskFuture.cancel(true);
            LOG.warn("Timed out while waiting for OnScheduled of '" + this.processor.getClass().getSimpleName() + "' processor to finish. An attempt is made to cancel the task via Thread.interrupt(). However it does not " + "guarantee that the task will be canceled since the code inside current OnScheduled operation may " + "have been written to ignore interrupts which may result in runaway thread which could lead to more issues " + "eventually requiring NiFi to be restarted. This is usually a bug in the target Processor '" + this.processor + "' that needs to be documented, reported and eventually fixed.");
            throw new RuntimeException("Timed out while executing one of processor's OnScheduled task.", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed while executing one of processor's OnScheduled task.", e);
        }
        finally {
            callback.postMonitor();
        }
    }
}

