/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.service;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.controller.AbstractConfiguredComponent;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.Heartbeater;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.annotation.OnConfigured;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceReference;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardControllerServiceNode
extends AbstractConfiguredComponent
implements ControllerServiceNode {
    private static final Logger LOG = LoggerFactory.getLogger(StandardControllerServiceNode.class);
    private final ControllerService proxedControllerService;
    private final ControllerService implementation;
    private final ControllerServiceProvider serviceProvider;
    private final VariableRegistry variableRegistry;
    private final AtomicReference<ControllerServiceState> stateRef = new AtomicReference<ControllerServiceState>(ControllerServiceState.DISABLED);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final Set<ConfiguredComponent> referencingComponents = new HashSet<ConfiguredComponent>();
    private String comment;
    private final AtomicBoolean active;

    public StandardControllerServiceNode(ControllerService proxiedControllerService, ControllerService implementation, String id, ValidationContextFactory validationContextFactory, ControllerServiceProvider serviceProvider, VariableRegistry variableRegistry) {
        super((ConfigurableComponent)implementation, id, validationContextFactory, serviceProvider);
        this.proxedControllerService = proxiedControllerService;
        this.implementation = implementation;
        this.serviceProvider = serviceProvider;
        this.active = new AtomicBoolean();
        this.variableRegistry = variableRegistry;
    }

    public ControllerService getProxiedControllerService() {
        return this.proxedControllerService;
    }

    public ControllerService getControllerServiceImplementation() {
        return this.implementation;
    }

    public ControllerServiceReference getReferences() {
        this.readLock.lock();
        try {
            StandardControllerServiceReference standardControllerServiceReference = new StandardControllerServiceReference(this, this.referencingComponents);
            return standardControllerServiceReference;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void addReference(ConfiguredComponent referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.add(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public List<ControllerServiceNode> getRequiredControllerServices() {
        HashSet<ControllerServiceNode> requiredServices = new HashSet<ControllerServiceNode>();
        for (Map.Entry pEntry : this.getProperties().entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)pEntry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || pEntry.getValue() == null) continue;
            ControllerServiceNode rNode = this.serviceProvider.getControllerServiceNode((String)pEntry.getValue());
            requiredServices.add(rNode);
            requiredServices.addAll(rNode.getRequiredControllerServices());
        }
        return new ArrayList<ControllerServiceNode>(requiredServices);
    }

    public void removeReference(ConfiguredComponent referencingComponent) {
        this.writeLock.lock();
        try {
            this.referencingComponents.remove(referencingComponent);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void verifyModifiable() throws IllegalStateException {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException("Cannot modify Controller Service configuration because it is currently enabled. Please disable the Controller Service first.");
        }
    }

    public void setProperty(String name, String value) {
        super.setProperty(name, value);
        this.onConfigured();
    }

    public boolean removeProperty(String name) {
        boolean removed = super.removeProperty(name);
        if (removed) {
            this.onConfigured();
        }
        return removed;
    }

    private void onConfigured() {
        try (NarCloseable x = NarCloseable.withNarLoader();){
            StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)this, (ControllerServiceLookup)this.serviceProvider, null, this.variableRegistry);
            ReflectionUtils.invokeMethodsWithAnnotation(OnConfigured.class, this.implementation, configContext);
        }
        catch (Exception e) {
            throw new ComponentLifeCycleException("Failed to invoke On-Configured Lifecycle methods of " + this.implementation, (Throwable)e);
        }
    }

    public void verifyCanDelete() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.implementation + " cannot be deleted because it is not disabled");
        }
    }

    public void verifyCanDisable() {
        this.verifyCanDisable(Collections.emptySet());
    }

    public void verifyCanDisable(Set<ControllerServiceNode> ignoreReferences) {
        if (!this.isActive()) {
            throw new IllegalStateException("Cannot disable " + this.getControllerServiceImplementation() + " because it is not enabled");
        }
        ControllerServiceReference references = this.getReferences();
        HashSet<ConfiguredComponent> activeReferences = new HashSet<ConfiguredComponent>();
        for (ConfiguredComponent activeReference : references.getActiveReferences()) {
            if (ignoreReferences.contains(activeReference)) continue;
            activeReferences.add(activeReference);
        }
        if (!activeReferences.isEmpty()) {
            throw new IllegalStateException(this.implementation + " cannot be disabled because it is referenced by " + activeReferences.size() + " components that are currently running: " + activeReferences);
        }
    }

    public void verifyCanEnable() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not disabled");
        }
        if (!this.isValid()) {
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not valid: " + this.getValidationErrors());
        }
    }

    public void verifyCanEnable(Set<ControllerServiceNode> ignoredReferences) {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not disabled");
        }
        HashSet<String> ids = new HashSet<String>();
        for (ControllerServiceNode node : ignoredReferences) {
            ids.add(node.getIdentifier());
        }
        Collection<ValidationResult> validationResults = this.getValidationErrors(ids);
        for (ValidationResult result : validationResults) {
            if (result.isValid()) continue;
            throw new IllegalStateException(this.implementation + " cannot be enabled because it is not valid: " + result);
        }
    }

    public void verifyCanUpdate() {
        if (this.getState() != ControllerServiceState.DISABLED) {
            throw new IllegalStateException(this.implementation + " cannot be updated because it is not disabled");
        }
    }

    public void verifyCanClearState() {
        this.verifyCanUpdate();
    }

    public String getComments() {
        this.readLock.lock();
        try {
            String string = this.comment;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void setComments(String comment) {
        this.writeLock.lock();
        try {
            this.comment = comment;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public ControllerServiceState getState() {
        return this.stateRef.get();
    }

    public boolean isActive() {
        return this.active.get();
    }

    public void enable(final ScheduledExecutorService scheduler, final long administrativeYieldMillis, final Heartbeater heartbeater) {
        if (this.stateRef.compareAndSet(ControllerServiceState.DISABLED, ControllerServiceState.ENABLING)) {
            this.active.set(true);
            final StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)this, (ControllerServiceLookup)this.serviceProvider, null, this.variableRegistry);
            scheduler.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ReflectionUtils.invokeMethodsWithAnnotation(OnEnabled.class, StandardControllerServiceNode.this.getControllerServiceImplementation(), configContext);
                        boolean shouldEnable = false;
                        AtomicBoolean atomicBoolean = StandardControllerServiceNode.this.active;
                        synchronized (atomicBoolean) {
                            shouldEnable = StandardControllerServiceNode.this.active.get() && StandardControllerServiceNode.this.stateRef.compareAndSet(ControllerServiceState.ENABLING, ControllerServiceState.ENABLED);
                        }
                        if (shouldEnable) {
                            heartbeater.heartbeat();
                        } else {
                            LOG.debug("Disabling service " + this + " after it has been enabled due to disable action being initiated.");
                            StandardControllerServiceNode.this.invokeDisable(configContext, heartbeater);
                            StandardControllerServiceNode.this.stateRef.set(ControllerServiceState.DISABLED);
                        }
                    }
                    catch (Exception e) {
                        Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
                        SimpleProcessLogger componentLog = new SimpleProcessLogger(StandardControllerServiceNode.this.getIdentifier(), (Object)StandardControllerServiceNode.this);
                        componentLog.error("Failed to invoke @OnEnabled method due to {}", cause);
                        LOG.error("Failed to invoke @OnEnabled method of {} due to {}", (Object)StandardControllerServiceNode.this.getControllerServiceImplementation(), (Object)cause.toString());
                        StandardControllerServiceNode.this.invokeDisable(configContext, heartbeater);
                        if (StandardControllerServiceNode.this.isActive()) {
                            scheduler.schedule(this, administrativeYieldMillis, TimeUnit.MILLISECONDS);
                        }
                        ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnDisabled.class, (Object)StandardControllerServiceNode.this.getControllerServiceImplementation(), configContext);
                        StandardControllerServiceNode.this.stateRef.set(ControllerServiceState.DISABLED);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable(ScheduledExecutorService scheduler, final Heartbeater heartbeater) {
        AtomicBoolean atomicBoolean = this.active;
        synchronized (atomicBoolean) {
            this.active.set(false);
        }
        if (this.stateRef.compareAndSet(ControllerServiceState.ENABLED, ControllerServiceState.DISABLING)) {
            final StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)this, (ControllerServiceLookup)this.serviceProvider, null, this.variableRegistry);
            scheduler.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        StandardControllerServiceNode.this.invokeDisable(configContext, heartbeater);
                    }
                    finally {
                        StandardControllerServiceNode.this.stateRef.set(ControllerServiceState.DISABLED);
                        heartbeater.heartbeat();
                    }
                }
            });
        } else {
            this.stateRef.compareAndSet(ControllerServiceState.ENABLING, ControllerServiceState.DISABLING);
        }
    }

    private void invokeDisable(ConfigurationContext configContext, Heartbeater heartbeater) {
        try {
            ReflectionUtils.invokeMethodsWithAnnotation(OnDisabled.class, this.getControllerServiceImplementation(), configContext);
        }
        catch (Exception e) {
            Throwable cause = e instanceof InvocationTargetException ? e.getCause() : e;
            SimpleProcessLogger componentLog = new SimpleProcessLogger(this.getIdentifier(), (Object)this);
            componentLog.error("Failed to invoke @OnDisabled method due to {}", cause);
            LOG.error("Failed to invoke @OnDisabled method of {} due to {}", (Object)this.getControllerServiceImplementation(), (Object)cause.toString());
        }
    }

    public Collection<ValidationResult> getValidationErrors(Set<String> serviceIdentifiersNotToValidate) {
        Collection<Object> results = null;
        if (this.stateRef.get() == ControllerServiceState.DISABLED) {
            results = super.getValidationErrors(serviceIdentifiersNotToValidate);
        }
        return results != null ? results : Collections.emptySet();
    }
}

