/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.state.manager;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.components.state.StateProvider;
import org.apache.nifi.components.state.StateProviderInitializationContext;
import org.apache.nifi.controller.state.ConfigParseException;
import org.apache.nifi.controller.state.StandardStateManager;
import org.apache.nifi.controller.state.StandardStateProviderInitializationContext;
import org.apache.nifi.controller.state.config.StateManagerConfiguration;
import org.apache.nifi.controller.state.config.StateProviderConfiguration;
import org.apache.nifi.framework.security.util.SslContextFactory;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.processor.StandardValidationContext;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardStateManagerProvider
implements StateManagerProvider {
    private static final Logger logger = LoggerFactory.getLogger(StandardStateManagerProvider.class);
    private final ConcurrentMap<String, StateManager> stateManagers = new ConcurrentHashMap<String, StateManager>();
    private final StateProvider localStateProvider;
    private final StateProvider clusterStateProvider;

    private StandardStateManagerProvider(StateProvider localStateProvider, StateProvider clusterStateProvider) {
        this.localStateProvider = localStateProvider;
        this.clusterStateProvider = clusterStateProvider;
    }

    public static StateManagerProvider create(NiFiProperties properties, VariableRegistry variableRegistry) throws ConfigParseException, IOException {
        StateProvider localProvider = StandardStateManagerProvider.createLocalStateProvider(properties, variableRegistry);
        StateProvider clusterProvider = properties.isNode() ? StandardStateManagerProvider.createClusteredStateProvider(properties, variableRegistry) : null;
        return new StandardStateManagerProvider(localProvider, clusterProvider);
    }

    private static StateProvider createLocalStateProvider(NiFiProperties properties, VariableRegistry variableRegistry) throws IOException, ConfigParseException {
        File configFile = properties.getStateManagementConfigFile();
        return StandardStateManagerProvider.createStateProvider(configFile, Scope.LOCAL, properties, variableRegistry);
    }

    private static StateProvider createClusteredStateProvider(NiFiProperties properties, VariableRegistry variableRegistry) throws IOException, ConfigParseException {
        File configFile = properties.getStateManagementConfigFile();
        return StandardStateManagerProvider.createStateProvider(configFile, Scope.CLUSTER, properties, variableRegistry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StateProvider createStateProvider(File configFile, Scope scope, NiFiProperties properties, VariableRegistry variableRegistry) throws ConfigParseException, IOException {
        PropertyDescriptor descriptor;
        StateProvider provider;
        String oppositeScopeXmlElementName;
        String providerXmlElementName;
        String providerDescription;
        String providerIdPropertyName;
        String providerId;
        switch (scope) {
            case CLUSTER: {
                providerId = properties.getClusterStateProviderId();
                providerIdPropertyName = "nifi.state.management.provider.cluster";
                providerDescription = "Cluster State Provider";
                providerXmlElementName = "cluster-provider";
                oppositeScopeXmlElementName = "local-provider";
                break;
            }
            case LOCAL: {
                providerId = properties.getLocalStateProviderId();
                providerIdPropertyName = "nifi.state.management.provider.local";
                providerDescription = "Local State Provider";
                providerXmlElementName = "local-provider";
                oppositeScopeXmlElementName = "cluster-provider";
                break;
            }
            default: {
                throw new AssertionError((Object)("Attempted to create State Provider for unknown Scope: " + scope));
            }
        }
        if (!configFile.exists()) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the State Management Configuration File " + configFile + " does not exist");
        }
        if (!configFile.canRead()) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the State Management Configuration File " + configFile + " cannot be read");
        }
        if (providerId == null) {
            if (scope == Scope.CLUSTER) {
                throw new IllegalStateException("Cannot create Cluster State Provider because the '" + providerIdPropertyName + "' property is missing from the NiFi Properties file. In order to run NiFi in a cluster, the " + providerIdPropertyName + " property must be configured in nifi.properties");
            }
            throw new IllegalStateException("Cannot create " + providerDescription + " because the '" + providerIdPropertyName + "' property is missing from the NiFi Properties file");
        }
        if (providerId.trim().isEmpty()) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the '" + providerIdPropertyName + "' property in the NiFi Properties file has no value set. This is a required property and must reference the identifier of one of the " + providerXmlElementName + " elements in the State Management Configuraiton File (" + configFile + ")");
        }
        StateManagerConfiguration config = StateManagerConfiguration.parse(configFile);
        StateProviderConfiguration providerConfig = config.getStateProviderConfiguration(providerId);
        if (providerConfig == null) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the '" + providerIdPropertyName + "' property in the NiFi Properties file is set to '" + providerId + "', but there is no " + providerXmlElementName + " entry in the State Management Configuration File (" + configFile + ") with this id");
        }
        if (providerConfig.getScope() != scope) {
            throw new IllegalStateException("Cannot create " + providerDescription + " because the '" + providerIdPropertyName + "' property in the NiFi Properties file is set to '" + providerId + "', but this id is assigned to a " + oppositeScopeXmlElementName + " entry in the State Management Configuration File (" + configFile + "), rather than a " + providerXmlElementName + " entry");
        }
        String providerClassName = providerConfig.getClassName();
        try {
            provider = StandardStateManagerProvider.instantiateStateProvider(providerClassName);
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot create " + providerDescription + " of type " + providerClassName, e);
        }
        if (!ArrayUtils.contains((Object[])provider.getSupportedScopes(), (Object)scope)) {
            throw new RuntimeException("Cannot use " + providerDescription + " (" + providerClassName + ") as it only supports scope(s) " + ArrayUtils.toString((Object)provider.getSupportedScopes()) + " but " + "instance" + " is configured to use scope " + scope);
        }
        HashMap<PropertyDescriptor, PropertyValue> propertyMap = new HashMap<PropertyDescriptor, PropertyValue>();
        HashMap<PropertyDescriptor, String> propertyStringMap = new HashMap<PropertyDescriptor, String>();
        for (PropertyDescriptor propertyDescriptor : provider.getPropertyDescriptors()) {
            propertyMap.put(propertyDescriptor, (PropertyValue)new StandardPropertyValue(propertyDescriptor.getDefaultValue(), null, variableRegistry));
            propertyStringMap.put(propertyDescriptor, propertyDescriptor.getDefaultValue());
        }
        for (Map.Entry entry : providerConfig.getProperties().entrySet()) {
            descriptor = provider.getPropertyDescriptor((String)entry.getKey());
            propertyStringMap.put(descriptor, (String)entry.getValue());
            propertyMap.put(descriptor, (PropertyValue)new StandardPropertyValue((String)entry.getValue(), null, variableRegistry));
        }
        SSLContext sslContext = SslContextFactory.createSslContext((NiFiProperties)properties, (boolean)false);
        StandardStateProviderInitializationContext standardStateProviderInitializationContext = new StandardStateProviderInitializationContext(providerId, propertyMap, sslContext);
        descriptor = provider;
        synchronized (descriptor) {
            provider.initialize((StateProviderInitializationContext)standardStateProviderInitializationContext);
        }
        StandardValidationContext validationContext = new StandardValidationContext(null, propertyStringMap, null, variableRegistry);
        Collection results = provider.validate((ValidationContext)validationContext);
        StringBuilder validationFailures = new StringBuilder();
        int invalidCount = 0;
        for (ValidationResult result : results) {
            if (result.isValid()) continue;
            validationFailures.append(result.toString()).append("\n");
            ++invalidCount;
        }
        if (invalidCount > 0) {
            throw new IllegalStateException("Could not initialize State Providers because the " + providerDescription + " is not valid. The following " + invalidCount + " Validation Errors occurred:\n" + validationFailures.toString() + "\nPlease check the configuration of the " + providerDescription + " with ID [" + providerId.trim() + "] in the file " + configFile.getAbsolutePath());
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StateProvider instantiateStateProvider(String type) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader detectedClassLoaderForType = ExtensionManager.getClassLoader((String)type);
            Class<?> rawClass = detectedClassLoaderForType == null ? Class.forName(type) : Class.forName(type, true, ExtensionManager.getClassLoader((String)type));
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<StateProvider> mgrClass = rawClass.asSubclass(StateProvider.class);
            StateProvider stateProvider = mgrClass.newInstance();
            return stateProvider;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    public synchronized StateManager getStateManager(String componentId) {
        StateManager stateManager = (StateManager)this.stateManagers.get(componentId);
        if (stateManager != null) {
            return stateManager;
        }
        stateManager = new StandardStateManager(this.localStateProvider, this.clusterStateProvider, componentId);
        this.stateManagers.put(componentId, stateManager);
        return stateManager;
    }

    public synchronized void shutdown() {
        this.localStateProvider.shutdown();
        if (this.clusterStateProvider != null) {
            this.clusterStateProvider.shutdown();
        }
    }

    public void enableClusterProvider() {
        this.clusterStateProvider.enable();
    }

    public void disableClusterProvider() {
        this.clusterStateProvider.disable();
    }

    public void onComponentRemoved(String componentId) {
        StateManager mgr = (StateManager)this.stateManagers.remove(componentId);
        if (mgr == null) {
            return;
        }
        try {
            mgr.clear(Scope.CLUSTER);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to clear clustered state for the component", (Throwable)e);
        }
        try {
            mgr.clear(Scope.LOCAL);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to clear local state for the component", (Throwable)e);
        }
        try {
            this.localStateProvider.onComponentRemoved(componentId);
        }
        catch (Exception e) {
            logger.warn("Component with ID {} was removed from NiFi instance but failed to cleanup resources used to maintain its local state", (Throwable)e);
        }
        if (this.clusterStateProvider != null) {
            try {
                this.clusterStateProvider.onComponentRemoved(componentId);
            }
            catch (Exception e) {
                logger.warn("Component with ID {} was removed from NiFi instance but failed to cleanup resources used to maintain its clustered state", (Throwable)e);
            }
        }
    }
}

