/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.connectable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.StandardFlowFileQueue;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.processor.FlowFileFilter;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.util.NiFiProperties;

public final class StandardConnection
implements Connection {
    private final String id;
    private final AtomicReference<ProcessGroup> processGroup;
    private final AtomicReference<String> name;
    private final AtomicReference<List<Position>> bendPoints;
    private final Connectable source;
    private final AtomicReference<Connectable> destination;
    private final AtomicReference<Collection<Relationship>> relationships;
    private final StandardFlowFileQueue flowFileQueue;
    private final AtomicInteger labelIndex = new AtomicInteger(1);
    private final AtomicLong zIndex = new AtomicLong(0L);
    private final ProcessScheduler scheduler;
    private final int hashCode;

    private StandardConnection(Builder builder) {
        this.id = builder.id;
        this.name = new AtomicReference<String>(builder.name);
        this.bendPoints = new AtomicReference(Collections.unmodifiableList(new ArrayList(builder.bendPoints)));
        this.processGroup = new AtomicReference<ProcessGroup>(builder.processGroup);
        this.source = builder.source;
        this.destination = new AtomicReference<Connectable>(builder.destination);
        this.relationships = new AtomicReference(Collections.unmodifiableCollection(builder.relationships));
        this.scheduler = builder.scheduler;
        this.flowFileQueue = new StandardFlowFileQueue(this.id, this, builder.flowFileRepository, builder.provenanceRepository, builder.resourceClaimManager, this.scheduler, builder.swapManager, builder.eventReporter, NiFiProperties.getInstance().getQueueSwapThreshold());
        this.hashCode = new HashCodeBuilder(7, 67).append((Object)this.id).toHashCode();
    }

    public ProcessGroup getProcessGroup() {
        return this.processGroup.get();
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public Authorizable getParentAuthorizable() {
        return null;
    }

    public Resource getResource() {
        return new Resource(){

            public String getIdentifier() {
                return "/connections/" + StandardConnection.this.getIdentifier();
            }

            public String getName() {
                String name = StandardConnection.this.getName();
                Collection<Relationship> relationships = StandardConnection.this.getRelationships();
                if (name == null && CollectionUtils.isNotEmpty(relationships)) {
                    name = StringUtils.join((Iterable)relationships.stream().map(relationship -> relationship.getName()).collect(Collectors.toSet()), (String)", ");
                }
                if (name == null) {
                    name = "Connection";
                }
                return name;
            }
        };
    }

    public AuthorizationResult checkAuthorization(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) {
        if (user == null) {
            return AuthorizationResult.denied((String)"Unknown user");
        }
        AuthorizationResult sourceResult = this.getSource().checkAuthorization(authorizer, action, user, resourceContext);
        if (AuthorizationResult.Result.Denied.equals((Object)sourceResult.getResult())) {
            return sourceResult;
        }
        return this.getDestination().checkAuthorization(authorizer, action, user, resourceContext);
    }

    public void authorize(Authorizer authorizer, RequestAction action, NiFiUser user, Map<String, String> resourceContext) throws AccessDeniedException {
        if (user == null) {
            throw new AccessDeniedException("Unknown user");
        }
        this.getSource().authorize(authorizer, action, user, resourceContext);
        this.getDestination().authorize(authorizer, action, user, resourceContext);
    }

    public List<Position> getBendPoints() {
        return this.bendPoints.get();
    }

    public void setBendPoints(List<Position> position) {
        this.bendPoints.set(Collections.unmodifiableList(new ArrayList<Position>(position)));
    }

    public int getLabelIndex() {
        return this.labelIndex.get();
    }

    public void setLabelIndex(int labelIndex) {
        this.labelIndex.set(labelIndex);
    }

    public long getZIndex() {
        return this.zIndex.get();
    }

    public void setZIndex(long zIndex) {
        this.zIndex.set(zIndex);
    }

    public Connectable getSource() {
        return this.source;
    }

    public Connectable getDestination() {
        return this.destination.get();
    }

    public Collection<Relationship> getRelationships() {
        return this.relationships.get();
    }

    public FlowFileQueue getFlowFileQueue() {
        return this.flowFileQueue;
    }

    public void setProcessGroup(ProcessGroup newGroup) {
        ProcessGroup currentGroup = this.processGroup.get();
        try {
            this.processGroup.set(newGroup);
        }
        catch (RuntimeException e) {
            this.processGroup.set(currentGroup);
            throw e;
        }
    }

    public void setRelationships(Collection<Relationship> newRelationships) {
        Collection<Relationship> currentRelationships = this.relationships.get();
        if (currentRelationships.equals(newRelationships)) {
            return;
        }
        if (this.getSource().isRunning()) {
            throw new IllegalStateException("Cannot update the relationships for Connection because the source of the Connection is running");
        }
        try {
            this.relationships.set(new ArrayList<Relationship>(newRelationships));
            this.getSource().updateConnection((Connection)this);
        }
        catch (RuntimeException e) {
            this.relationships.set(currentRelationships);
            throw e;
        }
    }

    public void setDestination(Connectable newDestination) {
        Connectable previousDestination = this.destination.get();
        if (previousDestination.equals(newDestination)) {
            return;
        }
        if (previousDestination.isRunning() && !(previousDestination instanceof Funnel) && !(previousDestination instanceof LocalPort)) {
            throw new IllegalStateException("Cannot change destination of Connection because the current destination is running");
        }
        if (this.getFlowFileQueue().getUnacknowledgedQueueSize().getObjectCount() > 0) {
            throw new IllegalStateException("Cannot change destination of Connection because FlowFiles from this Connection are currently held by " + previousDestination);
        }
        try {
            previousDestination.removeConnection((Connection)this);
            this.destination.set(newDestination);
            this.getSource().updateConnection((Connection)this);
            newDestination.addConnection((Connection)this);
            this.scheduler.registerEvent(newDestination);
        }
        catch (RuntimeException e) {
            this.destination.set(previousDestination);
            throw e;
        }
    }

    public void lock() {
        this.flowFileQueue.lock();
    }

    public void unlock() {
        this.flowFileQueue.unlock();
    }

    public List<FlowFileRecord> poll(FlowFileFilter filter, Set<FlowFileRecord> expiredRecords) {
        return this.flowFileQueue.poll(filter, expiredRecords);
    }

    public boolean equals(Object other) {
        if (!(other instanceof Connection)) {
            return false;
        }
        Connection con = (Connection)other;
        return new EqualsBuilder().append((Object)this.id, (Object)con.getIdentifier()).isEquals();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "Connection[Source ID=" + this.id + ",Dest ID=" + this.getDestination().getIdentifier() + "]";
    }

    public void enqueue(FlowFileRecord flowFile) {
        this.flowFileQueue.put(flowFile);
    }

    public void enqueue(Collection<FlowFileRecord> flowFiles) {
        this.flowFileQueue.putAll(flowFiles);
    }

    public void verifyCanUpdate() {
    }

    public void verifyCanDelete() {
        if (!this.flowFileQueue.isEmpty()) {
            throw new IllegalStateException("Queue not empty for " + this.getIdentifier());
        }
        if (this.source.isRunning() && !ConnectableType.FUNNEL.equals((Object)this.source.getConnectableType())) {
            throw new IllegalStateException("Source of Connection (" + this.source.getIdentifier() + ") is running");
        }
        Connectable dest = this.destination.get();
        if (dest.isRunning() && !ConnectableType.FUNNEL.equals((Object)dest.getConnectableType())) {
            throw new IllegalStateException("Destination of Connection (" + dest.getIdentifier() + ") is running");
        }
    }

    public static class Builder {
        private final ProcessScheduler scheduler;
        private String id = UUID.randomUUID().toString();
        private String name;
        private List<Position> bendPoints = new ArrayList<Position>();
        private ProcessGroup processGroup;
        private Connectable source;
        private Connectable destination;
        private Collection<Relationship> relationships;
        private FlowFileSwapManager swapManager;
        private EventReporter eventReporter;
        private FlowFileRepository flowFileRepository;
        private ProvenanceEventRepository provenanceRepository;
        private ResourceClaimManager resourceClaimManager;

        public Builder(ProcessScheduler scheduler) {
            this.scheduler = scheduler;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder source(Connectable source) {
            this.source = source;
            return this;
        }

        public Builder processGroup(ProcessGroup group) {
            this.processGroup = group;
            return this;
        }

        public Builder destination(Connectable destination) {
            this.destination = destination;
            return this;
        }

        public Builder relationships(Collection<Relationship> relationships) {
            this.relationships = new ArrayList<Relationship>(relationships);
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder bendPoints(List<Position> bendPoints) {
            this.bendPoints.clear();
            this.bendPoints.addAll(bendPoints);
            return this;
        }

        public Builder addBendPoint(Position bendPoint) {
            this.bendPoints.add(bendPoint);
            return this;
        }

        public Builder swapManager(FlowFileSwapManager swapManager) {
            this.swapManager = swapManager;
            return this;
        }

        public Builder eventReporter(EventReporter eventReporter) {
            this.eventReporter = eventReporter;
            return this;
        }

        public Builder flowFileRepository(FlowFileRepository flowFileRepository) {
            this.flowFileRepository = flowFileRepository;
            return this;
        }

        public Builder provenanceRepository(ProvenanceEventRepository provenanceRepository) {
            this.provenanceRepository = provenanceRepository;
            return this;
        }

        public Builder resourceClaimManager(ResourceClaimManager resourceClaimManager) {
            this.resourceClaimManager = resourceClaimManager;
            return this;
        }

        public StandardConnection build() {
            if (this.source == null) {
                throw new IllegalStateException("Cannot build a Connection without a Source");
            }
            if (this.destination == null) {
                throw new IllegalStateException("Cannot build a Connection without a Destination");
            }
            if (this.swapManager == null) {
                throw new IllegalStateException("Cannot build a Connection without a FlowFileSwapManager");
            }
            if (this.flowFileRepository == null) {
                throw new IllegalStateException("Cannot build a Connection without a FlowFile Repository");
            }
            if (this.provenanceRepository == null) {
                throw new IllegalStateException("Cannot build a Connection without a Provenance Repository");
            }
            if (this.resourceClaimManager == null) {
                throw new IllegalStateException("Cannot build a Connection without a Resource Claim Manager");
            }
            if (this.relationships == null) {
                this.relationships = new ArrayList<Relationship>();
            }
            if (this.relationships.isEmpty()) {
                if (this.source.getConnectableType() == ConnectableType.PROCESSOR) {
                    throw new IllegalStateException("Cannot build a Connection without any relationships");
                }
                this.relationships.add(Relationship.ANONYMOUS);
            }
            return new StandardConnection(this);
        }
    }
}

