/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import com.sun.jersey.api.client.ClientHandlerException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLContext;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.action.Action;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnRemoved;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.notification.OnPrimaryNodeStateChange;
import org.apache.nifi.annotation.notification.PrimaryNodeState;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.Resource;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.DataAuthorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.cluster.HeartbeatPayload;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.heartbeat.HeartbeatMonitor;
import org.apache.nifi.cluster.coordination.node.DisconnectionCode;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.coordination.node.NodeConnectionStatus;
import org.apache.nifi.cluster.protocol.DataFlow;
import org.apache.nifi.cluster.protocol.Heartbeat;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.cluster.protocol.NodeProtocolSender;
import org.apache.nifi.cluster.protocol.UnknownServiceAddressException;
import org.apache.nifi.cluster.protocol.message.HeartbeatMessage;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManagerProvider;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.ConnectableType;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Funnel;
import org.apache.nifi.connectable.LocalPort;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.connectable.Size;
import org.apache.nifi.connectable.StandardConnection;
import org.apache.nifi.controller.ClusterCoordinatorNodeInformant;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ContentAvailability;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.Counter;
import org.apache.nifi.controller.EventDrivenWorkerQueue;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.controller.ProcessScheduler;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.SnippetManager;
import org.apache.nifi.controller.StandardFunnel;
import org.apache.nifi.controller.StandardProcessorNode;
import org.apache.nifi.controller.UninheritableFlowException;
import org.apache.nifi.controller.ValidationContextFactory;
import org.apache.nifi.controller.cluster.ClusterProtocolHeartbeater;
import org.apache.nifi.controller.cluster.Heartbeater;
import org.apache.nifi.controller.exception.CommunicationsException;
import org.apache.nifi.controller.exception.ComponentLifeCycleException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.controller.label.Label;
import org.apache.nifi.controller.label.StandardLabel;
import org.apache.nifi.controller.leader.election.CuratorLeaderElectionManager;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.leader.election.LeaderElectionStateChangeListener;
import org.apache.nifi.controller.queue.FlowFileQueue;
import org.apache.nifi.controller.queue.QueueSize;
import org.apache.nifi.controller.reporting.ReportingTaskInstantiationException;
import org.apache.nifi.controller.reporting.ReportingTaskProvider;
import org.apache.nifi.controller.reporting.StandardReportingInitializationContext;
import org.apache.nifi.controller.reporting.StandardReportingTaskNode;
import org.apache.nifi.controller.repository.ContentRepository;
import org.apache.nifi.controller.repository.CounterRepository;
import org.apache.nifi.controller.repository.FlowFileEvent;
import org.apache.nifi.controller.repository.FlowFileEventRepository;
import org.apache.nifi.controller.repository.FlowFileRecord;
import org.apache.nifi.controller.repository.FlowFileRepository;
import org.apache.nifi.controller.repository.FlowFileSwapManager;
import org.apache.nifi.controller.repository.QueueProvider;
import org.apache.nifi.controller.repository.RepositoryStatusReport;
import org.apache.nifi.controller.repository.StandardCounterRepository;
import org.apache.nifi.controller.repository.StandardFlowFileRecord;
import org.apache.nifi.controller.repository.StandardRepositoryRecord;
import org.apache.nifi.controller.repository.SwapManagerInitializationContext;
import org.apache.nifi.controller.repository.SwapSummary;
import org.apache.nifi.controller.repository.claim.ContentClaim;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.controller.repository.claim.ResourceClaim;
import org.apache.nifi.controller.repository.claim.ResourceClaimManager;
import org.apache.nifi.controller.repository.claim.StandardContentClaim;
import org.apache.nifi.controller.repository.claim.StandardResourceClaim;
import org.apache.nifi.controller.repository.claim.StandardResourceClaimManager;
import org.apache.nifi.controller.repository.io.LimitedInputStream;
import org.apache.nifi.controller.scheduling.EventDrivenSchedulingAgent;
import org.apache.nifi.controller.scheduling.ProcessContextFactory;
import org.apache.nifi.controller.scheduling.QuartzSchedulingAgent;
import org.apache.nifi.controller.scheduling.StandardProcessScheduler;
import org.apache.nifi.controller.scheduling.TimerDrivenSchedulingAgent;
import org.apache.nifi.controller.serialization.FlowSerializationException;
import org.apache.nifi.controller.serialization.FlowSerializer;
import org.apache.nifi.controller.serialization.FlowSynchronizationException;
import org.apache.nifi.controller.serialization.FlowSynchronizer;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.StandardConfigurationContext;
import org.apache.nifi.controller.service.StandardControllerServiceProvider;
import org.apache.nifi.controller.state.manager.StandardStateManagerProvider;
import org.apache.nifi.controller.state.server.ZooKeeperStateServer;
import org.apache.nifi.controller.status.ConnectionStatus;
import org.apache.nifi.controller.status.PortStatus;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;
import org.apache.nifi.controller.status.RemoteProcessGroupStatus;
import org.apache.nifi.controller.status.RunStatus;
import org.apache.nifi.controller.status.TransmissionStatus;
import org.apache.nifi.controller.status.history.ComponentStatusRepository;
import org.apache.nifi.controller.status.history.StatusHistoryUtil;
import org.apache.nifi.controller.tasks.ExpireFlowFiles;
import org.apache.nifi.diagnostics.SystemDiagnostics;
import org.apache.nifi.diagnostics.SystemDiagnosticsFactory;
import org.apache.nifi.encrypt.StringEncryptor;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.events.BulletinFactory;
import org.apache.nifi.events.EventReporter;
import org.apache.nifi.flowfile.FlowFilePrioritizer;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.framework.security.util.SslContextFactory;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.groups.RemoteProcessGroupPortDescriptor;
import org.apache.nifi.groups.StandardProcessGroup;
import org.apache.nifi.history.History;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.logging.ControllerServiceLogObserver;
import org.apache.nifi.logging.LogLevel;
import org.apache.nifi.logging.LogObserver;
import org.apache.nifi.logging.LogRepository;
import org.apache.nifi.logging.LogRepositoryFactory;
import org.apache.nifi.logging.ProcessorLogObserver;
import org.apache.nifi.logging.ReportingTaskLogObserver;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.nar.NarThreadContextClassLoader;
import org.apache.nifi.processor.GhostProcessor;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.SimpleProcessLogger;
import org.apache.nifi.processor.StandardProcessorInitializationContext;
import org.apache.nifi.processor.StandardValidationContextFactory;
import org.apache.nifi.provenance.ProvenanceAuthorizableFactory;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.ProvenanceEventRepository;
import org.apache.nifi.provenance.ProvenanceEventType;
import org.apache.nifi.provenance.ProvenanceRepository;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.remote.HttpRemoteSiteListener;
import org.apache.nifi.remote.RemoteGroupPort;
import org.apache.nifi.remote.RemoteResourceManager;
import org.apache.nifi.remote.RemoteSiteListener;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.remote.SocketRemoteSiteListener;
import org.apache.nifi.remote.StandardRemoteProcessGroup;
import org.apache.nifi.remote.StandardRemoteProcessGroupPortDescriptor;
import org.apache.nifi.remote.StandardRootGroupPort;
import org.apache.nifi.remote.TransferDirection;
import org.apache.nifi.remote.cluster.NodeInformant;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.remote.protocol.socket.SocketFlowFileServerProtocol;
import org.apache.nifi.reporting.Bulletin;
import org.apache.nifi.reporting.BulletinRepository;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.GhostReportingTask;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.reporting.Severity;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.stream.io.LimitingInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.ComponentIdGenerator;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.ReflectionUtils;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowController
implements EventAccess,
ControllerServiceProvider,
ReportingTaskProvider,
QueueProvider,
Authorizable,
ProvenanceAuthorizableFactory,
NodeTypeProvider {
    public static final String DEFAULT_FLOWFILE_REPO_IMPLEMENTATION = "org.apache.nifi.controller.repository.WriteAheadFlowFileRepository";
    public static final String DEFAULT_CONTENT_REPO_IMPLEMENTATION = "org.apache.nifi.controller.repository.FileSystemRepository";
    public static final String DEFAULT_PROVENANCE_REPO_IMPLEMENTATION = "org.apache.nifi.provenance.VolatileProvenanceRepository";
    public static final String DEFAULT_SWAP_MANAGER_IMPLEMENTATION = "org.apache.nifi.controller.FileSystemSwapManager";
    public static final String DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION = "org.apache.nifi.controller.status.history.VolatileComponentStatusRepository";
    public static final String SCHEDULE_MINIMUM_NANOSECONDS = "flowcontroller.minimum.nanoseconds";
    public static final String GRACEFUL_SHUTDOWN_PERIOD = "nifi.flowcontroller.graceful.shutdown.seconds";
    public static final long DEFAULT_GRACEFUL_SHUTDOWN_SECONDS = 10L;
    public static final int METRICS_RESERVOIR_SIZE = 288;
    public static final String ROOT_GROUP_ID_ALIAS = "root";
    public static final String DEFAULT_ROOT_GROUP_NAME = "NiFi Flow";
    public static final double DEFAULT_POSITION_SCALE_FACTOR_X = 1.5;
    public static final double DEFAULT_POSITION_SCALE_FACTOR_Y = 1.34;
    private final AtomicInteger maxTimerDrivenThreads;
    private final AtomicInteger maxEventDrivenThreads;
    private final AtomicReference<FlowEngine> timerDrivenEngineRef;
    private final AtomicReference<FlowEngine> eventDrivenEngineRef;
    private final ContentRepository contentRepository;
    private final FlowFileRepository flowFileRepository;
    private final FlowFileEventRepository flowFileEventRepository;
    private final ProvenanceRepository provenanceRepository;
    private final BulletinRepository bulletinRepository;
    private final StandardProcessScheduler processScheduler;
    private final SnippetManager snippetManager;
    private final long gracefulShutdownSeconds;
    private final ExtensionManager extensionManager;
    private final NiFiProperties properties;
    private final SSLContext sslContext;
    private final Set<RemoteSiteListener> externalSiteListeners = new HashSet<RemoteSiteListener>();
    private final AtomicReference<CounterRepository> counterRepositoryRef;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final StandardControllerServiceProvider controllerServiceProvider;
    private final Authorizer authorizer;
    private final AuditService auditService;
    private final EventDrivenWorkerQueue eventDrivenWorkerQueue;
    private final ComponentStatusRepository componentStatusRepository;
    private final StateManagerProvider stateManagerProvider;
    private final long systemStartTime = System.currentTimeMillis();
    private final ConcurrentMap<String, ReportingTaskNode> reportingTasks = new ConcurrentHashMap<String, ReportingTaskNode>();
    private final VariableRegistry variableRegistry;
    private final ConcurrentMap<String, ControllerServiceNode> rootControllerServices = new ConcurrentHashMap<String, ControllerServiceNode>();
    private volatile ZooKeeperStateServer zooKeeperStateServer;
    private final AtomicReference<HeartbeatBean> heartbeatBeanRef = new AtomicReference();
    private final AtomicBoolean heartbeatsSuspended = new AtomicBoolean(false);
    private final Integer remoteInputSocketPort;
    private final Integer remoteInputHttpPort;
    private final Boolean isSiteToSiteSecure;
    private final AtomicReference<ProcessGroup> rootGroupRef = new AtomicReference();
    private final List<Connectable> startConnectablesAfterInitialization;
    private final List<RemoteGroupPort> startRemoteGroupPortsAfterInitialization;
    private final LeaderElectionManager leaderElectionManager;
    private final ClusterCoordinator clusterCoordinator;
    private final boolean configuredForClustering;
    private final int heartbeatDelaySeconds;
    private final StringEncryptor encryptor;
    private final ScheduledExecutorService clusterTaskExecutor = new FlowEngine(3, "Clustering Tasks", true);
    private final ResourceClaimManager resourceClaimManager = new StandardResourceClaimManager();
    private ScheduledFuture<?> heartbeatSenderFuture;
    private final Heartbeater heartbeater;
    private final HeartbeatMonitor heartbeatMonitor;
    private final AtomicReference<HeartbeatSendTask> heartbeatSendTask = new AtomicReference<Object>(null);
    private volatile NodeIdentifier nodeId;
    private boolean clustered;
    private NodeConnectionStatus connectionStatus;
    private String instanceId;
    private volatile boolean shutdown = false;
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private static final Logger LOG = LoggerFactory.getLogger(FlowController.class);
    private static final Logger heartbeatLogger = LoggerFactory.getLogger((String)"org.apache.nifi.cluster.heartbeat");

    public static FlowController createStandaloneInstance(FlowFileEventRepository flowFileEventRepo, NiFiProperties properties, Authorizer authorizer, AuditService auditService, StringEncryptor encryptor, BulletinRepository bulletinRepo, VariableRegistry variableRegistry) {
        return new FlowController(flowFileEventRepo, properties, authorizer, auditService, encryptor, false, null, bulletinRepo, null, null, variableRegistry);
    }

    public static FlowController createClusteredInstance(FlowFileEventRepository flowFileEventRepo, NiFiProperties properties, Authorizer authorizer, AuditService auditService, StringEncryptor encryptor, NodeProtocolSender protocolSender, BulletinRepository bulletinRepo, ClusterCoordinator clusterCoordinator, HeartbeatMonitor heartbeatMonitor, VariableRegistry variableRegistry) {
        FlowController flowController = new FlowController(flowFileEventRepo, properties, authorizer, auditService, encryptor, true, protocolSender, bulletinRepo, clusterCoordinator, heartbeatMonitor, variableRegistry);
        return flowController;
    }

    private FlowController(FlowFileEventRepository flowFileEventRepo, NiFiProperties properties, Authorizer authorizer, AuditService auditService, StringEncryptor encryptor, boolean configuredForClustering, NodeProtocolSender protocolSender, BulletinRepository bulletinRepo, ClusterCoordinator clusterCoordinator, HeartbeatMonitor heartbeatMonitor, VariableRegistry variableRegistry) {
        long snapshotMillis;
        long shutdownSecs;
        FlowFileRepository flowFileRepo;
        this.maxTimerDrivenThreads = new AtomicInteger(10);
        this.maxEventDrivenThreads = new AtomicInteger(5);
        this.encryptor = encryptor;
        this.properties = properties;
        this.heartbeatMonitor = heartbeatMonitor;
        this.sslContext = SslContextFactory.createSslContext((NiFiProperties)properties, (boolean)false);
        this.extensionManager = new ExtensionManager();
        this.clusterCoordinator = clusterCoordinator;
        this.timerDrivenEngineRef = new AtomicReference<FlowEngine>(new FlowEngine(this.maxTimerDrivenThreads.get(), "Timer-Driven Process"));
        this.eventDrivenEngineRef = new AtomicReference<FlowEngine>(new FlowEngine(this.maxEventDrivenThreads.get(), "Event-Driven Process"));
        this.flowFileRepository = flowFileRepo = FlowController.createFlowFileRepository(properties, this.resourceClaimManager);
        this.flowFileEventRepository = flowFileEventRepo;
        this.counterRepositoryRef = new AtomicReference<StandardCounterRepository>(new StandardCounterRepository());
        this.bulletinRepository = bulletinRepo;
        this.variableRegistry = variableRegistry == null ? VariableRegistry.EMPTY_REGISTRY : variableRegistry;
        try {
            this.provenanceRepository = this.createProvenanceRepository(properties);
            this.provenanceRepository.initialize(FlowController.createEventReporter(this.bulletinRepository), authorizer, (ProvenanceAuthorizableFactory)this);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Provenance Repository", e);
        }
        try {
            this.contentRepository = this.createContentRepository(properties);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create Content Repository", e);
        }
        try {
            this.stateManagerProvider = StandardStateManagerProvider.create(properties, this.variableRegistry);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.processScheduler = new StandardProcessScheduler(this, encryptor, this.stateManagerProvider, this.variableRegistry);
        this.eventDrivenWorkerQueue = new EventDrivenWorkerQueue(false, false, this.processScheduler);
        ProcessContextFactory contextFactory = new ProcessContextFactory(this.contentRepository, this.flowFileRepository, this.flowFileEventRepository, this.counterRepositoryRef.get(), (ProvenanceEventRepository)this.provenanceRepository);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.EVENT_DRIVEN, new EventDrivenSchedulingAgent(this.eventDrivenEngineRef.get(), this, this.stateManagerProvider, this.eventDrivenWorkerQueue, contextFactory, this.maxEventDrivenThreads.get(), encryptor, this.variableRegistry));
        QuartzSchedulingAgent quartzSchedulingAgent = new QuartzSchedulingAgent(this, this.timerDrivenEngineRef.get(), contextFactory, encryptor, this.variableRegistry);
        TimerDrivenSchedulingAgent timerDrivenAgent = new TimerDrivenSchedulingAgent(this, this.timerDrivenEngineRef.get(), contextFactory, encryptor, this.variableRegistry);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.TIMER_DRIVEN, timerDrivenAgent);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.PRIMARY_NODE_ONLY, timerDrivenAgent);
        this.processScheduler.setSchedulingAgent(SchedulingStrategy.CRON_DRIVEN, quartzSchedulingAgent);
        this.processScheduler.scheduleFrameworkTask(new ExpireFlowFiles(this, contextFactory), "Expire FlowFiles", 30L, 30L, TimeUnit.SECONDS);
        this.startConnectablesAfterInitialization = new ArrayList<Connectable>();
        this.startRemoteGroupPortsAfterInitialization = new ArrayList<RemoteGroupPort>();
        this.authorizer = authorizer;
        this.auditService = auditService;
        String gracefulShutdownSecondsVal = properties.getProperty(GRACEFUL_SHUTDOWN_PERIOD);
        try {
            shutdownSecs = Long.parseLong(gracefulShutdownSecondsVal);
            if (shutdownSecs < 1L) {
                shutdownSecs = 10L;
            }
        }
        catch (NumberFormatException nfe) {
            shutdownSecs = 10L;
        }
        this.gracefulShutdownSeconds = shutdownSecs;
        this.remoteInputSocketPort = properties.getRemoteInputPort();
        this.remoteInputHttpPort = properties.getRemoteInputHttpPort();
        this.isSiteToSiteSecure = properties.isSiteToSiteSecure();
        if (this.isSiteToSiteSecure.booleanValue() && this.sslContext == null && this.remoteInputSocketPort != null) {
            throw new IllegalStateException("NiFi Configured to allow Secure Site-to-Site communications but the Keystore/Truststore properties are not configured");
        }
        this.configuredForClustering = configuredForClustering;
        this.heartbeatDelaySeconds = (int)FormatUtils.getTimeDuration((String)properties.getNodeHeartbeatInterval(), (TimeUnit)TimeUnit.SECONDS);
        this.snippetManager = new SnippetManager();
        StandardProcessGroup rootGroup = new StandardProcessGroup(ComponentIdGenerator.generateId().toString(), this, this.processScheduler, properties, encryptor, this, this.variableRegistry);
        rootGroup.setName(DEFAULT_ROOT_GROUP_NAME);
        this.rootGroupRef.set(rootGroup);
        this.instanceId = ComponentIdGenerator.generateId().toString();
        this.controllerServiceProvider = new StandardControllerServiceProvider(this, this.processScheduler, this.bulletinRepository, this.stateManagerProvider, this.variableRegistry);
        if (this.remoteInputSocketPort == null) {
            LOG.info("Not enabling RAW Socket Site-to-Site functionality because nifi.remote.input.socket.port is not set");
        } else if (this.isSiteToSiteSecure.booleanValue() && this.sslContext == null) {
            LOG.error("Unable to create Secure Site-to-Site Listener because not all required Keystore/Truststore Properties are set. Site-to-Site functionality will be disabled until this problem is has been fixed.");
        } else {
            RemoteResourceManager.setServerProtocolImplementation((String)"SocketFlowFileProtocol", SocketFlowFileServerProtocol.class);
            ClusterCoordinatorNodeInformant nodeInformant = configuredForClustering ? new ClusterCoordinatorNodeInformant(clusterCoordinator) : null;
            this.externalSiteListeners.add((RemoteSiteListener)new SocketRemoteSiteListener(this.remoteInputSocketPort.intValue(), this.isSiteToSiteSecure != false ? this.sslContext : null, (NodeInformant)nodeInformant));
        }
        if (this.remoteInputHttpPort == null) {
            LOG.info("Not enabling HTTP(S) Site-to-Site functionality because the 'nifi.remote.input.http.enabled' property is not true");
        } else {
            this.externalSiteListeners.add((RemoteSiteListener)HttpRemoteSiteListener.getInstance());
        }
        for (RemoteSiteListener listener : this.externalSiteListeners) {
            listener.setRootGroup((ProcessGroup)rootGroup);
        }
        String snapshotFrequency = properties.getProperty("nifi.components.status.snapshot.frequency", "5 mins");
        try {
            snapshotMillis = FormatUtils.getTimeDuration((String)snapshotFrequency, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            snapshotMillis = FormatUtils.getTimeDuration((String)"5 mins", (TimeUnit)TimeUnit.MILLISECONDS);
        }
        if (properties.isStartEmbeddedZooKeeper() && configuredForClustering) {
            try {
                this.zooKeeperStateServer = ZooKeeperStateServer.create(properties);
                this.zooKeeperStateServer.start();
            }
            catch (IOException | QuorumPeerConfig.ConfigException e) {
                throw new IllegalStateException("Unable to initailize Flow because NiFi was configured to start an Embedded Zookeeper server but failed to do so", e);
            }
        } else {
            this.zooKeeperStateServer = null;
        }
        this.componentStatusRepository = this.createComponentStatusRepository();
        this.timerDrivenEngineRef.get().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                FlowController.this.componentStatusRepository.capture(FlowController.this.getControllerStatus());
            }
        }, snapshotMillis, snapshotMillis, TimeUnit.MILLISECONDS);
        this.connectionStatus = new NodeConnectionStatus(this.nodeId, DisconnectionCode.NOT_YET_CONNECTED);
        this.heartbeatBeanRef.set(new HeartbeatBean(rootGroup, false));
        if (configuredForClustering) {
            this.leaderElectionManager = new CuratorLeaderElectionManager(4);
            this.heartbeater = new ClusterProtocolHeartbeater(protocolSender, (Properties)properties);
            LOG.info("Checking if there is already a Cluster Coordinator Elected...");
            NodeIdentifier electedCoordinatorNodeId = clusterCoordinator.getElectedActiveCoordinatorNode();
            if (electedCoordinatorNodeId == null) {
                LOG.info("It appears that no Cluster Coordinator has been Elected yet. Registering for Cluster Coordinator Role.");
                this.registerForClusterCoordinator();
            } else {
                LOG.info("The Elected Cluster Coordinator is {}. Will not register to be elected for this role until after connecting to the cluster and inheriting the cluster's flow.", (Object)electedCoordinatorNodeId);
            }
            this.leaderElectionManager.start();
        } else {
            this.leaderElectionManager = null;
            this.heartbeater = null;
        }
    }

    public Authorizable getParentAuthorizable() {
        return null;
    }

    public Resource getResource() {
        return ResourceFactory.getControllerResource();
    }

    public HeartbeatMonitor getHeartbeatMonitor() {
        return this.heartbeatMonitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FlowFileRepository createFlowFileRepository(NiFiProperties properties, ResourceClaimManager contentClaimManager) {
        String implementationClassName = properties.getProperty("nifi.flowfile.repository.implementation", DEFAULT_FLOWFILE_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create FlowFile Repository because the NiFi Properties is missing the following property: nifi.flowfile.repository.implementation");
        }
        try {
            FlowFileRepository created;
            FlowFileRepository flowFileRepository = created = (FlowFileRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, FlowFileRepository.class);
            synchronized (flowFileRepository) {
                created.initialize(contentClaimManager);
            }
            return created;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static FlowFileSwapManager createSwapManager(NiFiProperties properties) {
        String implementationClassName = properties.getProperty("nifi.swap.manager.implementation", DEFAULT_SWAP_MANAGER_IMPLEMENTATION);
        if (implementationClassName == null) {
            return null;
        }
        try {
            return (FlowFileSwapManager)NarThreadContextClassLoader.createInstance((String)implementationClassName, FlowFileSwapManager.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static EventReporter createEventReporter(final BulletinRepository bulletinRepository) {
        return new EventReporter(){
            private static final long serialVersionUID = 1L;

            public void reportEvent(Severity severity, String category, String message) {
                Bulletin bulletin = BulletinFactory.createBulletin((String)category, (String)severity.name(), (String)message);
                bulletinRepository.addBulletin(bulletin);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeFlow() throws IOException {
        this.writeLock.lock();
        try {
            FlowFileQueue queue;
            List connections = this.getGroup(this.getRootGroupId()).findAllConnections();
            long maxIdFromSwapFiles = -1L;
            if (this.flowFileRepository.isVolatile()) {
                for (Connection connection : connections) {
                    queue = connection.getFlowFileQueue();
                    queue.purgeSwapFiles();
                }
            } else {
                for (Connection connection : connections) {
                    queue = connection.getFlowFileQueue();
                    SwapSummary swapSummary = queue.recoverSwappedFlowFiles();
                    if (swapSummary == null) continue;
                    Long maxFlowFileId = swapSummary.getMaxFlowFileId();
                    if (maxFlowFileId != null && maxFlowFileId > maxIdFromSwapFiles) {
                        maxIdFromSwapFiles = maxFlowFileId;
                    }
                    for (ResourceClaim resourceClaim : swapSummary.getResourceClaims()) {
                        this.resourceClaimManager.incrementClaimantCount(resourceClaim);
                    }
                }
            }
            this.flowFileRepository.loadFlowFiles((QueueProvider)this, maxIdFromSwapFiles + 1L);
            this.contentRepository.cleanup();
            for (RemoteSiteListener listener : this.externalSiteListeners) {
                listener.start();
            }
            this.notifyComponentsConfigurationRestored();
            this.timerDrivenEngineRef.get().scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            FlowController.this.updateRemoteProcessGroups();
                        }
                        catch (Throwable t) {
                            LOG.warn("Unable to update Remote Process Groups due to " + t);
                            if (!LOG.isDebugEnabled()) break block2;
                            LOG.warn("", t);
                        }
                    }
                }
            }, 0L, 30L, TimeUnit.SECONDS);
            this.initialized.set(true);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void notifyComponentsConfigurationRestored() {
        Throwable throwable;
        NarCloseable nc;
        for (ProcessorNode procNode : this.getGroup(this.getRootGroupId()).findAllProcessors()) {
            Processor processor = procNode.getProcessor();
            nc = NarCloseable.withNarLoader();
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)processor, new Object[0]);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (nc == null) continue;
                if (throwable != null) {
                    try {
                        nc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                nc.close();
            }
        }
        for (ControllerServiceNode serviceNode : this.getAllControllerServices()) {
            ControllerService service = serviceNode.getControllerServiceImplementation();
            nc = NarCloseable.withNarLoader();
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)service, new Object[0]);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (nc == null) continue;
                if (throwable != null) {
                    try {
                        nc.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                nc.close();
            }
        }
        for (ReportingTaskNode taskNode : this.getAllReportingTasks()) {
            ReportingTask task = taskNode.getReportingTask();
            nc = NarCloseable.withNarLoader();
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)task, new Object[0]);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (nc == null) continue;
                if (throwable != null) {
                    try {
                        nc.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    continue;
                }
                nc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFlowInitialized(boolean startDelayedComponents) {
        this.writeLock.lock();
        try {
            if (startDelayedComponents) {
                LOG.info("Starting {} processors/ports/funnels", (Object)(this.startConnectablesAfterInitialization.size() + this.startRemoteGroupPortsAfterInitialization.size()));
                for (Connectable connectable : this.startConnectablesAfterInitialization) {
                    if (connectable.getScheduledState() == ScheduledState.DISABLED) continue;
                    try {
                        if (connectable instanceof ProcessorNode) {
                            connectable.getProcessGroup().startProcessor((ProcessorNode)connectable);
                            continue;
                        }
                        this.startConnectable(connectable);
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start {} due to {}", new Object[]{connectable, t.toString()});
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.error("", t);
                    }
                }
                this.startConnectablesAfterInitialization.clear();
                int startedTransmitting = 0;
                for (RemoteGroupPort remoteGroupPort : this.startRemoteGroupPortsAfterInitialization) {
                    try {
                        remoteGroupPort.getRemoteProcessGroup().startTransmitting(remoteGroupPort);
                        ++startedTransmitting;
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start transmitting with {} due to {}", new Object[]{remoteGroupPort, t});
                    }
                }
                LOG.info("Started {} Remote Group Ports transmitting", (Object)startedTransmitting);
                this.startRemoteGroupPortsAfterInitialization.clear();
            } else {
                for (Connectable connectable : this.startConnectablesAfterInitialization) {
                    try {
                        if (!(connectable instanceof Funnel)) continue;
                        this.startConnectable(connectable);
                    }
                    catch (Throwable t) {
                        LOG.error("Unable to start {} due to {}", new Object[]{connectable, t});
                    }
                }
                this.startConnectablesAfterInitialization.clear();
                this.startRemoteGroupPortsAfterInitialization.clear();
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContentRepository createContentRepository(NiFiProperties properties) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String implementationClassName = properties.getProperty("nifi.content.repository.implementation", DEFAULT_CONTENT_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Content Repository because the NiFi Properties is missing the following property: nifi.content.repository.implementation");
        }
        try {
            ContentRepository contentRepo;
            ContentRepository contentRepository = contentRepo = (ContentRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, ContentRepository.class);
            synchronized (contentRepository) {
                contentRepo.initialize(this.resourceClaimManager);
            }
            return contentRepo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ProvenanceRepository createProvenanceRepository(NiFiProperties properties) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        String implementationClassName = properties.getProperty("nifi.provenance.repository.implementation", DEFAULT_PROVENANCE_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Provenance Repository because the NiFi Properties is missing the following property: nifi.provenance.repository.implementation");
        }
        try {
            return (ProvenanceRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, ProvenanceRepository.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ComponentStatusRepository createComponentStatusRepository() {
        String implementationClassName = this.properties.getProperty("nifi.components.status.repository.implementation", DEFAULT_COMPONENT_STATUS_REPO_IMPLEMENTATION);
        if (implementationClassName == null) {
            throw new RuntimeException("Cannot create Component Status Repository because the NiFi Properties is missing the following property: nifi.components.status.repository.implementation");
        }
        try {
            return (ComponentStatusRepository)NarThreadContextClassLoader.createInstance((String)implementationClassName, ComponentStatusRepository.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Connection createConnection(String id, String name, Connectable source, Connectable destination, Collection<String> relationshipNames) {
        StandardConnection.Builder builder = new StandardConnection.Builder(this.processScheduler);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        for (String relationshipName : Objects.requireNonNull(relationshipNames)) {
            relationships.add(new Relationship.Builder().name(relationshipName).build());
        }
        FlowFileSwapManager swapManager = FlowController.createSwapManager(this.properties);
        final EventReporter eventReporter = FlowController.createEventReporter(this.getBulletinRepository());
        try (NarCloseable narCloseable = NarCloseable.withNarLoader();){
            SwapManagerInitializationContext initializationContext = new SwapManagerInitializationContext(){

                public ResourceClaimManager getResourceClaimManager() {
                    return FlowController.this.resourceClaimManager;
                }

                public FlowFileRepository getFlowFileRepository() {
                    return FlowController.this.flowFileRepository;
                }

                public EventReporter getEventReporter() {
                    return eventReporter;
                }
            };
            swapManager.initialize(initializationContext);
        }
        return builder.id(Objects.requireNonNull(id).intern()).name(name == null ? null : name.intern()).relationships(relationships).source(Objects.requireNonNull(source)).destination(destination).swapManager(swapManager).eventReporter(eventReporter).resourceClaimManager(this.resourceClaimManager).flowFileRepository(this.flowFileRepository).provenanceRepository((ProvenanceEventRepository)this.provenanceRepository).build();
    }

    public Label createLabel(String id, String text) {
        return new StandardLabel(Objects.requireNonNull(id).intern(), text);
    }

    public Funnel createFunnel(String id) {
        return new StandardFunnel(id.intern(), null, (ProcessScheduler)this.processScheduler);
    }

    public Port createLocalInputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new LocalPort(id, name, null, ConnectableType.INPUT_PORT, this.processScheduler);
    }

    public Port createLocalOutputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new LocalPort(id, name, null, ConnectableType.OUTPUT_PORT, this.processScheduler);
    }

    public ProcessGroup createProcessGroup(String id) {
        return new StandardProcessGroup(Objects.requireNonNull(id).intern(), this, this.processScheduler, this.properties, this.encryptor, this, this.variableRegistry);
    }

    public ProcessorNode createProcessor(String type, String id) throws ProcessorInstantiationException {
        return this.createProcessor(type, id, true);
    }

    public ProcessorNode createProcessor(String type, String id, boolean firstTimeAdded) throws ProcessorInstantiationException {
        StandardProcessorNode procNode;
        boolean creationSuccessful;
        Processor processor;
        id = id.intern();
        try {
            processor = this.instantiateProcessor(type, id);
            creationSuccessful = true;
        }
        catch (ProcessorInstantiationException pie) {
            LOG.error("Could not create Processor of type " + type + " for ID " + id + "; creating \"Ghost\" implementation", (Throwable)pie);
            GhostProcessor ghostProc = new GhostProcessor();
            ghostProc.setIdentifier(id);
            ghostProc.setCanonicalClassName(type);
            processor = ghostProc;
            creationSuccessful = false;
        }
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.controllerServiceProvider, this.variableRegistry);
        if (creationSuccessful) {
            procNode = new StandardProcessorNode(processor, id, validationContextFactory, this.processScheduler, this.controllerServiceProvider);
        } else {
            String simpleClassName = type.contains(".") ? StringUtils.substringAfterLast((String)type, (String)".") : type;
            String componentType = "(Missing) " + simpleClassName;
            procNode = new StandardProcessorNode(processor, id, validationContextFactory, this.processScheduler, this.controllerServiceProvider, componentType, type);
        }
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ProcessorLogObserver(this.getBulletinRepository(), procNode));
        if (firstTimeAdded) {
            Throwable throwable;
            try {
                throwable = null;
                try (NarCloseable x = NarCloseable.withNarLoader();){
                    ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, processor, new Object[0]);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                logRepository.removeObserver("bulletin-observer");
                throw new ComponentLifeCycleException("Failed to invoke @OnAdded methods of " + procNode.getProcessor(), (Throwable)e);
            }
            if (firstTimeAdded) {
                throwable = null;
                try (NarCloseable nc = NarCloseable.withNarLoader();){
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)procNode.getProcessor(), new Object[0]);
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
        return procNode;
    }

    private Processor instantiateProcessor(String type, String identifier) throws ProcessorInstantiationException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader detectedClassLoaderForType = ExtensionManager.getClassLoader((String)type);
            Class<?> rawClass = detectedClassLoaderForType == null ? Class.forName(type) : Class.forName(type, true, ExtensionManager.getClassLoader((String)type));
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<Processor> processorClass = rawClass.asSubclass(Processor.class);
            Processor processor = processorClass.newInstance();
            SimpleProcessLogger componentLogger = new SimpleProcessLogger(identifier, processor);
            StandardProcessorInitializationContext ctx = new StandardProcessorInitializationContext(identifier, componentLogger, this, this);
            processor.initialize((ProcessorInitializationContext)ctx);
            LogRepositoryFactory.getRepository((String)identifier).setLogger((ComponentLog)componentLogger);
            Processor processor2 = processor;
            return processor2;
        }
        catch (Throwable t) {
            throw new ProcessorInstantiationException(type, t);
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    public String getInstanceId() {
        this.readLock.lock();
        try {
            String string = this.instanceId;
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public Heartbeater getHeartbeater() {
        return this.heartbeater;
    }

    public BulletinRepository getBulletinRepository() {
        return this.bulletinRepository;
    }

    public SnippetManager getSnippetManager() {
        return this.snippetManager;
    }

    public StateManagerProvider getStateManagerProvider() {
        return this.stateManagerProvider;
    }

    public Authorizer getAuthorizer() {
        return this.authorizer;
    }

    public Port createRemoteInputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new StandardRootGroupPort(id, name, null, TransferDirection.RECEIVE, ConnectableType.INPUT_PORT, this.authorizer, this.getBulletinRepository(), (ProcessScheduler)this.processScheduler, Boolean.TRUE.equals(this.isSiteToSiteSecure));
    }

    public Port createRemoteOutputPort(String id, String name) {
        id = Objects.requireNonNull(id).intern();
        name = Objects.requireNonNull(name).intern();
        this.verifyPortIdDoesNotExist(id);
        return new StandardRootGroupPort(id, name, null, TransferDirection.SEND, ConnectableType.OUTPUT_PORT, this.authorizer, this.getBulletinRepository(), (ProcessScheduler)this.processScheduler, Boolean.TRUE.equals(this.isSiteToSiteSecure));
    }

    public RemoteProcessGroup createRemoteProcessGroup(String id, String uri) {
        return new StandardRemoteProcessGroup(Objects.requireNonNull(id).intern(), Objects.requireNonNull(uri).intern(), null, this, this.sslContext);
    }

    public ProcessGroup getRootGroup() {
        return this.rootGroupRef.get();
    }

    private void verifyPortIdDoesNotExist(String id) {
        ProcessGroup rootGroup = this.getRootGroup();
        Port port = rootGroup.findOutputPort(id);
        if (port != null) {
            throw new IllegalStateException("An Input Port already exists with ID " + id);
        }
        port = rootGroup.findInputPort(id);
        if (port != null) {
            throw new IllegalStateException("An Input Port already exists with ID " + id);
        }
    }

    public String getName() {
        return this.getRootGroup().getName();
    }

    public void setName(String name) {
        this.getRootGroup().setName(name);
    }

    public String getComments() {
        return this.getRootGroup().getComments();
    }

    public void setComments(String comments) {
        this.getRootGroup().setComments(comments);
    }

    public boolean isTerminated() {
        this.readLock.lock();
        try {
            boolean bl = null == this.timerDrivenEngineRef.get() || this.timerDrivenEngineRef.get().isTerminated();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean kill) {
        this.shutdown = true;
        this.stopAllProcessors();
        this.readLock.lock();
        try {
            if (this.isTerminated() || this.timerDrivenEngineRef.get().isTerminating()) {
                throw new IllegalStateException("Controller already stopped or still stopping...");
            }
            if (this.leaderElectionManager != null) {
                this.leaderElectionManager.stop();
            }
            if (kill) {
                this.timerDrivenEngineRef.get().shutdownNow();
                this.eventDrivenEngineRef.get().shutdownNow();
                LOG.info("Initiated immediate shutdown of flow controller...");
            } else {
                this.timerDrivenEngineRef.get().shutdown();
                this.eventDrivenEngineRef.get().shutdown();
                LOG.info("Initiated graceful shutdown of flow controller...waiting up to " + this.gracefulShutdownSeconds + " seconds");
            }
            this.clusterTaskExecutor.shutdownNow();
            if (this.zooKeeperStateServer != null) {
                this.zooKeeperStateServer.shutdown();
            }
            this.getRootGroup().shutdown();
            this.stateManagerProvider.shutdown();
            for (ControllerServiceNode serviceNode : this.getAllControllerServices()) {
                NarCloseable narCloseable = NarCloseable.withNarLoader();
                Throwable throwable = null;
                try {
                    StandardConfigurationContext configContext = new StandardConfigurationContext((ConfiguredComponent)serviceNode, (ControllerServiceLookup)this.controllerServiceProvider, null, this.variableRegistry);
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)serviceNode.getControllerServiceImplementation(), configContext);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (narCloseable == null) continue;
                    if (throwable != null) {
                        try {
                            narCloseable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    narCloseable.close();
                }
            }
            for (ReportingTaskNode taskNode : this.getAllReportingTasks()) {
                ConfigurationContext configContext = taskNode.getConfigurationContext();
                NarCloseable narCloseable = NarCloseable.withNarLoader();
                Throwable throwable = null;
                try {
                    ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnShutdown.class, (Object)taskNode.getReportingTask(), configContext);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (narCloseable == null) continue;
                    if (throwable != null) {
                        try {
                            narCloseable.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    narCloseable.close();
                }
            }
            try {
                this.timerDrivenEngineRef.get().awaitTermination(this.gracefulShutdownSeconds / 2L, TimeUnit.SECONDS);
                this.eventDrivenEngineRef.get().awaitTermination(this.gracefulShutdownSeconds / 2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                LOG.info("Interrupted while waiting for controller termination.");
            }
            try {
                this.flowFileRepository.close();
            }
            catch (Throwable t) {
                LOG.warn("Unable to shut down FlowFileRepository due to {}", new Object[]{t});
            }
            if (this.timerDrivenEngineRef.get().isTerminated() && this.eventDrivenEngineRef.get().isTerminated()) {
                LOG.info("Controller has been terminated successfully.");
            } else {
                LOG.warn("Controller hasn't terminated properly.  There exists an uninterruptable thread that will take an indeterminate amount of time to stop.  Might need to kill the program manually.");
            }
            for (RemoteSiteListener listener : this.externalSiteListeners) {
                listener.stop();
            }
            if (this.processScheduler != null) {
                this.processScheduler.shutdown();
            }
            if (this.contentRepository != null) {
                this.contentRepository.shutdown();
            }
            if (this.provenanceRepository != null) {
                try {
                    this.provenanceRepository.close();
                }
                catch (IOException ioe) {
                    LOG.warn("There was a problem shutting down the Provenance Repository: " + ioe.toString());
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("", (Throwable)ioe);
                    }
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void serialize(FlowSerializer serializer, OutputStream os) throws FlowSerializationException {
        this.readLock.lock();
        try {
            serializer.serialize(this, os);
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void synchronize(FlowSynchronizer synchronizer, DataFlow dataFlow) throws FlowSerializationException, FlowSynchronizationException, UninheritableFlowException {
        this.writeLock.lock();
        try {
            LOG.debug("Synchronizing controller with proposed flow");
            synchronizer.sync(this, dataFlow, this.encryptor);
            LOG.info("Successfully synchronized controller with proposed flow");
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public int getMaxTimerDrivenThreadCount() {
        return this.maxTimerDrivenThreads.get();
    }

    public int getMaxEventDrivenThreadCount() {
        return this.maxEventDrivenThreads.get();
    }

    public void setMaxTimerDrivenThreadCount(int maxThreadCount) {
        this.writeLock.lock();
        try {
            this.setMaxThreadCount(maxThreadCount, this.timerDrivenEngineRef.get(), this.maxTimerDrivenThreads);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void setMaxEventDrivenThreadCount(int maxThreadCount) {
        this.writeLock.lock();
        try {
            this.setMaxThreadCount(maxThreadCount, this.eventDrivenEngineRef.get(), this.maxEventDrivenThreads);
            this.processScheduler.setMaxThreadCount(SchedulingStrategy.EVENT_DRIVEN, maxThreadCount);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void setMaxThreadCount(int maxThreadCount, FlowEngine engine, AtomicInteger maxThreads) {
        if (maxThreadCount < 1) {
            throw new IllegalArgumentException();
        }
        maxThreads.getAndSet(maxThreadCount);
        if (null != engine && engine.getCorePoolSize() < maxThreadCount) {
            engine.setCorePoolSize(maxThreads.intValue());
        }
    }

    public String getRootGroupId() {
        return this.getRootGroup().getIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRootGroup(ProcessGroup group) {
        if (Objects.requireNonNull(group).getParent() != null) {
            throw new IllegalArgumentException("A ProcessGroup that has a parent cannot be the Root Group");
        }
        this.writeLock.lock();
        try {
            this.rootGroupRef.set(group);
            for (RemoteSiteListener listener : this.externalSiteListeners) {
                listener.setRootGroup(group);
            }
            this.heartbeatBeanRef.set(new HeartbeatBean(group, this.isPrimary()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public SystemDiagnostics getSystemDiagnostics() {
        SystemDiagnosticsFactory factory = new SystemDiagnosticsFactory();
        return factory.create(this.flowFileRepository, this.contentRepository);
    }

    public void updateProcessGroup(ProcessGroupDTO dto) throws ProcessorInstantiationException {
        ProcessGroup group = this.lookupGroup(Objects.requireNonNull(dto).getId());
        String name = dto.getName();
        PositionDTO position = dto.getPosition();
        String comments = dto.getComments();
        if (name != null) {
            group.setName(name);
        }
        if (position != null) {
            group.setPosition(this.toPosition(position));
        }
        if (comments != null) {
            group.setComments(comments);
        }
    }

    private Position toPosition(PositionDTO dto) {
        return new Position(dto.getX().doubleValue(), dto.getY().doubleValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void instantiateSnippet(ProcessGroup group, FlowSnippetDTO dto) throws ProcessorInstantiationException {
        this.writeLock.lock();
        try {
            FlowSnippetDTO contents;
            this.validateSnippetContents(Objects.requireNonNull(group), dto);
            for (ControllerServiceDTO controllerServiceDTO : dto.getControllerServices()) {
                ControllerServiceNode serviceNode = this.createControllerService(controllerServiceDTO.getType(), controllerServiceDTO.getId(), true);
                serviceNode.setAnnotationData(controllerServiceDTO.getAnnotationData());
                serviceNode.setComments(controllerServiceDTO.getComments());
                serviceNode.setName(controllerServiceDTO.getName());
                group.addControllerService(serviceNode);
            }
            for (ControllerServiceDTO controllerServiceDTO : dto.getControllerServices()) {
                String serviceId = controllerServiceDTO.getId();
                ControllerServiceNode serviceNode = this.getControllerServiceNode(serviceId);
                for (Map.Entry entry : controllerServiceDTO.getProperties().entrySet()) {
                    if (entry.getValue() == null) continue;
                    serviceNode.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
            for (LabelDTO labelDTO : dto.getLabels()) {
                Label label = this.createLabel(labelDTO.getId(), labelDTO.getLabel());
                label.setPosition(this.toPosition(labelDTO.getPosition()));
                if (labelDTO.getWidth() != null && labelDTO.getHeight() != null) {
                    label.setSize(new Size(labelDTO.getWidth().doubleValue(), labelDTO.getHeight().doubleValue()));
                }
                label.setStyle(labelDTO.getStyle());
                group.addLabel(label);
            }
            for (FunnelDTO funnelDTO : dto.getFunnels()) {
                Funnel funnel = this.createFunnel(funnelDTO.getId());
                funnel.setPosition(this.toPosition(funnelDTO.getPosition()));
                group.addFunnel(funnel);
            }
            for (PortDTO portDTO : dto.getInputPorts()) {
                Port inputPort;
                if (group.isRootGroup()) {
                    inputPort = this.createRemoteInputPort(portDTO.getId(), portDTO.getName());
                    inputPort.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
                    if (portDTO.getGroupAccessControl() != null) {
                        ((RootGroupPort)inputPort).setGroupAccessControl(portDTO.getGroupAccessControl());
                    }
                    if (portDTO.getUserAccessControl() != null) {
                        ((RootGroupPort)inputPort).setUserAccessControl(portDTO.getUserAccessControl());
                    }
                } else {
                    inputPort = this.createLocalInputPort(portDTO.getId(), portDTO.getName());
                }
                inputPort.setPosition(this.toPosition(portDTO.getPosition()));
                inputPort.setProcessGroup(group);
                inputPort.setComments(portDTO.getComments());
                group.addInputPort(inputPort);
            }
            for (PortDTO portDTO : dto.getOutputPorts()) {
                Port outputPort;
                if (group.isRootGroup()) {
                    outputPort = this.createRemoteOutputPort(portDTO.getId(), portDTO.getName());
                    outputPort.setMaxConcurrentTasks(portDTO.getConcurrentlySchedulableTaskCount().intValue());
                    if (portDTO.getGroupAccessControl() != null) {
                        ((RootGroupPort)outputPort).setGroupAccessControl(portDTO.getGroupAccessControl());
                    }
                    if (portDTO.getUserAccessControl() != null) {
                        ((RootGroupPort)outputPort).setUserAccessControl(portDTO.getUserAccessControl());
                    }
                } else {
                    outputPort = this.createLocalOutputPort(portDTO.getId(), portDTO.getName());
                }
                outputPort.setPosition(this.toPosition(portDTO.getPosition()));
                outputPort.setProcessGroup(group);
                outputPort.setComments(portDTO.getComments());
                group.addOutputPort(outputPort);
            }
            for (ProcessorDTO processorDTO : dto.getProcessors()) {
                ProcessorNode procNode = this.createProcessor(processorDTO.getType(), processorDTO.getId());
                procNode.setPosition(this.toPosition(processorDTO.getPosition()));
                procNode.setProcessGroup(group);
                ProcessorConfigDTO config = processorDTO.getConfig();
                procNode.setComments(config.getComments());
                if (config.isLossTolerant() != null) {
                    procNode.setLossTolerant(config.isLossTolerant().booleanValue());
                }
                procNode.setName(processorDTO.getName());
                procNode.setYieldPeriod(config.getYieldDuration());
                procNode.setPenalizationPeriod(config.getPenaltyDuration());
                procNode.setBulletinLevel(LogLevel.valueOf((String)config.getBulletinLevel()));
                procNode.setAnnotationData(config.getAnnotationData());
                procNode.setStyle(processorDTO.getStyle());
                if (config.getRunDurationMillis() != null) {
                    procNode.setRunDuration(config.getRunDurationMillis().longValue(), TimeUnit.MILLISECONDS);
                }
                if (config.getSchedulingStrategy() != null) {
                    procNode.setSchedulingStrategy(SchedulingStrategy.valueOf((String)config.getSchedulingStrategy()));
                }
                procNode.setMaxConcurrentTasks(config.getConcurrentlySchedulableTaskCount().intValue());
                procNode.setScheduldingPeriod(config.getSchedulingPeriod());
                HashSet<Relationship> relationships = new HashSet<Relationship>();
                if (processorDTO.getRelationships() != null) {
                    for (RelationshipDTO rel : processorDTO.getRelationships()) {
                        if (!rel.isAutoTerminate().booleanValue()) continue;
                        relationships.add(procNode.getRelationship(rel.getName()));
                    }
                    procNode.setAutoTerminatedRelationships(relationships);
                }
                if (config.getProperties() != null) {
                    for (Map.Entry entry : config.getProperties().entrySet()) {
                        if (entry.getValue() == null) continue;
                        procNode.setProperty((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                group.addProcessor(procNode);
            }
            for (RemoteProcessGroupDTO remoteGroupDTO : dto.getRemoteProcessGroups()) {
                RemoteProcessGroup remoteGroup = this.createRemoteProcessGroup(remoteGroupDTO.getId(), remoteGroupDTO.getTargetUri());
                remoteGroup.setComments(remoteGroupDTO.getComments());
                remoteGroup.setPosition(this.toPosition(remoteGroupDTO.getPosition()));
                remoteGroup.setCommunicationsTimeout(remoteGroupDTO.getCommunicationsTimeout());
                remoteGroup.setYieldDuration(remoteGroupDTO.getYieldDuration());
                remoteGroup.setTransportProtocol(SiteToSiteTransportProtocol.valueOf((String)remoteGroupDTO.getTransportProtocol()));
                remoteGroup.setProxyHost(remoteGroupDTO.getProxyHost());
                remoteGroup.setProxyPort(remoteGroupDTO.getProxyPort());
                remoteGroup.setProxyUser(remoteGroupDTO.getProxyUser());
                remoteGroup.setProxyPassword(remoteGroupDTO.getProxyPassword());
                remoteGroup.setProcessGroup(group);
                if (remoteGroupDTO.getContents() != null) {
                    contents = remoteGroupDTO.getContents();
                    if (contents.getInputPorts() != null) {
                        remoteGroup.setInputPorts(this.convertRemotePort(contents.getInputPorts()));
                    }
                    if (contents.getOutputPorts() != null) {
                        remoteGroup.setOutputPorts(this.convertRemotePort(contents.getOutputPorts()));
                    }
                }
                group.addRemoteProcessGroup(remoteGroup);
            }
            for (ProcessGroupDTO groupDTO : dto.getProcessGroups()) {
                ProcessGroup childGroup = this.createProcessGroup(groupDTO.getId());
                childGroup.setParent(group);
                childGroup.setPosition(this.toPosition(groupDTO.getPosition()));
                childGroup.setComments(groupDTO.getComments());
                childGroup.setName(groupDTO.getName());
                group.addProcessGroup(childGroup);
                contents = groupDTO.getContents();
                FlowSnippetDTO childTemplateDTO = new FlowSnippetDTO();
                childTemplateDTO.setConnections(contents.getConnections());
                childTemplateDTO.setInputPorts(contents.getInputPorts());
                childTemplateDTO.setLabels(contents.getLabels());
                childTemplateDTO.setOutputPorts(contents.getOutputPorts());
                childTemplateDTO.setProcessGroups(contents.getProcessGroups());
                childTemplateDTO.setProcessors(contents.getProcessors());
                childTemplateDTO.setFunnels(contents.getFunnels());
                childTemplateDTO.setRemoteProcessGroups(contents.getRemoteProcessGroups());
                childTemplateDTO.setControllerServices(contents.getControllerServices());
                this.instantiateSnippet(childGroup, childTemplateDTO);
            }
            for (ConnectionDTO connectionDTO : dto.getConnections()) {
                void var8_15;
                RemoteGroupPort source;
                RemoteProcessGroup remoteGroup;
                ConnectableDTO sourceDTO = connectionDTO.getSource();
                ConnectableDTO destinationDTO = connectionDTO.getDestination();
                if (ConnectableType.REMOTE_OUTPUT_PORT.name().equals(sourceDTO.getType())) {
                    remoteGroup = group.getRemoteProcessGroup(sourceDTO.getGroupId());
                    source = remoteGroup.getOutputPort(sourceDTO.getId());
                } else {
                    ProcessGroup sourceGroup = this.getConnectableParent(group, sourceDTO.getGroupId());
                    source = sourceGroup.getConnectable(sourceDTO.getId());
                }
                if (ConnectableType.REMOTE_INPUT_PORT.name().equals(destinationDTO.getType())) {
                    remoteGroup = group.getRemoteProcessGroup(destinationDTO.getGroupId());
                    RemoteGroupPort remoteGroupPort = remoteGroup.getInputPort(destinationDTO.getId());
                } else {
                    ProcessGroup destinationGroup = this.getConnectableParent(group, destinationDTO.getGroupId());
                    Connectable connectable = destinationGroup.getConnectable(destinationDTO.getId());
                }
                HashSet<String> relationships = new HashSet<String>();
                if (connectionDTO.getSelectedRelationships() != null) {
                    relationships.addAll(connectionDTO.getSelectedRelationships());
                }
                Connection connection = this.createConnection(connectionDTO.getId(), connectionDTO.getName(), (Connectable)source, (Connectable)var8_15, relationships);
                if (connectionDTO.getBends() != null) {
                    ArrayList<Position> bendPoints = new ArrayList<Position>();
                    for (PositionDTO bend : connectionDTO.getBends()) {
                        bendPoints.add(new Position(bend.getX().doubleValue(), bend.getY().doubleValue()));
                    }
                    connection.setBendPoints(bendPoints);
                }
                FlowFileQueue queue = connection.getFlowFileQueue();
                queue.setBackPressureDataSizeThreshold(connectionDTO.getBackPressureDataSizeThreshold());
                queue.setBackPressureObjectThreshold(connectionDTO.getBackPressureObjectThreshold().longValue());
                queue.setFlowFileExpiration(connectionDTO.getFlowFileExpiration());
                List prioritizers = connectionDTO.getPrioritizers();
                if (prioritizers != null) {
                    ArrayList newPrioritizersClasses = new ArrayList(prioritizers);
                    ArrayList<FlowFilePrioritizer> newPrioritizers = new ArrayList<FlowFilePrioritizer>();
                    for (String className : newPrioritizersClasses) {
                        try {
                            newPrioritizers.add(this.createPrioritizer(className));
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                            throw new IllegalArgumentException("Unable to set prioritizer " + className + ": " + e);
                        }
                    }
                    queue.setPriorities(newPrioritizers);
                }
                connection.setProcessGroup(group);
                group.addConnection(connection);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private Set<RemoteProcessGroupPortDescriptor> convertRemotePort(Set<RemoteProcessGroupPortDTO> ports) {
        LinkedHashSet<StandardRemoteProcessGroupPortDescriptor> remotePorts = null;
        if (ports != null) {
            remotePorts = new LinkedHashSet<StandardRemoteProcessGroupPortDescriptor>(ports.size());
            for (RemoteProcessGroupPortDTO port : ports) {
                StandardRemoteProcessGroupPortDescriptor descriptor = new StandardRemoteProcessGroupPortDescriptor();
                descriptor.setId(port.getId());
                descriptor.setName(port.getName());
                descriptor.setComments(port.getComments());
                descriptor.setTargetRunning(port.isTargetRunning());
                descriptor.setConnected(port.isConnected());
                descriptor.setConcurrentlySchedulableTaskCount(port.getConcurrentlySchedulableTaskCount());
                descriptor.setTransmitting(port.isTransmitting());
                descriptor.setUseCompression(port.getUseCompression());
                remotePorts.add(descriptor);
            }
        }
        return remotePorts;
    }

    private ProcessGroup getConnectableParent(ProcessGroup group, String parentGroupId) {
        if (this.areGroupsSame(group.getIdentifier(), parentGroupId)) {
            return group;
        }
        return group.getProcessGroup(parentGroupId);
    }

    private void validateSnippetContents(ProcessGroup group, FlowSnippetDTO templateContents) {
        for (Object port : templateContents.getInputPorts()) {
            if (group.getInputPortByName(port.getName()) == null) continue;
            throw new IllegalStateException("One or more of the proposed Port names is not available in the process group");
        }
        for (Object port : templateContents.getOutputPorts()) {
            if (group.getOutputPortByName(port.getName()) == null) continue;
            throw new IllegalStateException("One or more of the proposed Port names is not available in the process group");
        }
        HashSet<String> processorClasses = new HashSet<String>();
        for (Object c : ExtensionManager.getExtensions(Processor.class)) {
            processorClasses.add(((Class)c).getName());
        }
        HashSet<String> prioritizerClasses = new HashSet<String>();
        for (Object c : ExtensionManager.getExtensions(FlowFilePrioritizer.class)) {
            prioritizerClasses.add(((Class)c).getName());
        }
        HashSet<String> controllerServiceClasses = new HashSet<String>();
        for (Class c : ExtensionManager.getExtensions(ControllerService.class)) {
            controllerServiceClasses.add(c.getName());
        }
        HashSet<ProcessorDTO> allProcs = new HashSet<ProcessorDTO>();
        HashSet<ConnectionDTO> allConns = new HashSet<ConnectionDTO>();
        allProcs.addAll(templateContents.getProcessors());
        allConns.addAll(templateContents.getConnections());
        for (ProcessGroupDTO childGroup : templateContents.getProcessGroups()) {
            allProcs.addAll(this.findAllProcessors(childGroup));
            allConns.addAll(this.findAllConnections(childGroup));
        }
        for (ProcessorDTO proc : allProcs) {
            if (processorClasses.contains(proc.getType())) continue;
            throw new IllegalStateException("Invalid Processor Type: " + proc.getType());
        }
        Set controllerServices = templateContents.getControllerServices();
        if (controllerServices != null) {
            for (ControllerServiceDTO service : controllerServices) {
                if (controllerServiceClasses.contains(service.getType())) continue;
                throw new IllegalStateException("Invalid Controller Service Type: " + service.getType());
            }
        }
        for (ConnectionDTO conn : allConns) {
            List prioritizers = conn.getPrioritizers();
            if (prioritizers == null) continue;
            for (String prioritizer : prioritizers) {
                if (prioritizerClasses.contains(prioritizer)) continue;
                throw new IllegalStateException("Invalid FlowFile Prioritizer Type: " + prioritizer);
            }
        }
    }

    private Set<ProcessorDTO> findAllProcessors(ProcessGroupDTO group) {
        HashSet<ProcessorDTO> procs = new HashSet<ProcessorDTO>();
        for (ProcessorDTO dto : group.getContents().getProcessors()) {
            procs.add(dto);
        }
        for (ProcessGroupDTO childGroup : group.getContents().getProcessGroups()) {
            procs.addAll(this.findAllProcessors(childGroup));
        }
        return procs;
    }

    private Set<ConnectionDTO> findAllConnections(ProcessGroupDTO group) {
        HashSet<ConnectionDTO> conns = new HashSet<ConnectionDTO>();
        for (ConnectionDTO dto : group.getContents().getConnections()) {
            conns.add(dto);
        }
        for (ProcessGroupDTO childGroup : group.getContents().getProcessGroups()) {
            conns.addAll(this.findAllConnections(childGroup));
        }
        return conns;
    }

    public boolean areGroupsSame(String id1, String id2) {
        if (id1 == null || id2 == null) {
            return false;
        }
        if (id1.equals(id2)) {
            return true;
        }
        String comparable1 = id1.equals(ROOT_GROUP_ID_ALIAS) ? this.getRootGroupId() : id1;
        String comparable2 = id2.equals(ROOT_GROUP_ID_ALIAS) ? this.getRootGroupId() : id2;
        return comparable1.equals(comparable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowFilePrioritizer createPrioritizer(String type) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            FlowFilePrioritizer prioritizer;
            ClassLoader detectedClassLoaderForType = ExtensionManager.getClassLoader((String)type);
            Class<?> rawClass = detectedClassLoaderForType == null ? Class.forName(type) : Class.forName(type, true, ExtensionManager.getClassLoader((String)type));
            Thread.currentThread().setContextClassLoader(detectedClassLoaderForType);
            Class<FlowFilePrioritizer> prioritizerClass = rawClass.asSubclass(FlowFilePrioritizer.class);
            FlowFilePrioritizer processorObj = prioritizerClass.newInstance();
            FlowFilePrioritizer flowFilePrioritizer = prioritizer = prioritizerClass.cast(processorObj);
            return flowFilePrioritizer;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    public PortDTO updateInputPort(String parentGroupId, PortDTO dto) {
        ProcessGroup parentGroup = this.lookupGroup(parentGroupId);
        Port port = parentGroup.getInputPort(dto.getId());
        if (port == null) {
            throw new IllegalStateException("No Input Port with ID " + dto.getId() + " is known as a child of ProcessGroup with ID " + parentGroupId);
        }
        String name = dto.getName();
        if (dto.getPosition() != null) {
            port.setPosition(this.toPosition(dto.getPosition()));
        }
        if (name != null) {
            port.setName(name);
        }
        return this.createDTO(port);
    }

    private PortDTO createDTO(Port port) {
        if (port == null) {
            return null;
        }
        PortDTO dto = new PortDTO();
        dto.setId(port.getIdentifier());
        dto.setPosition(new PositionDTO(Double.valueOf(port.getPosition().getX()), Double.valueOf(port.getPosition().getY())));
        dto.setName(port.getName());
        dto.setParentGroupId(port.getProcessGroup().getIdentifier());
        return dto;
    }

    public PortDTO updateOutputPort(String parentGroupId, PortDTO dto) {
        ProcessGroup parentGroup = this.lookupGroup(parentGroupId);
        Port port = parentGroup.getOutputPort(dto.getId());
        if (port == null) {
            throw new IllegalStateException("No Output Port with ID " + dto.getId() + " is known as a child of ProcessGroup with ID " + parentGroupId);
        }
        String name = dto.getName();
        if (name != null) {
            port.setName(name);
        }
        if (dto.getPosition() != null) {
            port.setPosition(this.toPosition(dto.getPosition()));
        }
        return this.createDTO(port);
    }

    public Set<Class> getFlowFileProcessorClasses() {
        return ExtensionManager.getExtensions(Processor.class);
    }

    public Set<Class> getFlowFileComparatorClasses() {
        return ExtensionManager.getExtensions(FlowFilePrioritizer.class);
    }

    private ProcessGroup lookupGroup(String id) {
        ProcessGroup group = this.getGroup(id);
        if (group == null) {
            throw new IllegalStateException("No Group with ID " + id + " exists");
        }
        return group;
    }

    public ProcessGroup getGroup(String id) {
        Objects.requireNonNull(id);
        ProcessGroup root = this.getRootGroup();
        String searchId = id.equals(ROOT_GROUP_ID_ALIAS) ? this.getRootGroupId() : id;
        return root == null ? null : root.findProcessGroup(searchId);
    }

    public ProcessGroupStatus getControllerStatus() {
        return this.getGroupStatus(this.getRootGroupId());
    }

    public ProcessGroupStatus getGroupStatus(String groupId) {
        return this.getGroupStatus(groupId, this.getProcessorStats());
    }

    public ProcessGroupStatus getGroupStatus(String groupId, NiFiUser user) {
        return this.getGroupStatus(groupId, this.getProcessorStats(), user);
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport) {
        ProcessGroup group = this.getGroup(groupId);
        return this.getGroupStatus(group, statusReport, (Predicate<Authorizable>)((Predicate)authorizable -> true));
    }

    public ProcessGroupStatus getGroupStatus(String groupId, RepositoryStatusReport statusReport, NiFiUser user) {
        ProcessGroup group = this.getGroup(groupId);
        return this.getGroupStatus(group, statusReport, (Predicate<Authorizable>)((Predicate)authorizable -> authorizable.isAuthorized(this.authorizer, RequestAction.READ, user)));
    }

    public ProcessGroupStatus getGroupStatus(ProcessGroup group, RepositoryStatusReport statusReport, Predicate<Authorizable> isAuthorized) {
        if (group == null) {
            return null;
        }
        ProcessGroupStatus status = new ProcessGroupStatus();
        status.setId(group.getIdentifier());
        status.setName(isAuthorized.evaluate((Object)group) ? group.getName() : group.getIdentifier());
        int activeGroupThreads = 0;
        long bytesRead = 0L;
        long bytesWritten = 0L;
        int queuedCount = 0;
        long queuedContentSize = 0L;
        int flowFilesIn = 0;
        long bytesIn = 0L;
        int flowFilesOut = 0;
        long bytesOut = 0L;
        int flowFilesReceived = 0;
        long bytesReceived = 0L;
        int flowFilesSent = 0;
        long bytesSent = 0L;
        int flowFilesTransferred = 0;
        long bytesTransferred = 0L;
        ArrayList<ProcessorStatus> processorStatusCollection = new ArrayList<ProcessorStatus>();
        status.setProcessorStatus(processorStatusCollection);
        for (Object procNode : group.getProcessors()) {
            ProcessorStatus procStat = this.getProcessorStatus(statusReport, (ProcessorNode)procNode, isAuthorized);
            processorStatusCollection.add(procStat);
            activeGroupThreads += procStat.getActiveThreadCount();
            bytesRead += procStat.getBytesRead();
            bytesWritten += procStat.getBytesWritten();
            flowFilesReceived += procStat.getFlowFilesReceived();
            bytesReceived += procStat.getBytesReceived();
            flowFilesSent += procStat.getFlowFilesSent();
            bytesSent += procStat.getBytesSent();
        }
        ArrayList<ProcessGroupStatus> localChildGroupStatusCollection = new ArrayList<ProcessGroupStatus>();
        status.setProcessGroupStatus(localChildGroupStatusCollection);
        for (Object childGroup : group.getProcessGroups()) {
            ProcessGroupStatus childGroupStatus = this.getGroupStatus((ProcessGroup)childGroup, statusReport, isAuthorized);
            localChildGroupStatusCollection.add(childGroupStatus);
            activeGroupThreads += childGroupStatus.getActiveThreadCount().intValue();
            bytesRead += childGroupStatus.getBytesRead().longValue();
            bytesWritten += childGroupStatus.getBytesWritten().longValue();
            queuedCount += childGroupStatus.getQueuedCount().intValue();
            queuedContentSize += childGroupStatus.getQueuedContentSize().longValue();
            flowFilesReceived += childGroupStatus.getFlowFilesReceived();
            bytesReceived += childGroupStatus.getBytesReceived();
            flowFilesSent += childGroupStatus.getFlowFilesSent();
            bytesSent += childGroupStatus.getBytesSent();
            flowFilesTransferred += childGroupStatus.getFlowFilesTransferred();
            bytesTransferred += childGroupStatus.getBytesTransferred();
        }
        ArrayList<RemoteProcessGroupStatus> remoteProcessGroupStatusCollection = new ArrayList<RemoteProcessGroupStatus>();
        status.setRemoteProcessGroupStatus(remoteProcessGroupStatusCollection);
        for (Object remoteGroup : group.getRemoteProcessGroups()) {
            RemoteProcessGroupStatus remoteStatus = this.createRemoteGroupStatus((RemoteProcessGroup)remoteGroup, statusReport, isAuthorized);
            if (remoteStatus == null) continue;
            remoteProcessGroupStatusCollection.add(remoteStatus);
            flowFilesReceived += remoteStatus.getReceivedCount().intValue();
            bytesReceived += remoteStatus.getReceivedContentSize().longValue();
            flowFilesSent += remoteStatus.getSentCount().intValue();
            bytesSent += remoteStatus.getSentContentSize().longValue();
        }
        ArrayList<ConnectionStatus> connectionStatusCollection = new ArrayList<ConnectionStatus>();
        status.setConnectionStatus(connectionStatusCollection);
        for (Connection conn : group.getConnections()) {
            Connectable destination;
            boolean isConnectionAuthorized = isAuthorized.evaluate((Object)conn);
            boolean isSourceAuthorized = isAuthorized.evaluate((Object)conn.getSource());
            boolean isDestinationAuthorized = isAuthorized.evaluate((Object)conn.getDestination());
            ConnectionStatus connStatus = new ConnectionStatus();
            connStatus.setId(conn.getIdentifier());
            connStatus.setGroupId(conn.getProcessGroup().getIdentifier());
            connStatus.setSourceId(conn.getSource().getIdentifier());
            connStatus.setSourceName(isSourceAuthorized ? conn.getSource().getName() : conn.getSource().getIdentifier());
            connStatus.setDestinationId(conn.getDestination().getIdentifier());
            connStatus.setDestinationName(isDestinationAuthorized ? conn.getDestination().getName() : conn.getDestination().getIdentifier());
            connStatus.setBackPressureDataSizeThreshold(conn.getFlowFileQueue().getBackPressureDataSizeThreshold());
            connStatus.setBackPressureObjectThreshold(conn.getFlowFileQueue().getBackPressureObjectThreshold());
            FlowFileEvent connectionStatusReport = statusReport.getReportEntry(conn.getIdentifier());
            if (connectionStatusReport != null) {
                connStatus.setInputBytes(connectionStatusReport.getContentSizeIn());
                connStatus.setInputCount(connectionStatusReport.getFlowFilesIn());
                connStatus.setOutputBytes(connectionStatusReport.getContentSizeOut());
                connStatus.setOutputCount(connectionStatusReport.getFlowFilesOut());
                flowFilesTransferred += connectionStatusReport.getFlowFilesIn() + connectionStatusReport.getFlowFilesOut();
                bytesTransferred += connectionStatusReport.getContentSizeIn() + connectionStatusReport.getContentSizeOut();
            }
            if (isConnectionAuthorized) {
                if (StringUtils.isNotBlank((CharSequence)conn.getName())) {
                    connStatus.setName(conn.getName());
                } else if (conn.getRelationships() != null && !conn.getRelationships().isEmpty()) {
                    ArrayList<String> relationships = new ArrayList<String>(conn.getRelationships().size());
                    for (Relationship relationship : conn.getRelationships()) {
                        relationships.add(relationship.getName());
                    }
                    connStatus.setName(StringUtils.join(relationships, (String)", "));
                }
            } else {
                connStatus.setName(conn.getIdentifier());
            }
            QueueSize queueSize = conn.getFlowFileQueue().size();
            int connectionQueuedCount = queueSize.getObjectCount();
            long connectionQueuedBytes = queueSize.getByteCount();
            if (connectionQueuedCount > 0) {
                connStatus.setQueuedBytes(connectionQueuedBytes);
                connStatus.setQueuedCount(connectionQueuedCount);
            }
            connectionStatusCollection.add(connStatus);
            queuedCount += connectionQueuedCount;
            queuedContentSize += connectionQueuedBytes;
            Connectable source = conn.getSource();
            if (ConnectableType.REMOTE_OUTPUT_PORT.equals((Object)source.getConnectableType())) {
                RemoteGroupPort remoteOutputPort = (RemoteGroupPort)source;
                activeGroupThreads += this.processScheduler.getActiveThreadCount(remoteOutputPort);
            }
            if (!ConnectableType.REMOTE_INPUT_PORT.equals((Object)(destination = conn.getDestination()).getConnectableType())) continue;
            RemoteGroupPort remoteInputPort = (RemoteGroupPort)destination;
            activeGroupThreads += this.processScheduler.getActiveThreadCount(remoteInputPort);
        }
        ArrayList<PortStatus> inputPortStatusCollection = new ArrayList<PortStatus>();
        status.setInputPortStatus(inputPortStatusCollection);
        Set inputPorts = group.getInputPorts();
        for (Port port : inputPorts) {
            FlowFileEvent entry;
            boolean isInputPortAuthorized = isAuthorized.evaluate((Object)port);
            PortStatus portStatus = new PortStatus();
            portStatus.setId(port.getIdentifier());
            portStatus.setGroupId(port.getProcessGroup().getIdentifier());
            portStatus.setName(isInputPortAuthorized ? port.getName() : port.getIdentifier());
            portStatus.setActiveThreadCount(Integer.valueOf(this.processScheduler.getActiveThreadCount(port)));
            if (ScheduledState.RUNNING.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Running);
            } else if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Disabled);
            } else if (!port.isValid()) {
                portStatus.setRunStatus(RunStatus.Invalid);
            } else {
                portStatus.setRunStatus(RunStatus.Stopped);
            }
            if (port instanceof RootGroupPort) {
                RootGroupPort rootGroupPort = (RootGroupPort)port;
                portStatus.setTransmitting(Boolean.valueOf(rootGroupPort.isTransmitting()));
            }
            if ((entry = (FlowFileEvent)statusReport.getReportEntries().get(port.getIdentifier())) == null) {
                portStatus.setInputBytes(0L);
                portStatus.setInputCount(0);
                portStatus.setOutputBytes(0L);
                portStatus.setOutputCount(0);
            } else {
                int processedCount = entry.getFlowFilesOut();
                long numProcessedBytes = entry.getContentSizeOut();
                portStatus.setOutputBytes(numProcessedBytes);
                portStatus.setOutputCount(processedCount);
                int inputCount = entry.getFlowFilesIn();
                long inputBytes = entry.getContentSizeIn();
                portStatus.setInputBytes(inputBytes);
                portStatus.setInputCount(inputCount);
                flowFilesIn += inputCount;
                bytesIn += inputBytes;
                bytesWritten += entry.getBytesWritten();
                flowFilesReceived += entry.getFlowFilesReceived();
                bytesReceived += entry.getBytesReceived();
            }
            inputPortStatusCollection.add(portStatus);
            activeGroupThreads += portStatus.getActiveThreadCount().intValue();
        }
        ArrayList<PortStatus> outputPortStatusCollection = new ArrayList<PortStatus>();
        status.setOutputPortStatus(outputPortStatusCollection);
        Set outputPorts = group.getOutputPorts();
        for (Port port : outputPorts) {
            FlowFileEvent entry;
            boolean isOutputPortAuthorized = isAuthorized.evaluate((Object)port);
            PortStatus portStatus = new PortStatus();
            portStatus.setId(port.getIdentifier());
            portStatus.setGroupId(port.getProcessGroup().getIdentifier());
            portStatus.setName(isOutputPortAuthorized ? port.getName() : port.getIdentifier());
            portStatus.setActiveThreadCount(Integer.valueOf(this.processScheduler.getActiveThreadCount(port)));
            if (ScheduledState.RUNNING.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Running);
            } else if (ScheduledState.DISABLED.equals((Object)port.getScheduledState())) {
                portStatus.setRunStatus(RunStatus.Disabled);
            } else if (!port.isValid()) {
                portStatus.setRunStatus(RunStatus.Invalid);
            } else {
                portStatus.setRunStatus(RunStatus.Stopped);
            }
            if (port instanceof RootGroupPort) {
                RootGroupPort rootGroupPort = (RootGroupPort)port;
                portStatus.setTransmitting(Boolean.valueOf(rootGroupPort.isTransmitting()));
            }
            if ((entry = (FlowFileEvent)statusReport.getReportEntries().get(port.getIdentifier())) == null) {
                portStatus.setInputBytes(0L);
                portStatus.setInputCount(0);
                portStatus.setOutputBytes(0L);
                portStatus.setOutputCount(0);
            } else {
                int processedCount = entry.getFlowFilesOut();
                long numProcessedBytes = entry.getContentSizeOut();
                portStatus.setOutputBytes(numProcessedBytes);
                portStatus.setOutputCount(processedCount);
                int inputCount = entry.getFlowFilesIn();
                long inputBytes = entry.getContentSizeIn();
                portStatus.setInputBytes(inputBytes);
                portStatus.setInputCount(inputCount);
                bytesRead += entry.getBytesRead();
                flowFilesOut += entry.getFlowFilesOut();
                bytesOut += entry.getContentSizeOut();
                flowFilesSent = entry.getFlowFilesSent();
                bytesSent += entry.getBytesSent();
            }
            outputPortStatusCollection.add(portStatus);
            activeGroupThreads += portStatus.getActiveThreadCount().intValue();
        }
        for (Funnel funnel : group.getFunnels()) {
            activeGroupThreads += this.processScheduler.getActiveThreadCount(funnel);
        }
        status.setActiveThreadCount(Integer.valueOf(activeGroupThreads));
        status.setBytesRead(Long.valueOf(bytesRead));
        status.setBytesWritten(Long.valueOf(bytesWritten));
        status.setQueuedCount(Integer.valueOf(queuedCount));
        status.setQueuedContentSize(Long.valueOf(queuedContentSize));
        status.setInputContentSize(Long.valueOf(bytesIn));
        status.setInputCount(Integer.valueOf(flowFilesIn));
        status.setOutputContentSize(Long.valueOf(bytesOut));
        status.setOutputCount(Integer.valueOf(flowFilesOut));
        status.setFlowFilesReceived(flowFilesReceived);
        status.setBytesReceived(bytesReceived);
        status.setFlowFilesSent(flowFilesSent);
        status.setBytesSent(bytesSent);
        status.setFlowFilesTransferred(flowFilesTransferred);
        status.setBytesTransferred(bytesTransferred);
        return status;
    }

    private RemoteProcessGroupStatus createRemoteGroupStatus(RemoteProcessGroup remoteGroup, RepositoryStatusReport statusReport, Predicate<Authorizable> isAuthorized) {
        FlowFileEvent portEvent;
        boolean isConnected;
        boolean isRemoteProcessGroupAuthorized = isAuthorized.evaluate((Object)remoteGroup);
        int receivedCount = 0;
        long receivedContentSize = 0L;
        int sentCount = 0;
        long sentContentSize = 0L;
        int activeThreadCount = 0;
        int activePortCount = 0;
        int inactivePortCount = 0;
        RemoteProcessGroupStatus status = new RemoteProcessGroupStatus();
        status.setGroupId(remoteGroup.getProcessGroup().getIdentifier());
        status.setName(isRemoteProcessGroupAuthorized ? remoteGroup.getName() : remoteGroup.getIdentifier());
        status.setTargetUri(isRemoteProcessGroupAuthorized ? remoteGroup.getTargetUri().toString() : null);
        long lineageMillis = 0L;
        int flowFilesRemoved = 0;
        int flowFilesTransferred = 0;
        for (Port port : remoteGroup.getInputPorts()) {
            isConnected = port.hasIncomingConnection();
            if (!isConnected) continue;
            if (port.isRunning()) {
                ++activePortCount;
            } else {
                ++inactivePortCount;
            }
            activeThreadCount += this.processScheduler.getActiveThreadCount(port);
            portEvent = statusReport.getReportEntry(port.getIdentifier());
            if (portEvent == null) continue;
            lineageMillis += portEvent.getAggregateLineageMillis();
            flowFilesRemoved += portEvent.getFlowFilesRemoved();
            flowFilesTransferred += portEvent.getFlowFilesOut();
            sentCount += portEvent.getFlowFilesSent();
            sentContentSize += portEvent.getBytesSent();
        }
        for (Port port : remoteGroup.getOutputPorts()) {
            isConnected = !port.getConnections().isEmpty();
            if (!isConnected) continue;
            if (port.isRunning()) {
                ++activePortCount;
            } else {
                ++inactivePortCount;
            }
            activeThreadCount += this.processScheduler.getActiveThreadCount(port);
            portEvent = statusReport.getReportEntry(port.getIdentifier());
            if (portEvent == null) continue;
            receivedCount += portEvent.getFlowFilesReceived();
            receivedContentSize += portEvent.getBytesReceived();
        }
        status.setId(remoteGroup.getIdentifier());
        status.setTransmissionStatus(remoteGroup.isTransmitting() ? TransmissionStatus.Transmitting : TransmissionStatus.NotTransmitting);
        status.setActiveThreadCount(Integer.valueOf(activeThreadCount));
        status.setReceivedContentSize(Long.valueOf(receivedContentSize));
        status.setReceivedCount(Integer.valueOf(receivedCount));
        status.setSentContentSize(Long.valueOf(sentContentSize));
        status.setSentCount(Integer.valueOf(sentCount));
        status.setActiveRemotePortCount(Integer.valueOf(activePortCount));
        status.setInactiveRemotePortCount(Integer.valueOf(inactivePortCount));
        int flowFilesOutOrRemoved = flowFilesTransferred + flowFilesRemoved;
        status.setAverageLineageDuration(flowFilesOutOrRemoved == 0 ? 0L : lineageMillis / (long)flowFilesOutOrRemoved, TimeUnit.MILLISECONDS);
        return status;
    }

    private ProcessorStatus getProcessorStatus(RepositoryStatusReport report, ProcessorNode procNode, Predicate<Authorizable> isAuthorized) {
        boolean isProcessorAuthorized = isAuthorized.evaluate((Object)procNode);
        ProcessorStatus status = new ProcessorStatus();
        status.setId(procNode.getIdentifier());
        status.setGroupId(procNode.getProcessGroup().getIdentifier());
        status.setName(isProcessorAuthorized ? procNode.getName() : procNode.getIdentifier());
        status.setType(isProcessorAuthorized ? procNode.getComponentType() : "Processor");
        FlowFileEvent entry = (FlowFileEvent)report.getReportEntries().get(procNode.getIdentifier());
        if (entry == null) {
            status.setInputBytes(0L);
            status.setInputCount(0);
            status.setOutputBytes(0L);
            status.setOutputCount(0);
            status.setBytesWritten(0L);
            status.setBytesRead(0L);
            status.setProcessingNanos(0L);
            status.setInvocations(0);
            status.setAverageLineageDuration(0L);
            status.setFlowFilesRemoved(0);
        } else {
            int processedCount = entry.getFlowFilesOut();
            long numProcessedBytes = entry.getContentSizeOut();
            status.setOutputBytes(numProcessedBytes);
            status.setOutputCount(processedCount);
            int inputCount = entry.getFlowFilesIn();
            long inputBytes = entry.getContentSizeIn();
            status.setInputBytes(inputBytes);
            status.setInputCount(inputCount);
            long readBytes = entry.getBytesRead();
            status.setBytesRead(readBytes);
            long writtenBytes = entry.getBytesWritten();
            status.setBytesWritten(writtenBytes);
            status.setProcessingNanos(entry.getProcessingNanoseconds());
            status.setInvocations(entry.getInvocations());
            status.setAverageLineageDuration(entry.getAverageLineageMillis());
            status.setFlowFilesReceived(entry.getFlowFilesReceived());
            status.setBytesReceived(entry.getBytesReceived());
            status.setFlowFilesSent(entry.getFlowFilesSent());
            status.setBytesSent(entry.getBytesSent());
            status.setFlowFilesRemoved(entry.getFlowFilesRemoved());
        }
        if (ScheduledState.DISABLED.equals((Object)procNode.getScheduledState())) {
            status.setRunStatus(RunStatus.Disabled);
        } else if (!procNode.isValid()) {
            status.setRunStatus(RunStatus.Invalid);
        } else if (ScheduledState.RUNNING.equals((Object)procNode.getScheduledState())) {
            status.setRunStatus(RunStatus.Running);
        } else {
            status.setRunStatus(RunStatus.Stopped);
        }
        status.setActiveThreadCount(this.processScheduler.getActiveThreadCount(procNode));
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessor(String parentGroupId, String processorId) {
        ProcessGroup group = this.lookupGroup(parentGroupId);
        ProcessorNode node = group.getProcessor(processorId);
        if (node == null) {
            throw new IllegalStateException("Cannot find ProcessorNode with ID " + processorId + " within ProcessGroup with ID " + parentGroupId);
        }
        this.writeLock.lock();
        try {
            if (this.initialized.get()) {
                group.startProcessor(node);
            } else {
                this.startConnectablesAfterInitialization.add((Connectable)node);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isInitialized() {
        return this.initialized.get();
    }

    public void startConnectable(Connectable connectable) {
        block9: {
            ProcessGroup group = Objects.requireNonNull(connectable).getProcessGroup();
            this.writeLock.lock();
            try {
                if (this.initialized.get()) {
                    switch (Objects.requireNonNull(connectable).getConnectableType()) {
                        case FUNNEL: {
                            group.startFunnel((Funnel)connectable);
                            break block9;
                        }
                        case INPUT_PORT: 
                        case REMOTE_INPUT_PORT: {
                            group.startInputPort((Port)connectable);
                            break block9;
                        }
                        case OUTPUT_PORT: 
                        case REMOTE_OUTPUT_PORT: {
                            group.startOutputPort((Port)connectable);
                            break block9;
                        }
                        default: {
                            throw new IllegalArgumentException();
                        }
                    }
                }
                this.startConnectablesAfterInitialization.add(connectable);
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    public void startTransmitting(RemoteGroupPort remoteGroupPort) {
        this.writeLock.lock();
        try {
            if (this.initialized.get()) {
                remoteGroupPort.getRemoteProcessGroup().startTransmitting(remoteGroupPort);
            } else {
                this.startRemoteGroupPortsAfterInitialization.add(remoteGroupPort);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void stopProcessor(String parentGroupId, String processorId) {
        ProcessGroup group = this.lookupGroup(parentGroupId);
        ProcessorNode node = group.getProcessor(processorId);
        if (node == null) {
            throw new IllegalStateException("Cannot find ProcessorNode with ID " + processorId + " within ProcessGroup with ID " + parentGroupId);
        }
        group.stopProcessor(node);
    }

    public void stopAllProcessors() {
        this.stopProcessGroup(this.getRootGroupId());
    }

    public void startProcessGroup(String groupId) {
        this.lookupGroup(groupId).startProcessing();
    }

    public void stopProcessGroup(String groupId) {
        this.lookupGroup(groupId).stopProcessing();
    }

    public ReportingTaskNode createReportingTask(String type) throws ReportingTaskInstantiationException {
        return this.createReportingTask(type, true);
    }

    public ReportingTaskNode createReportingTask(String type, boolean firstTimeAdded) throws ReportingTaskInstantiationException {
        return this.createReportingTask(type, UUID.randomUUID().toString(), firstTimeAdded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReportingTaskNode createReportingTask(String type, String id, boolean firstTimeAdded) throws ReportingTaskInstantiationException {
        StandardReportingTaskNode taskNode;
        if (type == null || id == null) {
            throw new NullPointerException();
        }
        ReportingTask task = null;
        boolean creationSuccessful = true;
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader detectedClassLoader = ExtensionManager.getClassLoader((String)type);
            Class<?> rawClass = detectedClassLoader == null ? Class.forName(type) : Class.forName(type, false, detectedClassLoader);
            Thread.currentThread().setContextClassLoader(detectedClassLoader);
            Class<ReportingTask> reportingTaskClass = rawClass.asSubclass(ReportingTask.class);
            ReportingTask reportingTaskObj = reportingTaskClass.newInstance();
            task = reportingTaskClass.cast(reportingTaskObj);
        }
        catch (Exception e) {
            LOG.error("Could not create Reporting Task of type " + type + " for ID " + id + "; creating \"Ghost\" implementation", (Throwable)e);
            GhostReportingTask ghostTask = new GhostReportingTask();
            ghostTask.setIdentifier(id);
            ghostTask.setCanonicalClassName(type);
            task = ghostTask;
            creationSuccessful = false;
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
        StandardValidationContextFactory validationContextFactory = new StandardValidationContextFactory(this.controllerServiceProvider, this.variableRegistry);
        if (creationSuccessful) {
            taskNode = new StandardReportingTaskNode(task, id, this, (ProcessScheduler)this.processScheduler, (ValidationContextFactory)validationContextFactory, this.variableRegistry);
        } else {
            String simpleClassName = type.contains(".") ? StringUtils.substringAfterLast((String)type, (String)".") : type;
            String componentType = "(Missing) " + simpleClassName;
            taskNode = new StandardReportingTaskNode(task, id, this, (ProcessScheduler)this.processScheduler, (ValidationContextFactory)validationContextFactory, componentType, type, this.variableRegistry);
        }
        taskNode.setName(task.getClass().getSimpleName());
        if (firstTimeAdded) {
            SimpleProcessLogger componentLog = new SimpleProcessLogger(id, taskNode.getReportingTask());
            StandardReportingInitializationContext config = new StandardReportingInitializationContext(id, taskNode.getName(), SchedulingStrategy.TIMER_DRIVEN, "1 min", componentLog, this);
            try {
                task.initialize((ReportingInitializationContext)config);
            }
            catch (InitializationException ie) {
                throw new ReportingTaskInstantiationException("Failed to initialize reporting task of type " + type, (Throwable)ie);
            }
            try (NarCloseable x = NarCloseable.withNarLoader();){
                ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, task, new Object[0]);
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)taskNode.getReportingTask(), new Object[0]);
            }
            catch (Exception e) {
                throw new ComponentLifeCycleException("Failed to invoke On-Added Lifecycle methods of " + task, (Throwable)e);
            }
        }
        this.reportingTasks.put(id, taskNode);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ReportingTaskLogObserver(this.getBulletinRepository(), taskNode));
        return taskNode;
    }

    public ReportingTaskNode getReportingTaskNode(String taskId) {
        return (ReportingTaskNode)this.reportingTasks.get(taskId);
    }

    public void startReportingTask(ReportingTaskNode reportingTaskNode) {
        if (this.isTerminated()) {
            throw new IllegalStateException("Cannot start reporting task " + reportingTaskNode.getIdentifier() + " because the controller is terminated");
        }
        reportingTaskNode.verifyCanStart();
        this.processScheduler.schedule(reportingTaskNode);
    }

    public void stopReportingTask(ReportingTaskNode reportingTaskNode) {
        if (this.isTerminated()) {
            return;
        }
        reportingTaskNode.verifyCanStop();
        this.processScheduler.unschedule(reportingTaskNode);
    }

    public void removeReportingTask(ReportingTaskNode reportingTaskNode) {
        ReportingTaskNode existing = (ReportingTaskNode)this.reportingTasks.get(reportingTaskNode.getIdentifier());
        if (existing == null || existing != reportingTaskNode) {
            throw new IllegalStateException("Reporting Task " + reportingTaskNode + " does not exist in this Flow");
        }
        reportingTaskNode.verifyCanDelete();
        try (NarCloseable x = NarCloseable.withNarLoader();){
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)reportingTaskNode.getReportingTask(), reportingTaskNode.getConfigurationContext());
        }
        for (Map.Entry entry : reportingTaskNode.getProperties().entrySet()) {
            ControllerServiceNode serviceNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (serviceNode = this.controllerServiceProvider.getControllerServiceNode(value)) == null) continue;
            serviceNode.removeReference((ConfiguredComponent)reportingTaskNode);
        }
        this.reportingTasks.remove(reportingTaskNode.getIdentifier());
    }

    public Set<ReportingTaskNode> getAllReportingTasks() {
        return new HashSet<ReportingTaskNode>(this.reportingTasks.values());
    }

    public ControllerServiceNode createControllerService(String type, String id, boolean firstTimeAdded) {
        ControllerServiceNode serviceNode = this.controllerServiceProvider.createControllerService(type, id, firstTimeAdded);
        LogRepository logRepository = LogRepositoryFactory.getRepository((String)id);
        logRepository.addObserver("bulletin-observer", LogLevel.WARN, (LogObserver)new ControllerServiceLogObserver(this.getBulletinRepository(), serviceNode));
        if (firstTimeAdded) {
            ControllerService service = serviceNode.getControllerServiceImplementation();
            try (NarCloseable nc = NarCloseable.withNarLoader();){
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, (Object)service, new Object[0]);
            }
        }
        return serviceNode;
    }

    public void enableReportingTask(ReportingTaskNode reportingTaskNode) {
        reportingTaskNode.verifyCanEnable();
        this.processScheduler.enableReportingTask(reportingTaskNode);
    }

    public void disableReportingTask(ReportingTaskNode reportingTaskNode) {
        reportingTaskNode.verifyCanDisable();
        this.processScheduler.disableReportingTask(reportingTaskNode);
    }

    public Set<ConfiguredComponent> disableReferencingServices(ControllerServiceNode serviceNode) {
        return this.controllerServiceProvider.disableReferencingServices(serviceNode);
    }

    public Set<ConfiguredComponent> enableReferencingServices(ControllerServiceNode serviceNode) {
        return this.controllerServiceProvider.enableReferencingServices(serviceNode);
    }

    public Set<ConfiguredComponent> scheduleReferencingComponents(ControllerServiceNode serviceNode) {
        return this.controllerServiceProvider.scheduleReferencingComponents(serviceNode);
    }

    public Set<ConfiguredComponent> unscheduleReferencingComponents(ControllerServiceNode serviceNode) {
        return this.controllerServiceProvider.unscheduleReferencingComponents(serviceNode);
    }

    public void enableControllerService(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.enableControllerService(serviceNode);
    }

    public void enableControllerServices(Collection<ControllerServiceNode> serviceNodes) {
        this.controllerServiceProvider.enableControllerServices(serviceNodes);
    }

    public void disableControllerService(ControllerServiceNode serviceNode) {
        serviceNode.verifyCanDisable();
        this.controllerServiceProvider.disableControllerService(serviceNode);
    }

    public void verifyCanEnableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanEnableReferencingServices(serviceNode);
    }

    public void verifyCanScheduleReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanScheduleReferencingComponents(serviceNode);
    }

    public void verifyCanDisableReferencingServices(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanDisableReferencingServices(serviceNode);
    }

    public void verifyCanStopReferencingComponents(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.verifyCanStopReferencingComponents(serviceNode);
    }

    public ControllerService getControllerService(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerService(serviceIdentifier);
    }

    public ControllerService getControllerServiceForComponent(String serviceIdentifier, String componentId) {
        return this.controllerServiceProvider.getControllerServiceForComponent(serviceIdentifier, componentId);
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) throws IllegalArgumentException {
        return this.controllerServiceProvider.getControllerServiceIdentifiers(serviceType);
    }

    public ControllerServiceNode getControllerServiceNode(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerServiceNode(serviceIdentifier);
    }

    public Set<ControllerServiceNode> getRootControllerServices() {
        return new HashSet<ControllerServiceNode>(this.rootControllerServices.values());
    }

    public void addRootControllerService(ControllerServiceNode serviceNode) {
        ControllerServiceNode existing = this.rootControllerServices.putIfAbsent(serviceNode.getIdentifier(), serviceNode);
        if (existing != null) {
            throw new IllegalStateException("Controller Service with ID " + serviceNode.getIdentifier() + " already exists at the Controller level");
        }
    }

    public ControllerServiceNode getRootControllerService(String serviceIdentifier) {
        return (ControllerServiceNode)this.rootControllerServices.get(serviceIdentifier);
    }

    public void removeRootControllerService(ControllerServiceNode service) {
        ControllerServiceNode existing = (ControllerServiceNode)this.rootControllerServices.get(Objects.requireNonNull(service).getIdentifier());
        if (existing == null) {
            throw new IllegalStateException(service + " is not a member of this Process Group");
        }
        service.verifyCanDelete();
        try (NarCloseable x = NarCloseable.withNarLoader();){
            StandardConfigurationContext configurationContext = new StandardConfigurationContext((ConfiguredComponent)service, (ControllerServiceLookup)this.controllerServiceProvider, null, this.variableRegistry);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnRemoved.class, (Object)service.getControllerServiceImplementation(), configurationContext);
        }
        for (Map.Entry entry : service.getProperties().entrySet()) {
            ControllerServiceNode referencedNode;
            String value;
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            if (descriptor.getControllerServiceDefinition() == null || (value = entry.getValue() == null ? descriptor.getDefaultValue() : (String)entry.getValue()) == null || (referencedNode = this.getRootControllerService(value)) == null) continue;
            referencedNode.removeReference((ConfiguredComponent)service);
        }
        this.rootControllerServices.remove(service.getIdentifier());
        this.getStateManagerProvider().onComponentRemoved(service.getIdentifier());
        LOG.info("{} removed from Flow Controller", (Object)service, (Object)this);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.controllerServiceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.controllerServiceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.controllerServiceProvider.getControllerServiceName(serviceIdentifier);
    }

    public void removeControllerService(ControllerServiceNode serviceNode) {
        this.controllerServiceProvider.removeControllerService(serviceNode);
    }

    public Set<ControllerServiceNode> getAllControllerServices() {
        return this.controllerServiceProvider.getAllControllerServices();
    }

    public List<Counter> getCounters() {
        ArrayList<Counter> counters = new ArrayList<Counter>();
        CounterRepository counterRepo = this.counterRepositoryRef.get();
        for (Counter counter : counterRepo.getCounters()) {
            counters.add(counter);
        }
        return counters;
    }

    public Counter resetCounter(String identifier) {
        CounterRepository counterRepo = this.counterRepositoryRef.get();
        Counter resetValue = counterRepo.resetCounter(identifier);
        return resetValue;
    }

    public QueueSize getTotalFlowFileCount(ProcessGroup group) {
        QueueSize size;
        int count = 0;
        long contentSize = 0L;
        for (Connection connection : group.getConnections()) {
            size = connection.getFlowFileQueue().size();
            count += size.getObjectCount();
            contentSize += size.getByteCount();
        }
        for (ProcessGroup childGroup : group.getProcessGroups()) {
            size = this.getTotalFlowFileCount(childGroup);
            count += size.getObjectCount();
            contentSize += size.getByteCount();
        }
        return new QueueSize(count, contentSize);
    }

    public int getActiveThreadCount() {
        return this.getGroupStatus(this.getRootGroupId()).getActiveThreadCount();
    }

    private RepositoryStatusReport getProcessorStats() {
        return this.getProcessorStats(System.currentTimeMillis() - 300000L);
    }

    private RepositoryStatusReport getProcessorStats(long since) {
        return this.flowFileEventRepository.reportTransferEvents(since);
    }

    public void startHeartbeating() throws IllegalStateException {
        if (!this.isConfiguredForClustering()) {
            throw new IllegalStateException("Unable to start heartbeating because heartbeating is not configured.");
        }
        this.writeLock.lock();
        try {
            this.stopHeartbeating();
            HeartbeatSendTask sendTask = new HeartbeatSendTask();
            this.heartbeatSendTask.set(sendTask);
            this.heartbeatSenderFuture = this.clusterTaskExecutor.scheduleWithFixedDelay(sendTask, 0L, this.heartbeatDelaySeconds, TimeUnit.SECONDS);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void suspendHeartbeats() {
        this.heartbeatsSuspended.set(true);
    }

    public void resumeHeartbeats() {
        this.heartbeatsSuspended.set(false);
    }

    public void stopHeartbeating() throws IllegalStateException {
        if (!this.isConfiguredForClustering()) {
            throw new IllegalStateException("Unable to stop heartbeating because heartbeating is not configured.");
        }
        this.writeLock.lock();
        try {
            if (!this.isHeartbeating()) {
                return;
            }
            if (this.heartbeatSenderFuture != null) {
                this.heartbeatSenderFuture.cancel(false);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isHeartbeating() {
        this.readLock.lock();
        try {
            boolean bl = this.heartbeatSenderFuture != null && !this.heartbeatSenderFuture.isCancelled();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getHeartbeatDelaySeconds() {
        this.readLock.lock();
        try {
            int n = this.heartbeatDelaySeconds;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public NodeIdentifier getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(NodeIdentifier nodeId) {
        this.nodeId = nodeId;
    }

    public boolean isClustered() {
        this.readLock.lock();
        try {
            boolean bl = this.clustered;
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean isConfiguredForClustering() {
        return this.configuredForClustering;
    }

    private void registerForClusterCoordinator() {
        this.leaderElectionManager.register("Cluster Coordinator", new LeaderElectionStateChangeListener(){

            @Override
            public synchronized void onLeaderRelinquish() {
                FlowController.this.heartbeatMonitor.stop();
                if (FlowController.this.clusterCoordinator != null) {
                    FlowController.this.clusterCoordinator.removeRole("Cluster Coordinator");
                }
            }

            @Override
            public synchronized void onLeaderElection() {
                FlowController.this.heartbeatMonitor.start();
                if (FlowController.this.clusterCoordinator != null) {
                    FlowController.this.clusterCoordinator.addRole("Cluster Coordinator");
                }
            }
        });
    }

    private void registerForPrimaryNode() {
        this.leaderElectionManager.register("Primary Node", new LeaderElectionStateChangeListener(){

            @Override
            public void onLeaderElection() {
                FlowController.this.setPrimary(true);
            }

            @Override
            public void onLeaderRelinquish() {
                FlowController.this.setPrimary(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClustered(boolean clustered, String clusterInstanceId) {
        this.writeLock.lock();
        try {
            boolean isChanging = false;
            if (this.clustered != clustered) {
                isChanging = true;
                if (clustered) {
                    LOG.info("Cluster State changed from Not Clustered to Clustered");
                } else {
                    LOG.info("Cluster State changed from Clustered to Not Clustered");
                }
            }
            this.clustered = clustered;
            this.eventDrivenWorkerQueue.setClustered(clustered);
            if (clusterInstanceId != null) {
                this.instanceId = clusterInstanceId;
            }
            if (isChanging) {
                if (clustered) {
                    this.registerForPrimaryNode();
                    this.registerForClusterCoordinator();
                    this.leaderElectionManager.start();
                    this.stateManagerProvider.enableClusterProvider();
                    this.heartbeat();
                } else {
                    this.leaderElectionManager.unregister("Primary Node");
                    this.leaderElectionManager.unregister("Cluster Coordinator");
                    this.stateManagerProvider.disableClusterProvider();
                    this.setPrimary(false);
                }
                List remoteGroups = this.getGroup(this.getRootGroupId()).findAllRemoteProcessGroups();
                for (RemoteProcessGroup remoteGroup : remoteGroups) {
                    remoteGroup.reinitialize(clustered);
                }
            }
            this.heartbeatBeanRef.set(new HeartbeatBean(this.getRootGroup(), this.isPrimary()));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean isPrimary() {
        return this.isClustered() && this.leaderElectionManager != null && this.leaderElectionManager.isLeader("Primary Node");
    }

    public void setPrimary(boolean primary) {
        Throwable throwable;
        NarCloseable narCloseable;
        PrimaryNodeState nodeState = primary ? PrimaryNodeState.ELECTED_PRIMARY_NODE : PrimaryNodeState.PRIMARY_NODE_REVOKED;
        ProcessGroup rootGroup = this.getGroup(this.getRootGroupId());
        for (ProcessorNode procNode : rootGroup.findAllProcessors()) {
            narCloseable = NarCloseable.withNarLoader();
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)procNode.getProcessor(), nodeState);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (narCloseable == null) continue;
                if (throwable != null) {
                    try {
                        narCloseable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                narCloseable.close();
            }
        }
        for (ControllerServiceNode serviceNode : this.getAllControllerServices()) {
            narCloseable = NarCloseable.withNarLoader();
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)serviceNode.getControllerServiceImplementation(), nodeState);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (narCloseable == null) continue;
                if (throwable != null) {
                    try {
                        narCloseable.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                narCloseable.close();
            }
        }
        for (ReportingTaskNode reportingTaskNode : this.getAllReportingTasks()) {
            narCloseable = NarCloseable.withNarLoader();
            throwable = null;
            try {
                ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnPrimaryNodeStateChange.class, (Object)reportingTaskNode.getReportingTask(), nodeState);
            }
            catch (Throwable throwable6) {
                throwable = throwable6;
                throw throwable6;
            }
            finally {
                if (narCloseable == null) continue;
                if (throwable != null) {
                    try {
                        narCloseable.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    continue;
                }
                narCloseable.close();
            }
        }
        this.eventDrivenWorkerQueue.setPrimary(primary);
        HeartbeatBean oldBean = this.heartbeatBeanRef.getAndSet(new HeartbeatBean(rootGroup, primary));
        if (oldBean == null || oldBean.isPrimary() != primary) {
            String message = primary ? "This node has been elected Primary Node" : "This node is no longer Primary Node";
            Bulletin bulletin = BulletinFactory.createBulletin((String)"Primary Node", (String)Severity.INFO.name(), (String)message);
            this.bulletinRepository.addBulletin(bulletin);
            LOG.info(message);
        }
    }

    static boolean areEqual(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }

    static boolean areEqual(Long a, Long b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.compareTo(b) == 0;
    }

    public ContentAvailability getContentAvailability(final ProvenanceEventRecord event) {
        final String replayFailure = this.getReplayFailureReason(event);
        return new ContentAvailability(){

            public String getReasonNotReplayable() {
                return replayFailure;
            }

            public boolean isContentSame() {
                return FlowController.areEqual(event.getPreviousContentClaimContainer(), event.getContentClaimContainer()) && FlowController.areEqual(event.getPreviousContentClaimSection(), event.getContentClaimSection()) && FlowController.areEqual(event.getPreviousContentClaimIdentifier(), event.getContentClaimIdentifier()) && FlowController.areEqual(event.getPreviousContentClaimOffset(), event.getContentClaimOffset()) && FlowController.areEqual(event.getPreviousFileSize(), event.getFileSize());
            }

            public boolean isInputAvailable() {
                try {
                    return FlowController.this.contentRepository.isAccessible(this.createClaim(event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier(), event.getPreviousContentClaimOffset()));
                }
                catch (IOException e) {
                    return false;
                }
            }

            public boolean isOutputAvailable() {
                try {
                    return FlowController.this.contentRepository.isAccessible(this.createClaim(event.getContentClaimContainer(), event.getContentClaimSection(), event.getContentClaimIdentifier(), event.getContentClaimOffset()));
                }
                catch (IOException e) {
                    return false;
                }
            }

            private ContentClaim createClaim(String container, String section, String identifier, Long offset) {
                if (container == null || section == null || identifier == null) {
                    return null;
                }
                StandardResourceClaim resourceClaim = new StandardResourceClaim(container, section, identifier, false);
                return new StandardContentClaim(resourceClaim, offset == null ? 0L : offset);
            }

            public boolean isReplayable() {
                return replayFailure == null;
            }
        };
    }

    public InputStream getContent(ProvenanceEventRecord provEvent, ContentDirection direction, String requestor, String requestUri) throws IOException {
        long size;
        long offset;
        StandardContentClaim claim;
        ResourceClaim resourceClaim;
        Objects.requireNonNull(provEvent);
        Objects.requireNonNull(direction);
        Objects.requireNonNull(requestor);
        Objects.requireNonNull(requestUri);
        if (direction == ContentDirection.INPUT) {
            if (provEvent.getPreviousContentClaimContainer() == null || provEvent.getPreviousContentClaimSection() == null || provEvent.getPreviousContentClaimIdentifier() == null) {
                throw new IllegalArgumentException("Input Content Claim not specified");
            }
            resourceClaim = this.resourceClaimManager.newResourceClaim(provEvent.getPreviousContentClaimContainer(), provEvent.getPreviousContentClaimSection(), provEvent.getPreviousContentClaimIdentifier(), false);
            claim = new StandardContentClaim(resourceClaim, provEvent.getPreviousContentClaimOffset());
            offset = provEvent.getPreviousContentClaimOffset() == null ? 0L : provEvent.getPreviousContentClaimOffset();
            size = provEvent.getPreviousFileSize();
        } else {
            if (provEvent.getContentClaimContainer() == null || provEvent.getContentClaimSection() == null || provEvent.getContentClaimIdentifier() == null) {
                throw new IllegalArgumentException("Output Content Claim not specified");
            }
            resourceClaim = this.resourceClaimManager.newResourceClaim(provEvent.getContentClaimContainer(), provEvent.getContentClaimSection(), provEvent.getContentClaimIdentifier(), false);
            claim = new StandardContentClaim(resourceClaim, provEvent.getContentClaimOffset());
            offset = provEvent.getContentClaimOffset() == null ? 0L : provEvent.getContentClaimOffset();
            size = provEvent.getFileSize();
        }
        InputStream rawStream = this.contentRepository.read((ContentClaim)claim);
        ResourceClaim resourceClaim2 = claim.getResourceClaim();
        StandardProvenanceEventRecord sendEvent = new StandardProvenanceEventRecord.Builder().setEventType(ProvenanceEventType.DOWNLOAD).setFlowFileUUID(provEvent.getFlowFileUuid()).setAttributes(provEvent.getAttributes(), Collections.emptyMap()).setCurrentContentClaim(resourceClaim2.getContainer(), resourceClaim2.getSection(), resourceClaim2.getId(), Long.valueOf(offset), size).setTransitUri(requestUri).setEventTime(System.currentTimeMillis()).setFlowFileEntryDate(provEvent.getFlowFileEntryDate()).setLineageStartDate(provEvent.getLineageStartDate()).setComponentType(this.getName()).setComponentId(this.getRootGroupId()).setDetails("Download of " + (direction == ContentDirection.INPUT ? "Input" : "Output") + " Content requested by " + requestor + " for Provenance Event " + provEvent.getEventId()).build();
        this.provenanceRepository.registerEvent((ProvenanceEventRecord)sendEvent);
        return new LimitedInputStream(rawStream, size);
    }

    public InputStream getContent(FlowFileRecord flowFile, String requestor, String requestUri) throws IOException {
        InputStream stream;
        ResourceClaim resourceClaim;
        Objects.requireNonNull(flowFile);
        Objects.requireNonNull(requestor);
        Objects.requireNonNull(requestUri);
        ContentClaim contentClaim = flowFile.getContentClaim();
        if (contentClaim == null) {
            resourceClaim = null;
            stream = new ByteArrayInputStream(new byte[0]);
        } else {
            resourceClaim = flowFile.getContentClaim().getResourceClaim();
            stream = this.contentRepository.read(flowFile.getContentClaim());
            long contentClaimOffset = flowFile.getContentClaimOffset();
            if (contentClaimOffset > 0L) {
                StreamUtils.skip((InputStream)stream, (long)contentClaimOffset);
            }
            stream = new LimitingInputStream(stream, flowFile.getSize());
        }
        StandardProvenanceEventRecord.Builder sendEventBuilder = new StandardProvenanceEventRecord.Builder().setEventType(ProvenanceEventType.DOWNLOAD).setFlowFileUUID(flowFile.getAttribute(CoreAttributes.UUID.key())).setAttributes(flowFile.getAttributes(), Collections.emptyMap()).setTransitUri(requestUri).setEventTime(System.currentTimeMillis()).setFlowFileEntryDate(flowFile.getEntryDate()).setLineageStartDate(flowFile.getLineageStartDate()).setComponentType(this.getName()).setComponentId(this.getRootGroupId()).setDetails("Download of Content requested by " + requestor + " for " + flowFile);
        if (contentClaim != null) {
            sendEventBuilder.setCurrentContentClaim(resourceClaim.getContainer(), resourceClaim.getSection(), resourceClaim.getId(), Long.valueOf(contentClaim.getOffset() + flowFile.getContentClaimOffset()), flowFile.getSize());
        }
        StandardProvenanceEventRecord sendEvent = sendEventBuilder.build();
        this.provenanceRepository.registerEvent((ProvenanceEventRecord)sendEvent);
        return stream;
    }

    private String getReplayFailureReason(ProvenanceEventRecord event) {
        ProvenanceEventType type = event.getEventType();
        if (type == ProvenanceEventType.JOIN) {
            return "Cannot replay events that are created from multiple parents";
        }
        Long contentSize = event.getPreviousFileSize();
        String contentClaimId = event.getPreviousContentClaimIdentifier();
        String contentClaimSection = event.getPreviousContentClaimSection();
        String contentClaimContainer = event.getPreviousContentClaimContainer();
        if (contentSize == null || contentClaimId == null || contentClaimSection == null || contentClaimContainer == null) {
            return "Cannot replay data from Provenance Event because the event does not contain the required Content Claim";
        }
        try {
            ResourceClaim resourceClaim = this.resourceClaimManager.newResourceClaim(contentClaimContainer, contentClaimSection, contentClaimId, false);
            StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, event.getPreviousContentClaimOffset());
            if (!this.contentRepository.isAccessible((ContentClaim)contentClaim)) {
                return "Content is no longer available in Content Repository";
            }
        }
        catch (IOException ioe) {
            return "Failed to determine whether or not content was available in Content Repository due to " + ioe.toString();
        }
        if (event.getSourceQueueIdentifier() == null) {
            return "Cannot replay data from Provenance Event because the event does not specify the Source FlowFile Queue";
        }
        List connections = this.getGroup(this.getRootGroupId()).findAllConnections();
        FlowFileQueue queue = null;
        for (Connection connection : connections) {
            if (!event.getSourceQueueIdentifier().equals(connection.getIdentifier())) continue;
            queue = connection.getFlowFileQueue();
            break;
        }
        if (queue == null) {
            return "Cannot replay data from Provenance Event because the Source FlowFile Queue with ID " + event.getSourceQueueIdentifier() + " no longer exists";
        }
        return null;
    }

    public ProvenanceEventRecord replayFlowFile(long provenanceEventRecordId, NiFiUser user) throws IOException {
        ProvenanceEventRecord record = this.provenanceRepository.getEvent(provenanceEventRecordId, user);
        if (record == null) {
            throw new IllegalStateException("Cannot find Provenance Event with ID " + provenanceEventRecordId);
        }
        return this.replayFlowFile(record, user);
    }

    public ProvenanceEventRecord replayFlowFile(ProvenanceEventRecord event, NiFiUser user) throws IOException {
        if (event == null) {
            throw new NullPointerException();
        }
        ProvenanceEventType type = event.getEventType();
        if (type == ProvenanceEventType.JOIN) {
            throw new IllegalArgumentException("Cannot replay events that are created from multiple parents");
        }
        Long contentSize = event.getPreviousFileSize();
        String contentClaimId = event.getPreviousContentClaimIdentifier();
        String contentClaimSection = event.getPreviousContentClaimSection();
        String contentClaimContainer = event.getPreviousContentClaimContainer();
        if (contentSize == null || contentClaimId == null || contentClaimSection == null || contentClaimContainer == null) {
            throw new IllegalArgumentException("Cannot replay data from Provenance Event because the event does not contain the required Content Claim");
        }
        if (event.getSourceQueueIdentifier() == null) {
            throw new IllegalArgumentException("Cannot replay data from Provenance Event because the event does not specify the Source FlowFile Queue");
        }
        List connections = this.getGroup(this.getRootGroupId()).findAllConnections();
        FlowFileQueue queue = null;
        for (Connection connection : connections) {
            if (!event.getSourceQueueIdentifier().equals(connection.getIdentifier())) continue;
            queue = connection.getFlowFileQueue();
            break;
        }
        if (queue == null) {
            throw new IllegalStateException("Cannot replay data from Provenance Event because the Source FlowFile Queue with ID " + event.getSourceQueueIdentifier() + " no longer exists");
        }
        ResourceClaim resourceClaim = this.resourceClaimManager.newResourceClaim(event.getPreviousContentClaimContainer(), event.getPreviousContentClaimSection(), event.getPreviousContentClaimIdentifier(), false);
        this.resourceClaimManager.incrementClaimantCount(resourceClaim);
        long claimOffset = event.getPreviousContentClaimOffset() == null ? 0L : event.getPreviousContentClaimOffset();
        StandardContentClaim contentClaim = new StandardContentClaim(resourceClaim, claimOffset);
        contentClaim.setLength(event.getPreviousFileSize() == null ? -1L : event.getPreviousFileSize());
        if (!this.contentRepository.isAccessible((ContentClaim)contentClaim)) {
            this.resourceClaimManager.decrementClaimantCount(resourceClaim);
            throw new IllegalStateException("Cannot replay data from Provenance Event because the data is no longer available in the Content Repository");
        }
        String parentUUID = event.getFlowFileUuid();
        String newFlowFileUUID = UUID.randomUUID().toString();
        FlowFileRecord flowFileRecord = new StandardFlowFileRecord.Builder().addAttributes(event.getPreviousAttributes()).contentClaim(contentClaim).contentClaimOffset(0L).entryDate(System.currentTimeMillis()).id(this.flowFileRepository.getNextFlowFileSequence()).lineageStart(event.getLineageStartDate(), 0L).size(contentSize).addAttribute("flowfile.replay", "true").addAttribute("flowfile.replay.timestamp", String.valueOf(new Date())).addAttribute(CoreAttributes.UUID.key(), newFlowFileUUID).removeAttributes(CoreAttributes.DISCARD_REASON.key(), CoreAttributes.ALTERNATE_IDENTIFIER.key()).build();
        StandardProvenanceEventRecord replayEvent = new StandardProvenanceEventRecord.Builder().setEventType(ProvenanceEventType.REPLAY).addChildUuid(newFlowFileUUID).addParentUuid(parentUUID).setFlowFileUUID(parentUUID).setAttributes(Collections.emptyMap(), flowFileRecord.getAttributes()).setCurrentContentClaim(event.getContentClaimContainer(), event.getContentClaimSection(), event.getContentClaimIdentifier(), event.getContentClaimOffset(), event.getFileSize()).setDetails("Replay requested by " + user.getIdentity()).setEventTime(System.currentTimeMillis()).setFlowFileEntryDate(System.currentTimeMillis()).setLineageStartDate(event.getLineageStartDate()).setComponentType(event.getComponentType()).setComponentId(event.getComponentId()).build();
        this.provenanceRepository.registerEvent((ProvenanceEventRecord)replayEvent);
        StandardRepositoryRecord record = new StandardRepositoryRecord(queue, flowFileRecord);
        record.setDestination(queue);
        this.flowFileRepository.updateRepository(Collections.singleton(record));
        queue.put(flowFileRecord);
        return replayEvent;
    }

    public boolean isConnected() {
        this.rwLock.readLock().lock();
        try {
            boolean bl = this.connectionStatus != null && this.connectionStatus.getState() == NodeConnectionState.CONNECTED;
            return bl;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    public void setConnectionStatus(NodeConnectionStatus connectionStatus) {
        this.rwLock.writeLock().lock();
        try {
            this.connectionStatus = connectionStatus;
            this.heartbeatBeanRef.set(new HeartbeatBean(this.getRootGroup(), this.isPrimary()));
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    public void heartbeat() {
        if (!this.isClustered()) {
            return;
        }
        if (this.shutdown) {
            return;
        }
        HeartbeatSendTask task = this.heartbeatSendTask.get();
        if (task != null) {
            this.clusterTaskExecutor.submit(task);
        }
    }

    HeartbeatMessage createHeartbeatMessage() {
        try {
            HeartbeatBean bean = this.heartbeatBeanRef.get();
            if (bean == null) {
                this.readLock.lock();
                try {
                    bean = new HeartbeatBean(this.getGroup(this.getRootGroupId()), this.isPrimary());
                }
                finally {
                    this.readLock.unlock();
                }
            }
            HeartbeatPayload hbPayload = new HeartbeatPayload();
            hbPayload.setSystemStartTime(this.systemStartTime);
            hbPayload.setActiveThreadCount(this.getActiveThreadCount());
            QueueSize queueSize = this.getTotalFlowFileCount(bean.getRootGroup());
            hbPayload.setTotalFlowFileCount(queueSize.getObjectCount());
            hbPayload.setTotalFlowFileBytes(queueSize.getByteCount());
            NodeIdentifier nodeId = this.getNodeId();
            if (nodeId == null) {
                LOG.warn("Cannot create Heartbeat Message because node's identifier is not known at this time");
                return null;
            }
            HashSet<String> roles = new HashSet<String>();
            if (bean.isPrimary()) {
                roles.add("Primary Node");
            }
            if (this.clusterCoordinator.isActiveClusterCoordinator()) {
                roles.add("Cluster Coordinator");
            }
            Heartbeat heartbeat = new Heartbeat(nodeId, roles, this.connectionStatus, hbPayload.marshal());
            HeartbeatMessage message = new HeartbeatMessage();
            message.setHeartbeat(heartbeat);
            heartbeatLogger.debug("Generated heartbeat");
            return message;
        }
        catch (Throwable ex) {
            LOG.warn("Failed to create heartbeat due to: " + ex, ex);
            return null;
        }
    }

    private void updateRemoteProcessGroups() {
        List remoteGroups = this.getGroup(this.getRootGroupId()).findAllRemoteProcessGroups();
        for (RemoteProcessGroup remoteGroup : remoteGroups) {
            try {
                remoteGroup.refreshFlowContents();
            }
            catch (ClientHandlerException | CommunicationsException e) {
                LOG.warn("Unable to communicate with remote instance {} due to {}", (Object)remoteGroup, (Object)e.toString());
                if (!LOG.isDebugEnabled()) continue;
                LOG.warn("", e);
            }
        }
    }

    public List<ProvenanceEventRecord> getProvenanceEvents(long firstEventId, int maxRecords) throws IOException {
        return new ArrayList<ProvenanceEventRecord>(this.provenanceRepository.getEvents(firstEventId, maxRecords));
    }

    public Authorizable createDataAuthorizable(String componentId) {
        DataAuthorizable authorizable;
        String rootGroupId = this.getRootGroupId();
        if (rootGroupId.equals(componentId)) {
            authorizable = new DataAuthorizable((Authorizable)this.getRootGroup());
        } else {
            Connectable connectable = this.getRootGroup().findConnectable(componentId);
            if (connectable == null) {
                throw new ResourceNotFoundException("The component that generated this event is no longer part of the data flow.");
            }
            authorizable = new DataAuthorizable((Authorizable)connectable);
        }
        return authorizable;
    }

    public List<Action> getFlowChanges(int firstActionId, int maxActions) {
        History history = this.auditService.getActions(firstActionId, maxActions);
        return new ArrayList<Action>(history.getActions());
    }

    public Integer getRemoteSiteListeningPort() {
        return this.remoteInputSocketPort;
    }

    public Integer getRemoteSiteListeningHttpPort() {
        return this.remoteInputHttpPort;
    }

    public Boolean isRemoteSiteCommsSecure() {
        return this.isSiteToSiteSecure;
    }

    public ProcessScheduler getProcessScheduler() {
        return this.processScheduler;
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType, String groupId) {
        return this.controllerServiceProvider.getControllerServiceIdentifiers(serviceType, groupId);
    }

    public ProvenanceRepository getProvenanceRepository() {
        return this.provenanceRepository;
    }

    public StatusHistoryDTO getConnectionStatusHistory(String connectionId) {
        return this.getConnectionStatusHistory(connectionId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getConnectionStatusHistory(String connectionId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getConnectionStatusHistory(connectionId, startTime, endTime, preferredDataPoints));
    }

    public StatusHistoryDTO getProcessorStatusHistory(String processorId) {
        return this.getProcessorStatusHistory(processorId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getProcessorStatusHistory(String processorId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getProcessorStatusHistory(processorId, startTime, endTime, preferredDataPoints));
    }

    public StatusHistoryDTO getProcessGroupStatusHistory(String processGroupId) {
        return this.getProcessGroupStatusHistory(processGroupId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getProcessGroupStatusHistory(String processGroupId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getProcessGroupStatusHistory(processGroupId, startTime, endTime, preferredDataPoints));
    }

    public StatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteGroupId) {
        return this.getRemoteProcessGroupStatusHistory(remoteGroupId, null, null, Integer.MAX_VALUE);
    }

    public StatusHistoryDTO getRemoteProcessGroupStatusHistory(String remoteGroupId, Date startTime, Date endTime, int preferredDataPoints) {
        return StatusHistoryUtil.createStatusHistoryDTO(this.componentStatusRepository.getRemoteProcessGroupStatusHistory(remoteGroupId, startTime, endTime, preferredDataPoints));
    }

    public Collection<FlowFileQueue> getAllQueues() {
        List connections = this.getGroup(this.getRootGroupId()).findAllConnections();
        ArrayList<FlowFileQueue> queues = new ArrayList<FlowFileQueue>(connections.size());
        for (Connection connection : connections) {
            queues.add(connection.getFlowFileQueue());
        }
        return queues;
    }

    private static class HeartbeatBean {
        private final ProcessGroup rootGroup;
        private final boolean primary;

        public HeartbeatBean(ProcessGroup rootGroup, boolean primary) {
            this.rootGroup = rootGroup;
            this.primary = primary;
        }

        public ProcessGroup getRootGroup() {
            return this.rootGroup;
        }

        public boolean isPrimary() {
            return this.primary;
        }
    }

    private class HeartbeatSendTask
    implements Runnable {
        private final DateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS", Locale.US);

        private HeartbeatSendTask() {
        }

        @Override
        public void run() {
            try {
                String heartbeatAddress;
                if (FlowController.this.heartbeatsSuspended.get()) {
                    return;
                }
                HeartbeatMessage message = FlowController.this.createHeartbeatMessage();
                if (message == null) {
                    heartbeatLogger.debug("No heartbeat to send");
                    return;
                }
                long sendStart = System.nanoTime();
                FlowController.this.heartbeater.send(message);
                long sendNanos = System.nanoTime() - sendStart;
                long sendMillis = TimeUnit.NANOSECONDS.toMillis(sendNanos);
                try {
                    heartbeatAddress = FlowController.this.heartbeater.getHeartbeatAddress();
                }
                catch (IOException ioe) {
                    heartbeatAddress = "Cluster Coordinator (could not determine socket address)";
                }
                heartbeatLogger.info("Heartbeat created at {} and sent to {} at {}; send took {} millis", new Object[]{this.dateFormatter.format(new Date(message.getHeartbeat().getCreatedTimestamp())), heartbeatAddress, this.dateFormatter.format(new Date()), sendMillis});
            }
            catch (UnknownServiceAddressException usae) {
                if (heartbeatLogger.isDebugEnabled()) {
                    heartbeatLogger.debug(usae.getMessage());
                }
            }
            catch (Throwable ex) {
                heartbeatLogger.warn("Failed to send heartbeat due to: " + ex, ex);
            }
        }
    }
}

