/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.nifi.controller.Template;
import org.apache.nifi.persistence.TemplateDeserializer;
import org.apache.nifi.stream.io.ByteArrayInputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.RelationshipDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.TemplateDTO;
import org.w3c.dom.Element;

public class TemplateUtils {
    public static TemplateDTO parseDto(Element templateElement) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TemplateDTO.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return (TemplateDTO)unmarshaller.unmarshal((Source)new DOMSource(templateElement), TemplateDTO.class).getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not parse XML as a valid template", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TemplateDTO parseDto(byte[] bytes) {
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);){
            TemplateDTO templateDTO = TemplateDeserializer.deserialize((InputStream)in);
            return templateDTO;
        }
        catch (IOException ioe) {
            throw new RuntimeException("Could not parse bytes as template", ioe);
        }
    }

    public static List<Template> parseTemplateStream(byte[] bytes) {
        ArrayList<Template> templates = new ArrayList<Template>();
        try (ByteArrayInputStream rawIn = new ByteArrayInputStream(bytes);
             DataInputStream in = new DataInputStream((InputStream)rawIn);){
            while (TemplateUtils.isMoreData(in)) {
                int length = in.readInt();
                byte[] buffer = new byte[length];
                StreamUtils.fillBuffer((InputStream)in, (byte[])buffer, (boolean)true);
                TemplateDTO dto = TemplateDeserializer.deserialize((InputStream)new ByteArrayInputStream(buffer));
                templates.add(new Template(dto));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not parse bytes", e);
        }
        return templates;
    }

    private static boolean isMoreData(InputStream in) throws IOException {
        in.mark(1);
        int nextByte = in.read();
        if (nextByte == -1) {
            return false;
        }
        in.reset();
        return true;
    }

    public static void scrubTemplate(TemplateDTO templateDto) {
        TemplateUtils.scrubSnippet(templateDto.getSnippet());
    }

    private static void scrubSnippet(FlowSnippetDTO snippet) {
        if (snippet != null) {
            if (snippet.getProcessors() != null) {
                TemplateUtils.scrubProcessors(snippet.getProcessors());
            }
            if (snippet.getConnections() != null) {
                TemplateUtils.scrubConnections(snippet.getConnections());
            }
            if (snippet.getRemoteProcessGroups() != null) {
                TemplateUtils.scrubRemoteProcessGroups(snippet.getRemoteProcessGroups());
            }
            if (snippet.getProcessGroups() != null) {
                TemplateUtils.scrubProcessGroups(snippet.getProcessGroups());
            }
            if (snippet.getControllerServices() != null) {
                TemplateUtils.scrubControllerServices(snippet.getControllerServices());
            }
        }
    }

    private static void scrubProcessGroups(Set<ProcessGroupDTO> processGroups) {
        for (ProcessGroupDTO processGroupDTO : processGroups) {
            processGroupDTO.setActiveRemotePortCount(null);
            processGroupDTO.setDisabledCount(null);
            processGroupDTO.setInactiveRemotePortCount(null);
            processGroupDTO.setInputPortCount(null);
            processGroupDTO.setInvalidCount(null);
            processGroupDTO.setOutputPortCount(null);
            processGroupDTO.setRunningCount(null);
            processGroupDTO.setStoppedCount(null);
            TemplateUtils.scrubSnippet(processGroupDTO.getContents());
        }
    }

    private static void scrubProcessors(Set<ProcessorDTO> processors) {
        for (ProcessorDTO processorDTO : processors) {
            ProcessorConfigDTO processorConfig = processorDTO.getConfig();
            if (processorConfig != null) {
                if (processorConfig.getProperties() != null) {
                    Map processorProperties = processorConfig.getProperties();
                    if (processorConfig.getDescriptors() != null) {
                        Collection descriptors = processorConfig.getDescriptors().values();
                        for (PropertyDescriptorDTO descriptor : descriptors) {
                            if (!descriptor.isSensitive()) continue;
                            processorProperties.put(descriptor.getName(), null);
                        }
                    }
                }
                processorConfig.setCustomUiUrl(null);
                processorConfig.setDefaultConcurrentTasks(null);
                processorConfig.setDefaultSchedulingPeriod(null);
                processorConfig.setAutoTerminatedRelationships(null);
            }
            for (RelationshipDTO relationship : processorDTO.getRelationships()) {
                relationship.setDescription(null);
            }
            processorDTO.setValidationErrors(null);
            processorDTO.setInputRequirement(null);
            processorDTO.setDescription(null);
            processorDTO.setInputRequirement(null);
            processorDTO.setPersistsState(null);
            processorDTO.setState(null);
            processorDTO.setSupportsBatching(null);
            processorDTO.setSupportsEventDriven(null);
            processorDTO.setSupportsParallelProcessing(null);
        }
    }

    private static void scrubControllerServices(Set<ControllerServiceDTO> controllerServices) {
        for (ControllerServiceDTO serviceDTO : controllerServices) {
            Map properties = serviceDTO.getProperties();
            Map descriptors = serviceDTO.getDescriptors();
            if (properties != null && descriptors != null) {
                for (PropertyDescriptorDTO descriptor : descriptors.values()) {
                    if (!descriptor.isSensitive()) continue;
                    properties.put(descriptor.getName(), null);
                }
            }
            serviceDTO.setDescriptors(null);
            serviceDTO.setCustomUiUrl(null);
            serviceDTO.setValidationErrors(null);
        }
    }

    private static void scrubConnections(Set<ConnectionDTO> connections) {
        for (ConnectionDTO connectionDTO : connections) {
            connectionDTO.setAvailableRelationships(null);
            TemplateUtils.scrubConnectable(connectionDTO.getSource());
            TemplateUtils.scrubConnectable(connectionDTO.getDestination());
        }
    }

    private static void scrubConnectable(ConnectableDTO connectable) {
        if (connectable != null) {
            connectable.setComments(null);
            connectable.setExists(null);
            connectable.setRunning(null);
            connectable.setTransmitting(null);
            connectable.setName(null);
        }
    }

    private static void scrubRemoteProcessGroups(Set<RemoteProcessGroupDTO> remoteGroups) {
        for (RemoteProcessGroupDTO remoteProcessGroupDTO : remoteGroups) {
            remoteProcessGroupDTO.setFlowRefreshed(null);
            remoteProcessGroupDTO.setInputPortCount(null);
            remoteProcessGroupDTO.setOutputPortCount(null);
            remoteProcessGroupDTO.setTransmitting(null);
            remoteProcessGroupDTO.setProxyPassword(null);
            remoteProcessGroupDTO.setActiveRemoteInputPortCount(null);
            remoteProcessGroupDTO.setInactiveRemoteInputPortCount(null);
            remoteProcessGroupDTO.setActiveRemoteOutputPortCount(null);
            remoteProcessGroupDTO.setInactiveRemoteOutputPortCount(null);
            remoteProcessGroupDTO.setAuthorizationIssues(null);
            remoteProcessGroupDTO.setFlowRefreshed(null);
            remoteProcessGroupDTO.setName(null);
            remoteProcessGroupDTO.setTargetSecure(null);
            remoteProcessGroupDTO.setTransmitting(null);
        }
    }
}

