/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.leader.election;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.RetryForever;
import org.apache.nifi.controller.cluster.ZooKeeperClientConfig;
import org.apache.nifi.controller.leader.election.LeaderElectionManager;
import org.apache.nifi.controller.leader.election.LeaderElectionStateChangeListener;
import org.apache.nifi.engine.FlowEngine;
import org.apache.nifi.util.NiFiProperties;
import org.apache.zookeeper.common.PathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CuratorLeaderElectionManager
implements LeaderElectionManager {
    private static final Logger logger = LoggerFactory.getLogger(CuratorLeaderElectionManager.class);
    private final FlowEngine leaderElectionMonitorEngine;
    private final ZooKeeperClientConfig zkConfig;
    private CuratorFramework curatorClient;
    private volatile boolean stopped = true;
    private final Map<String, LeaderRole> leaderRoles = new HashMap<String, LeaderRole>();
    private final Map<String, LeaderElectionStateChangeListener> registeredRoles = new HashMap<String, LeaderElectionStateChangeListener>();

    public CuratorLeaderElectionManager(int threadPoolSize) {
        this.leaderElectionMonitorEngine = new FlowEngine(threadPoolSize, "Leader Election Notification", true);
        NiFiProperties properties = NiFiProperties.getInstance();
        this.zkConfig = ZooKeeperClientConfig.createConfig((Properties)properties);
    }

    @Override
    public synchronized void start() {
        if (!this.stopped) {
            return;
        }
        this.stopped = false;
        RetryForever retryPolicy = new RetryForever(5000);
        this.curatorClient = CuratorFrameworkFactory.newClient((String)this.zkConfig.getConnectString(), (int)this.zkConfig.getSessionTimeoutMillis(), (int)this.zkConfig.getConnectionTimeoutMillis(), (RetryPolicy)retryPolicy);
        this.curatorClient.start();
        for (Map.Entry<String, LeaderElectionStateChangeListener> entry : this.registeredRoles.entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
        logger.info("{} started", (Object)this);
    }

    @Override
    public synchronized void register(String roleName) {
        this.register(roleName, null);
    }

    @Override
    public synchronized void register(String roleName, LeaderElectionStateChangeListener listener) {
        logger.debug("{} Registering new Leader Selector for role {}", (Object)this, (Object)roleName);
        if (this.leaderRoles.containsKey(roleName)) {
            logger.info("{} Attempted to register Leader Election for role '{}' but this role is already registered", (Object)this, (Object)roleName);
            return;
        }
        String rootPath = this.zkConfig.getRootPath();
        String leaderPath = rootPath + (rootPath.endsWith("/") ? "" : "/") + "leaders/" + roleName;
        try {
            PathUtils.validatePath((String)rootPath);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Cannot register leader election for role '" + roleName + "' because this is not a valid role name");
        }
        this.registeredRoles.put(roleName, listener);
        if (!this.isStopped()) {
            ElectionListener electionListener = new ElectionListener(roleName, listener);
            LeaderSelector leaderSelector = new LeaderSelector(this.curatorClient, leaderPath, (ExecutorService)this.leaderElectionMonitorEngine, (LeaderSelectorListener)electionListener);
            leaderSelector.autoRequeue();
            leaderSelector.start();
            LeaderRole leaderRole = new LeaderRole(leaderSelector, electionListener);
            this.leaderRoles.put(roleName, leaderRole);
        }
        logger.info("{} Registered new Leader Selector for role {}", (Object)this, (Object)roleName);
    }

    @Override
    public synchronized void unregister(String roleName) {
        this.registeredRoles.remove(roleName);
        LeaderRole leaderRole = this.leaderRoles.remove(roleName);
        LeaderSelector leaderSelector = leaderRole.getLeaderSelector();
        if (leaderSelector == null) {
            logger.warn("Cannot unregister Leader Election Role '{}' becuase that role is not registered", (Object)roleName);
            return;
        }
        leaderSelector.close();
        logger.info("This node is no longer registered to be elected as the Leader for Role '{}'", (Object)roleName);
    }

    @Override
    public synchronized void stop() {
        this.stopped = true;
        for (LeaderRole role : this.leaderRoles.values()) {
            LeaderSelector selector = role.getLeaderSelector();
            selector.close();
        }
        this.leaderRoles.clear();
        if (this.curatorClient != null) {
            this.curatorClient.close();
            this.curatorClient = null;
        }
        logger.info("{} stopped and closed", (Object)this);
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    public String toString() {
        return "CuratorLeaderElectionManager[stopped=" + this.isStopped() + "]";
    }

    @Override
    public synchronized boolean isLeader(String roleName) {
        LeaderRole role = this.leaderRoles.get(roleName);
        if (role == null) {
            return false;
        }
        return role.isLeader();
    }

    private class ElectionListener
    extends LeaderSelectorListenerAdapter
    implements LeaderSelectorListener {
        private final String roleName;
        private final LeaderElectionStateChangeListener listener;
        private volatile boolean leader;

        public ElectionListener(String roleName, LeaderElectionStateChangeListener listener) {
            this.roleName = roleName;
            this.listener = listener;
        }

        public boolean isLeader() {
            return this.leader;
        }

        public void stateChanged(CuratorFramework client, ConnectionState newState) {
            logger.info("{} Connection State changed to {}", (Object)this, (Object)newState.name());
            super.stateChanged(client, newState);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void takeLeadership(CuratorFramework client) throws Exception {
            this.leader = true;
            logger.info("{} This node has been elected Leader for Role '{}'", (Object)this, (Object)this.roleName);
            if (this.listener != null) {
                this.listener.onLeaderElection();
            }
            try {
                while (!CuratorLeaderElectionManager.this.isStopped()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        logger.info("{} has been interrupted; no longer leader for role '{}'", (Object)this, (Object)this.roleName);
                        Thread.currentThread().interrupt();
                        this.leader = false;
                        logger.info("{} This node is no longer leader for role '{}'", (Object)this, (Object)this.roleName);
                        if (this.listener == null) return;
                        this.listener.onLeaderRelinquish();
                        return;
                    }
                }
            }
            finally {
                this.leader = false;
                logger.info("{} This node is no longer leader for role '{}'", (Object)this, (Object)this.roleName);
                if (this.listener != null) {
                    this.listener.onLeaderRelinquish();
                }
            }
        }
    }

    private static class LeaderRole {
        private final LeaderSelector leaderSelector;
        private final ElectionListener electionListener;

        public LeaderRole(LeaderSelector leaderSelector, ElectionListener electionListener) {
            this.leaderSelector = leaderSelector;
            this.electionListener = electionListener;
        }

        public LeaderSelector getLeaderSelector() {
            return this.leaderSelector;
        }

        public boolean isLeader() {
            return this.electionListener.isLeader();
        }
    }
}

