/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.reporting;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.FormatUtils;

public class StandardReportingInitializationContext
implements ReportingInitializationContext,
ControllerServiceLookup {
    private final String id;
    private final String name;
    private final String schedulingPeriod;
    private final SchedulingStrategy schedulingStrategy;
    private final ControllerServiceProvider serviceProvider;
    private final ComponentLog logger;

    public StandardReportingInitializationContext(String id, String name, SchedulingStrategy schedulingStrategy, String schedulingPeriod, ComponentLog logger, ControllerServiceProvider serviceProvider) {
        this.id = id;
        this.name = name;
        this.schedulingPeriod = schedulingPeriod;
        this.serviceProvider = serviceProvider;
        this.schedulingStrategy = schedulingStrategy;
        this.logger = logger;
    }

    public String getIdentifier() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        if (this.schedulingStrategy == SchedulingStrategy.TIMER_DRIVEN) {
            return FormatUtils.getTimeDuration((String)this.schedulingPeriod, (TimeUnit)timeUnit);
        }
        return -1L;
    }

    public String getSchedulingPeriod() {
        return this.schedulingPeriod;
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return this.schedulingStrategy;
    }

    public Set<String> getControllerServiceIdentifiers(Class<? extends ControllerService> serviceType) {
        return this.serviceProvider.getControllerServiceIdentifiers(serviceType, null);
    }

    public ControllerService getControllerService(String identifier) {
        return this.serviceProvider.getControllerService(identifier);
    }

    public boolean isControllerServiceEnabled(ControllerService service) {
        return this.serviceProvider.isControllerServiceEnabled(service);
    }

    public boolean isControllerServiceEnabled(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabled(serviceIdentifier);
    }

    public boolean isControllerServiceEnabling(String serviceIdentifier) {
        return this.serviceProvider.isControllerServiceEnabling(serviceIdentifier);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public String getControllerServiceName(String serviceIdentifier) {
        return this.serviceProvider.getControllerServiceName(serviceIdentifier);
    }

    public ComponentLog getLogger() {
        return this.logger;
    }
}

